<?php
/**
 * HUBzero CMS
 *
 * Copyright 2005-2011 Purdue University. All rights reserved.
 *
 * This file is part of: The HUBzero(R) Platform for Scientific Collaboration
 *
 * The HUBzero(R) Platform for Scientific Collaboration (HUBzero) is free
 * software: you can redistribute it and/or modify it under the terms of
 * the GNU Lesser General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any
 * later version.
 *
 * HUBzero is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * HUBzero is a registered trademark of Purdue University.
 *
 * @package   hubzero-cms
 * @author    Shawn Rice <zooley@purdue.edu>
 * @copyright Copyright 2005-2011 Purdue University. All rights reserved.
 * @license   http://www.gnu.org/licenses/lgpl-3.0.html LGPLv3
 */

// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die('Restricted access');

require_once(JPATH_ROOT . DS . 'components' . DS . 'com_collections' . DS . 'tables' . DS . 'asset.php');

/**
 * Courses model class for a course
 */
class CollectionsModelAsset extends JObject
{
	/**
	 * CoursesTableInstance
	 * 
	 * @var object
	 */
	public $_tbl = NULL;

	/**
	 * CoursesTableInstance
	 * 
	 * @var object
	 */
	private $_creator = NULL;

	/**
	 * JDatabase
	 * 
	 * @var object
	 */
	private $_db = NULL;

	/**
	 * Constructor
	 * 
	 * @param      integer $id  Resource ID or alias
	 * @param      object  &$db JDatabase
	 * @return     void
	 */
	public function __construct($oid=null, $item_id=null)
	{
		$this->_db = JFactory::getDBO();

		$this->_tbl = new CollectionsTableAsset($this->_db);

		if (is_numeric($oid) || is_string($oid))
		{
			$this->_tbl->load($oid, $item_id);
		}
		else if (is_object($oid))
		{
			$this->_tbl->bind($oid);
		}
		else if (is_array($oid))
		{
			$this->_tbl->bind($oid);
		}
	}

	/**
	 * Returns a reference to a wiki page object
	 *
	 * This method must be invoked as:
	 *     $inst = CoursesInstance::getInstance($alias);
	 *
	 * @param      string $pagename The page to load
	 * @param      string $scope    The page scope
	 * @return     object WikiPage
	 */
	static function &getInstance($oid=null, $item_id=null)
	{
		static $instances;

		if (!isset($instances)) 
		{
			$instances = array();
		}

		if (is_numeric($oid) || is_string($oid))
		{
			$key = $oid . '_' . $item_id;
		}
		else if (is_object($oid))
		{
			$key = $oid->id . '_' . $item_id;
		}
		else if (is_array($oid))
		{
			$key = $oid['id'] . '_' . $item_id;
		}

		if (!isset($instances[$key])) 
		{
			$instances[$key] = new CollectionsModelAsset($oid, $item_id);
		}

		return $instances[$key];
	}

	/**
	 * Returns a property of the object or the default value if the property is not set.
	 *
	 * @access	public
	 * @param	string $property The name of the property
	 * @param	mixed  $default The default value
	 * @return	mixed The value of the property
	 * @see		getProperties()
	 * @since	1.5
 	 */
	public function get($property, $default=null)
	{
		if (isset($this->_tbl->$property)) 
		{
			return $this->_tbl->$property;
		}
		return $default;
	}

	/**
	 * Modifies a property of the object, creating it if it does not already exist.
	 *
	 * @access	public
	 * @param	string $property The name of the property
	 * @param	mixed  $value The value of the property to set
	 * @return	mixed Previous value of the property
	 * @see		setProperties()
	 * @since	1.5
	 */
	public function set($property, $value = null)
	{
		$previous = isset($this->_tbl->$property) ? $this->_tbl->$property : null;
		$this->_tbl->$property = $value;
		return $previous;
	}

	/**
	 * Check if the resource exists
	 * 
	 * @param      mixed $idx Index value
	 * @return     array
	 */
	public function exists()
	{
		if ($this->get('id') && (int) $this->get('id') > 0) 
		{
			return true;
		}
		return false;
	}

	/**
	 * Get the creator of this entry
	 * 
	 * Accepts an optional property name. If provided
	 * it will return that property value. Otherwise,
	 * it returns the entire JUser object
	 *
	 * @return     mixed
	 */
	public function creator($property=null)
	{
		if (!isset($this->_creator) || !is_object($this->_creator))
		{
			$this->_creator = JUser::getInstance($this->created_by);
		}
		/*if ($property && is_a($this->_creator, 'JUser'))
		{
			return $this->_creator->get($property);
		}*/
		return $this->_creator;
	}

	/**
	 * Is an asset an image?
	 *
	 * @return    boolean True if image, false if not
	 */
	public function image()
	{
		jimport('joomla.filesystem.file');
		$ext = strtolower(JFile::getExt($this->get('filename')));

		if (in_array($ext, array('jpg', 'jpe', 'jpeg', 'gif', 'png')))
		{
			return true;
		}

		return false;
	}

	/**
	 * Remove a record
	 *
	 * @return    boolean True on success, false if errors
	 */
	public function remove()
	{
		if (!$this->_tbl->remove($this->get('id')))
		{
			$this->setError($this->_tbl->getError());
			return false;
		}
		return true;
	}

	/**
	 * Bind data to the model's table object
	 * 
	 * @param      mixed $data Array or object
	 * @return     boolean True on success, false if errors
	 */
	public function bind($data=null)
	{
		return $this->_tbl->bind($data);
	}

	/**
	 * Store content
	 * Can be passed a boolean to turn off check() method
	 *
	 * @param     boolean $check Call check() method?
	 * @return    boolean True on success, false if errors
	 */
	public function update($field, $before, $after)
	{
		if (!$this->_tbl->updateField($field, $before, $after))
		{
			$this->setError($this->_tbl->getError());
			return false;
		}

		return true;
	}

	/**
	 * Store content
	 * Can be passed a boolean to turn off check() method
	 *
	 * @param     boolean $check Call check() method?
	 * @return    boolean True on success, false if errors
	 */
	public function store($check=true)
	{
		if (empty($this->_db))
		{
			return false;
		}

		if ($this->get('_file'))
		{
			$config = JComponentHelper::getParams('com_collections');

			$path = JPATH_ROOT . DS . trim($config->get('filepath', '/site/collections'), DS) . DS . $this->get('item_id');

			if (!is_dir($path)) 
			{
				jimport('joomla.filesystem.folder');
				if (!JFolder::create($path, 0777)) 
				{
					$this->setError(JText::_('Error uploading. Unable to create path.'));
					return false;
				}
			}

			$file = $this->get('_file');

			// Make the filename safe
			jimport('joomla.filesystem.file');
			$file['name'] = urldecode($files['name']);
			$file['name'] = JFile::makeSafe($file['name']);
			$file['name'] = str_replace(' ', '_', $file['name']);

			// Upload new files
			if (!JFile::upload($file['tmp_name'], $path . DS . $file['name'])) 
			{
				$this->setError(JText::_('ERROR_UPLOADING') . ': ' . $file['name']);
				return false;
			}

			$this->set('filename', $file['name']);
		}

		if ($check)
		{
			if (!$this->_tbl->check())
			{
				$this->setError($this->_tbl->getError());
				return false;
			}
		}

		if (!$this->_tbl->store())
		{
			$this->setError($this->_tbl->getError());
			return false;
		}

		return true;
	}

	/**
	 * Update ordering
	 *
	 * @return    boolean True on success, false if errors
	 */
	public function reorder($item_id=0)
	{
		if (!$item_id)
		{
			$item_id = $this->get('item_id');
		}
		return $this->_tbl->reorder("item_id=" . $this->_db->Quote(intval($item_id)));
	}
}

