# @package      hubzero-cms
dnl # @file         hub.m4
# @author       Nicholas J. Kisseberth <nkissebe@purdue.edu>
# @copyright    Copyright (c) 2005-2014 HUBzero Foundation, LLC.
# @license      http://www.gnu.org/licenses/lgpl-3.0.html LGPLv3
#
# Copyright (c) 2005-2014 HUBzero Foundation, LLC.
#
# This file is part of: The HUBzero(R) Platform for Scientific Collaboration
#
# The HUBzero(R) Platform for Scientific Collaboration (HUBzero) is free
# software: you can redistribute it and/or modify it under the terms of
# the GNU Lesser General Public License as published by the Free Software
# Foundation, either version 3 of the License, or (at your option) any
# later version.
#
# HUBzero is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
# HUBzero is a registered trademark of HUBzero Foundation, LLC.

dnl
ifdef(`HUBNAME',`',`define(`HUBNAME',example)')dnl
ifdef(`FQDN',`',`undefine(`USE_CANONICAL_HOSTNAME')')dnl
ifdef(`DOCUMENT_ROOT',`',`define(`DOCUMENT_ROOT',`/var/www/HUBNAME')')dnl
ifdef(`FQDN',`',`define(`FQDN',example.com)')dnl
changecom(`//')dnl
dnl
# Basic HUBzero Website Definition
#
# DO NOT MODIFY THIS FILE DIRECTLY!!!!
# This file is automatically generated from /etc/APACHE_HOME/sites-m4/HUBNAME
# and can get recreated on demand by `''hzcms' and other tools
changecom(`#')

NameVirtualHost *:80
<VirtualHost _default_:80>
	DocumentRoot DOCUMENT_ROOT
	TraceEnable off
	RewriteEngine on
	ServerSignature off
	ServerName FQDN
	
ifdef(`USE_CANONICAL_HOSTNAME',`	# Force requests to use canonical hostname
	RewriteCond %{HTTP_HOST} !^FQDN$ [NC]
	RewriteCond %{HTTP_HOST} !^$
	RewriteRule ^/(.*) http://FQDN}/$1 [L,R]

')dnl
dnl
ifdef(`USE_TRAC',`	# Redirect requests to Trac URLs to secure (https) site
	RewriteCond     %{REQUEST_URI}  ^/tools/[^/]+((/(pygments|prefs|chrome|log|login|wiki|timeline|roadmap|browser|search|about|diff|changeset|logout|settings|attachment|raw-attachment|export)($|/))) [OR]
	RewriteRule     ^(.*)$          https://%{HTTP_HOST}%{REQUEST_URI} [R,L]

')dnl
dnl
ifdef(`USE_WEBDAV',`	# Redirect WebDAV request to secure (https) site
	RewriteCond     %{REQUEST_URI}  ^/webdav($|/)
	RewriteRule     ^(.*)$          https://%{HTTP_HOST}%{REQUEST_URI} [R,L]

')dnl
dnl
	# Block direct access to subversion, git and mercurial repository meta-data
	RewriteRule ^(.*/)?(\.svn|\.git|\.hg)/ - [R=404,L]

	<Directory />
		Order Deny,Allow
		Deny from all
		Options None
		AllowOverride None
	</Directory>

	<Directory DOCUMENT_ROOT>
		RewriteEngine On
		Order Allow,Deny
		Allow from all
		Options FollowSymLinks
		AllowOverride None
		DirectoryIndex index.php index.html
		RewriteCond %{REQUEST_FILENAME} !-f
		RewriteCond %{REQUEST_FILENAME} !-d
		RewriteRule (.*) index.php
	</Directory>

	<Directory DOCUMENT_ROOT/api>
		RewriteEngine On
		Order Allow,Deny
		Allow from all
		Options FollowSymLinks
		AllowOverride None
		DirectoryIndex index.php index.html
		RewriteCond %{REQUEST_FILENAME} !-f
		RewriteCond %{REQUEST_FILENAME} !-d
		RewriteRule (.*) index.php
		Satisfy Any
		php_flag magic_quotes_gpc off
	</Directory>

	<Directory DOCUMENT_ROOT/site/protected>
		Order Deny,Allow
		Deny from all
		Options none
		AllowOverride None
	</Directory>

	LogLevel warn
	LogFormat "%{%Y-%m-%d %H:%M:%S %Z}t %P %u \"%r\" %>s %B %a \"%{Referer}i\" \"%{User-Agent}i\" %{SSL_PROTOCOL}x %T %D %{userid}n %{jsession}n %{site}C %{auth}n %{component}n %{view}n %{task}n %{action}n %{item}n" hublog
	ErrorLog WEBLOGFILEROOT/HUBNAME-error-ssl.log
	CustomLog WEBLOGFILEROOT/HUBNAME-access.log hublog

	# Compensation for MSIE client flaws
	SetEnvIf User-Agent ".*MSIE [1-5]\..*" nokeepalive downgrade-1.0 force-response-1.0
	<Limit POST>
		SetEnvIf User-Agent “.*MSIE ([6-9]|[0-9]{2}).*” nokeepalive
	</Limit>

	# Don't execute PHP files in the support files directory (/site)
	<Location /site>
		AddType text/plain .php .phtml .pht .phps .php3 .php3p .php4 .php5 .php6
		php_admin_value engine Off
	</Location>

	AddType application/x-font-ttf .ttf
	AddType application/vnd.ms-fontobject .eot
	AddType application/x-font-opentype .otf
	AddType application/x-font-woff .woff

</VirtualHost>
