#
# @package      hubzero-cms
# @file         installation/sql/mysql/hz_sample_data.sql
# @author       Nicholas J. Kisseberth <nkissebe@purdue.edu>
# @copyright    Copyright (c) 2010-2013 Purdue University. All rights reserved.
# @license      http://www.gnu.org/licenses/gpl2.html GPLv2
#
# Copyright (c) 2010-2013 Purdue University
# All rights reserved.
#
# This file is free software: you can redistribute it and/or modify it
# under the terms of the GNU General Public License as published by the
# Free Software Foundation, either version 2 of the License, or (at your
# option) any later version.
#
# This file is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
# HUBzero is a registered trademark of Purdue University.
#

#
# IMPORTANT - THIS FILE MUST BE SAVED WITH UTF-8 ENCODING ONLY. BEWARE IF EDITING!
#

SET NAMES 'utf8';
SET @@SESSION.sql_mode = '';

UPDATE `#__extensions` SET enabled='0' WHERE `type`='component' AND `element` IN ('com_banners','com_weblinks','com_contacts','com_wrapper','com_mailto','com_massmail');
UPDATE `#__extensions` SET params='{"show_headings":"1","show_name":"1","show_articles":"1","show_link":"1","show_cat_description":"1","show_cat_items":"1","show_feed_image":"1","show_feed_description":"1","show_item_description":"1","feed_word_count":"0"}' WHERE `type`='component' AND `element`='com_newsfeeds';
UPDATE `#__extensions` SET params='{"upload_extensions":"bmp,csv,doc,epg,gif,ico,jpg,odg,odp,ods,odt,pdf,png,ppt,swf,txt,xcf,xls,BMP,CSV,DOC,EPG,GIF,ICO,JPG,ODG,ODP,ODS,ODT,PDF,PNG,PPT,SWF,TXT,XCF,XLS","upload_maxsize":"10","file_path":"site/media","image_path":"site/media/images","restrict_uploads":"1","allowed_media_usergroup":"3","check_mime":"1","image_extensions":"bmp, gif, jpg, png","ignore_extensions":"","upload_mime":"image/jpeg, image/gif, image/png, image/bmp, application/x-shockwave-flash, application/msword, application/excel, application/pdf, application/powerpoint, text/plain, application/x-zip","upload_mime_illegal":"text/html","enable_flash":"0"}' WHERE `type`='component' AND `element`='com_media';
UPDATE `#__extensions` SET params='{"show_noauth":"0","show_title":"1","link_titles":"0","show_intro":"1","show_section":"0","link_section":"0","show_category":"0","link_category":"0","show_author":"0","show_create_date":"0","show_modify_date":"0","show_item_navigation":"0","show_readmore":"1","show_vote":"0","show_icons":"0","show_print_icon":"0","show_email_icon":"0","show_hits":"0","feed_summary":"0","filter_tags":"","filter_attritbutes":""}' WHERE `type`='component' AND `element`='com_content';
UPDATE `#__extensions` SET params='{"allowUserRegistration":"1","new_usertype":"2","useractivation":"1","frontend_userparams":"1","allow_duplicate_emails":"0"}' WHERE `type`='component' AND `element`='com_users';


UPDATE `#__modules` SET position='user3' WHERE title='Main Menu';
UPDATE `#__modules` SET showtitle='0' WHERE title='Main Menu';
UPDATE `#__modules` SET params= '{"menutype":"mainmenu","menu_style":"list","startLevel":"0","endLevel":"0","showAllChildren":"1","window_open":"","show_whitespace":"0","cache":"1","tag_id":"","class_sfx":"","moduleclass_sfx":"_menu","maxdepth":"10","menu_images":"0","menu_images_align":"0","menu_images_link":"0","expand_menu":"0","activate_parent":"0","full_active_id":"0","indent_image":"0","indent_image1":"","indent_image2":"","indent_image3":"","indent_image4":"","indent_image5":"","indent_image6":"","spacer":"","end_spacer":""}' WHERE title='Main Menu';
UPDATE `#__modules` SET published='0' WHERE title IN ('Quick Icons','Popular Articles','Recently Added Articles','Logged-in Users');
UPDATE `#__modules` SET module='mod_hubmenu' WHERE title='Admin Menu';

--
-- HUBzero sample data for table `hosttype`
--

INSERT INTO `hosttype` (`name`, `value`, `description`) VALUES ('workspace',1,'Workspace host');
INSERT INTO `hosttype` (`name`, `value`, `description`) VALUES ('fileserver',2,'Fileserver host');
INSERT INTO `hosttype` (`name`, `value`, `description`) VALUES ('pubnet',4,'Public host');
INSERT INTO `hosttype` (`name`, `value`, `description`) VALUES ('sessions',8,'Normal jobs');
INSERT INTO `hosttype` (`name`, `value`, `description`) VALUES ('openvz',16,'OpenVZ');

--
-- HUBzero sample data for table `#__assets`
--

REPLACE INTO `#__assets` VALUES (1, 0, 0, 183, 0, 'root.1', 'Root Asset', '{\"core.login.site\":{\"1\":1,\"6\":1,\"2\":1},\"core.login.admin\":{\"6\":1},\"core.login.offline\":{\"6\":1},\"core.admin\":{\"8\":1},\"core.manage\":{\"7\":1},\"core.create\":{\"6\":1,\"3\":1},\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"core.edit.own\":{\"6\":1,\"3\":1}}');
REPLACE INTO `#__assets` VALUES (2, 1, 69, 70, 1, 'com_admin', 'com_admin', '{}');
REPLACE INTO `#__assets` VALUES (4, 1, 71, 72, 1, 'com_cache', 'com_cache', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"7\":1}}');
REPLACE INTO `#__assets` VALUES (5, 1, 73, 74, 1, 'com_checkin', 'com_checkin', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"7\":1}}');
REPLACE INTO `#__assets` VALUES (6, 1, 75, 76, 1, 'com_config', 'com_config', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"7\":1},\"core.create\":{\"7\":1},\"core.delete\":{\"7\":1},\"core.edit\":{\"7\":1},\"core.edit.state\":{\"7\":1}}');
REPLACE INTO `#__assets` VALUES (8, 1, 77, 130, 1, 'com_content', 'com_content', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":{\"3\":1},\"core.delete\":[],\"core.edit\":{\"4\":1},\"core.edit.state\":{\"5\":1},\"core.edit.own\":[]}');
REPLACE INTO `#__assets` VALUES (9, 1, 131, 132, 1, 'com_cpanel', 'com_cpanel', '{}');
REPLACE INTO `#__assets` VALUES (10, 1, 133, 134, 1, 'com_installer', 'com_installer', '{\"core.admin\":[],\"core.manage\":{\"7\":0},\"core.delete\":{\"7\":0},\"core.edit.state\":{\"7\":0}}');
REPLACE INTO `#__assets` VALUES (11, 1, 135, 136, 1, 'com_languages', 'com_languages', '{\"core.admin\":{\"7\":1},\"core.manage\":[],\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
REPLACE INTO `#__assets` VALUES (12, 1, 137, 138, 1, 'com_login', 'com_login', '{}');
REPLACE INTO `#__assets` VALUES (13, 1, 139, 140, 1, 'com_mailto', 'com_mailto', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"7\":1},\"core.create\":{\"7\":1},\"core.delete\":{\"7\":1},\"core.edit\":{\"7\":1},\"core.edit.state\":{\"7\":1}}');
REPLACE INTO `#__assets` VALUES (14, 1, 141, 142, 1, 'com_massmail', 'com_massmail', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"7\":1},\"core.create\":{\"7\":1},\"core.delete\":{\"7\":1},\"core.edit\":{\"7\":1},\"core.edit.state\":{\"7\":1}}');
REPLACE INTO `#__assets` VALUES (15, 1, 143, 144, 1, 'com_media', 'com_media', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":{\"3\":1},\"core.delete\":{\"5\":1}}');
REPLACE INTO `#__assets` VALUES (16, 1, 145, 146, 1, 'com_menus', 'com_menus', '{\"core.admin\":{\"7\":1},\"core.manage\":[],\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
REPLACE INTO `#__assets` VALUES (17, 1, 147, 148, 1, 'com_messages', 'com_messages', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"7\":1}}');
REPLACE INTO `#__assets` VALUES (18, 1, 149, 150, 1, 'com_modules', 'com_modules', '{\"core.admin\":{\"7\":1},\"core.manage\":[],\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
REPLACE INTO `#__assets` VALUES (19, 1, 151, 154, 1, 'com_newsfeeds', 'com_newsfeeds', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}');
REPLACE INTO `#__assets` VALUES (20, 1, 155, 156, 1, 'com_plugins', 'com_plugins', '{\"core.admin\":{\"7\":1},\"core.manage\":[],\"core.edit\":[],\"core.edit.state\":[]}');
REPLACE INTO `#__assets` VALUES (21, 1, 157, 158, 1, 'com_redirect', 'com_redirect', '{\"core.admin\":{\"7\":1},\"core.manage\":[]}');
REPLACE INTO `#__assets` VALUES (23, 1, 159, 160, 1, 'com_templates', 'com_templates', '{\"core.admin\":{\"7\":1},\"core.manage\":[],\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
REPLACE INTO `#__assets` VALUES (24, 1, 161, 164, 1, 'com_users', 'com_users', '{\"core.admin\":{\"7\":1},\"core.manage\":[],\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
REPLACE INTO `#__assets` VALUES (27, 8, 120, 129, 2, 'com_content.category.2', 'Uncategorised', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}');
REPLACE INTO `#__assets` VALUES (30, 19, 152, 153, 2, 'com_newsfeeds.category.5', 'Uncategorised', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}');
REPLACE INTO `#__assets` VALUES (32, 24, 162, 163, 2, 'com_users.category.7', 'Uncategorised', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
REPLACE INTO `#__assets` VALUES (34, 1, 165, 166, 1, 'com_joomlaupdate', 'com_joomlaupdate', '{\"core.admin\":[],\"core.manage\":[],\"core.delete\":[],\"core.edit.state\":[]}');
INSERT INTO `#__assets` VALUES (35, 1, 63, 64, 1, 'com_answers', 'com_answers', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `#__assets` VALUES (36, 1, 61, 62, 1, 'com_billboards', 'com_billboards', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `#__assets` VALUES (37, 1, 59, 60, 1, 'com_blog', 'com_blog', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `#__assets` VALUES (38, 1, 31, 32, 1, 'com_citations', 'com_citations', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `#__assets` VALUES (39, 1, 29, 30, 1, 'com_courses', 'com_courses', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `#__assets` VALUES (40, 1, 27, 28, 1, 'com_cron', 'com_cron', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `#__assets` VALUES (41, 1, 17, 26, 1, 'com_events', 'com_events', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `#__assets` VALUES (43, 1, 15, 16, 1, 'com_feedback', 'com_feedback', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `#__assets` VALUES (44, 1, 13, 14, 1, 'com_forum', 'com_forum', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `#__assets` VALUES (45, 1, 67, 68, 1, 'com_groups', 'com_groups', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `#__assets` VALUES (46, 1, 11, 12, 1, 'com_help', 'com_help', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `#__assets` VALUES (47, 1, 9, 10, 1, 'com_jobs', 'com_jobs', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `#__assets` VALUES (48, 1, 7, 8, 1, 'com_kb', 'com_kb', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `#__assets` VALUES (49, 1, 5, 6, 1, 'com_members', 'com_members', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `#__assets` VALUES (50, 1, 3, 4, 1, 'com_newsletter', 'com_newsletter', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `#__assets` VALUES (51, 1, 33, 34, 1, 'com_poll', 'com_poll', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `#__assets` VALUES (52, 1, 35, 36, 1, 'com_projects', 'com_projects', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `#__assets` VALUES (54, 1, 57, 58, 1, 'com_resources', 'com_resources', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `#__assets` VALUES (55, 1, 55, 56, 1, 'com_services', 'com_services', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `#__assets` VALUES (56, 1, 53, 54, 1, 'com_store', 'com_store', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `#__assets` VALUES (57, 1, 51, 52, 1, 'com_support', 'com_support', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `#__assets` VALUES (58, 1, 49, 50, 1, 'com_system', 'com_system', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `#__assets` VALUES (59, 1, 47, 48, 1, 'com_tags', 'com_tags', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `#__assets` VALUES (60, 1, 65, 66, 1, 'com_tools', 'com_tools', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `#__assets` VALUES (62, 1, 45, 46, 1, 'com_usage', 'com_usage', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `#__assets` VALUES (63, 1, 43, 44, 1, 'com_user', 'com_user', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `#__assets` VALUES (64, 1, 41, 42, 1, 'com_whatsnew', 'com_whatsnew', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `#__assets` VALUES (65, 1, 39, 40, 1, 'com_wiki', 'com_wiki', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `#__assets` VALUES (66, 1, 37, 38, 1, 'com_wishlist', 'com_wishlist', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `#__assets` VALUES (67, 1, 1, 2, 1, 'com_search', 'com_search', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `#__assets` VALUES (68, 8, 78, 93, 2, 'com_content.category.8', 'com_content', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `#__assets` VALUES (69, 8, 94, 111, 2, 'com_content.category.9', 'com_content', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `#__assets` VALUES (70, 8, 112, 113, 2, 'com_content.category.10', 'com_content', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `#__assets` VALUES (71, 8, 114, 115, 2, 'com_content.category.11', 'com_content', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `#__assets` VALUES (72, 41, 18, 19, 2, 'com_events.category.12', 'com_events', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `#__assets` VALUES (73, 41, 20, 21, 2, 'com_events.category.13', 'com_events', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `#__assets` VALUES (74, 41, 22, 23, 2, 'com_events.category.14', 'com_events', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `#__assets` VALUES (75, 41, 24, 25, 2, 'com_events.category.15', 'com_events', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `#__assets` VALUES (76, 77, 117, 118, 3, 'com_content.category.16', 'com_content', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `#__assets` VALUES (77, 8, 116, 119, 2, 'com_content.category.17', 'com_content', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `#__assets` VALUES (78, 27, 121, 122, 3, 'com_content.article.1', 'Home', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `#__assets` VALUES (79, 68, 79, 80, 3, 'com_content.article.2', 'Our Cyberinfrastructure', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `#__assets` VALUES (80, 68, 81, 82, 3, 'com_content.article.3', 'About Us', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `#__assets` VALUES (81, 68, 83, 84, 3, 'com_content.article.4', 'Contact Us', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `#__assets` VALUES (82, 68, 85, 86, 3, 'com_content.article.5', 'Quotes', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `#__assets` VALUES (83, 68, 87, 88, 3, 'com_content.article.6', 'Usage', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `#__assets` VALUES (84, 68, 89, 90, 3, 'com_content.article.7', 'Copyrights', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `#__assets` VALUES (85, 68, 91, 92, 3, 'com_content.article.8', 'Feedback', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `#__assets` VALUES (86, 69, 95, 96, 3, 'com_content.article.11', 'Terms of Use', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `#__assets` VALUES (87, 69, 97, 98, 3, 'com_content.article.12', 'Intellectual Property Considerations', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `#__assets` VALUES (88, 69, 99, 100, 3, 'com_content.article.13', 'Creative Commons', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `#__assets` VALUES (89, 69, 101, 102, 3, 'com_content.article.14', 'Submitting Content', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `#__assets` VALUES (90, 27, 123, 124, 3, 'com_content.article.22', 'Discover', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `#__assets` VALUES (91, 27, 125, 126, 3, 'com_content.article.32', 'Congratulations', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `#__assets` VALUES (92, 69, 103, 104, 3, 'com_content.article.27', 'Privacy Policy', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `#__assets` VALUES (93, 69, 105, 106, 3, 'com_content.article.28', 'Abuse Policy', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `#__assets` VALUES (94, 69, 107, 108, 3, 'com_content.article.29', 'Legal', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `#__assets` VALUES (95, 69, 109, 110, 3, 'com_content.article.30', 'HUBzero Accessibility Statement', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `#__assets` VALUES (96, 27, 127, 128, 3, 'com_content.article.31', 'Community', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `#__assets` VALUES (97, 1, 167, 168, 1, 'com_collections', 'com_collections', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `#__assets` VALUES (98, 1, 169, 170, 1, 'com_dataviewer', 'com_dataviewer', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `#__assets` VALUES (99, 1, 171, 172, 1, 'com_storefront', 'com_storefront', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `#__assets` VALUES (100, 1, 173, 174, 1, 'com_cart', 'com_cart', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `#__assets` VALUES (101, 1, 175, 176, 1, 'com_publications', 'com_publications', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `#__assets` VALUES (103, 1, 177, 178, 1, 'com_feedaggregator', 'com_feedaggregator', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `#__assets` VALUES (104, 1, 179, 180, 1, 'com_update', 'com_update', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `#__assets` VALUES (105, 1, 181, 182, 1, 'com_time', 'com_time', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');

--
-- HUBzero sample data for table `#__auth_domain`
--

INSERT INTO `#__auth_domain` VALUES ('facebook','',1,'','authentication');
INSERT INTO `#__auth_domain` VALUES ('google','',2,'','authentication');
INSERT INTO `#__auth_domain` VALUES ('linkedin','',3,'','authentication');
INSERT INTO `#__auth_domain` VALUES ('pucas','',4,'','authentication');

--
-- HUBzero sample data for table `#__categories`
--

INSERT INTO `#__categories` VALUES (8,68,1,1,2,1,'about','com_content','about','about','','',1,0,'0000-00-00 00:00:00',1,'','','','',0,'0000-00-00 00:00:00',0,'0000-00-00 00:00:00',0,'');
INSERT INTO `#__categories` VALUES (9,69,1,3,4,1,'legal','com_content','legal','legal','','',1,0,'0000-00-00 00:00:00',1,'','','','',0,'0000-00-00 00:00:00',0,'0000-00-00 00:00:00',0,'');
INSERT INTO `#__categories` VALUES (10,70,1,5,6,1,'browse','com_content','browse','browse','','',1,0,'0000-00-00 00:00:00',1,'','','','',0,'0000-00-00 00:00:00',0,'0000-00-00 00:00:00',0,'');
INSERT INTO `#__categories` VALUES (11,71,1,7,8,1,'presenters','com_content','presenters','presenters','','',1,0,'0000-00-00 00:00:00',1,'','','','',0,'0000-00-00 00:00:00',0,'0000-00-00 00:00:00',0,'');
INSERT INTO `#__categories` VALUES (12,72,1,9,10,1,'meeting','com_events','Meeting','meeting','','',1,0,'0000-00-00 00:00:00',1,'','','','',0,'0000-00-00 00:00:00',0,'0000-00-00 00:00:00',0,'');
INSERT INTO `#__categories` VALUES (13,73,1,11,12,1,'seminar','com_events','Seminar','seminar','','',1,0,'0000-00-00 00:00:00',1,'','','','',0,'0000-00-00 00:00:00',0,'0000-00-00 00:00:00',0,'');
INSERT INTO `#__categories` VALUES (14,74,1,13,14,1,'workshop','com_events','Workshop','workshop','','',1,0,'0000-00-00 00:00:00',1,'','','','',0,'0000-00-00 00:00:00',0,'0000-00-00 00:00:00',0,'');
INSERT INTO `#__categories` VALUES (15,75,1,15,16,1,'general','com_events','General','general','','',1,0,'0000-00-00 00:00:00',1,'','','','',0,'0000-00-00 00:00:00',0,'0000-00-00 00:00:00',0,'');
INSERT INTO `#__categories` VALUES (16,76,17,18,19,2,'features/frontpage','com_content','frontpage','frontpage','','',1,0,'0000-00-00 00:00:00',1,'','','','',0,'0000-00-00 00:00:00',0,'0000-00-00 00:00:00',0,'');
INSERT INTO `#__categories` VALUES (17,77,1,17,20,1,'features','com_content','features','features','','',1,0,'0000-00-00 00:00:00',1,'','','','',0,'0000-00-00 00:00:00',0,'0000-00-00 00:00:00',0,'');

--
-- HUBzero sample data for table `#__citations_types`
--

INSERT INTO `#__citations_types` VALUES (1,'journal','Journal','',NULL,NULL);
INSERT INTO `#__citations_types` VALUES (2,'article','Article','',NULL,NULL);
INSERT INTO `#__citations_types` VALUES (3,'book','Book','',NULL,NULL);
INSERT INTO `#__citations_types` VALUES (4,'booklet','Booklet','',NULL,NULL);
INSERT INTO `#__citations_types` VALUES (5,'conference','Conference','',NULL,NULL);
INSERT INTO `#__citations_types` VALUES (6,'inbook','In Book','',NULL,NULL);
INSERT INTO `#__citations_types` VALUES (7,'incollection','In Collection','',NULL,NULL);
INSERT INTO `#__citations_types` VALUES (8,'inproceedings','In Proceedings','',NULL,NULL);
INSERT INTO `#__citations_types` VALUES (9,'magazine','Magazine','',NULL,NULL);
INSERT INTO `#__citations_types` VALUES (10,'manual','Manual','',NULL,NULL);
INSERT INTO `#__citations_types` VALUES (11,'mastersthesis','Masters Thesis','',NULL,NULL);
INSERT INTO `#__citations_types` VALUES (12,'misc','Misc','',NULL,NULL);
INSERT INTO `#__citations_types` VALUES (13,'phdthesis','PhD Thesis','',NULL,NULL);
INSERT INTO `#__citations_types` VALUES (14,'proceedings','Proceedings','',NULL,NULL);
INSERT INTO `#__citations_types` VALUES (15,'techreport','Tech Report','',NULL,NULL);
INSERT INTO `#__citations_types` VALUES (16,'unpublished','Unpublished','',NULL,NULL);
INSERT INTO `#__citations_types` VALUES (17,'patent','Patent','',NULL,NULL);
INSERT INTO `#__citations_types` VALUES (18,'chapter','Chapter','',NULL,NULL);
INSERT INTO `#__citations_types` VALUES (19,'notes','Text Snippet/Notes','',NULL,NULL);
INSERT INTO `#__citations_types` VALUES (20,'letter','Letter','',NULL,NULL);
INSERT INTO `#__citations_types` VALUES (21,'xarchive','XArchive','',NULL,NULL);
INSERT INTO `#__citations_types` VALUES (22,'manuscript','Manuscript','',NULL,NULL);
INSERT INTO `#__citations_types` VALUES (23,'paper','Paper',NULL,NULL,NULL);
INSERT INTO `#__citations_types` VALUES (24,'presentation','Presentation',NULL,NULL,NULL);
INSERT INTO `#__citations_types` VALUES (25,'publication','Publication',NULL,NULL,NULL);
INSERT INTO `#__citations_types` VALUES (26,'researchreport','Research Report',NULL,NULL,NULL);
INSERT INTO `#__citations_types` VALUES (27,'annualreport','Annual Report',NULL,NULL,NULL);
INSERT INTO `#__citations_types` VALUES (28,'governmentreport','Government report',NULL,NULL,NULL);
INSERT INTO `#__citations_types` VALUES (29,'poster','Poster',NULL,NULL,NULL);

--
-- HUBzero sample data for table `#__citations_format`
--

INSERT INTO `#__citations_format` (`id`, `typeid`, `style`, `format`) VALUES (1,NULL,'custom','');

--
-- HUBzero sample data for table `#__content`
--

INSERT INTO `#__content` VALUES (1,78,'Home','home','','{xhub:include type=\"stylesheet\" filename=\"pages/home.css\"}\r\n\r\n<div id=\"features\">\r\n	<div class=\"wrap\">\r\n		<h2>Features</h2>\r\n		<div class=\"three columns first\">\r\n			<div class=\"resource\">\r\n				{xhub:module position=\"featureLeft\"}\r\n			</div>\r\n		</div>\r\n		<div class=\"three columns second\">\r\n			<div class=\"poll\">\r\n				{xhub:module position=\"featureMiddle\"}\r\n			</div>\r\n		</div>\r\n		<div class=\"three columns third\">\r\n			<div class=\"tool\">\r\n				{xhub:module position=\"featureRight\"}\r\n			</div>\r\n		</div>\r\n		<div class=\"clear\"></div>\r\n	</div>\r\n</div>\r\n\r\n<div class=\"highlight-section\">\r\n	<p>\r\n		Welcome to our community for scientific and educational collaboration.\r\n	</p>\r\n</div><!-- / .highlight-section -->\r\n\r\n<div class=\"events-section\">\r\n	<div class=\"wrap\">\r\n		<div class=\"four columns first\">\r\n			<h2>News &amp; Events</h2>\r\n			<p>\r\n				Find out what\'s happening and what\'s new. Find information about the many public meetings and scientific symposia.\r\n			</p>\r\n		</div>\r\n		<div class=\"four columns second third fourth\">\r\n			<div class=\"two columns first\">\r\n				{xhub:module position=\"eventsLeft\"}\r\n			</div>\r\n			<div class=\"two columns second\">\r\n				{xhub:module position=\"eventsRight\"}\r\n			</div>\r\n			<div class=\"clear\"></div>\r\n		</div>\r\n		<div class=\"clear\"></div>\r\n	</div>\r\n</div><!-- / .inner -->\r\n\r\n<div class=\"resources-section wrap\">\r\n	<div class=\"four columns first\">\r\n		<h2>Resources</h2>\r\n		<p>\r\n			Browse our continually expanding user-submitted content that covers a broad range of topics.\r\n		</p>\r\n	</div>\r\n	<div class=\"four columns second third fourth\">\r\n		<div class=\"two columns first\">\r\n			<h3>Search</h3>\r\n			<form action=\"/search/\" method=\"get\" class=\"search\">\r\n				<fieldset>\r\n					<label for=\"rsearchword\">Keyword or phrase:</label>\r\n					<input type=\"text\" name=\"terms\" id=\"rsearchword\" value=\"\" />\r\n					<input type=\"hidden\" name=\"domains[]\" value=\"resources\" />\r\n					<input type=\"submit\" value=\"Search\" />\r\n				</fieldset>\r\n			</form>\r\n		</div>\r\n		<div class=\"two columns second\">\r\n			<h3>Upload</h3>\r\n			<p>\r\n				Become a contributor and share your work with the community! <a href=\"/resources/new\" class=\"contributelink\">Get started &rarr;</a>\r\n			</p>\r\n		</div>\r\n		<div class=\"clear\"></div>\r\n\r\n		<div class=\"two columns first\">\r\n			<h3>Categories</h3>\r\n			<ul>\r\n				<li><a href=\"/resources/courses\">Courses</a></li>\r\n				<li><a href=\"/resources/othermaterials\">Other Materials</a></li>\r\n				<li><a href=\"/resources/presentations\">Presentations</a></li>\r\n				<li><a href=\"/resources/publications\">Publications</a></li>\r\n				<li><a href=\"/resources/seminars\">Seminars</a></li>\r\n				<li><a href=\"/resources/tools\">Tools</a></li>\r\n			</ul>\r\n		</div>\r\n		<div class=\"two columns second\">\r\n			{xhub:module position=\"toptags\"}\r\n		</div>\r\n		<div class=\"clear\"></div>\r\n	</div>\r\n	<div class=\"clear\"></div>\r\n</div><!-- / .inner -->', '', '1', '0', '0', '2', '2010-03-25 06:26:40', '62', '', '2012-09-07 19:18:38', '1008', '0', '0000-00-00 00:00:00', '2010-03-25 06:26:40', '0000-00-00 00:00:00', '', '', '{\"show_title\":\"0\",\"link_titles\":\"\",\"show_intro\":\"1\",\"show_section\":\"0\",\"link_section\":\"0\",\"show_category\":\"0\",\"link_category\":\"0\",\"show_vote\":\"\",\"show_author\":\"0\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_pdf_icon\":\"0\",\"show_print_icon\":\"0\",\"show_email_icon\":\"0\",\"language\":\"\",\"keyref\":\"\",\"readmore\":\"\"}',20,0,1,'','',1,1645,'robots=\nauthor=',0,'','');
INSERT INTO `#__content` VALUES (2,79,'Our Cyberinfrastructure','hubzero','','<p>\r\n<img src=\"/media/system/images/hubzero-logo-2012.png\" align=\"right\"/>\r\nOur web site is powered by the <a href=\"http://hubzero.org\">HUBzero&reg;\r\nPlatform for Scientific Collaboration</a> originally developed at <a href=\"http://www.purdue.edu\">Purdue University</a>.\r\nHUBzero was specifically designed to help a scientific community share\r\nresources and work together with one another.  Users can upload their own\r\ncontent--including tutorials, courses, publications, and animations--and\r\nshare them with the rest of the community.  But each hub is more than\r\njust a repository of information.  It is a place where researchers and\r\neducators can collaborate in private spaces to build simulation/modeling tools, gather datasets, and share them online.  Users can launch\r\ncomputations and view results with an ordinary web browser--without\r\nhaving to download, compile, or install any code.  The tools they access\r\nare not just web forms, but powerful graphical tools that support visualization\r\nand comparison of results.\r\n</p>\r\n<h3>How Does a Hub Differ From a Web Site?</h3>\r\n<p>\r\nAt its core, a hub is a web site built with many familiar open source\r\npackages--the Linux operating system, an Apache web server, a MySQL\r\ndatabase, PHP web scripting, and the Joomla content management\r\nsystem.  The HUBzero software builds upon that infrastructure to create\r\nan environment in which researchers, educators, and students can access\r\nsimulation tools and share information.  Specifically, we define a \"hub\"\r\nas a web-based collaboration environment with the following features:\r\n<ul>\r\n	<li>Interactive simulation tools, hosted on the hub cluster and delivered to your browser</li>\r\n	<li>Simulation tool development area, including source code control and bug tracking</li>\r\n	<li>Videos and other supporting media for classes, tutorials, and documentation</li>\r\n	<li>Groups and projects for private collaboration</li>\r\n	<li>Mechanism for uploading and sharing resources</li>\r\n	<li>5-star ratings and user feedback for resources</li>\r\n	<li>User support area, with question-and-answer forum</li>\r\n	<li>Statistics about users and usage patterns</li>\r\n</ul>\r\n</p><p>\r\nYou can use this software to <a href=\"http://hubzero.org/getstarted\">start a hub</a> for your own scientific community.  Join others in the <a href=\"http://hubzero.org/about/foundation\">HUBzero Foundation</a> and help to develop the platform.  Visit <a href=\"http://hubzero.org\">HUBzero.org</a> to learn more.\r\n</p>','',1,1,0,8,'2010-03-25 06:26:40',62,'','0000-00-00 00:00:00',0,0,'0000-00-00 00:00:00','2010-03-25 06:26:40','0000-00-00 00:00:00','','','{\"show_title\":\"1\",\"link_titles\":\"\",\"show_intro\":\"1\",\"show_section\":\"0\",\"link_section\":\"0\",\"show_category\":\"0\",\"link_category\":\"0\",\"show_vote\":\"\",\"show_author\":\"0\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_pdf_icon\":\"0\",\"show_print_icon\":\"0\",\"show_email_icon\":\"0\",\"language\":\"\",\"keyref\":\"\",\"readmore\":\"\"}',2,0,1,'','',1,19,'robots=\nauthor=',0,'','');
INSERT INTO `#__content` VALUES (3,80,'About Us','about','','<p class=\"warning\">\r\nEdit this page and fill in information about your project.  Think of\r\nthis page as the front page of a brochure.  Describe your overall\r\nproject and its goals in simple terms.  The following text is just\r\na suggestion for the kinds of things you might see on this page.\r\n</p>\r\n\r\n<h3>Our Mission</h3>\r\n\r\n<p>The Your Organization (YORG) is funded by <i>Your Funding Organization</i>\r\nwith a mission to <i>change the world</i>.</p>\r\n\r\n<h3>What is {xhub:getcfg hubShortName}?</h3>\r\n<p>\r\nThis web site is a resource for research, education and collaboration\r\nin <i>your science area</i>.  It hosts\r\n<a href=\"/resources/browse\">various resources</a> which will help you learn\r\nabout <i>your science area</i>, including\r\n<a href=\"/resources/seminars\">Seminars</a>,\r\n<a href=\"/resources/courses\">Courses</a>,\r\n<a href=\"/resources/teachingmaterials\">Teaching Materials</a>, and more.\r\nThese resources come from <a href=\"/members\">contributors</a> in our\r\nscientific community, and are used by <a href=\"/usage\">visitors from all\r\nover the world</a>.\r\n</p>\r\n<p>\r\nMost importantly, {xhub:getcfg hubShortURL} offers live <a href=\"/resources/tools/\">Simulation/Modeling Tools</a>\r\nwhich you can access from your web browser, so you can not only learn\r\nabout but also simulate <i>your science area</i>.\r\n</p>\r\n\r\n<h3>Join Us</h3>\r\n<ul>\r\n<li><a href=\"/register\" title=\"Sign up!\">Create your own account</a>.\r\nIt\'s free and will give you access to our\r\n<a href=\"/resources/tools/\" title=\"View a list of tools\">online simulation tools</a>\r\nand <a href=\"/discover\">other features</a>.</li>\r\n<li><a href=\"/groups/new\">Create your own private user group</a> and collaborate privately with students and colleagues that you invite.</li>\r\n<li><a href=\"/resources/new\">Become a contributor</a>\r\nby uploading your own presentations and simulation tools for others to share.</li>\r\n<li><a href=\"/answers/question/new\">Ask a question</a> in our <a href=\"/answers\">community forum</a>, and let the\r\ncommunity help you out.</li>\r\n</ul>','',1,1,0,8,'2010-03-25 06:26:40',62,'','0000-00-00 00:00:00',1,0,'0000-00-00 00:00:00','2010-03-25 06:26:40','0000-00-00 00:00:00','','','{\"show_title\":\"1\",\"link_titles\":\"\",\"show_intro\":\"1\",\"show_section\":\"0\",\"link_section\":\"0\",\"show_category\":\"0\",\"link_category\":\"0\",\"show_vote\":\"\",\"show_author\":\"0\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_pdf_icon\":\"0\",\"show_print_icon\":\"0\",\"show_email_icon\":\"0\",\"language\":\"\",\"keyref\":\"\",\"readmore\":\"\"}',3,0,2,'','',1,173,'robots=\nauthor=',0,'','');
INSERT INTO `#__content` VALUES (4,81,'Contact Us','contact','','<p class=\"warning\">Edit this page and fill in your own contact information, so people know who owns and operates this site.</p>','',1,1,0,8,'2010-03-25 06:26:40',62,'','2010-03-27 16:19:26',63,0,'0000-00-00 00:00:00','2010-03-25 06:26:40','0000-00-00 00:00:00','','','{\"show_title\":\"1\",\"link_titles\":\"\",\"show_intro\":\"1\",\"show_section\":\"0\",\"link_section\":\"0\",\"show_category\":\"0\",\"link_category\":\"0\",\"show_vote\":\"\",\"show_author\":\"0\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_pdf_icon\":\"0\",\"show_print_icon\":\"0\",\"show_email_icon\":\"0\",\"language\":\"\",\"keyref\":\"\",\"readmore\":\"\"}',3,0,3,'','',1,34,'robots=\nauthor=',0,'','');
INSERT INTO `#__content` VALUES (5,82,'Quotes','quotes','','<div style=\"text-align:right; margin:0; padding:0 0 1em 0;\"><a href=\"feedback/success_story\">Add Your Success Story</a></div>\r\n<p>{xhub:module position=\"quotes\" style=\"-1\"}</p>','',1,1,0,8,'2010-03-25 06:26:40',62,'','2010-03-26 15:03:09',63,0,'0000-00-00 00:00:00','2010-03-25 06:26:40','0000-00-00 00:00:00','','','{\"show_title\":\"1\",\"link_titles\":\"\",\"show_intro\":\"1\",\"show_section\":\"0\",\"link_section\":\"0\",\"show_category\":\"0\",\"link_category\":\"0\",\"show_vote\":\"\",\"show_author\":\"0\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_pdf_icon\":\"0\",\"show_print_icon\":\"0\",\"show_email_icon\":\"0\",\"language\":\"\",\"keyref\":\"\",\"readmore\":\"\"}',2,0,4,'','',1,43,'robots=\nauthor=',0,'','');
INSERT INTO `#__content` VALUES (6,83,'Usage','usage','','About usage placeholder','',0,1,0,8,'2010-03-25 06:26:40',62,'','0000-00-00 00:00:00',0,0,'0000-00-00 00:00:00','2010-03-25 06:26:40','0000-00-00 00:00:00','','','{\"pageclass_sfx\":\"\",\"show_title\":\"1\",\"link_titles\":\"\",\"show_intro\":\"1\",\"show_section\":\"0\",\"link_section\":\"0\",\"show_category\":\"0\",\"link_category\":\"0\",\"show_vote\":\"\",\"show_author\":\"0\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_pdf_icon\":\"0\",\"show_print_icon\":\"0\",\"show_email_icon\":\"0\",\"language\":\"\",\"keyref\":\"\"}',1,0,5,'','',1,2,'robots=\nauthor=\n',0,'','');
INSERT INTO `#__content` VALUES (7,84,'Copyrights','dmcapolicy','','<p class=\"warning\">Edit this page and fill in your contact information at the bottom.  Having this in place protects you from copyright violations.  If any of your users uploads material that infringes copyright protection, the copyright owner will send a \"take down\" notice to the address below.  When you receive such a letter, you are obliged to unpublish the offending material right away.</p>\r\n<p>To file a copyright infringement notification with us, you will need to send a written communication that includes substantially the following (please consult your legal counsel or see Section 512(c)(3) of the Copyright Act to confirm these requirements):</p>\r\n<ul>\r\n<li> A physical or electronic signature of a person authorized to act on behalf of the owner of an exclusive right that is allegedly infringed.</li>\r\n<li> Identification of the copyrighted work claimed to have been infringed, or, if multiple copyrighted works at a single online site are covered by a single notification, a representative list of such works at that site.</li>\r\n<li> Identification of the material that is claimed to be infringing or to be the subject of infringing activity and that is to be removed or access to which is to be disabled, and information reasonably sufficient to permit the service provider to locate the material. <strong>Providing URLs in the body of an email is the best way to help us locate content quickly.</strong></li>\r\n<li> Information reasonably sufficient to permit the service provider to contact the complaining party, such as an address, telephone number, and, if available, an electronic mail address at which the complaining party may be contacted.</li>\r\n<li> A statement that the complaining party has a good faith belief that use of the material in the manner complained of is not authorized by the copyright owner, its agent, or the law.</li>\r\n<li> A statement that the information in the notification is accurate, and under penalty of perjury, that the complaining party is authorized to act on behalf of the owner of an exclusive right that is allegedly infringed.</li>\r\n</ul>\r\n<p>Such written notice should be sent to our designated agent as follows:</p>\r\n<address> DMCA Complaints<br /> This Person<br /> 1234 Street<br /> City, ST 99999<br /> Fax: 555-555-5555<br /> </address>\r\n<p>Please also note that under Section 512(f) any person who knowingly materially misrepresents that material or activity is infringing may be subject to liability.</p>','',1,1,0,8,'2010-03-25 06:26:40',62,'','2010-03-26 15:06:42',63,0,'0000-00-00 00:00:00','2010-03-25 06:26:40','0000-00-00 00:00:00','','','{\"show_title\":\"1\",\"link_titles\":\"\",\"show_intro\":\"1\",\"show_section\":\"0\",\"link_section\":\"0\",\"show_category\":\"0\",\"link_category\":\"0\",\"show_vote\":\"\",\"show_author\":\"0\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_pdf_icon\":\"0\",\"show_print_icon\":\"0\",\"show_email_icon\":\"0\",\"language\":\"\",\"keyref\":\"\",\"readmore\":\"\"}',3,0,6,'','',1,30,'robots=\nauthor=',0,'','');
INSERT INTO `#__content` VALUES (8,85,'Feedback','feedback','','About feedback placeholder','',1,1,0,8,'2010-03-25 06:26:40',62,'','0000-00-00 00:00:00',0,0,'0000-00-00 00:00:00','2010-03-25 06:26:40','0000-00-00 00:00:00','','','{\"pageclass_sfx\":\"\",\"show_title\":\"1\",\"link_titles\":\"\",\"show_intro\":\"1\",\"show_section\":\"0\",\"link_section\":\"0\",\"show_category\":\"0\",\"link_category\":\"0\",\"show_vote\":\"\",\"show_author\":\"0\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_pdf_icon\":\"0\",\"show_print_icon\":\"0\",\"show_email_icon\":\"0\",\"language\":\"\",\"keyref\":\"\"}',1,0,7,'','',1,41,'robots=\nauthor=\n',0,'','');
INSERT INTO `#__content` VALUES (11,86,'Terms of Use','terms','','<p class=\"warning\">Edit this page with appropriate terms of use for your site under advice of legal council at your institution.  The following text is provided as example text, with placeholders for <strong>MyInstitution</strong>, <strong>MyState</strong>, and <strong>MyCounty</strong>.</p>\r\n<p>Please read these Terms of Use carefully before accessing {xhub:getcfg hubShortURL}.  The {xhub:getcfg hubShortURL} site is operated by a community of researchers and hosted by MyInstitution.  Your access to {xhub:getcfg hubShortURL} is subject to your agreement to these Terms of Use.  By accessing {xhub:getcfg hubShortURL}, you accept, without limitation or qualification, these Terms of Use.</p>\r\n<h3>Modification of the Agreement</h3>\r\n<p>We maintain the right to modify these Terms of Use and may do so by posting modifications on this page.  Any modification is effective immediately upon posting the modification unless otherwise stated.  Your continued use of {xhub:getcfg hubShortURL} following the posting of any modification signifies your acceptance of that modification.  You should regularly visit this page to review the current Terms of Use.</p>\r\n<h3>Eligibility, Registration, Access, and Termination</h3>\r\n<p>The {xhub:getcfg hubShortURL} site is limited to non-commercial educational and research activities.  Posting of spam messages or other commercial advertisements is a violation of these terms and may result in termination of your account.</p>\r\n<p>Certain portions of {xhub:getcfg hubShortURL} are limited to registered users and/or allow a user to participate in online services by entering personal information.  You agree that any information provided to {xhub:getcfg hubShortURL} in these areas will be complete and accurate, and that you will neither register under the name of nor attempt to enter {xhub:getcfg hubShortURL} under the name of another person or entity.</p>\r\n<p>You are responsible for maintaining the confidentiality of your user ID and password, if any, and for restricting access to your computer, and you agree to accept responsibility for all activities that occur under your account or password.  {xhub:getcfg hubShortURL} does not authorize use of your User ID by third-parties.</p>\r\n<p>We may, in our sole discretion, terminate or suspend your access to and use of {xhub:getcfg hubShortURL} without notice and for any reason, including for violation of these Terms of Use or for other conduct that we, in our sole discretion, believe to be unlawful or harmful to others.  In the event of termination, you are no longer authorized to access {xhub:getcfg hubShortURL}.</p>\r\n<h3>Privacy and Confidentiality</h3>\r\n<p>We respect your privacy.  We will only use your personal identification information to support and manage your use of {xhub:getcfg hubShortURL}, including the use of tracking cookies to facilitate {xhub:getcfg hubShortURL} security procedures.  MyInstitution and {xhub:getcfg hubShortURL} sponsors regularly request {xhub:getcfg hubShortURL} usages statistics and other information.  Usage of {xhub:getcfg hubShortURL} is monitored and usage statistics are collected and reported on a regular basis.  {xhub:getcfg hubShortURL} also reserves the right to contact you to request additional information or to keep you updated on changes to {xhub:getcfg hubShortURL}.  You may opt out of receiving newsletters and other non-essential communications.  No information that would identify you personally will be provided to sponsors or third parties without your permission.</p>\r\n<p>All information posted or stored on {xhub:getcfg hubShortURL} is potentially available to all other users of {xhub:getcfg hubShortURL}.  MyInstitution and {xhub:getcfg hubShortURL} disclaim any responsibility or capability for the preservation of confidentiality of such information. <em>Do not post or store information on {xhub:getcfg hubShortURL} if you expect to or are obligated to protect the confidentiality of that information.</em></p>\r\n<h3>Conduct</h3>\r\n<p>You are responsible at all times for using {xhub:getcfg hubShortURL} in a manner that is legal, ethical, and not to the detriment of others.  Quotas for disk storage, job submissions, and other limited resources are strictly enforced.  You may request an increase in your quota, but attempting to circumvent your quota is unethical and may lead to a termination of your account.  You agree to delete unused files and acknowledge that if you fail to do so, the files may be deleted for you.  You agree that you will not:</p>\r\n<ul>\r\n<li>Use email addresses obtained or accessed through {xhub:getcfg hubShortURL} to transmit the same or substantially similar unsolicited message to multiple recipients without a valid purpose specifically related to the research and education mission of {xhub:getcfg hubShortURL};</li>\r\n<li>Use {xhub:getcfg hubShortURL} to commit a criminal offense or to encourage others to conduct that would constitute a criminal offense or give rise to a civil liability;</li>\r\n<li>Violate any applicable law;</li>\r\n<li>Post or transmit any unlawful, threatening, libelous, harassing, defamatory, vulgar, obscene, pornographic, profane, or otherwise objectionable content;</li>\r\n<li>Use {xhub:getcfg hubShortURL} to impersonate other parties or entities;</li>\r\n<li>Use {xhub:getcfg hubShortURL} to upload any content that contains a software virus, \"Trojan Horse\" or any other computer code, files, or programs that may alter, damage, or interrupt the functionality of {xhub:getcfg hubShortURL} or the hardware or software of any other person who accesses {xhub:getcfg hubShortURL};</li>\r\n<li>Upload, post, email, or otherwise transmit any materials that you do not have a right to transmit under any law or under a contractual relationship;</li>\r\n<li>Alter, damage, or delete any content posted on {xhub:getcfg hubShortURL};</li>\r\n<li>Disrupt the normal flow of communication in any way;</li>\r\n<li>Claim a relationship with or speak for any business, association, or other organization for which you are not authorized to claim such a relationship;</li>\r\n<li>Post or transmit any unsolicited advertising, promotional materials, or other forms of solicitation;</li>\r\n<li>Post any material that infringes or violates the intellectual property rights of another.</li>\r\n</ul>\r\n<h3>Disclaimers</h3>\r\n<p>THE {xhub:getcfg hubShortName} AND ANY INFORMATION, PRODUCTS OR SERVICES ON IT ARE PROVIDED \"AS IS\" WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  MyInstitution and {xhub:getcfg hubShortURL} do not warrant, and hereby disclaim any warranties, either express or implied, with respect to the accuracy, adequacy or completeness of any good, service, or information obtained from {xhub:getcfg hubShortURL}.  MyInstitution does not warrant that {xhub:getcfg hubShortURL} will operate in an uninterrupted or error-free manner or that {xhub:getcfg hubShortURL} is free of viruses or other harmful components.  Use of {xhub:getcfg hubShortURL} is at your own risk.</p>\r\n<p>You agree that {xhub:getcfg hubShortURL} and its administrator, MyInstitution, shall have no liability for any consequential, indirect, punitive, special or incidental damages, whether foreseeable or unforeseeable (including, but not limited to, claims for defamation, errors, loss of data, or interruption in availability of data), arising out of or relating to your use of {xhub:getcfg hubShortURL} or any resource that you access through {xhub:getcfg hubShortURL}.</p>\r\n<p>The {xhub:getcfg hubShortURL} site hosts content from a number of authors.  The statements and views of these authors are theirs alone, and do not reflect the stances or policies of MyInstitution or their sponsors, nor does their posting imply the endorsement of MyInstitution or their sponsors.</p>\r\n<h3>Choice of Law/Forum Selection/Attorney Fees</h3>\r\n<p>You agree that any dispute arising out of or relating to {xhub:getcfg hubShortURL}, whether based in contract, tort, statutory or other law, will be governed by federal law and by the laws of MyState, excluding its conflicts of law provisions.  You further consent to the personal jurisdiction of and exclusive venue in the federal and state courts located in and serving MyCounty, MyState as the exclusive legal forums for any such dispute.</p>','',1,3,0,9,'2010-03-25 06:26:40',62,'','2010-03-26 15:18:45',63,0,'0000-00-00 00:00:00','2010-03-25 06:26:40','0000-00-00 00:00:00','','','{\"show_title\":\"1\",\"link_titles\":\"0\",\"show_intro\":\"1\",\"show_section\":\"0\",\"link_section\":\"0\",\"show_category\":\"0\",\"link_category\":\"0\",\"show_vote\":\"\",\"show_author\":\"0\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_pdf_icon\":\"0\",\"show_print_icon\":\"0\",\"show_email_icon\":\"0\",\"language\":\"\",\"keyref\":\"\",\"readmore\":\"\"}',9,0,8,'','',1,20,'robots=\nauthor=',0,'','');
INSERT INTO `#__content` VALUES (12,87,'Intellectual Property Considerations','licensing','','<p>\r\nAll materials contributed to {xhub:getcfg hubShortURL} must have clearly defined rights\r\nand privileges.  We have instituted the following guidelines for all\r\nmaterials uploaded onto this site:\r\n</p>\r\n<h3>Simulation Tools</h3>\r\n<p>\r\n<div style=\"float:left; margin:10px;\">\r\n<a href=\"http://www.opensource.org/docs/definition.php\">\r\n<img src=\"/media/system/images/open_source_button.png\"  alt=\"Open Source (OSI) Logo\"></a>\r\n</div>\r\nSimulation tools can be made available online through HUBzero\'s\r\n<a href=\"http://hubzero.org/topics/middleware\">unique middleware</a>, so\r\nusers don\'t have to download or install any source code.  As such, the\r\nsource code for your tool can be completely protected, and may not require\r\nany license.  We do encourage our developers, however, to release their\r\ntools as <a href=\"http://www.opensource.org/\">open source</a> so that\r\nothers can build upon their work.  Please check with your local institution\r\nfor details on their policy for open source release.  If you\r\ndecide to make your source code available for download, we do require\r\nthat you include some well-defined license so that our users clearly\r\nunderstand how they are allowed to use your source code.  The <a href=\"http://opensource.org/licenses/alphabetical\">licenses available on opensource.org</a> have been vetted by lawyers and can be used right out of the box.\r\n</p>\r\n\r\n<h3>Seminars and Other Materials</h3>\r\n<p>\r\n<div style=\"float:left; margin:10px;\">\r\n<a rel=\"license\" href=\"http://creativecommons.org/licenses/by-nc-sa/3.0/\"><img alt=\"Creative Commons License\" style=\"border-width: 0\" src=\"/media/system/images/creativecommons-2.5.png\" style=\"float:left;\"/></a>\r\n</div>\r\nWe strongly encourage contributors of online presentations, teaching\r\nmaterials, animations, and other materials to adopt the\r\n<a href=\"http://creativecommons.org/licenses/by-nc-sa/3.0/\" title=\"Learn more about Creative Commons\">Creative Commons 3.0 license</a>.\r\nThis allows others to use your work for non-commercial purposes, but\r\nthey must acknowledge you as a source and share their derivative works\r\nunder the same license.  Note that this also gives you an opportunity\r\nto build upon their work!</p>\r\n<p>\r\nWe strongly encourage all contributors to adopt these licensing guidelines.\r\nIf you want to contribute, but for some reason you are unable to agree to\r\nthese licenses, please <a href=\"/support/ticket/new\">contact us</a>,\r\nso we can follow up and discuss other options.\r\n</p>','',1,3,0,9,'2010-03-25 06:26:40',62,'','2010-03-27 15:53:32',63,0,'0000-00-00 00:00:00','2010-03-25 06:26:40','0000-00-00 00:00:00','','','{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_section\":\"\",\"link_section\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_vote\":\"\",\"show_author\":\"0\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_pdf_icon\":\"0\",\"show_print_icon\":\"0\",\"show_email_icon\":\"0\",\"language\":\"\",\"keyref\":\"\",\"readmore\":\"\"}',13,0,7,'','',1,15,'robots=\nauthor=',0,'','');
INSERT INTO `#__content` VALUES (13,88,'Creative Commons','cc','','<h3>What is Creative Commons?</h3>\r\n\r\n<p>\r\n<img src=\"/media/system/images/cc_button.jpg\" style=\"float: left; margin: 6px;\"/>The Creative Commons (CC) enables copyright holders to grant some or all of their rights to the public while retaining others through a variety of licensing and contract schemes. {xhub:getcfg hubShortName} prefers the <a href=\"http://creativecommons.org/licenses/by-nc-sa/3.0/\">Creative Commons 3.0</a> license, which is well suited to education and academic research.  This license allows people to use your work for non-commercial purposes, but they must attribute you as a source, and they must share any derivative works under the same license.</p>\r\n\r\n<p><i>Offering your work under a CC license does not mean giving up your copyright. It means offering some of your rights to any member of the public but only on certain conditions.</i>  You may offer your work on {xhub:getcfg hubShortName} under a non-commercial license and still grant commercial licenses separately, on a case-by-case basis.</p>\r\n\r\n<p>For further information on Creative Commons visit the <a href=\"http://creativecommons.org/\">Creative Commons homepage</a>.</p>\r\n\r\n<h3>From the Creative Commons FAQ:</h3>\r\n\r\n<blockquote cite=\"http://wiki.creativecommons.org/FAQ\">\r\n<h4>What if I change my mind?</h4>\r\n<p>Creative Commons licenses are non-revocable. This means that you cannot stop someone, who has obtained your work under a Creative Commons license, from using the work according to that license. You can stop distributing your work under a Creative Commons license at any time you wish; but this will not withdraw any copies of your work that already exist under a Creative Commons license from circulation, be they verbatim copies, copies included in collective works and/or adaptations of your work. So you need to think carefully when choosing a Creative Commons license to make sure that you are happy for people to be using your work consistent with the terms of the license, even if you later stop distributing your work.</p>\r\n\r\n<h4>Do Creative Commons licenses affect fair use, fair dealing or other exceptions to copyright?</h4>\r\n<p>No. All jurisdictions allow some uses of copyrighted material without permission, such as quotation, current-affairs reporting, or parody, although these vary from country to country. These are not dependent on the license and so cannot be affected by it. To make this clear, all of our licenses include this or similar language: Nothing in this license is intended to reduce, limit, or restrict any rights arising from fair use, first sale or other limitations on the exclusive rights of the copyright owner under copyright law or other applicable laws. Thus, regardless of the jurisdiction a user is in, our licenses do not affect a user\'s right to use or allow use of content under copyright exceptions.</p>\r\n\r\n<h4>What happens if someone misuses my Creative Commons-licensed work?</h4>\r\n<p>A Creative Commons license terminates automatically if someone uses your work contrary to the license terms. This means that, if a person uses your work under a Creative Commons license and they, for example, fail to attribute your work in the manner you specified, then they no longer have the right to continue to use your work. This only applies in relation to the person in breach of the license; it does not apply generally to the other people who use your work under a Creative Commons license and comply with its terms.</p>\r\n</blockquote>','',1,3,0,9,'2010-03-25 06:26:40',62,'','2010-03-27 20:24:17',63,0,'0000-00-00 00:00:00','2010-03-25 06:26:40','0000-00-00 00:00:00','','','{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_section\":\"\",\"link_section\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_vote\":\"0\",\"show_author\":\"0\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_pdf_icon\":\"0\",\"show_print_icon\":\"0\",\"show_email_icon\":\"0\",\"language\":\"\",\"keyref\":\"\",\"readmore\":\"\"}',10,0,6,'','',1,5,'robots=\nauthor=',0,'','');
INSERT INTO `#__content` VALUES (14,89,'Submitting Content','license','','<p>\r\n		THE WORK (AS DEFINED BELOW) IS PROVIDED UNDER THE TERMS OF THIS LICENSE.  THE WORK IS PROTECTED BY COPYRIGHT AND/OR OTHER APPLICABLE LAW.  ANY USE OF THE WORK OTHER THAN AS AUTHORIZED UNDER THIS LICENSE OR COPYRIGHT LAW IS PROHIBITED.\r\n	</p>\r\n	<p>\r\n		{xhub:getcfg hubShortURL} ACCEPTS AND AGREES TO BE BOUND BY THE TERMS OF THIS LICENSE.  THE LICENSOR (YOU) GRANTS {xhub:getcfg hubShortURL} THE RIGHTS CONTAINED HERE IN CONSIDERATION OF {xhub:getcfg hubShortURL}\'S ACCEPTANCE OF SUCH TERMS AND CONDITIONS.\r\n	</p>\r\n	<ol>\r\n	 <li>Definitions\r\n		<ol>\r\n		 <li>\"Collective Work\" means a work, such as a periodical issue, anthology or encyclopedia, in which the Work in its entirety in unmodified form, along with a number of other contributions, constituting separate and independent works in themselves, are assembled into a collective whole.  A work that constitutes a Collective Work will not be considered a Derivative Work (as defined below) for the purposes of this License.</li>\r\n		 <li>\"Derivative Work\" means a work based upon the Work or upon the Work and other pre-existing works, such as a translation, musical arrangement, dramatization, fictionalization, motion picture version, sound recording, art reproduction, abridgment, condensation, or any other form in which the Work may be recast, transformed, or adapted, except that a work that constitutes a Collective Work will not be considered a Derivative Work for the purpose of this License.  For the avoidance of doubt, where the Work is a musical composition or sound recording, the synchronization of the Work in timed-relation with a moving image (\"synching\") will be considered a Derivative Work for the purpose of this License.</li>\r\n		 <li>\"Licensor\" means the individual or entity that offers the Work under the terms of this License.</li>\r\n		 <li>\"Original Author\" means the individual or entity who created the Work.</li>\r\n		 <li>\"Work\" means the copyrightable work of authorship offered under the terms of this License.</li>\r\n		</ol>\r\n	 </li>\r\n	 <li>License Grant\r\n		<p>Subject to the terms and conditions of this License, Licensor hereby grants {xhub:getcfg hubShortURL} a worldwide, royalty-free, non-exclusive, perpetual (for the duration of the applicable copyright) license to exercise the rights in the Work as stated below:</p>\r\n		<ol>\r\n		 <li>to reproduce the Work, to incorporate the Work into one or more Collective Works, and to reproduce the Work as incorporated in the Collective Works;</li>\r\n		 <li>to create and reproduce Derivative Works;</li>\r\n		 <li>to distribute copies or phonorecords of, display publicly, perform publicly, and perform publicly by means of a digital audio transmission the Work including as incorporated in Collective Works;</li>\r\n		 <li>to distribute copies or phonorecords of, display publicly, perform publicly, and perform publicly by means of a digital audio transmission Derivative Works;</li>\r\n		</ol>\r\n		<p>The above rights may be exercised in all media and formats whether now known or hereafter devised.  The above rights include the right to make such modifications as are technically necessary to exercise the rights in other media and formats.  All rights not expressly granted by Licensor are hereby reserved, including but not limited to the rights set forth in Sections 4(d) and 4(e).</p>\r\n	</li>\r\n	<li>Representations, Warranties and Disclaimer\r\n		<p>UNLESS OTHERWISE MUTUALLY AGREED BY THE PARTIES IN WRITING, LICENSOR AND {xhub:getcfg hubShortURL} BOTH OFFER THE WORK AS-IS AND MAKE NO REPRESENTATIONS OR WARRANTIES OF ANY KIND CONCERNING THE WORK, EXPRESS, IMPLIED, STATUTORY OR OTHERWISE, INCLUDING, WITHOUT LIMITATION, WARRANTIES OF TITLE, MERCHANTIBILITY, FITNESS FOR A PARTICULAR PURPOSE, NONINFRINGEMENT, OR THE ABSENCE OF LATENT OR OTHER DEFECTS, ACCURACY, OR THE PRESENCE OF ABSENCE OF ERRORS, WHETHER OR NOT DISCOVERABLE.  SOME JURISDICTIONS DO NOT ALLOW THE EXCLUSION OF IMPLIED WARRANTIES, SO SUCH EXCLUSION MAY NOT APPLY IN ALL SITUATIONS.</p>\r\n	</li>\r\n	<li>Limitation on Liability\r\n		<p>EXCEPT TO THE EXTENT REQUIRED BY APPLICABLE LAW, IN NO EVENT WILL LICENSOR HOLD {xhub:getcfg hubShortURL} LIABLE ON ANY LEGAL THEORY FOR ANY SPECIAL, INCIDENTAL, CONSEQUENTIAL, PUNITIVE OR EXEMPLARY DAMAGES ARISING OUT OF THIS LICENSE OR THE USE OF THE WORK, EVEN IF LICENSOR AND/OR {xhub:getcfg hubShortURL} HAVE BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.</p>\r\n	</li>\r\n	<li>Termination\r\n		<ol>\r\n		 <li>This License and the rights granted hereunder will terminate automatically upon any breach by {xhub:getcfg hubShortURL} of the terms of this License.  Individuals or entities who have received Collective Works or Derivative Works from {xhub:getcfg hubShortURL} under this License, however, will not have their licenses terminated provided such individuals or entities remain in full compliance with those licenses.  Sections 1, 2, 5, 6, 7, and 8 will survive any termination of this License.</li>\r\n		 <li>Subject to the above terms and conditions, the license granted here is perpetual (for the duration of the applicable copyright in the Work).  Notwithstanding the above, Licensor reserves the right to release the Work under different license terms or to stop distributing the Work at any time; provided, however that any such election will not serve to withdraw this License (or any other license that has been, or is required to be, granted under the terms of this License), and this License will continue in full force and effect unless terminated as stated above.</li>\r\n		</ol>\r\n	 </li>\r\n	 <li>Miscellaneous\r\n		<ol>\r\n		 <li>Each time {xhub:getcfg hubShortURL} distributes or publicly digitally performs the Work, a Collective Work, or a Derivative Work, the Licensor offers to the recipient a license to the Work on the same terms and conditions as the license granted to {xhub:getcfg hubShortURL} under this License.</li>\r\n		 <li>If any provision of this License is invalid or unenforceable under applicable law, it shall not affect the validity or enforceability of the remainder of the terms of this License, and without further action by the parties to this agreement, such provision shall be reformed to the minimum extent necessary to make such provision valid and enforceable.</li>\r\n		 <li>No term or provision of this License shall be deemed waived and no breach consented to unless such waiver or consent shall be in writing and signed by the party to be charged with such waiver or consent.</li>\r\n		 <li>This License constitutes the entire agreement between the parties with respect to the Work licensed here.  There are no understandings, agreements or representations with respect to the Work not specified here.  Neither Licensor nor {xhub:getcfg hubShortURL} shall be bound by any additional provisions that may appear in any communication between the parties.  This License may not be modified without the mutual written agreement of the Licensor and {xhub:getcfg hubShortURL}.</li>\r\n		</ol>\r\n	 </li>\r\n	</ol>','',1,3,0,9,'2010-03-25 06:26:40',62,'','0000-00-00 00:00:00',0,0,'0000-00-00 00:00:00','2010-03-25 06:26:40','0000-00-00 00:00:00','','','{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_section\":\"\",\"link_section\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_vote\":\"0\",\"show_author\":\"0\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_pdf_icon\":\"0\",\"show_print_icon\":\"0\",\"show_email_icon\":\"0\",\"language\":\"\",\"keyref\":\"\",\"readmore\":\"\"}',7,0,5,'','',1,1,'robots=\nauthor=',0,'','');
INSERT INTO `#__content` VALUES (22,90,'Discover','discover','','{xhub:include type=\"stylesheet\" filename=\"pages/discover.css\"}\r\n<div class=\"grid\">\r\n	<div class=\"col span-quarter\">\r\n		<h2>Do More</h2>\r\n	</div>\r\n\r\n	<div class=\"col span-quarter\">\r\n		<div class=\"presentation\">\r\n			<h3><a href=\"/resources\">Resources</a></h3>\r\n			<p>Find the latest cutting-edge research in our <a href=\"/resources\">resources</a>.</p>\r\n		</div>\r\n	</div>\r\n	<div class=\"col span-quarter\">\r\n		<div class=\"quote\">\r\n			<h3><a href=\"/citations\">Citations</a></h3>\r\n			<p>See who has <a href=\"/citations\">cited</a> our content in their work.</p>\r\n		</div>\r\n	</div>\r\n	<div class=\"col span-quarter omega\">\r\n		<div class=\"tag\">\r\n			<h3><a href=\"/tags\">Tags</a></h3>\r\n			<p>Explore all our content through <a href=\"/tags\">tags</a> or even tag content yourself.</p>\r\n		</div>\r\n	</div>\r\n</div>\r\n\r\n<div class=\"grid below\">\r\n	<div class=\"col span-quarter offset-quarter\">\r\n		<div class=\"blog\">\r\n			<h3><a href=\"/blog\">Blog</a></h3>\r\n			<p>Read the <a href=\"/blog\">latest entry</a> or browse the archive for articles of interest.</p>\r\n		</div>\r\n	</div>\r\n	<div class=\"col span-quarter\">\r\n		<div class=\"wiki\">\r\n			<h3><a href=\"/wiki\">Wiki</a></h3>\r\n			<p>Browse our user-generated <a href=\"/wiki\">wiki pages</a> or write your own.</p>\r\n		</div>\r\n	</div>\r\n	<div class=\"col span-quarter omega\">\r\n		<div class=\"feedback\">\r\n			<h3><a href=\"/feedback\">Feedback</a></h3>\r\n			<p>Like something? Having trouble? <a href=\"/feedback\">Let us know what you think!</a></p>\r\n		</div>\r\n	</div>\r\n</div>\r\n\r\n<div class=\"grid\">\r\n	<div class=\"col span-quarter\">\r\n		<h2>Services</h2>\r\n	</div>\r\n	<div class=\"col span-quarter\">\r\n		<div class=\"contribute\">\r\n			<h3><a href=\"/resources/new\">Upload</a></h3>\r\n			<p><a href=\"/resources/new\">Publish</a> your own tools, seminars, and other content on this site.</p>\r\n		</div>\r\n	</div>\r\n	<div class=\"col span-quarter\">\r\n		<div class=\"tool\">\r\n			<h3><a href=\"/tools\">Tool Forge</a></h3>\r\n			<p>The <a href=\"/tools\">development area</a> for simulation tools. Sign up and manage your own software project!</p>\r\n		</div>\r\n	</div>\r\n	<div class=\"col span-quarter omega\">\r\n		<div class=\"cart\">\r\n			<h3><a href=\"/store\">Store</a></h3>\r\n			<p><a href=\"/store\">Purchase items</a> such as t-shirts using points you earn by helping out.</p>\r\n		</div>\r\n	</div>\r\n</div>\r\n\r\n<div class=\"grid\">\r\n	<div class=\"col span-quarter\">\r\n		<h2>What\'s Happening</h2>\r\n	</div>\r\n	<div class=\"col span-quarter\">\r\n		<div class=\"event\">\r\n			<h3><a href=\"/events\">Events</a></h3>\r\n			<p>Find information about the many upcoming <a href=\"/events\">public meetings and scientific symposia</a>.</p>\r\n		</div>\r\n	</div>\r\n	<div class=\"col span-quarter\">\r\n		<div class=\"new\">\r\n			<h3><a href=\"/whatsnew\">What\'s New</a></h3>\r\n			<p>Find the latest content posted on the site with our <a href=\"/whatsnew\">What\'s New</a> section.</p>\r\n		</div>\r\n	</div>\r\n	<div class=\"col span-quarter omega\">\r\n		<div class=\"poll\">\r\n			<h3><a href=\"/poll\">Poll</a></h3>\r\n			<p>Respond to our poll questions and <a href=\"/poll\">see what everyone else is thinking</a>.</p>\r\n		</div>\r\n	</div>\r\n</div>', '', '1', '0', '0', '2', '2010-03-27 16:47:23', '62', '', '2013-08-29 20:43:06', '1000', '0', '0000-00-00 00:00:00', '2010-03-27 16:47:23', '0000-00-00 00:00:00', '', '', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"0\",\"link_author\":\"\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"0\",\"show_email_icon\":\"0\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}',13,0,4,'','',1,155,'{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}',0,'*','');
INSERT INTO `#__content` VALUES (32,91,'Congratulations','congratulations','','{xhub:include type=\"stylesheet\" filename=\"pages/congrats.css\"}\r\n\r\n<div id=\"features\">\r\n<div class=\"wrap\">\r\n	<div class=\"three columns first\">\r\n<div class=\"use\">\r\n		<h3>Utilize</h3>\r\n		<p>View tutorials and read about how to use the numerous features of a hub. We show you how to add content, customize your dashboard, create groups, and more.</p>\r\n		<p class=\"btn-container\"><a class=\"btn\" href=\"http://hubzero.org/documentation/1.1.0/users\" rel=\"external\">User documentation</a></p>\r\n</div>\r\n	</div>\r\n	<div class=\"three columns second\">\r\n<div class=\"manage\">\r\n		<h3>Manage</h3>\r\n		<p>Read the manual for managing the content and functionality of a hub. It progresses step-by-step through various common tasks and familiarizes you with the administrative interface.</p>\r\n		<p class=\"btn-container\"><a class=\"btn\" href=\"http://hubzero.org/documentation/1.1.0/managers\" rel=\"external\">Manager documentation</a></p>\r\n</div>\r\n	</div>\r\n	<div class=\"three columns third\">\r\n<div class=\"customize\">\r\n		<h3>Extend</h3>\r\n		<p>Build your own extensions and discover how to extend or tailor the existing ones to your needs. We try to guide you through the creation steps and provide examples for download.</p>\r\n		<p class=\"btn-container\"><a class=\"btn\" href=\"http://hubzero.org/documentation/1.1.0/webdevs\" rel=\"external\">Developer documentation</a></p>\r\n</div>\r\n	</div>\r\n	<div class=\"clear\"></div>\r\n</div>\r\n</div>\r\n\r\n<div class=\"highlight-section\">\r\n	<p>\r\n		Ready to go? Jump to the <a rel=\"external\" href=\"/administrator\">administration</a> or learn how to <a href=\"http://hubzero.org/documentation/1.1.0/managers/articles.homepage\" rel=\"external\">change this page</a>.\r\n	</p>\r\n</div><!-- / .highlight-section -->\r\n\r\n<div class=\"support-section\">\r\n<div class=\"wrap\">\r\n	<div class=\"four columns first\">\r\n		<h2>Support</h2>\r\n		<p>\r\n			If you need help or support while developing your hub, reach out to us.\r\n		</p>\r\n	</div>\r\n	<div class=\"four columns second third fourth\">\r\n		<div class=\"two columns first\">\r\n			<h3>I have an idea!</h3>\r\n			<p>\r\n				Think something can be done better or is missing? Post your <a href=\"http://hubzero.org/wishlist\" rel=\"external\">ideas or feature requests</a>. We\'d love to hear from you.\r\n			</p>\r\n		</div>\r\n		<div class=\"two columns second\">\r\n			<h3>I have an error!</h3>\r\n			<p>\r\n				We continually test our code and strive for a smooth, error-free experience but, sadly, we can make mistakes. If you found a bug, <a href=\"http://hubzero.org/support/ticket/new\" rel=\"external\">let us know</a>.\r\n			</p>\r\n		</div>\r\n		<div class=\"clear\"></div>\r\n	</div>\r\n	<div class=\"clear\"></div>\r\n</div>\r\n</div><!-- / .inner -->\r\n\r\n<div class=\"blocks-section wrap\">\r\n	<div class=\"four columns first\">\r\n		<h2>Community</h2>\r\n		<p>\r\n			Connect with the growing HUBzero developer community and see what your peers have to say.\r\n		</p>\r\n	</div>\r\n	<div class=\"four columns second third fourth\">\r\n		<div class=\"two columns first\">\r\n			<h3>Groups</h3>\r\n			<p>\r\n				Members working together. <a rel=\"external\" href=\"http://hubzero.org/groups\">Groups</a> allow <a rel=\"external\" href=\"http://hubzero.org/members\">members</a> with similar interests to get in touch with each other and collaborate on projects.\r\n			</p>\r\n		</div>\r\n		<div class=\"two columns second\">\r\n			<h3>Wiki</h3>\r\n			<p>\r\n				The <a rel=\"external\" href=\"http://hubzero.org/wiki\">wiki</a> is a space where you can share work, ideas, pictures, links, and media &mdash; and just about anything else you can think of.\r\n			</p>\r\n		</div>\r\n		<div class=\"clear\"></div>\r\n\r\n		<div class=\"two columns first\">\r\n			<h3>Questions &amp; Answers</h3>\r\n			<p>\r\n				This is where you can <a rel=\"external\" href=\"http://hubzero.org/answers\">ask questions</a>, get answers, and help others in the community.\r\n			</p>\r\n		</div>\r\n		<div class=\"two columns second\">\r\n			<h3>Forums</h3>\r\n			<p>\r\n				A place for you to start a <a rel=\"external\" href=\"http://hubzero.org/forum\">discussion</a> or find out what everyone is talking about.\r\n			</p>\r\n		</div>\r\n		<div class=\"clear\"></div>\r\n	</div>\r\n	<div class=\"clear\"></div>\r\n</div><!-- / .inner -->','',1,0,0,2,'2012-09-07 16:55:44',1008,'','2012-09-07 19:16:06',1008,0,'0000-00-00 00:00:00','2012-09-07 16:55:44','0000-00-00 00:00:00','','','{\"show_title\":\"0\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_section\":\"\",\"link_section\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_vote\":\"\",\"show_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_pdf_icon\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"language\":\"\",\"keyref\":\"\",\"readmore\":\"\"}',2,0,2,'','',1,7,'robots=\nauthor=',0,'','');
INSERT INTO `#__content` VALUES (27,92,'Privacy Policy','privacy','','<p>We respect your privacy. We will never sell your e-mail address or other personally identifiable information to third parties, or make that information publicly available without your permission.</p>\r\n<p>We are a scientific project and we provide a free service, so we do track your activities on this site.  We combine your usage metrics with others to create an aggregate picture of how the site is being used, and we report <a href=\"usage\">that usage</a> publicly on our site and send similar quarterly reports to our program sponsors.  However, such usage reports never contain detailed information about your activities as an individual without your prior consent.</p>\r\n<p>From time to time, we work with other other projects that seek to study social interactions on the site.  We may share your activities with those groups, but they are bound by a Memorandum of Understanding to follow our policies and respect your privacy in the same way that we do.  We may contact you on their behalf and ask you to participate in their study, but your participation is voluntary, and your information will not be publicly released without your prior consent.</p>\r\n<p>We reserve the right to contact you to request additional information or to keep you updated on changes to {xhub:getcfg hubShortURL}. You may opt out of receiving newsletters and other non-essential communications by updating the settings in your account profile.</p>\r\n<p>All resources, wiki articles, blogs, questions, answers, or other information posted or stored on {xhub:getcfg hubShortURL} is potentially available to all other users of {xhub:getcfg hubShortURL}.  We do our best to restrict access to source code and to other private materials shared within groups.  However, we are a research project and our software is constantly changing.  We disclaim any responsibility or capability for the preservation of confidentiality of any information posted on this site. <em>Do not post or store information on {xhub:getcfg hubShortURL} if you expect to or are obligated to protect the confidentiality of that information.</em></p>\r\n<h3>Changes to policy</h3>\r\n<p>We may occasionally update our Privacy Policy to reflect changes in our practices and services. If we make material changes in the way we collect, use, or share your personal information, we will notify you and/or prominently post notices of the changes on our website.</p>','',1,3,0,9,'2012-05-02 12:15:06',62,'','2012-05-02 12:20:30',62,0,'0000-00-00 00:00:00','2012-05-02 12:15:06','0000-00-00 00:00:00','','','{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_section\":\"\",\"link_section\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_vote\":\"\",\"show_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_pdf_icon\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"language\":\"\",\"keyref\":\"\",\"readmore\":\"\"}',2,0,4,'','',1,0,'robots=\nauthor=',0,'','');
INSERT INTO `#__content` VALUES (28,93,'Abuse Policy','abuse','','<p>\r\nYou are responsible at all times for using {xhub:getcfg hubShortURL} in a manner that is legal, ethical, and not to the detriment of others.  Once you have created an account, you are allowed to post materials and participate in other social networking features available on this site.  All members are encouraged to help moderate content and click on \"report abuse\" links to report any material deemed offensive or inappropriate.  If your posted material is reported as abusive, it will be immediately withdrawn and subsequently reviewed by a site administrator.  If the material is judged to be appropriate, it will be restored.  Otherwise, it will be removed from the site, and depending on the inappropriate nature of the content, your account may be terminated.\r\n</p><p>\r\nAll users must recognize that system resources on {xhub:getcfg hubShortURL} are limited.  Quotas for disk storage, job submissions, and other limited resources are strictly enforced. By using {xhub:getcfg hubShortURL}, you agree to delete unused files and acknowledge that if you fail to do so, the files may be deleted for you.  You may request an increase in system quotas, and you may use points to pay for premium services, but you may not circumvent the policies put in place to manage resources.\r\n</p><p>\r\n<em>Creating multiple accounts or otherwise gaming the system in order to earn extra points, to increase your disk quota, or to gain an unfair share of other system resources is strictly prohibited and may lead to termination of your account.</em></p>\r\n<p>\r\nBy using {xhub:getcfg hubShortURL}, you agree that:\r\n</p>\r\n<ul>\r\n <li>You will not use {xhub:getcfg hubShortURL} to commit a criminal offense or to encourage others to conduct what would constitute a criminal offense or give rise to a civil liability;</li>\r\n <li>You will not violate any applicable law;</li>\r\n <li>You will not post or transmit any unlawful, threatening, libelous, harassing, defamatory, vulgar, obscene, pornographic, profane, or otherwise objectionable content;</li>\r\n <li>You will not use {xhub:getcfg hubShortURL} to impersonate other parties or entities;</li>\r\n <li>You will not use {xhub:getcfg hubShortURL} to upload any content that contains a software virus, \"Trojan Horse\" or any other computer code, files, or programs that may alter, damage, or interrupt the functionality of {xhub:getcfg hubShortURL} or the hardware or software of any other person who accesses {xhub:getcfg hubShortURL};</li>\r\n <li>You will not post any material that infringes or violates the intellectual property rights of another;</li>\r\n <li>You will not redistribute resource materials posted on {xhub:getcfg hubShortURL} or create derivative works unless it is allowed by the license terms posted for a resource;</li>\r\n <li>You will not alter, damage, or delete any content posted on {xhub:getcfg hubShortURL};</li>\r\n <li>You will not claim a relationship with or speak for any business, association, or other organization for which you are not authorized to claim such a relationship;</li>\r\n <li>You will not post or transmit any unsolicited advertising, promotional materials, or other forms of solicitation;</li>\r\n <li>You will not use email addresses obtained or accessed through {xhub:getcfg hubShortURL} to transmit the same or substantially similar unsolicited message to multiple recipients without a valid purpose specifically related to the research and education mission of the {xhub:getcfg hubShortURL};</li>\r\n</ul>','',1,3,0,9,'2012-05-02 12:19:12',62,'','2012-05-02 12:20:14',62,0,'0000-00-00 00:00:00','2012-05-02 12:19:12','0000-00-00 00:00:00','','','{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_section\":\"\",\"link_section\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_vote\":\"\",\"show_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_pdf_icon\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"language\":\"\",\"keyref\":\"\",\"readmore\":\"\"}',2,0,3,'','',1,0,'robots=\nauthor=',0,'','');
INSERT INTO `#__content` VALUES (29,94,'Legal','legal','','<p class=\"warning\">\r\nEdit this page and fill in contact information for your project, or unpublish it if you think it is unnecessary.  The following text is just\r\na suggestion for the policies that you may want to highlight, and your contact for legal issues.\r\n</p>\r\n\r\n<h3>Policies</h3>\r\n<p>Review {xhub:getcfg hubShortURL}\'s <a href=\"/legal/terms\">Terms of Use</a>, <a href=\"/legal/privacy\">Privacy Policy</a> or <a href=\"/legal/abuse\">Abuse Policy</a>.</p>\r\n\r\n<h3>Legal Contacts</h3>\r\n<div class=\"two columns first\" id=\"getintouch\">\r\n	{xhub:module position=\"contact\"}\r\n</div><!-- / .two columns first -->\r\n<div class=\"two columns second\">\r\n	<div class=\"vcard\">	\r\n		<address class=\"adr\">\r\n			<span class=\"fn org\">{Your Organization}</span><br />\r\n			<span class=\"street-address\">{Street Address}</span><br />\r\n			<span class=\"locality\">{City}</span>, <span class=\"region\">{Region/Stqte}</span> <span class=\"postal-code\">{Postal Code}</span><br />\r\n			<span class=\"country-name\">{Country}</span>\r\n		</address>\r\n		<p>\r\n			<span class=\"tel\"><span class=\"type\">Phone</span> +{Telephone}</span>\r\n		</p>\r\n	</div><!-- / .vcard -->\r\n</div><!-- / .two columns second -->','',1,3,0,9,'2012-05-02 12:21:09',62,'','0000-00-00 00:00:00',0,0,'0000-00-00 00:00:00','2012-05-02 12:21:09','0000-00-00 00:00:00','','','{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_section\":\"\",\"link_section\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_vote\":\"\",\"show_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_pdf_icon\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"language\":\"\",\"keyref\":\"\",\"readmore\":\"\"}',1,0,2,'','',1,2,'robots=\nauthor=',0,'','');
INSERT INTO `#__content` VALUES (30,95,'HUBzero Accessibility Statement','accessibility','','<div id=\"getintouch\" style=\"width:350px; float:right; margin:0px 0px 15px 25px; border: #cccccc 1px solid; padding:0px 10px 10px 10px;\">\r\n	{xhub:module position=\"accessibilitycontact\"}\r\n</div>\r\n\r\n<div>\r\n<h3>An Open Commitment</h3>\r\n<p>Our web site is built on the <a href=\"http://hubzero.org\">HUBzero&reg;</a> software platform.  The HUBzero team is committed to creating websites that are accessible to the widest possible audience, regardless of technology or ability.  If you find accessibility problems with our site, please report them so we can take corrective action.</p>\r\n\r\n<h3>Guidelines, Standards and Testing</h3>\r\n<p>Our site has been developed according to the following standards:</p>\r\n<dl>\r\n	<dt>Section 508</dt>\r\n	<dd>\r\n		<p>This website endeavors to meet or exceed the requirements of <a href=\"http://www.access-board.gov/508.htm\">Section 508 of the Rehabilitation Act</a>.</p>\r\n	</dd>\r\n	\r\n	<dt>WCAG 2.0</dt>\r\n	<dd>\r\n		<p>This website endeavors to conform to level AA standards, and where possible strive for AAA, as defined by <a href=\"http://www.w3.org/TR/WCAG20\" rel=\"external\">W3C\'s Web Content Accessibility Guidelines (WCAG) 2.0</a>. These guidelines provide web authors and designers with recommendations to help provide website content that is accessible to all users.</p>\r\n	</dd>\r\n	\r\n	<dt>Coding Standards</dt>\r\n	<dd>\r\n		<p>Pages on this site have been authored to be compliant with current W3C standards for <a href=\"http://www.w3.org/TR/xhtml1/\" rel=\"external\">HTML (XHTML 1.0 Strict)</a> and <a href=\"http://www.w3.org/TR/CSS21/\" rel=\"external\">CSS</a>. Standards-compliant code helps to ensure that visitors using assistive technologies (such as screen readers) are able to access the site contents.</p>\r\n	</dd>\r\n	\r\n	<dt>Additional Testing</dt>\r\n	<dd>\r\n		<p></p>\r\n		<p>In addition to reviewing for compliance with the standards noted above, we periodically test with such technologies as the <a href=\"http://wave.webaim.org/\" rel=\"external\">Web Accessibility Evaluation Tool</a>, <a href=\"http://achecker.ca/checker/index.php\" rel=\"external\">AChecker</a>, and try to test with a range of assistive technologies (e.g., JAWS and WindowEyes screen readers). We also appreciate any input from third parties and assistive technology users from the community.</p>\r\n	</dd>\r\n</dl>\r\n\r\n<h3>Contributed Content</h3>\r\n<p>While we make every effort to make sure that all pages designed and maintained by us are fully accessible, the accessibility of some contributed content is most often beyond our control.</p>\r\n</div>','',1,3,0,9,'2012-05-02 12:28:16',62,'','0000-00-00 00:00:00',0,0,'0000-00-00 00:00:00','2012-05-02 12:28:16','0000-00-00 00:00:00','','','{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_section\":\"\",\"link_section\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_vote\":\"\",\"show_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_pdf_icon\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"language\":\"\",\"keyref\":\"\",\"readmore\":\"\"}',1,0,1,'','',1,0,'robots=\nauthor=',0,'','');
INSERT INTO `#__content` VALUES (31,96,'Community','community','','{xhub:include type=\"stylesheet\" filename=\"pages/community.css\"}\r\n\r\n<div class=\"tagline\">\r\n	<p>Join the community!</p>\r\n</div>\r\n\r\n<div class=\"about odd members\">\r\n	<h3><a href=\"/members\">Members</a></h3>\r\n	<p>As a member, you instantly become part of a community designed for you and your colleagues.  Browse the <a href=\"/members\">profiles</a> of people who have joined this site. Find members with similar <a href=\"/tags\">interests</a>.</p>\r\n</div>\r\n\r\n<div class=\"about even groups\">\r\n	<h3>Groups</h3>\r\n	<p>Members working together! Groups are an easy way to share content and conversation, either privately or with the world.  Explore our <a href=\"/groups\">groups</a> and get in touch with <a href=\"/members\">members</a> with similar interests.</p>\r\n</div>\r\n\r\n<div class=\"about odd answers\">\r\n	<h3><a href=\"/answers\">Questions &amp; Answers</a></h3>\r\n	<p>Submit a question to our community and get an answer from real people. <a href=\"/answers/new\">Ask questions</a>, get <a href=\"/answers\">answers</a>, and help others.</p>\r\n</div>\r\n\r\n<div class=\"about even forum\">\r\n	<h3><a href=\"/forum\">Forum</a></h3>\r\n	<p>A place for you to start a <a href=\"/forum\">discussion</a> or find out what everyone is talking about.</p>\r\n</div>', '', '1', '0', '0', '2', '2012-09-07 16:33:42', '1008', '', '2013-08-29 20:43:06', '1000', '0', '0000-00-00 00:00:00', '2012-09-07 16:33:42', '0000-00-00 00:00:00', '', '', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}',4,0,3,'','',1,10,'{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}',0,'*','');

--
-- HUBzero sample data for table `#__events_config`
--

INSERT INTO `#__events_config` (`param`, `value`) VALUES ('adminmail','');
INSERT INTO `#__events_config` (`param`, `value`) VALUES ('adminlevel','0');
INSERT INTO `#__events_config` (`param`, `value`) VALUES ('starday','0');
INSERT INTO `#__events_config` (`param`, `value`) VALUES ('mailview','NO');
INSERT INTO `#__events_config` (`param`, `value`) VALUES ('byview','NO');
INSERT INTO `#__events_config` (`param`, `value`) VALUES ('hitsview','NO');
INSERT INTO `#__events_config` (`param`, `value`) VALUES ('repeatview','NO');
INSERT INTO `#__events_config` (`param`, `value`) VALUES ('dateformat','0');
INSERT INTO `#__events_config` (`param`, `value`) VALUES ('calUseStdTime','NO');
INSERT INTO `#__events_config` (`param`, `value`) VALUES ('navbarcolor','');
INSERT INTO `#__events_config` (`param`, `value`) VALUES ('startview','month');
INSERT INTO `#__events_config` (`param`, `value`) VALUES ('calEventListRowsPpg','30');
INSERT INTO `#__events_config` (`param`, `value`) VALUES ('calSimpleEventForm','YES');
INSERT INTO `#__events_config` (`param`, `value`) VALUES ('defColor','');
INSERT INTO `#__events_config` (`param`, `value`) VALUES ('calForceCatColorEventForm','NO');
INSERT INTO `#__events_config` (`param`, `value`) VALUES ('fields','');

--
-- HUBzero sample data for table `#__faq`
--

INSERT INTO `#__faq` VALUES (1,'What are groups?','general','uploadpath=/site/kb\nshow_authors=1\nallow_comments=0\nclose_comments=year\nfeeds_enabled=1\nfeed_entries=partial\nshow_date=2','<h4>Work together with your colleagues</h4>\r\n	<p>Create a group to organize your interactions.  Group members can:</p>\r\n	<ul>\r\n	<li>Post content that only other group members are allowed to see\r\n	<li>Export their content to other web sites, and brand it with their own logo\r\n</ul>\r\n	<h4>Create a new group</h4>\r\n	<p>You can <a href=\"/groups/new\">create your own group</a> of users.  Just fill in a simple form choosing a group name, a title, and a brief description, so that others will know what your group is about.  Once created, your group title and description will be available for all to see in the <a href=\"/groups/browse\">list of all groups</a>.  Each group also has its own page, which contains a link that other users can click on to request membership.</p>\r\n	<h4>Managing group members</h4>\r\n	<p>Whenever another user requests membership, you will receive an email asking you to approve their request.  To do this, log in and visit the <a href=\"/groups\">groups</a> page and find your group name.  If you\'re logged in, you should see a <i>[manage]</i> link next to the group name.  Clicking on that link will bring up a page showing a list of users who have requested membership.  Use the controls on that page to approve or deny their request.  You can use the same page to promote ordinary users to also act as managers, so they can help you approve or deny requests.  You can also demote or remove users from your group.<br />\r\nOnce removed from a group, a user will no longer have access to protected or private group resources.  Of course, they can always rejoin the group at any point by requesting membership and going through the usual approval process.<br />\r\n<strong>Note:</strong> All groups must have at least one manager. If you are the last manager of a group, you will <em>not</em> be able to demote or remove yourself from the group.\r\n</p>','2011-03-31 15:10:54',62,'2011-03-31 15:10:54',62,0,'0000-00-00 00:00:00',1,0,3,1,1,0,0,0);
INSERT INTO `#__faq` VALUES (2,'Why is Hispanic / Latino not a racial background choice?','hispanic','show_date=2\nallow_comments=0\nclose_comments=year\nfeeds_enabled=1\nfeed_entries=partial','<p>According to U.S. government guidelines, ethnic heritage and racial background are to be separate, distinct questions and responses.  \\\"Ethnic Heritage\\\" defines membership in cultural groups such as Hispanic / Latino, whereas \\\"Racial Background\\\" is based on ancestry and genetic groups.  This issue is handled in various ways outside the U.S., and the current standards continue to evolve.  We realize this distinction may be somewhat confusing, but we must conform to the latest reporting standards required by the government.<br />\r\nMore precise definitions of the various racial background and ethnic heritage choices are as follows:</p>\r\n	<h3>Racial Background</h3>\r\n	<ul>\r\n	<li><b>American Indian or Alaska Native</b><br />\r\nPersons having origins in any of the original peoples of North and South America (including Central America), and who maintains cultural identification through tribal affiliation or community recognition.\r\n</li>\r\n	<li><b>Asian</b><br />\r\nPersons having origins in any of the original peoples of the Far East, Southeast Asia or the Indian subcontinent, including for example, Cambodia, China, India, Japan, Korea, Malaysia, Pakistan, the Philippine Islands, Thailand, and Vietnam.\r\n</li>\r\n	<li><b>Black or African American</b><br />\r\nPersons having origins in any of the black racial groups of Africa.\r\n</li>\r\n	<li><b>Native Hawaiian or Other Pacific Islander</b><br />\r\nPersons having origins in any of the original peoples of Hawaii, Guam, Samoa, or other Pacific Islands.\r\n</li>\r\n	<li><b>White</b><br />\r\nPersons having origins in any of the original peoples of Europe, the Middle East, or North Africa.\r\n</li>\r\n	</ul>\r\n	<h3>Ethnic Heritage</h3>\r\n	<ul>\r\n	<li><b>Hispanic or Latino</b><br />\r\nPersons of Cuban, Mexican, Puerto Rican, Central or South American, or other Spanish culture of origin, regardless of race.\r\n</li>\r\n	</ul>','2011-03-31 17:21:07',69,'2011-03-31 17:21:07',69,0,'0000-00-00 00:00:00',1,0,2,1,2,0,0,0);
INSERT INTO `#__faq` VALUES (3,'Why can\\\'t I log in?','login','show_date=2\nallow_comments=0\nclose_comments=year\nfeeds_enabled=1\nfeed_entries=partial','<p>Have you registered? You must register in order to log in. If you have registered and you still cannot log in then check and double-check your username and password. Usually this is the problem; if not, contact <a href=\\\"/support/report_problems/\\\" title=\\\"Report problem form\\\">support</a>.\n</p>','2010-03-25 06:26:40',62,'0000-00-00 00:00:00',0,0,'0000-00-00 00:00:00',1,0,1,1,2,0,0,0);
INSERT INTO `#__faq` VALUES (4,'I registered but cannot log in!','login2','uploadpath=/site/kb\nshow_authors=1\nallow_comments=0\nclose_comments=year\nfeeds_enabled=1\nfeed_entries=partial\nshow_date=2','<ul>\r\n<li>If this is a <b>new account</b>, you won\'t be able to log in until you\'ve confirmed your e-mail address.  Right after you registered, you should have received an e-mail at the address that you registered with us.  This e-mail contains a special link.  Click on the link to prove that you can receive e-mail from us.  If you did not receive the e-mail, make sure that you did not misspell your e-mail address when you registered with us.  Check your junk mail folder to see if the e-mail message wound up there.</li>\r\n<li>If this is an <b>old account</b>, check that you are entering the correct username and password.  If you\'ve forgotten your password, you can <a href=\"/login/reset\">recover it</a>.</li>\r\n<li>In either case, make sure that <a href=\"/kb/misc/cookies\">cookies are enabled</a> for your browser.  If all else fails, <a href=\"/support/ticket/new\" title=\"Report problems form\">report the problem</a> in our support area.</li>\r\n</ul>','2010-03-25 06:26:40',62,'0000-00-00 00:00:00',0,0,'0000-00-00 00:00:00',1,0,0,1,2,0,0,0);
INSERT INTO `#__faq` VALUES (5,'I registered in the past but cannot log in anymore!','login3','uploadpath=/site/kb\nshow_authors=1\nallow_comments=0\nclose_comments=year\nfeeds_enabled=1\nfeed_entries=partial\nshow_date=2','<p>You may have entered an incorrect username or password.  If you\'ve forgotten either one, you can <a href=\"/login/remind\">recover your username</a> or <a href=\"/login/reset\">recover your password</a>.  Just fill out the form, and we\'ll send your account information to the e-mail address that you registered with your account.  If you\'ve changed e-mail addresses and can no longer recover your account information, <a href=\"/support/report_problems/\" title=\"Report problems form\">contact support</a>, and we\'ll help you recover your account.\r\n</p>','2010-03-25 06:26:40',62,'0000-00-00 00:00:00',0,0,'0000-00-00 00:00:00',1,0,4,1,2,0,0,0);
INSERT INTO `#__faq` VALUES (6,'I\'ve lost my password!','pwreset','uploadpath=/site/kb\nshow_authors=1\nallow_comments=0\nclose_comments=year\nfeeds_enabled=1\nfeed_entries=partial\nshow_date=2','<p>Don\'t panic!  We can <a href=\"/login/reset\">reset your password</a> and send instructions to the e-mail address that you have on file with us.  Then, you can follow the instructions, log in to the site, and change your password to anything you like.\r\n</p><p>\r\n<b>Note:</b>  If you don\'t receive an e-mail after resetting your password, check your junk mail folder and make sure that it didn\'t get filed there by mistake.  If you no longer have access to the e-mail address that you have on file with us, <a href=\"/support/report_problems/\">contact support</a> and we\'ll help you recover your account.\r\n</p>','2010-03-25 06:26:40',62,'0000-00-00 00:00:00',0,0,'0000-00-00 00:00:00',1,0,0,1,2,0,0,0);
INSERT INTO `#__faq` VALUES (7,'Why do I get logged off automatically?','autologout','show_date=2\nallow_comments=0\nclose_comments=year\nfeeds_enabled=1\nfeed_entries=partial','<p>If you do not check the <i>Remember login</i> box when you log in, the site will only keep you logged in for a short time.  This prevents misuse of your account by anyone else.  To stay logged in, check the box during login.  This is not recommended if you access the site from a shared computer--e.g., in a library, internet cafe, university lab, etc.\n</p>','2010-03-25 06:26:40',62,'0000-00-00 00:00:00',0,0,'0000-00-00 00:00:00',1,0,1,1,2,0,0,0);
INSERT INTO `#__faq` VALUES (8,'Why do I need to register at all?','register','uploadpath=/site/kb\nshow_authors=1\nallow_comments=0\nclose_comments=year\nfeeds_enabled=1\nfeed_entries=partial\nshow_date=2','<p>Registration will give you access to additional features not available to guest users, including access to simulation/modeling tools, the ability to ask questions, create private groups, participate in discussions, rate resources, and more.  The registration process is completely automatic and it takes just a few minutes.  Your registration also helps us sustain this project.  Our funding agency periodically reviews statistics about the number of users that access our site.  By registering and filling in your personal profile, you are helping to justify our existence and continue our funding.\r\n</p>','2010-03-25 06:26:40',62,'0000-00-00 00:00:00',0,0,'0000-00-00 00:00:00',1,0,0,1,2,0,0,0);
INSERT INTO `#__faq` VALUES (9,'How do I change my password?','pwchange','uploadpath=/site/kb\nshow_authors=1\nallow_comments=0\nclose_comments=year\nfeeds_enabled=1\nfeed_entries=partial\nshow_date=2','<p>We have multiple methods available to help you change your password. If you can\'t remember your password, go to the <a href="/login/reset">forgot password</a> page to reset it. If you\'re already logged in, and simply wish to change your password, go to your <a href="/members/myaccount/account">account page</a> for a quick password change form.</p>','2010-03-25 06:26:40',62,'0000-00-00 00:00:00',0,0,'0000-00-00 00:00:00',1,0,0,1,2,0,0,0);
INSERT INTO `#__faq` VALUES (10,'How do I change my username?','username','show_date=2\nallow_comments=0\nclose_comments=year\nfeeds_enabled=1\nfeed_entries=partial','<p>Sorry, but login names cannot be changed.  If this is poses a serious problem for you, please <a href=\\\"/support/report_problems/\\\" title=\\\"Trouble report page\\\">contact our support team</a>.\n</p>','2010-03-25 06:26:40',62,'0000-00-00 00:00:00',0,0,'0000-00-00 00:00:00',1,0,0,1,2,0,0,0);
INSERT INTO `#__faq` VALUES (11,'How to View/Download Video Content?','video','show_date=2\nallow_comments=0\nclose_comments=year\nfeeds_enabled=1\nfeed_entries=partial','<p>This hub relies on two formats of video files, MP4 (MPEG-4) mostly used for podcasts but  also can be viewed directly on your computer, and Windows Media Player which is used by older lectures and seminars.  In general we sugguest Apple Quicktime for playing MP4 files, however there are a variety of MP4 players available.<br />\nWe recommend VideoLAN.org\\\'s <a href=\\\"http://www.videolan.org/\\\" rel=\\\"external\\\">VLC - Media Player</a>, a free cross-platform media player that supports a large number of multimedia formats, without the need for additional codecs. It will play both the MP4 and Windows Media Player files. You will have to copy and paste the video URL from your browser to the VLC player (menu <em>file-&gt;open network</em>). Below are operating system specific issues for those using Windows Media Player.<br />\nBelow is a list of OS specific player issues:</p>\n	<ul>\n	<li><b>Windows</b><br />\nIf you\\\'re experiencing problems viewing video lectures on Windows systems, make sure that you\\\'ve installed the latest WindowsMedia software:<br />\n<a href=\\\"http://www.microsoft.com/windows/windowsmedia/mp10/default.aspx\\\" rel=\\\"external\\\"\\\">Windows Media Player for Windows</a>\n</li>\n	<li><b>Mac OS X</b><br />\nIf you\\\'re experiencing problems viewing video lectures on Mac OS X systems, make sure that you\\\'ve installed the latest WindowsMedia software:<br />\n<a href=\\\"http://www.microsoft.com/windows/windowsmedia/software/Macintosh/osx/default.aspx\\\" rel=\\\"external\\\">Windows Media Player for Mac OS X</a><br />\n<strong>NOTE:</strong> Microsoft will continue to offer Windows Media Player for Mac as a download free of charge, but has no plans to provide<br />\nfuture updates or product support. Instead, Microsoft will be offering <a href=\\\"http://www.microsoft.com/windows/windowsmedia/player/flip4mac.mspx\\\" rel=\\\"external\\\">Windows Media&reg; Components for Quicktime, by Flip4Mac&trade;</a>, as an<br />\nalternative for Mac OS X users wanting to play Windows Media Audio and Windows Media Video. Requires Mac OS X version 10.3.9 or later and QuickTime version 6.5 or later.<br />\n<b>Known Issue:</b> Windows Media Player 9 for Mas OS X may have difficulty playing secure video streams (URLs starting with \\\'https\\\'). The Flip4Mac plugin described above fixes this problem.\n</li>\n	<li><b>Linux</b><br />\nNo currently known issues.  Use <a href=\\\"http://www.videolan.org/\\\" rel=\\\"external\\\">VideoLAN Media Player</a> or equivalent application.\n</li>\n	<li><b>MacOS Classic</b><br />\nIf you don\\\'t have Mac OS X, get the <a href=\\\"http://www.microsoft.com/windows/windowsmedia/download/mac71.aspx\\\" rel=\\\"external\\\">Windows Media Player for Mac 7.1</a> which runs on the Macintosh Classic OS.\n</li>\n	</ul>\n	<h3>Downloading Video and Audio Content</h3>\n	<p><img src=\\\"/site/images/kb/video_download.jpg\\\" alt=\\\"browser download\\\" class=\\\"align-right\\\"><br />\nMost of this hub\\\'s video and audio content is downloadable.  Proceedures varry depending on the browser you are using:</p>\n	<ul>\n	<li><b>Firefox</b><br />\nRight click (hold click for Mac) on the resource link, select \\\"Save Link As...\\\", a dialog box will appear allowing you to save document as a file.\n</li>\n	<li><b>Internet Explorer</b><br />\nRight click on the resource link, then select \\\"Save Target As...\\\", a dialog box will appear allowing you to save document as a file.  Mac users should drag the link to their desktop or folder and the document will be downloaded.\n</li>\n	<li><b>Safari</b><br />\nControl-click on the resource link, then select \\\"Download Linked File\\\", the document will download to your download\\\'s folder.  The download folder is specified using the <i>Preferences</i> menu and selecting the <i>General</i> tab.\n</li>\n	</ul>\n	<h3>Continued Problems</h3>\n	<p>If the problem persists, please send us a <a href=\\\"support/report_problems/\\\">trouble report</a>.\n</p>','2010-03-25 06:26:40',62,'0000-00-00 00:00:00',0,0,'0000-00-00 00:00:00',1,0,0,1,3,0,0,0);
INSERT INTO `#__faq` VALUES (12,'How to enable pop-ups?','popups','show_date=2\nallow_comments=0\nclose_comments=year\nfeeds_enabled=1\nfeed_entries=partial','<p>Web pages can use the JavaScript language to automatically force the your web browser to open new windows.  This capability has often been abused by advertising sites and many browsers disable the capability by default.<br />\nYou must enable pop-ups for this site in order to do file downloads.  The way in which this is done varies from browser to browser:</p>\n	<ul>\n	<li><b>Firefox</b><br />\nGo to the <i>Edit-&gt;Preferences</i> menu and choose the <i>Content</i> icon at the top of the dialog.  If <i>Block pop-up windows</i> is checked, add this site to the <i>Exceptions</i> list.<br />\nFirefox also uses plugins to filter pop-ups.  The most common plugin is NoScript.  To enable a pop-up for a particular page, select the highlighted <i>S</i> icon at the bottom of the browser to instruct NoScript to allow the pop-up.\n</li>\n	<li><b>Internet Explorer</b><br />\nGo to <i>Tools-&gt;Internet Options</i> menu. Click on the <i>Privacy</i> tab. Uncheck the field <i>Block pop-ups\\\'</i> (<i>Turn on Pop-up Blocker</i> in IE 7.x). This will unblock pop-ups from all sites. To only allow pop-ups from this site, check <i>Block pop-ups</i> and click on <i>Settings</i>. Enter the address of this site in the field <i>Address of Web site to allow:</i> and click <i>Add</i>. Close all windows.\n</li>\n	<li><b>Safari</b><br />\nGo to the menu bar and select <i>Safari-&gt;Preferences</i> and choose the <i>Security</i> tab. If <i>Block pop-up windows</i> is checked, uncheck it.\n</li>\n	<li><b>Opera</b><br />\nApple OSX - Go to the menu bar and select <i>Opera-&gt;Quick Preferences</i> and make sure \\\"Block all pop-ups\\\" is not selected (click on it to toggle preference).<br />\nWindows - Go to the menu bar and select <i>Tools-&gt;Quick Preferences</i> and make sure <i>Block all pop-ups</i> is not selected (click on it to toggle preference).\n</li>\n	<li><b>Konqueror</b><br />\nGo to the <i>Settings-&gt;Configure Konqueror</i> menu and choose Java and JavaScript.  Select the JavaScript tab at the top of the dialog.  In the center of the dialog is a <i>Domain-Specific</i>policy mechanism.  Press the <i>New...</i> button and type the address of this site for the host or domain name.  Select <i>Accept</i> for the policy.  Set the <i>Open new windows</i> policy to <i>Allow</i>.\n</li>\n	<li><b>Mozilla</b><br />\nGo to the <i>Edit-&gt;Preferences</i> menu and choose <i>Privacy</i> and <i>Security-&gt;Popup Windows</i>.  There, you can add the address for this site to the <i>Allowed Sites</i>.\n</li>\n	</ul>','2010-03-25 06:26:40',62,'0000-00-00 00:00:00',0,0,'0000-00-00 00:00:00',1,0,0,1,3,0,0,0);
INSERT INTO `#__faq` VALUES (13,'Why do I need Java?','java','show_date=2\nallow_comments=0\nclose_comments=year\nfeeds_enabled=1\nfeed_entries=partial','<p>In order to access the simulation tools, you must have Java version 1.4 or later installed on your machine and enabled in your web browser.  Note that Java is <em>not</em> the same as Javascript.  Visit the <a href=\\\"http://www.java.com/en/download/installed.jsp\\\" rel=\\\"external\\\">Java website</a> to verify which version of Java is installed on your browser.  You can also <a href=\\\"http://www.java.com/en/download/manual.jsp\\\" rel=\\\"external\\\">upgrade</a> to the latest release of Java. If you do not have access to install plug-ins, please contact your system administrator about installing or upgrading your Java.</p>\n	<h4>Known Issues</h4>\n	<ul>\n	<li><b>KDE Konqueror</b><br />\nTo enable Java in the KDE Konqueror browser, make sure that the Java preferences are enabled and that <i>Use KIO</i> is checked.  In the box that specifies the path to the <i>java</i> executable, simply typing <i>java</i> often works better than the full path to the executable.</li>\n	</ul>','2010-03-25 06:26:40',62,'0000-00-00 00:00:00',0,0,'0000-00-00 00:00:00',1,0,1,1,3,0,0,0);
INSERT INTO `#__faq` VALUES (14,'How to Enable Cookies','cookies','show_date=2\nallow_comments=0\nclose_comments=year\nfeeds_enabled=1\nfeed_entries=partial','<p>In order to log in to this site, you must enable cookies in your browser.  Instructions for enabling cookies in common browsers are listed below. If your browser is not listed, please check its website or other browser documentation for more information.</p>\n	<h3>Windows IE 6/7</h3>\n	<ul>\n	<li>In <i>Tools</i> menu, click <i>Internet Options</i></li>\n	<li>Click <i>Privacy tab</i></li>\n	<li>Click <i>Advanced button</i></li>\n	<li>Check the box next to <i>Override Automatic Cookie Handlng</i></li>\n	<li>At bottom, check the box next to <i>Always accept session cookies</i></li>\n	<li>Click <i>OK</i></li>\n	<li>Now you should be able to <a href=\\\"/login\\\">log in</a></li>\n	</ul>\n	<h3>Firefox 1/2</h3>\n	<ul>\n	<li>In <i>Tools</i> menu, select <i>Options...</i></li>\n	<li>Click <i>Advanced</i> icon</li>\n	<li>Select/expand cookies section on left</li>\n	<li>Check box next to <i>Allow Sites to Set Cookies</i></li>\n	<li>Now you should be able to <a href=\\\"/login\\\">log in</a></li>\n	</ul>\n	<h3>Safari 1.2.4</h3>\n	<ul>\n	<li>Click on <i>Safari</i> tab on menu bar</li>\n	<li>Click <i>Preferences</i></li>\n	<li>Click <i>Security</i> tab</li>\n	<li>Ensure <i>Enable Javascript</i> is enabled</li>\n	<li>In the cookies area, choose either <i>Only from sites you navigate to</i> or <i>Always</i></li>\n	<li>Now you should be able to <a href=\\\"/login\\\">log in</a></li>\n	</ul>\n	<h3>Netscape 7</h3>\n	<ul>\n	<li>In <i>Edit</i> menu, select <i>Preferences</i></li>\n	<li>Select <i>Privacy and Security</i></li>\n	<li>Select <i>Cookies</i></li>\n	<li>Select <i>Enable All Cookies</i> or <i>Enable cookies for the originating website only</i></li>\n	<li>Click <i>OK</i></li>\n	<li>Now you should be able to <a href=\\\"/login\\\">log in</a></li>\n	</ul>\n	<h3>Mac IE 5</h3>\n	<ul>\n	<li><a href=\\\"http://www.mozilla.com/firefox/\\\">Download Firefox</a> and use it instead.  :)</li>\n	<li>If you must use Mac IE 5, follow these instructions...</li>\n	<li>Go to <i>Edit</i> menu, select <i>Preferences</i></li>\n	<li>Click on <i>Receiving Files</i> settings</li>\n	<li>Click on <i>Cookies</i></li>\n	<li>In the pull-down menu labeled <i>When receiving cookies:</i>, select <i>Never Ask</i> or <i>Ask for each site.</i></li>\n	<li>Clicking <i>Ask for each site</i> will display a prompt asking if you\\\'d like to accept cookies for this site. Click <i>Accept</i>.</li>\n	<li>Now you should be able to <a href=\\\"/login\\\">log in</a></li>\n	</ul>','2010-03-25 06:26:40',62,'0000-00-00 00:00:00',0,0,'0000-00-00 00:00:00',1,0,0,1,3,0,0,0);
INSERT INTO `#__faq` VALUES (15,'Share a simulation session','share','uploadpath=/site/kb\nshow_authors=1\nallow_comments=0\nclose_comments=year\nfeeds_enabled=1\nfeed_entries=partial\nshow_date=2','<p>Have some interesting results from a simulation that you\'d like someone else to see? Share the session!\r\nEnter one or more login names in the form beneath the tool session and click on the <i>Share</i> button.  Anyone added for sharing will see your tool session listed on their own <i>My Sessions</i> area on their <a href=\"/members/myaccount\">dashboard page</a>.  Just as you would click a link to resume a tool session, they can click the link and access your session.  Many people can access a single session at the same time and discuss the results on a conference call.\r\n</p><p>\r\n<b>Note:</b>  If you don\'t want others to have control of the tool, be sure to select the <i>Read-Only</i> checkbox before sharing the session.\r\n</p>','2010-03-25 06:26:40',62,'0000-00-00 00:00:00',0,0,'0000-00-00 00:00:00',1,0,0,1,5,0,0,0);
INSERT INTO `#__faq` VALUES (16,'Rate a Resource','rate','show_date=2\nallow_comments=0\nclose_comments=year\nfeeds_enabled=1\nfeed_entries=partial','<p>Rating a resource is quick and easy.<br />\nEvery resource has two sets of stars: the average rating and your rating. If you haven\\\'t rated a resource, you\\\'re rating will show up as a set of slightly grayed out stars.<br />\nTo rate the resource, hover over your rating stars. The stars will change to red depending on where your cursor is. If you want a four star rating, move the cursor until you see four red stars and then click.  You will be taken to a form where you can then add comments, suggestions, and even tags.  If you\\\'d like to remain anonymous, be sure to check the box.  Otherwise, your name will show up next to your rating and your comments on the resource page.\n</p>','2010-03-25 06:26:40',62,'0000-00-00 00:00:00',0,0,'0000-00-00 00:00:00',1,0,1,1,5,0,0,0);
INSERT INTO `#__faq` VALUES (17,'Customize your dashboard page','personalize','uploadpath=/site/kb\nshow_authors=1\nallow_comments=0\nclose_comments=year\nfeeds_enabled=1\nfeed_entries=partial\nshow_date=2','<p>To change your <a href=\"/members/myaccount\"> dashboard page</a>, simply click the <i>Personalize</i> button located in the upper-right corner of that page.  The page will enter a customization mode where you may move modules around by simple drag-and-drop, remove modules, or add modules.  When you\'re done, click the <i>finish</i> button and all your changes will be saved.  Your changes will even be remembered the next time you log in--even if you use a different computer!\r\n</p>','2010-03-25 06:26:40',62,'0000-00-00 00:00:00',0,0,'0000-00-00 00:00:00',1,0,0,1,5,0,0,0);
INSERT INTO `#__faq` VALUES (18,'Renaming Sessions','rename','show_date=2\nallow_comments=0\nclose_comments=year\nfeeds_enabled=1\nfeed_entries=partial','<p>You can rename a simulation session by simple double-clicking the session title just above the active tool area.  The title will then become a text box where you can input any title you wish.  Press the TAB key or ENTER key to save changes or press ESC to cancel.\n</p>','2010-03-25 06:26:40',62,'0000-00-00 00:00:00',0,0,'0000-00-00 00:00:00',1,0,0,1,5,0,0,0);
INSERT INTO `#__faq` VALUES (19,'How to use WebDAV to access your hub storage','webdav','show_date=2\nallow_comments=0\nclose_comments=year\nfeeds_enabled=1\nfeed_entries=partial','<p>WebDAV is the Distributed Authoring and Versioning extension to the standard HTTP/HTTPS web protocol.  It allows a client to browse a remote filesystem, usually with a graphical browser that makes it appear that your files are on your desktop.  You may access your hub storage using only the secure version of this service (HTTPS).  We do not support HTTP.  Most modern computer platforms support HTTPS transport for WebDAV with either small adjustments or freely available software.</p>\n	<h3>Linux/Unix</h3>\n	<p>If you use the KDE graphical desktop environment, you can access your hub storage with the Konqueror browser by typing the special URL <tt>webdavs://HUBADDRESS/webdav</tt> into the Location field of the browser.  It will prompt you for your hub login and password.  Thereafter, you traverse your home directory by clicking on folders and you can drag and drop files to your desktop.<br />\n<a href=\\\"http://www.webdav.org/cadaver/\\\" rel=\\\"external\\\">Cadaver</a> is a text-mode WebDAV browser.  It can be used if it is compiled with SSL support.  Invoke it with the command <tt>cadaver https://HUBADDRESS/webdav</tt> and it will prompt you for your hub login and password.  You can then use it in a manner similar to FTP.<br />\nIf you are using Linux, you can use the <a href=\\\"http://dav.sourceforge.net/\\\" rel=\\\"external\\\">davfs</a> kernel module to mount your hub storage area as a local filesystem.</p>\n	<h3>Macintosh</h3>\n	<p>MacOS versions 10.4 and higher support HTTPS transport for WebDAV using the Finder.  To access your hub directory, select the Go menu in the Finder and choose \\\"Connect to Network Server\\\".  Enter the URL <tt>https://HUBADDRESS/webdav</tt> into the address field.  You will be prompted for your hub login and password.<br />\nMacOS versions lower than 10.4 do not have support for HTTPS, but a free client exists.  Download <a href=\\\"http://www.webdav.org/goliath/\\\" rel=\\\"external\\\">Goliath</a> and install it on your system.  Invoke it and use <tt>https://HUBADDRESS/webdav</tt> as the address to connect to.  Note that you may also use Goliath on newer MacOS platforms as well.</p>\n	<h3>Windows</h3>\n	<p>Windows XP systems have native support for accessing WebDAV storage via HTTPS, but it may be disabled by default depending on how your OS was configured.  Try these instructions first, and then check the next set of instructions to enable WebDAV.  To access your hub storage,</p>\n	<ul>\n	<li> Double-click on the desktop icon called \\\"My Network Places\\\".</li>\n	<li> This will invoke a dialog box where you can select \\\"Add Network Place\\\".  This will invoke a wizard that you can step through.</li>\n	<li> Select the \\\"Choose another network location\\\" function.</li>\n	<li> The wizard will then ask you for the \\\"Internet or Network Address.\\\"  In the box, type <tt>https://HUBADDRESS/webdav</tt></li>\n	<li> Specify the name that you would like to have associated with this storage space.  An icon will be created for the hub storage folder.  When you double-click on it to open it, you will be prompted for your hub login and password.</li>\n	</ul>\n	<h4>Enabling WebDAV in Windows XP</h4>\n	<p>If the steps above do not work, for Windows XP, or you cannot find the named options, your OS may have WebDAV turned off by default.  Do the following additional steps and then try to add network storage again.</p>\n	<ul>\n	<li>Open Windows Explorer</li>\n	<li>Go to the \\\"Tools\\\" menu and select \\\"Folder Options\\\"</li>\n	<li>Select the radio button \\\"Use Windows classic folders\\\" under \\\"Tasks\\\".</li>\n	</ul>\n	<h4>Windows 2003 users cannot access secure WebDAV</h4>\n	<p>There is no support for secure WebDAV transport in Windows 2003.  Various workarounds have been suggested, but it appears the easiest action to take is to simply upgrade the OS.\n</p>','2010-03-25 06:26:40',62,'0000-00-00 00:00:00',0,0,'0000-00-00 00:00:00',1,0,2,1,5,0,0,0);
INSERT INTO `#__faq` VALUES (20,'Troubleshoot','troubleshoot','uploadpath=/site/kb\nshow_authors=1\nallow_comments=0\nclose_comments=year\nfeeds_enabled=1\nfeed_entries=partial\nshow_date=2','<p>There are two common reasons why you may not be able to view an application.</p>\r\n	<ul>\r\n	<li><b>The tool is internally misconfigured.</b>  If you can look at your <a href=\"/members/myaccount\">personalized dashboard page</a> and see that the tool you just started does not appear in the list of running sessions, it exited before it could be viewed.  You should <a href=\"/support/ticket/new\">report this as a problem</a>.\r\n	<li><b>The Java interpreter won\'t start or is misconfigured.</b>  If you\'ve been able to view applications in previous times with the same browser, usually you can solve this problem by restarting your browser.  Make sure that all instances of the browser (e.g. multiple windows) are stopped in order to properly stop and restart the Java environment.  If this fails to make tool sessions viewable, consult the <a href=\"/kb/misc/java/\">Java page</a> for more platform-specific hints.</li>\r\n	</ul>','2010-03-25 06:26:40',62,'0000-00-00 00:00:00',0,0,'0000-00-00 00:00:00',1,0,2,1,6,0,0,0);
INSERT INTO `#__faq` VALUES (21,'Help! I\\\'m getting a Java error!','javaerr','show_date=2\nallow_comments=0\nclose_comments=year\nfeeds_enabled=1\nfeed_entries=partial','<p>Users may experience a Java error on Mac OS X if they are using Java version 1.3 and below. Please ensure your Java install is up to date.<br />\nNOTE! For gecko browsers (Mozilla, Firefox, Camino), the following may be the source of the error:</p>\n	<blockquote cite=\\\"http://plugindoc.mozdev.org/OSX.html#Java\\\"><p>Mozilla will only use <abbr title=\\\"Java Runtime Engine\\\">JRE</abbr> 1.3.1, even if a later JRE is installed [Bug 197813]. To use a newer JRE, you will need to install the <a href=\\\"http://javaplugin.sourceforge.net/\\\">Java Embedding Plugin for Mac OS X</a>. This plugin is beta quality software, and may have bugs and cause problems. Read the <a href=\\\"http://javaplugin.sourceforge.net/Readme.html\\\">Readme</a> before installing it.</p></blockquote>\n	<p>Java for Windows, Mac OS, Solaris, and Linux can be downloaded <a href=\\\"http://www.java.com/en/download/\\\">here</a>. Instructions for installation may also be found at that site.\n</p>','2010-03-25 06:26:40',62,'0000-00-00 00:00:00',0,0,'0000-00-00 00:00:00',1,0,1,1,6,0,0,0);
INSERT INTO `#__faq` VALUES (22,'Signed Applet','applet','show_date=2\nallow_comments=0\nclose_comments=year\nfeeds_enabled=1\nfeed_entries=partial','<p>If you are behind a network firewall that requires you to use a web proxy with your browser, your Java environment will also need to use a proxy to connect to tool sessions.  The default security manager for Java stipulates that an applet can make network connections only to the web server from which it was originally loaded.  Connecting to a proxy requires additional privileges&#8212;even though the ultimate connection through the proxy is to the originating web server.</p>\n<p>In order to empower an applet with additional privileges, it must be <i>signed</i>.  This is a process by which a cryptographic identity is added to the applet to prove the identity of its author.  The first time you load a particular signed applet, your Java virtual machine will show you a dialog  which shows that the applet was authored by HUBzero and is confirmed by Thawte Consulting (a certificate authority that most JVM\\\'s trust).  If you trust the author of this applet, you can select \\\"Yes\\\" to load the applet.<p>\nA signed applet can have many privileges.  It can access your general window system, your computer\\\'s peripherals, and your local file system.  This site\\\'s VNC applet uses additional privileges <strong class=\\\"highlight\\\">only to connect to your web proxy.</strong>  The applet contains no code to perform any kind of additional access to your computer\\\'s local resources.\n</p>','2010-03-25 06:26:40',62,'0000-00-00 00:00:00',0,0,'0000-00-00 00:00:00',1,0,2,1,6,0,0,0);
INSERT INTO `#__faq` VALUES (23,'Why the math question?','why_the_math_question','show_date=2\nallow_comments=0\nclose_comments=year\nfeeds_enabled=1\nfeed_entries=partial','<p>When you use the Help button to submit a trouble report, it may ask you a simple math question such as \\\"What is the sum of 3 and 5?\\\" You get this if you\\\'re not logged in. Providing a correct answer gives us some indication that you\\\'re a human that has read and understood the question--not a bot that is attempting to put spam on our site!\n</p>','2010-03-25 06:26:40',62,'0000-00-00 00:00:00',0,0,'0000-00-00 00:00:00',1,0,0,1,3,0,0,0);
INSERT INTO `#__faq` VALUES (24,'Frequently Asked Questions','faq','show_date=2\nallow_comments=0\nclose_comments=year\nfeeds_enabled=1\nfeed_entries=partial','<ul class=\"faq-list\">\r\n  <li><a href=\"#groupdiscoverability\">What is Group Discoverability?</a></li>\r\n   <li><a href=\"#groupmembership\">What is Group Membership Access?</a></li>\r\n   <li><a href=\"#groupcustomization\">How to Customize a Group?</a></li>\r\n   <li><a href=\"#groupaccesslevels\">What are Group Plugin Access Levels?</a></li>\r\n  <li><a href=\"#groupmanagement\">How are groups managed?</a></li>\r\n    <li><a href=\"#leavegroup\">How do I leave a group?</a></li>\r\n    <li><a href=\"#deletegroup\">How do I delete a group?</a></li>\r\n</ul>\r\n\r\n<h3><a name=\"groupdiscoverability\"></a>What is Group Discoverability?</h3>\r\n<p>All groups have an overall discoverability setting of either visible or hidden. This determines whether or not the group appears in searches or by browsing groups. Visible means the group can be found by anyone, hidden means the reverse.</p>\r\n<p>The group mangers have the ability to update the group discoverability which can be found by editing the group.</p>\r\n<p>Group managers can also set access restrictions on each group plugin (members, messages, wiki, etc) to limit access to that specific plugin\'s content. Information about group access levels can be found below.</p>\r\n\r\n<h3><a name=\"groupmembership\"></a>What is Group Membership Access?</h3>\r\n<p>Group membership allows for groups to restrict access for new members. There are four settings for group membership: Anyone or Open, Restricted, Invite Only, and Closed.</p>\r\n<ol>\r\n<li><strong>Anyone or Open</strong> means that if a registered hub member comes to you group they will be able to click a button to join the group without a group manager having to approve. </li>\r\n<li><strong>Restricted</strong> means that the user will have to enter a reason for wanting to join the group and a group manager must approve their request before they will be granted access to the group.</li>\r\n<li><strong>Invite Only</strong> means that the user will not be able to join the group unless they have been sent a group invite from one of the group managers.</li>\r\n<li><strong>Closed</strong> simply means that membership cannot be modified.</li>\r\n</ol>\r\n<p>The group managers have the ability to update the group membership access, which can be found by editing the group.</p>\r\n\r\n<h3><a name=\"groupcustomization\"></a>How to Customize a Group?</h3>\r\n<p>Groups allow for customization including adding a group logo, customizing the group home or main page (instead of using default group description and random selection of group members), setting group plugin access levels (discussed below), and the ability to add extra custom group pages.</p>\r\n<p>All group managers can customize any of these items through the group customization interface.</p>\r\n\r\n<h3><a name=\"groupaccesslevels\"></a>What are Group Plugin Access Levels?</h3>\r\n<p>Group Plugin Access Levels allow for groups to set access levels for each plugin (members, messages, wiki, etc) individually. The different access levels are: Any HUB Visitor, Registered HUB Members, Group Members, and Disabled or Off.</p>\r\n<ol>\r\n<li><strong>Any HUB Visitor</strong> means that if a guest (not logged in user) comes to the group plugin they will be granted access to view the plugin but not allowed to perform any actions (add, edit, delete, etc) within the plugin.</li>\r\n<li><strong>Registered HUB Members</strong> means that if a HUB member (not a member of the group) comes to the group plugin they will be granted access to view the plugin but not allowed to perform any actions (add, edit, delete, etc) within the plugin. Guest users will not be granted access to view the plugin.</li>\r\n<li><strong>Group Members</strong> means that is a group member comes to the group plugin they will granted access to view the plugin and perform any actions that group members are allowed to perform. Guest users and Registered HUB users will not be granted access to the plugin.</li>\r\n<li><strong>Disabled or Off</strong> means that no one will be granted access to the plugin.</li>\r\n</ol>\r\n<p>All group managers have the ability to update the group plugin access levels, which can be found through the group customization interface.</p>\r\n\r\n<h3><a name=\"groupmanagement\"></a>How are groups managed?</h3>\r\n<p>When you create a group, you are automatically made its first manager. As manager, you can also promote members to help you run the group.</p>\r\n<p><strong>A group manager can</strong>:</p>\r\n<ol>\r\n  <li>Create group participation rules</li>\r\n  <li>Promote/demote members and approve/deny membership requests.</li>\r\n  <li>Modify information about the group\r\n    <ul>\r\n      <li>Create or change the group name</li>\r\n      <li>Create or change the group description</li>\r\n      <li>Associate the group with an external URL</li>\r\n      <li>Determine whether or not your group wiki pages, resources, and discussion topics can be viewed by non-members.</li>\r\n      <li>Moderate group discussions</li>\r\n    </ul>\r\n  </li>\r\n</ol>\r\n<p>There\'s no upper limit on the number of managers a group can have, but a group <strong>must</strong> have at least one manager at all times.</p>\r\n<p>You can read about keeping your group happy on the <a href=\"/kb/groups/guide\">Tips for Running Your Group</a> page.</p>\r\n\r\n<h3><a name=\"leavegroup\"></a>How do I leave a group?</h3>\r\n<p>To Leave a group navigate to your Member profile then to the Groups tab. There you will see a listing of all the groups you are associated with. Along the right side of the listing there is a Remove icon. Clicking this link will remove you from the group. You can also navigate directly to the group and click the cancel group membership button.</p>\r\n<p><em>Note: You will not be able to leave a group if you are the only group manager. You must promote someone else in the group first before removing yourself.</em></p>\r\n\r\n<h3><a name=\"deletegroup\"></a>How do I delete a group?</h3>\r\n<p>To Delete a group navigate to your Member profile then to the Groups tab. There you will see a listing of all the groups you are associated with. Along the right side of the listing you will see a Trash icon. Clicking this will take you to another screen to confirm deletion of the group.</p>\r\n<p><em>Note: You will not be able to delete a group if there are other members still in the group.</em></p>\r\n\r\n<hr />\r\n\r\n<p>Return to <a href=\"/groups\">the main groups page</a>.</p>','2010-03-25 06:26:40',62,'0000-00-00 00:00:00',0,0,'0000-00-00 00:00:00',1,0,4,1,1,0,0,0);
INSERT INTO `#__faq` VALUES (25,'Group Guidelines & Tips','guide','show_date=2\nallow_comments=0\nclose_comments=year\nfeeds_enabled=1\nfeed_entries=partial','<p>Ultimately it is the Admins that decide what the rules are for their group, but if you have been made a manager of a group, here are some suggestions for keeping your group happy:</p>\r\n\r\n<h3>Manager Guidelines</h3>\r\n<p>If you are a manager of a group, here are some pointers for creating a thriving community:</p>\r\n<ol>\r\n    <li><strong>Invite your friends</strong> and anyone you know who is interested in what you are interested in. Having group members is the first step in having a successful group!</li> \r\n    <li><strong>Visit the group frequently.</strong> Groups thrive with daily discussion, and with daily responses from other members of the community, in chat and on the discussion boards.</li>\r\n  <li><strong>Moderate, moderate, moderate!</strong> Successful groups are kept in check by good moderation. Tend that garden; pull the weeds, mow the lawn, prune the roses, etc. To help you moderate your group, you can enlist other members to become moderators. Moderators don\\\'t have full administrative power, but they can help you moderate pool submissions, keep tabs on discussions, and weed out the people who don\\\'t play by the rules.</li>\r\n</ol>\r\n\r\n<h3>Removing members</h3>\r\n<p>Here are some general guidelines to help managers determine how and when to use the removing feature.</p>\r\n<p>\\\"Removing\\\" is when a person is removed from a group. They can come back if they want, but some trolls just need a cooling off period and are remorseful when they return.</p>\r\n<ul>\r\n    <li>Use this power wisely and sparingly.</li>\r\n   <li>If a troll types or posts something offensive, they should be warned.</li>\r\n  <li>If they continue their behavior, they should be removed. You can do this from the members list.</li>\r\n</ul>\r\n\r\n<h3>Group Life </h3>\r\n<h4>Swearing</h4>\r\n<p>People ask if it\\\'s OK to swear. It is OK to swear so long as you\\\'re not offending, insulting or harassing anybody.</p>\r\n\r\n<h4>Porn</h4>\r\n<p>Porn, nudity and other such content is not disallowed, but it shouldn\\\'t be posted in public areas.</p>\r\n\r\n<h4>Trolls</h4>\r\n<p>Trolls are people who are just being rude and obnoxious, and are generally trying to offend, shock, harass, abuse or otherwise annoy people. Dealing with such people can often be difficult, but they should not go unwarned or unremoved. Trolls can destroy a community, and often this is their goal.</p>\r\n<p>Trolls thrive on attention, and often the best way to deal with them is to completely ignore them. They don\\\'t know when they are being ignored, all they know is that no one is responding to their attempts to annoy, harass or offend.</p>\r\n\r\n<hr />\r\n\r\n<p>Return to <a href=\\\"/groups\\\">the main groups page</a>.</p>','2011-03-31 15:24:31',69,'2011-03-31 15:24:31',69,0,'0000-00-00 00:00:00',1,0,3,1,1,0,0,0);
INSERT INTO `#__faq` VALUES (27,'Frequently Asked Questions','faq','show_date=2\nallow_comments=0\nclose_comments=year\nfeeds_enabled=1\nfeed_entries=partial','<ul class=\\\"faq-list\\\">\r\n	<li><a href=\\\"#explanation\\\">What are resources?</a></li>\r\n	<li><a href=\\\"#create\\\">How do I upload a new resource?</a></li>\r\n	<li><a href=\\\"#delete\\\">How can I delete a resource?</a></li>\r\n	<li><a href=\\\"#limit\\\">Is there a limit on the number of resources I can submit?</a></li>\r\n</ul>\r\n\r\n<h3><a name=\\\"explanation\\\"></a>What are resources?</h3>\r\n<p>Think of a hub as an empty library.  Resources are items on the shelves.  Unlike a traditional library, resources not only be publications, but also videos, tools, animations, and other types.  Anyone can upload resources, although some hubs require moderation and approval before a resource is posted.</p>\r\n\r\n<h3><a name=\\\"create\\\"></a>How do I upload a new resource?</h3>\r\n<p>You can submit a new resource with our <a href=\\\"/resources/new\\\">contribution section</a>. This will guide you, step-by-step, through the process. If you get interrupted during the submission process, no problem.  The hub will remember where you left off.  Submissions may be worked on at your leisure and submitted at any future date when you feel they are ready.</p>\r\n\r\n<h3><a name=\\\"deletetag\\\"></a>How can I delete a resource?</h3>\r\n<p>Currently, you can\\\'t. This is partly because others may reference your resource in journal articles, and it would be wrong for it to suddenly disappear.  Instead, resources are normally \\\"retired,\\\" or put in a state where they can be seen but not downloaded or used.  If you wish to have a resource retired or completely removed, please contact our support and we will work with you to address the issue.</p>\r\n\r\n<h3><a name=\\\"taglimit\\\"></a>Is there a limit on the number of resources I can submit?</h3>\r\n<p>No.  Think of resources as publications or presentations that you would be proud to have others find in the library.  It usually takes time to produce high-quality resources, but there is no limit on the amount that you can contribute</p>\r\n\r\n<hr />\r\n\r\n<p>Back to the <a href=\\\"/resources\\\">main Resources page</a>.</p>','2010-03-27 11:27:39',63,'0000-00-00 00:00:00',0,0,'0000-00-00 00:00:00',1,0,7,1,7,0,0,0);
INSERT INTO `#__faq` VALUES (28,'Earning points in the Questions & Answers forum','earning_points_in_the_answers_forum','show_date=2\nallow_comments=0\nclose_comments=year\nfeeds_enabled=1\nfeed_entries=partial','<p>Each question in the forum has its own \\\"market\\\" value, which reflects the level of community interest the question has generated. This is calculated by summing up the weighted number of answers, recommendations and answer votes, e.g. each additional answer rises the value of the question by 10 points, each recommendation by 2 points, etc. When the person who asked the question selects an answer as most helpful, the question gets 20 bonus points and is considered to be closed. At that moment the accumulated point value of the question is distributed between participating parties. One third of the value goes to the asker; another third goes to the user whose answer was accepted as the best; the remaining third is split between all users who answered the question, provided that their response received at least 3 community votes and more than half of those are positive (users found them helpful). In the case of only one answer, or if the community vote requirement is not satisfied, the user whose answer was accepted as best gets the remainder of accumulated points for the question.</p>\r\n<p>Additionally, users will get monthly \\\"royalty\\\" payments for their questions and answers based on the total of received question recommendations and answer votes. The royalty payment is distributed the same way as the points at question closure. The more community interest the question generates and the more positive votes your answer receives, the more points you earn as a result.</p>\r\n<p>You can boost the value of your question by assigning a point reward for best answer. This can be done when you first submit your question, provided that you have funds available on your account. The amount you set aside for the reward is not deducted from your account until you select the winner, but is meanwhile kept on hold. If you are not satisfied with a single answer and do not wish to name a winner, you have an option to withdraw your question.</p>','2011-03-31 13:52:03',71,'2011-03-31 13:52:03',71,0,'0000-00-00 00:00:00',1,0,6,1,8,0,0,0);
INSERT INTO `#__faq` VALUES (29,'Frequently Asked Questions','faq','show_date=2\nallow_comments=0\nclose_comments=year\nfeeds_enabled=1\nfeed_entries=partial','<ul class=\\\"faq-list\\\"> \r\n	<li><a href=\\\"#tagsexplanation\\\">What are tags?</a></li> \r\n	<li><a href=\\\"#createtag\\\">How do I create a new tag?</a></li> \r\n	<li><a href=\\\"#deletetag\\\">How can I delete a tag?</a></li> \r\n	<li><a href=\\\"#removetag\\\">How can I remove a tag from a resource/group/my profile/etc?</a></li> \r\n	<li><a href=\\\"#taglimit\\\">Is there a limit on the number of tags I can add to an item?</a></li> \r\n	<li><a href=\\\"#otherstags\\\">Can I tell who\\\'s tagged another member\\\'s content?</a></li> \r\n</ul> \r\n \r\n<h3><a name=\\\"tagsexplanation\\\"></a>What are tags?</h3> \r\n<p>Tags are like keywords or category labels. Tags help you find content, events, and members which have something in common or similar interests. Tags can be added to groups, your profile, resources, wiki pages, and events.</p> \r\n \r\n<h3><a name=\\\"createtag\\\"></a>How do I create a new tag?</h3> \r\n<p>When creating or editing content, your profile, groups, etc. you can add or remove tags as you wish. If a tag doesn\\\'t already exist, simply typing it in a \\\"Tags\\\" form field will create it and make it available for everyone to use.</p> \r\n \r\n<h3><a name=\\\"deletetag\\\"></a>How can I delete a tag?</h3> \r\n<p>You can\\\'t. Tags can only be deleted by the site administrators. You may only remove tags from a piece of content or profile.</p> \r\n \r\n<h3><a name=\\\"removetag\\\"></a>How can I remove a tag from a resource/group/my profile/etc?</h3> \r\n<p>When editing content, your profile, groups, etc. you can remove tags by simply deleting them from the list presented in the \\\"Tags\\\" form field.</p> \r\n \r\n<h3><a name=\\\"taglimit\\\"></a>Is there a limit on the number of tags I can add to an item?</h3> \r\n<p>No. You should be able to add as many tags as you want to taggable content/profiles.</p> \r\n \r\n<h3><a name=\\\"otherstags\\\"></a>Can I tell who\\\'s tagged another member\\\'s content?</h3> \r\n<p>No. Who tagged an item and what tags they added is currently not available to users.</p> \r\n \r\n<hr /> \r\n \r\n<p>Back to the <a href=\\\"/tags\\\">main Tags page</a>.</p>','2010-03-27 13:24:44',62,'2010-03-27 13:27:17',63,0,'0000-00-00 00:00:00',1,0,11,1,4,0,0,0);
INSERT INTO `#__faq` VALUES (42,'Where do I go for documentation?','testarticle','uploadpath=/site/kb\nshow_authors=1\nallow_comments=1\nclose_comments=year\nfeeds_enabled=1\nfeed_entries=partial\nshow_date=2','Documentation can be found in <a href=\"https://hubzero.org/documentation\">HUBzero\'s documentation page<a>.','2011-04-01 10:25:02',71,'2011-04-01 10:25:02',0,0,'0000-00-00 00:00:00',1,0,5,1,3,0,0,0);

--
-- HUBzero sample data for table `#__faq_categories`
--

INSERT INTO `#__faq_categories` VALUES (1,'Members & Groups','groups','&quot;Members only&quot; content, working with member groups, member content, and member privileges.',0,1,0,0);
INSERT INTO `#__faq_categories` VALUES (2,'Login & Registration','registration','The following will try to answer some frequently recieved questions concerning login and registration issues.',0,1,0,0);
INSERT INTO `#__faq_categories` VALUES (3,'Miscellaneous','misc','Issues that don\\\'t necessarily fit in other categories, but that can affect hub use or are very helpful in using it.',0,1,0,0);
INSERT INTO `#__faq_categories` VALUES (4,'Tags','tags','Information about tags and how to deal with them.',0,1,0,0);
INSERT INTO `#__faq_categories` VALUES (5,'Tips','tips','Learn more about features of this hub you may not have known about.',0,1,0,0);
INSERT INTO `#__faq_categories` VALUES (6,'Tools','tools','The most common questions on launching and using simulation tools.',0,1,0,0);
INSERT INTO `#__faq_categories` VALUES (7,'Resources','resources','Questions, concerns, and problems you may have with uploading and publishing content on this site.',0,1,0,0);
INSERT INTO `#__faq_categories` VALUES (8,'Reward Points','points','<p>Our hub is powered by your contributions!  We want to reward you for your efforts and encourage you to contribute more.  So we have introduced a new system of reward points similar to airline miles.</p>\r\n\r\n<p><img src=\\\"site/media/images/header_economy',0,1,0,0);

--
-- HUBzero sample data for table `#__forum_categories`
--

INSERT INTO `#__forum_categories` (`id`, `title`, `alias`, `description`, `created`, `created_by`, `modified`, `modified_by`, `access`, `state`, `scope`, `scope_id`, `section_id`, `closed`, `asset_id`, `object_id`) VALUES (1,'Discussions','discussions','Default category for all discussions in this forum.','2012-05-24 17:33:36',0,'0000-00-00 00:00:00',0,0,0,'site',0,1,0,0,0);

--
-- HUBzero sample data for table `#__forum_sections`
--

INSERT INTO `#__forum_sections` (`id`, `title`, `alias`, `created`, `created_by`, `access`, `state`, `scope`, `scope_id`, `asset_id`, `object_id`) VALUES (1,'Default Section','defaultsection','2012-05-24 17:33:36',0,0,1,'site',0,0,0);

--
--
-- HUBzero sample data for table `#__jobs_categories`
--

INSERT INTO `#__jobs_categories` (`id`, `category`, `ordernum`, `description`) VALUES (1,'Scientific/Technical Staff',3,'');
INSERT INTO `#__jobs_categories` (`id`, `category`, `ordernum`, `description`) VALUES (2,'Post-Doctoral Researcher',2,'');
INSERT INTO `#__jobs_categories` (`id`, `category`, `ordernum`, `description`) VALUES (3,'Faculty Tenure & Tenure-Track',1,'');

--
-- HUBzero sample data for table `#__jobs_types`
--

INSERT INTO `#__jobs_types` (`id`, `category`) VALUES (1,'Full-time');
INSERT INTO `#__jobs_types` (`id`, `category`) VALUES (2,'Part-time');
INSERT INTO `#__jobs_types` (`id`, `category`) VALUES (3,'Contract');
INSERT INTO `#__jobs_types` (`id`, `category`) VALUES (4,'Internship');
INSERT INTO `#__jobs_types` (`id`, `category`) VALUES (5,'Temporary');

--
-- HUBzero sample data for table `#__menu`
--

TRUNCATE `#__menu`;
ALTER TABLE `#__menu` DROP KEY  `idx_client_id_parent_id_alias_language`;
ALTER TABLE `#__menu` ADD KEY `idx_client_id_parent_id_alias_language` (`client_id`,`parent_id`,`alias`, `language`);

INSERT INTO `#__menu` VALUES (1,'','Menu_Item_Root','root','','','','',1,0,0,0,0,0,'0000-00-00 00:00:00',0,0,'',0,'',0,221,0,'*',0);
INSERT INTO `#__menu` VALUES (4,'mainmenu','Resources','resources','','discover/resources','index.php?Itemid=','alias',1,41,2,0,1,0,'0000-00-00 00:00:00',0,1,'',0,'{\"aliasoptions\":\"88\"}',112,117,0,'*',0);
INSERT INTO `#__menu` VALUES (5,'mainmenu','Members','members','','community/members','index.php?Itemid=','alias',1,76,2,0,1,0,'0000-00-00 00:00:00',0,1,'',0,'{\"aliasoptions\":\"83\"}',142,143,0,'*',0);
INSERT INTO `#__menu` VALUES (6,'mainmenu','Events','events','','discover/events','index.php?Itemid=','alias',1,41,2,0,7,0,'0000-00-00 00:00:00',0,1,'',0,'{\"aliasoptions\":\"85\"}',128,129,0,'*',0);
INSERT INTO `#__menu` VALUES (7,'mainmenu','About','about','','about','index.php?option=com_content&view=article&id=3','component',1,1,1,22,5,0,'0000-00-00 00:00:00',0,1,'',0,'{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"0\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}',157,170,0,'*',0);
INSERT INTO `#__menu` VALUES (8,'mainmenu','Support','support','','support','index.php?Itemid=','alias',1,1,1,0,6,0,'0000-00-00 00:00:00',0,1,'',0,'{\"aliasoptions\":\"84\"}',175,184,0,'*',0);
INSERT INTO `#__menu` VALUES (9,'about','About Us','aboutus','','aboutus','index.php?option=com_content&view=article&id=3','component',1,1,1,22,1,0,'0000-00-00 00:00:00',0,1,'',0,'{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}',75,86,0,'*',0);
INSERT INTO `#__menu` VALUES (10,'about','Contact Us','contact','','aboutus/contact','index.php?option=com_content&view=article&id=4','component',1,9,2,22,1,0,'0000-00-00 00:00:00',0,1,'',0,'{\"show_noauth\":\"\",\"show_title\":\"1\",\"link_titles\":\"\",\"show_intro\":\"1\",\"show_section\":\"0\",\"link_section\":\"0\",\"show_category\":\"0\",\"link_category\":\"0\",\"show_author\":\"0\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_item_navigation\":\"\",\"show_readmore\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"0\",\"show_email_icon\":\"0\",\"show_hits\":\"\",\"feed_summary\":\"\",\"page_title\":\"\",\"show_page_title\":\"1\",\"pageclass_sfx\":\"\",\"menu_image\":\"0\",\"secure\":\"0\"}',76,77,0,'*',0);
INSERT INTO `#__menu` VALUES (15,'about','Copyright Infringement Notification','dmcapolicy','','aboutus/dmcapolicy','index.php?option=com_content&view=article&id=7','component',1,9,2,22,3,0,'0000-00-00 00:00:00',0,1,'',0,'{\"show_noauth\":\"\",\"show_title\":\"1\",\"link_titles\":\"\",\"show_intro\":\"1\",\"show_section\":\"0\",\"link_section\":\"0\",\"show_category\":\"0\",\"link_category\":\"0\",\"show_author\":\"0\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_item_navigation\":\"\",\"show_readmore\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"0\",\"show_email_icon\":\"0\",\"show_hits\":\"\",\"feed_summary\":\"\",\"page_title\":\"\",\"show_page_title\":\"1\",\"pageclass_sfx\":\"\",\"menu_image\":\"0\",\"secure\":\"0\"}',80,81,0,'*',0);
INSERT INTO `#__menu` VALUES (17,'about','Our Cyberinfrastructure','hubzero','','aboutus/hubzero','index.php?option=com_content&view=article&id=2','component',1,9,2,22,4,0,'0000-00-00 00:00:00',0,1,'',0,'{\"show_noauth\":\"\",\"show_title\":\"1\",\"link_titles\":\"\",\"show_intro\":\"1\",\"show_section\":\"0\",\"link_section\":\"0\",\"show_category\":\"0\",\"link_category\":\"0\",\"show_author\":\"0\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_item_navigation\":\"\",\"show_readmore\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"0\",\"show_email_icon\":\"0\",\"show_hits\":\"\",\"feed_summary\":\"\",\"page_title\":\"\",\"show_page_title\":\"1\",\"pageclass_sfx\":\"\",\"menu_image\":\"0\",\"secure\":\"0\"}',82,83,0,'*',0);
INSERT INTO `#__menu` VALUES (19,'about','Terms of Use','terms','','aboutus/terms','index.php?option=com_content&view=article&id=11','component',1,9,2,22,2,0,'0000-00-00 00:00:00',0,1,'',0,'{\"show_noauth\":\"\",\"show_title\":\"1\",\"link_titles\":\"0\",\"show_intro\":\"1\",\"show_section\":\"0\",\"link_section\":\"0\",\"show_category\":\"0\",\"link_category\":\"0\",\"show_author\":\"0\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_item_navigation\":\"\",\"show_readmore\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"0\",\"show_email_icon\":\"0\",\"show_hits\":\"\",\"feed_summary\":\"\",\"page_title\":\"\",\"show_page_title\":\"1\",\"pageclass_sfx\":\"\",\"menu_image\":\"0\",\"secure\":\"0\"}',78,79,0,'*',0);
INSERT INTO `#__menu` VALUES (20,'mainmenu','What\'s New','whatsnew','','discover/resources/whatsnew','index.php?option=com_whatsnew&view=results&layout=display','component',-2,4,3,1030,1,0,'0000-00-00 00:00:00',0,1,'',0,'{\"period\":\"resources:month\",\"page_title\":\"\",\"show_page_title\":\"1\",\"pageclass_sfx\":\"\",\"menu_image\":\"0\",\"secure\":\"0\"}',113,114,0,'*',0);
INSERT INTO `#__menu` VALUES (21,'mainmenu','Upload','upload','','discover/resources/upload','/resources/new','url',-2,4,3,0,2,0,'0000-00-00 00:00:00',0,1,'',0,'{\"menu_image\":\"0\"}',115,116,0,'*',0);
INSERT INTO `#__menu` VALUES (32,'mainmenu','Groups','groups','','community/groups','index.php?Itemid=','alias',1,76,2,0,2,0,'0000-00-00 00:00:00',0,1,'',0,'{\"aliasoptions\":\"81\"}',144,145,0,'*',0);
INSERT INTO `#__menu` VALUES (37,'mainmenu','Knowledge Base','knowledgebase','','support/knowledgebase','index.php?Itemid=','alias',1,8,2,0,1,0,'0000-00-00 00:00:00',0,1,'',0,'{\"aliasoptions\":\"82\"}',176,177,0,'*',0);
INSERT INTO `#__menu` VALUES (38,'mainmenu','Report a Problem','reportproblems','','support/reportproblems','/feedback/report_problems','url',1,8,2,0,2,0,'0000-00-00 00:00:00',0,1,'',0,'{\"menu_image\":\"0\"}',178,179,0,'*',0);
INSERT INTO `#__menu` VALUES (39,'mainmenu','Tickets','tickets','','support/tickets','/support/tickets','url',1,8,2,0,3,0,'0000-00-00 00:00:00',0,1,'',0,'{\"menu_image\":\"0\"}',180,181,0,'*',0);
INSERT INTO `#__menu` VALUES (40,'mainmenu','Wish List','wishlist','','support/wishlist','index.php?Itemid=','alias',1,8,2,0,4,0,'0000-00-00 00:00:00',0,1,'',0,'{\"aliasoptions\":\"92\"}',182,183,0,'*',0);
INSERT INTO `#__menu` VALUES (41,'mainmenu','Discover','discover','','discover','index.php?option=com_content&view=article&id=22','component',1,1,1,22,3,0,'0000-00-00 00:00:00',0,1,'',0,'{\"show_noauth\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_section\":\"\",\"link_section\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_author\":\"0\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_item_navigation\":\"\",\"show_readmore\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"0\",\"show_email_icon\":\"0\",\"show_hits\":\"\",\"feed_summary\":\"\",\"page_title\":\"\",\"show_page_title\":\"1\",\"pageclass_sfx\":\"\",\"menu_image\":\"0\",\"secure\":\"0\"}',105,136,0,'*',0);
INSERT INTO `#__menu` VALUES (42,'mainmenu','Wiki','wiki','','discover/wiki','index.php?Itemid=','alias',1,41,2,0,5,0,'0000-00-00 00:00:00',0,1,'',0,'{\"aliasoptions\":\"86\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1}',124,125,0,'*',0);
INSERT INTO `#__menu` VALUES (43,'mainmenu','Questions & Answers','answers','','community/answers','index.php?Itemid=','alias',1,76,2,0,4,0,'0000-00-00 00:00:00',0,1,'',0,'{\"aliasoptions\":\"77\"}',148,149,0,'*',0);
INSERT INTO `#__menu` VALUES (44,'mainmenu','Tags','tags','','discover/tags','index.php?Itemid=','alias',1,41,2,0,4,0,'0000-00-00 00:00:00',0,1,'',0,'{\"aliasoptions\":\"89\"}',122,123,0,'*',0);
INSERT INTO `#__menu` VALUES (45,'mainmenu','Citations','citations','','discover/citations','index.php?Itemid=','alias',1,41,2,0,6,0,'0000-00-00 00:00:00',0,1,'',0,'{\"aliasoptions\":\"79\"}',126,127,0,'*',0);
INSERT INTO `#__menu` VALUES (46,'mainmenu','&nbsp;','n','','discover/n','','separator',1,41,2,0,3,0,'0000-00-00 00:00:00',0,1,'',0,'{\"menu_image\":\"0\"}',120,121,0,'*',0);
INSERT INTO `#__menu` VALUES (47,'mainmenu','Feedback','feedback','','discover/feedback','index.php?Itemid=','alias',-2,41,2,0,10,0,'0000-00-00 00:00:00',0,1,'',0,'{\"aliasoptions\":\"93\"}',134,135,0,'*',0);
INSERT INTO `#__menu` VALUES (48,'mainmenu','Store','store','','discover/store','index.php?Itemid=','alias',1,41,2,0,9,0,'0000-00-00 00:00:00',0,1,'',0,'{\"aliasoptions\":\"90\"}',132,133,0,'*',0);
INSERT INTO `#__menu` VALUES (49,'mainmenu','&nbsp;','n','','discover/n','','separator',1,41,2,0,8,0,'0000-00-00 00:00:00',0,1,'',0,'{\"menu_image\":\"0\"}',130,131,0,'*',0);
INSERT INTO `#__menu` VALUES (50,'mainmenu','Tool Forge','tools','','discover/tools','index.php?Itemid=','alias',-2,41,2,0,2,0,'0000-00-00 00:00:00',0,1,'',0,'{\"aliasoptions\":\"87\"}',118,119,0,'*',0);
INSERT INTO `#__menu` VALUES (55,'default','Login','login','','login','index.php?option=com_users&view=login','component',1,1,1,25,4,0,'0000-00-00 00:00:00',0,1,'',0,'{\"show_login_title\":\"1\",\"header_login\":\"\",\"login_message\":\"0\",\"description_login\":\"1\",\"description_login_text\":\"Log in with your <br \\/> hub account.\",\"image_login\":\"\",\"image_login_align\":\"right\",\"show_logout_title\":\"1\",\"header_logout\":\"\",\"logout\":\"\",\"logout_message\":\"1\",\"description_logout\":\"1\",\"description_logout_text\":\"\",\"image_logout\":\"\",\"page_title\":\"\",\"show_page_title\":\"1\",\"pageclass_sfx\":\"\",\"menu_image\":\"0\",\"secure\":\"0\",\"login_redirect_url\":\"\\/members\\/myaccount\"}',151,156,0,'*',0);
INSERT INTO `#__menu` VALUES (56,'default','Logout','logout','','logout','index.php?option=com_users&view=logout','component',1,1,1,25,5,0,'0000-00-00 00:00:00',0,1,'',0,'{\"show_login_title\":\"1\",\"header_login\":\"\",\"login\":\"\",\"login_message\":\"0\",\"description_login\":\"0\",\"description_login_text\":\"\",\"image_login\":\"\",\"image_login_align\":\"right\",\"show_logout_title\":\"1\",\"header_logout\":\"\",\"logout\":\"\",\"logout_message\":\"1\",\"description_logout\":\"1\",\"description_logout_text\":\"\",\"image_logout\":\"\",\"page_title\":\"\",\"show_page_title\":\"1\",\"pageclass_sfx\":\"\",\"menu_image\":\"0\",\"secure\":\"0\"}',171,172,0,'*',0);
INSERT INTO `#__menu` VALUES (59,'default','Reset','reset','','login/reset','index.php?option=com_users&view=reset','component',1,55,2,25,2,0,'0000-00-00 00:00:00',0,1,'',0,'{\"page_title\":\"\",\"show_page_title\":\"1\",\"pageclass_sfx\":\"\",\"menu_image\":\"0\",\"secure\":\"0\"}',154,155,0,'*',0);
INSERT INTO `#__menu` VALUES (60,'default','Remind','remind','','login/remind','index.php?option=com_users&view=remind','component',1,55,2,25,1,0,'0000-00-00 00:00:00',0,1,'',0,'{\"page_title\":\"\",\"show_page_title\":\"1\",\"pageclass_sfx\":\"\",\"menu_image\":\"0\",\"secure\":\"0\"}',152,153,0,'*',0);
INSERT INTO `#__menu` VALUES (65,'mainmenu','Contact Us','contact','','about/contact','index.php?option=com_content&view=article&id=4','component',1,7,2,22,1,0,'0000-00-00 00:00:00',0,1,'',0,'{\"show_noauth\":\"\",\"show_title\":\"1\",\"link_titles\":\"\",\"show_intro\":\"1\",\"show_section\":\"0\",\"link_section\":\"0\",\"show_category\":\"0\",\"link_category\":\"0\",\"show_author\":\"0\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_item_navigation\":\"\",\"show_readmore\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"0\",\"show_email_icon\":\"0\",\"show_hits\":\"\",\"feed_summary\":\"\",\"page_title\":\"\",\"show_page_title\":\"1\",\"pageclass_sfx\":\"\",\"menu_image\":\"0\",\"secure\":\"0\"}',162,163,0,'*',0);
INSERT INTO `#__menu` VALUES (66,'mainmenu','Terms of Use','terms','','about/terms','index.php?option=com_content&view=article&id=11','component',1,7,2,22,2,0,'0000-00-00 00:00:00',0,1,'',0,'{\"show_noauth\":\"\",\"show_title\":\"1\",\"link_titles\":\"0\",\"show_intro\":\"1\",\"show_section\":\"0\",\"link_section\":\"0\",\"show_category\":\"0\",\"link_category\":\"0\",\"show_author\":\"0\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_item_navigation\":\"\",\"show_readmore\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"0\",\"show_email_icon\":\"0\",\"show_hits\":\"\",\"feed_summary\":\"\",\"page_title\":\"\",\"show_page_title\":\"1\",\"pageclass_sfx\":\"\",\"menu_image\":\"0\",\"secure\":\"0\"}',164,165,0,'*',0);
INSERT INTO `#__menu` VALUES (67,'mainmenu','Copyright Infringement','copyright','','about/copyright','index.php?option=com_content&view=article&id=7','component',1,7,2,22,3,0,'0000-00-00 00:00:00',0,1,'',0,'{\"show_noauth\":\"\",\"show_title\":\"1\",\"link_titles\":\"\",\"show_intro\":\"1\",\"show_section\":\"0\",\"link_section\":\"0\",\"show_category\":\"0\",\"link_category\":\"0\",\"show_author\":\"0\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_item_navigation\":\"\",\"show_readmore\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"0\",\"show_email_icon\":\"0\",\"show_hits\":\"\",\"feed_summary\":\"\",\"page_title\":\"\",\"show_page_title\":\"1\",\"pageclass_sfx\":\"\",\"menu_image\":\"0\",\"secure\":\"0\"}',166,167,0,'*',0);
INSERT INTO `#__menu` VALUES (68,'mainmenu','Our Cyberinfrastructure','hubzero','','about/hubzero','index.php?option=com_content&view=article&id=2','component',1,7,2,22,4,0,'0000-00-00 00:00:00',0,1,'',0,'{\"show_noauth\":\"\",\"show_title\":\"1\",\"link_titles\":\"\",\"show_intro\":\"1\",\"show_section\":\"0\",\"link_section\":\"0\",\"show_category\":\"0\",\"link_category\":\"0\",\"show_author\":\"0\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_item_navigation\":\"\",\"show_readmore\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"0\",\"show_email_icon\":\"0\",\"show_hits\":\"\",\"feed_summary\":\"\",\"page_title\":\"\",\"show_page_title\":\"1\",\"pageclass_sfx\":\"\",\"menu_image\":\"0\",\"secure\":\"0\"}',168,169,0,'*',0);
INSERT INTO `#__menu` VALUES (69,'legal','Legal','legal','','legal','index.php?option=com_content&view=article&id=29','component',1,1,1,22,1,0,'0000-00-00 00:00:00',0,1,'',0,'{\"show_noauth\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_section\":\"\",\"link_section\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_item_navigation\":\"\",\"show_readmore\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"feed_summary\":\"\",\"page_title\":\"\",\"show_page_title\":\"1\",\"pageclass_sfx\":\"\",\"menu_image\":\"0\",\"secure\":\"0\"}',87,102,0,'*',0);
INSERT INTO `#__menu` VALUES (70,'legal','Abuse Policy','abuse','','legal/abuse','index.php?option=com_content&view=article&id=28','component',1,69,2,22,1,0,'0000-00-00 00:00:00',0,1,'',0,'{\"show_noauth\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_section\":\"\",\"link_section\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_item_navigation\":\"\",\"show_readmore\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"feed_summary\":\"\",\"page_title\":\"\",\"show_page_title\":\"1\",\"pageclass_sfx\":\"\",\"menu_image\":\"0\",\"secure\":\"0\"}',88,89,0,'*',0);
INSERT INTO `#__menu` VALUES (71,'legal','Privacy Policy','privacy','','legal/privacy','index.php?option=com_content&view=article&id=27','component',1,69,2,22,2,0,'0000-00-00 00:00:00',0,1,'',0,'{\"show_noauth\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_section\":\"\",\"link_section\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_item_navigation\":\"\",\"show_readmore\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"feed_summary\":\"\",\"page_title\":\"\",\"show_page_title\":\"1\",\"pageclass_sfx\":\"\",\"menu_image\":\"0\",\"secure\":\"0\"}',90,91,0,'*',0);
INSERT INTO `#__menu` VALUES (72,'legal','Terms of Use','terms','','legal/terms','index.php?option=com_content&view=article&id=11','component',1,69,2,22,3,0,'0000-00-00 00:00:00',0,1,'',0,'{\"show_noauth\":\"\",\"show_title\":\"1\",\"link_titles\":\"0\",\"show_intro\":\"1\",\"show_section\":\"0\",\"link_section\":\"0\",\"show_category\":\"0\",\"link_category\":\"0\",\"show_author\":\"0\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_item_navigation\":\"\",\"show_readmore\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"0\",\"show_email_icon\":\"0\",\"show_hits\":\"\",\"feed_summary\":\"\",\"page_title\":\"\",\"show_page_title\":\"1\",\"pageclass_sfx\":\"\",\"menu_image\":\"0\",\"secure\":\"0\"}',92,93,0,'*',0);
INSERT INTO `#__menu` VALUES (73,'legal','Licensing Content','licensing','','legal/licensing','index.php?option=com_content&view=article&id=12','component',1,69,2,22,4,0,'0000-00-00 00:00:00',0,1,'',0,'{\"show_noauth\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_section\":\"\",\"link_section\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_author\":\"0\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_item_navigation\":\"\",\"show_readmore\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"0\",\"show_email_icon\":\"0\",\"show_hits\":\"\",\"feed_summary\":\"\",\"page_title\":\"\",\"show_page_title\":\"1\",\"pageclass_sfx\":\"\",\"menu_image\":\"0\",\"secure\":\"0\"}',96,97,0,'*',0);
INSERT INTO `#__menu` VALUES (74,'legal','Submitting Content','license','','legal/license','index.php?option=com_content&view=article&id=14','component',1,69,2,22,5,0,'0000-00-00 00:00:00',0,1,'',0,'{\"show_noauth\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_section\":\"\",\"link_section\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_author\":\"0\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_item_navigation\":\"\",\"show_readmore\":\"\",\"show_vote\":\"0\",\"show_icons\":\"\",\"show_print_icon\":\"0\",\"show_email_icon\":\"0\",\"show_hits\":\"\",\"feed_summary\":\"\",\"page_title\":\"\",\"show_page_title\":\"1\",\"pageclass_sfx\":\"\",\"menu_image\":\"0\",\"secure\":\"0\"}',98,99,0,'*',0);
INSERT INTO `#__menu` VALUES (75,'legal','Accessibility Statement','accessibility','','legal/accessibility','index.php?option=com_content&view=article&id=30','component',1,69,2,22,6,0,'0000-00-00 00:00:00',0,1,'',0,'{\"show_noauth\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_section\":\"\",\"link_section\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_item_navigation\":\"\",\"show_readmore\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"feed_summary\":\"\",\"page_title\":\"\",\"show_page_title\":\"1\",\"pageclass_sfx\":\"\",\"menu_image\":\"0\",\"secure\":\"0\"}',100,101,0,'*',0);
INSERT INTO `#__menu` VALUES (76,'mainmenu','Community','community','','community','index.php?option=com_content&view=article&id=31','component',1,1,1,22,4,0,'0000-00-00 00:00:00',0,1,'',0,'{\"show_noauth\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_section\":\"\",\"link_section\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_item_navigation\":\"\",\"show_readmore\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"feed_summary\":\"\",\"page_title\":\"\",\"show_page_title\":\"1\",\"pageclass_sfx\":\"\",\"menu_image\":\"0\",\"secure\":\"0\"}',139,150,0,'*',0);
INSERT INTO `#__menu` VALUES (77,'default','Questions & Answers','answers','','answers','index.php?option=com_answers&view=questions&layout=search','component',1,1,1,1000,14,0,'0000-00-00 00:00:00',0,1,'',0,'{\"notify_users\":\"\",\"page_title\":\"\",\"show_page_title\":\"1\",\"pageclass_sfx\":\"\",\"menu_image\":\"0\",\"secure\":\"0\"}',199,200,0,'*',0);
INSERT INTO `#__menu` VALUES (78,'default','Blog','blog','','blog','index.php?option=com_blog&view=entries&layout=display','component',1,1,1,1002,6,0,'0000-00-00 00:00:00',0,1,'',0,'{\"cleanintro\":\"\",\"introlength\":\"300\",\"show_authors\":\"\",\"allow_comments\":\"\",\"feeds_enabled\":\"\",\"feed_entries\":\"\",\"show_date\":\"\",\"page_title\":\"\",\"show_page_title\":\"1\",\"pageclass_sfx\":\"\",\"menu_image\":\"0\",\"secure\":\"0\"}',173,174,0,'*',0);
INSERT INTO `#__menu` VALUES (79,'default','Citations','citations','','citations','index.php?option=com_citations&view=citations&layout=display','component',1,1,1,1003,7,0,'0000-00-00 00:00:00',0,1,'',0,'{\"citation_label\":\"\",\"citation_rollover\":\"\",\"citation_sponsors\":\"\",\"citation_import\":\"\",\"citation_bulk_import\":\"\",\"citation_download\":\"\",\"citation_batch_download\":\"\",\"citation_download_exclude\":\"\",\"citation_coins\":\"\",\"citation_openurl\":\"\",\"citation_url\":\"\",\"citation_custom_url\":\"\",\"citation_cited\":\"\",\"citation_cited_single\":\"\",\"citation_cited_multiple\":\"\",\"citation_show_tags\":\"\",\"citation_allow_tags\":\"\",\"citation_show_badges\":\"\",\"citation_allow_badges\":\"\",\"citation_format\":\"\",\"page_title\":\"\",\"show_page_title\":\"1\",\"pageclass_sfx\":\"\",\"menu_image\":\"0\",\"secure\":\"0\"}',185,186,0,'*',0);
INSERT INTO `#__menu` VALUES (80,'default','Forum','forum','','forum','index.php?option=com_forum&view=sections&layout=display','component',1,1,1,1009,10,0,'0000-00-00 00:00:00',0,1,'',0,'{\"filepath\":\"\\/site\\/forum\",\"forum\":\"\",\"page_title\":\"\",\"show_page_title\":\"1\",\"pageclass_sfx\":\"\",\"menu_image\":\"0\",\"secure\":\"0\"}',191,192,0,'*',0);
INSERT INTO `#__menu` VALUES (81,'default','Groups','groups','','groups','index.php?option=com_groups&view=intro','component',1,1,1,1010,11,0,'0000-00-00 00:00:00',0,1,'',0,'{\"join_policy\":\"\",\"privacy\":\"\",\"auto_approve\":\"\",\"display_system_users\":\"\",\"email_comment_processing\":\"\",\"email_member_groupsidcussionemail_autosignup\":\"\",\"intro_mygroups\":\"\",\"intro_interestinggroups\":\"\",\"intro_populargroups\":\"\",\"page_title\":\"\",\"show_page_title\":\"1\",\"pageclass_sfx\":\"\",\"menu_image\":\"0\",\"secure\":\"0\"}',193,194,0,'*',0);
INSERT INTO `#__menu` VALUES (82,'default','Knowledge Base','kb','','kb','index.php?option=com_kb&view=articles&layout=display','component',1,1,1,1013,12,0,'0000-00-00 00:00:00',0,1,'',0,'{\"show_date\":\"\",\"allow_comments\":\"\",\"close_comments\":\"\",\"feeds_enabled\":\"\",\"feed_entries\":\"\",\"page_title\":\"\",\"show_page_title\":\"1\",\"pageclass_sfx\":\"\",\"menu_image\":\"0\",\"secure\":\"0\"}',195,196,0,'*',0);
INSERT INTO `#__menu` VALUES (83,'default','Members','members','','members','index.php?option=com_members&view=profiles&layout=browse','component',1,1,1,1014,13,0,'0000-00-00 00:00:00',0,1,'',0,'{\"privacy\":\"\",\"bankAccounts\":\"\",\"user_messaging\":\"\",\"employeraccess\":\"\",\"shadowMax\":\"\",\"shadowMin\":\"0\",\"shadowWarning\":\"7\",\"page_title\":\"\",\"show_page_title\":\"1\",\"pageclass_sfx\":\"\",\"menu_image\":\"0\",\"secure\":\"0\"}',197,198,0,'*',0);
INSERT INTO `#__menu` VALUES (84,'default','Support','support','','support','index.php?option=com_support&view=index&layout=display','component',1,1,1,1025,17,0,'0000-00-00 00:00:00',0,1,'',0,'{\"feed_summary\":\"\",\"emails\":\"{config.mailfrom}\",\"blacklist\":\"\",\"badwords\":\"viagra, pharmacy, xanax, phentermine, dating, ringtones, tramadol, hydrocodone, levitra, ambien, vicodin, fioricet, diazepam, cash advance, free online, online gambling, online prescriptions, debt consolidation, baccarat, loan, slots, credit, mortgage, casino, slot, texas holdem, teen nude, orgasm, gay, fuck, crap, shit, asshole, cunt, fucker, fuckers, motherfucker, fucking, milf, cocksucker, porno, videosex, sperm, hentai, internet gambling, kasino, kasinos, poker, lottery, texas hold em, texas holdem, fisting\",\"email_processing\":\"\",\"page_title\":\"\",\"show_page_title\":\"1\",\"pageclass_sfx\":\"\",\"menu_image\":\"0\",\"secure\":\"0\"}',205,206,0,'*',0);
INSERT INTO `#__menu` VALUES (85,'default','Events','events','','events','index.php?option=com_events&view=browse&layout=month','component',1,1,1,1006,8,0,'0000-00-00 00:00:00',0,1,'',0,'{\"page_title\":\"\",\"show_page_title\":\"1\",\"pageclass_sfx\":\"\",\"menu_image\":\"0\",\"secure\":\"0\"}',187,188,0,'*',0);
INSERT INTO `#__menu` VALUES (86,'default','Wiki','wiki','','wiki','index.php?option=com_wiki&view=page&layout=display','component',1,1,1,1032,21,0,'0000-00-00 00:00:00',0,1,'',0,'{\"page_title\":\"\",\"show_page_title\":\"1\",\"pageclass_sfx\":\"\",\"menu_image\":\"0\",\"secure\":\"0\"}',213,214,0,'*',0);
INSERT INTO `#__menu` VALUES (87,'default','Tool Forge','tools','','tools','index.php?option=com_tools&view=tools&layout=display','component',1,1,1,1028,19,0,'0000-00-00 00:00:00',0,1,'',0,'{\"mw_on\":\"\",\"shareable\":\"\",\"warn_multiples\":\"\",\"show_storage\":\"\",\"contribtool_on\":\"\",\"usedoi\":\"\",\"exec_pu\":\"\",\"screenshot_edit\":\"\",\"page_title\":\"\",\"show_page_title\":\"1\",\"pageclass_sfx\":\"\",\"menu_image\":\"0\",\"secure\":\"0\"}',209,210,0,'*',0);
INSERT INTO `#__menu` VALUES (88,'default','Resources','resources','','resources','index.php?option=com_resources&view=intro','component',1,1,1,1022,15,0,'0000-00-00 00:00:00',0,1,'',0,'{\"autoapprove\":\"\",\"autoapproved_users\":\"\",\"cc_license\":\"\",\"cc_license_custom\":\"\",\"email_when_approved\":\"\",\"browsetags\":\"\",\"show_authors\":\"\",\"show_assocs\":\"\",\"show_ranking\":\"\",\"show_rating\":\"\",\"show_date\":\"\",\"show_metadata\":\"\",\"show_citation\":\"\",\"show_audience\":\"\",\"page_title\":\"\",\"show_page_title\":\"1\",\"pageclass_sfx\":\"\",\"menu_image\":\"0\",\"secure\":\"0\"}',201,202,0,'*',0);
INSERT INTO `#__menu` VALUES (89,'default','Tags','tags','','tags','index.php?option=com_tags&view=tags&layout=display','component',1,1,1,1027,18,0,'0000-00-00 00:00:00',0,1,'',0,'{\"page_title\":\"\",\"show_page_title\":\"1\",\"pageclass_sfx\":\"\",\"menu_image\":\"0\",\"secure\":\"0\"}',207,208,0,'*',0);
INSERT INTO `#__menu` VALUES (90,'default','Store','store','','store','index.php?option=com_store&view=shop&layout=display','component',1,1,1,1024,16,0,'0000-00-00 00:00:00',0,1,'',0,'{\"store_enabled\":\"\",\"page_title\":\"\",\"show_page_title\":\"1\",\"pageclass_sfx\":\"\",\"menu_image\":\"0\",\"secure\":\"0\"}',203,204,0,'*',0);
INSERT INTO `#__menu` VALUES (92,'default','Wishlist','wishlist','','wishlist','index.php?option=com_wishlist&view=wishlist','component',1,1,1,1033,22,0,'0000-00-00 00:00:00',0,1,'',0,'{\"banking\":\"\",\"allow_advisory\":\"\",\"votesplit\":\"\",\"show_percentage_granted\":\"\",\"page_title\":\"\",\"show_page_title\":\"1\",\"pageclass_sfx\":\"\",\"menu_image\":\"0\",\"secure\":\"0\"}',215,216,0,'*',0);
INSERT INTO `#__menu` VALUES (93,'default','Feedback','feedback','','feedback','index.php?option=com_feedback&view=feedback&layout=display','component',1,1,1,1008,9,0,'0000-00-00 00:00:00',0,1,'',0,'{\"blacklist\":\"\",\"badwords\":\"viagra, pharmacy, xanax, phentermine, dating, ringtones, tramadol, hydrocodone, levitra, ambien, vicodin, fioricet, diazepam, cash advance, free online, online gambling, online prescriptions, debt consolidation, baccarat, loan, slots, credit, mortgage, casino, slot, texas holdem, teen nude, orgasm, gay, fuck, crap, shit, asshole, cunt, fucker, fuckers, motherfucker, fucking, milf, cocksucker, porno, videosex, sperm, hentai, internet gambling, kasino, kasinos, poker, lottery, texas hold em, texas holdem, fisting\",\"page_title\":\"\",\"show_page_title\":\"1\",\"pageclass_sfx\":\"\",\"menu_image\":\"0\",\"secure\":\"0\"}',189,190,0,'*',0);
INSERT INTO `#__menu` VALUES (94,'default','What\'s New','whatsnew','','whatsnew','index.php?option=com_whatsnew&view=results&layout=display','component',1,1,1,1031,20,0,'0000-00-00 00:00:00',0,1,'',0,'{\"period\":\"\",\"page_title\":\"\",\"show_page_title\":\"1\",\"pageclass_sfx\":\"\",\"menu_image\":\"0\",\"secure\":\"0\"}',211,212,0,'*',0);
INSERT INTO `#__menu` VALUES (95,'default','Congratulations','congratulations','','congratulations','index.php?option=com_content&view=article&id=32','component',1,1,1,22,3,0,'0000-00-00 00:00:00',0,1,'',0,'{\"show_noauth\":\"\",\"show_title\":\"0\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_section\":\"\",\"link_section\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_item_navigation\":\"\",\"show_readmore\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"feed_summary\":\"\",\"page_title\":\"\",\"show_page_title\":\"1\",\"pageclass_sfx\":\"\",\"menu_image\":\"0\",\"secure\":\"0\"}',137,138,0,'*',0);
INSERT INTO `#__menu` VALUES (96,'legal','Creative Commons','cc','','legal/cc','index.php?option=com_content&view=article&id=13','component',1,69,2,22,3,0,'0000-00-00 00:00:00',0,1,'',0,'{\"show_noauth\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_section\":\"\",\"link_section\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_author\":\"0\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_item_navigation\":\"\",\"show_readmore\":\"\",\"show_vote\":\"0\",\"show_icons\":\"\",\"show_print_icon\":\"0\",\"show_email_icon\":\"0\",\"show_hits\":\"\",\"feed_summary\":\"\",\"page_title\":\"\",\"show_page_title\":\"1\",\"pageclass_sfx\":\"\",\"menu_image\":\"0\",\"secure\":\"0\"}',94,95,0,'*',0);
INSERT INTO `#__menu` VALUES (97,'about','Quotes','quotes','','aboutus/quotes','index.php?option=com_content&view=article&id=5','component',1,9,2,22,5,0,'0000-00-00 00:00:00',0,1,'',0,'{\"show_noauth\":\"\",\"show_title\":\"1\",\"link_titles\":\"\",\"show_intro\":\"1\",\"show_section\":\"0\",\"link_section\":\"0\",\"show_category\":\"0\",\"link_category\":\"0\",\"show_author\":\"0\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_item_navigation\":\"\",\"show_readmore\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"0\",\"show_email_icon\":\"0\",\"show_hits\":\"\",\"feed_summary\":\"\",\"page_title\":\"\",\"show_page_title\":\"1\",\"pageclass_sfx\":\"\",\"menu_image\":\"0\",\"secure\":\"0\"}',84,85,0,'*',0);
INSERT INTO `#__menu` VALUES (98,'mainmenu','Projects','projects','','community/projects','index.php?Itemid=','alias',1,76,2,0,3,0,'0000-00-00 00:00:00',0,1,'',0,'{\"aliasoptions\":\"99\"}',146,147,0,'*',0);
INSERT INTO `#__menu` VALUES (99,'default','Projects','projects','','projects','index.php?option=com_projects&view=browse','component',1,1,1,1019,22,0,'0000-00-00 00:00:00',0,1,'',0,'{\"grantinfo\":\"\",\"confirm_step\":\"\",\"edit_settings\":\"\",\"restricted_data\":\"\",\"restricted_upfront\":\"\",\"approve_restricted\":\"\",\"offroot\":\"\",\"messaging\":\"\",\"privacy\":\"\",\"use_alias\":\"\",\"page_title\":\"\",\"show_page_title\":\"1\",\"pageclass_sfx\":\"\",\"menu_image\":\"0\",\"secure\":\"0\"}',217,218,0,'*',0);
INSERT INTO `#__menu` VALUES (100,'default','Home','home','','home','index.php?option=com_content&view=article&id=1','component',1,1,1,22,2,0,'0000-00-00 00:00:00',0,1,'',0,'{\"show_noauth\":\"\",\"show_title\":\"0\",\"link_titles\":\"\",\"show_intro\":\"1\",\"show_section\":\"0\",\"link_section\":\"0\",\"show_category\":\"0\",\"link_category\":\"0\",\"show_author\":\"0\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_item_navigation\":\"\",\"show_readmore\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"0\",\"show_email_icon\":\"0\",\"show_hits\":\"\",\"feed_summary\":\"\",\"page_title\":\"\",\"show_page_title\":\"1\",\"pageclass_sfx\":\"\",\"menu_image\":\"0\",\"secure\":\"0\"}',103,104,1,'*',0);
INSERT INTO `#__menu` VALUES (101,'main','com_answers','answers','','answers','index.php?option=com_answers','component',1,1,1,1000,0,0,'0000-00-00 00:00:00',0,0,'',0,'',7,8,0,'*',1);
INSERT INTO `#__menu` VALUES (102,'main','com_billboards','billboards','','billboards','index.php?option=com_billboards','component',1,1,1,1001,0,0,'0000-00-00 00:00:00',0,0,'',0,'',31,32,0,'*',1);
INSERT INTO `#__menu` VALUES (103,'main','com_blog','blog','','blog','index.php?option=com_blog','component',1,1,1,1002,0,0,'0000-00-00 00:00:00',0,0,'',0,'',29,30,0,'*',1);
INSERT INTO `#__menu` VALUES (104,'main','com_citations','citations','','citations','index.php?option=com_citations','component',1,1,1,1003,0,0,'0000-00-00 00:00:00',0,0,'',0,'',27,28,0,'*',1);
INSERT INTO `#__menu` VALUES (105,'main','com_cron','cron','','cron','index.php?option=com_cron','component',1,1,1,1005,0,0,'0000-00-00 00:00:00',0,0,'',0,'',25,26,0,'*',1);
INSERT INTO `#__menu` VALUES (106,'main','com_events','events','','events','index.php?option=com_events','component',1,1,1,1006,0,0,'0000-00-00 00:00:00',0,0,'',0,'',21,22,0,'*',1);
INSERT INTO `#__menu` VALUES (107,'main','com_feedback','feedback','','feedback','index.php?option=com_feedback','component',1,1,1,1008,0,0,'0000-00-00 00:00:00',0,0,'',0,'',23,24,0,'*',1);
INSERT INTO `#__menu` VALUES (108,'main','com_groups','groups','','groups','index.php?option=com_groups','component',1,1,1,1010,0,0,'0000-00-00 00:00:00',0,0,'',0,'',19,20,0,'*',1);
INSERT INTO `#__menu` VALUES (109,'main','com_jobs','jobs','','jobs','index.php?option=com_jobs','component',1,1,1,1012,0,0,'0000-00-00 00:00:00',0,0,'',0,'',17,18,0,'*',1);
INSERT INTO `#__menu` VALUES (110,'main','com_kb','kb','','kb','index.php?option=com_kb','component',1,1,1,1013,0,0,'0000-00-00 00:00:00',0,0,'',0,'',15,16,0,'*',1);
INSERT INTO `#__menu` VALUES (111,'main','com_members','members','','members','index.php?option=com_members','component',1,1,1,1014,0,0,'0000-00-00 00:00:00',0,0,'',0,'',13,14,0,'*',1);
INSERT INTO `#__menu` VALUES (112,'main','com_newsletter','newsletter','','newsletter','index.php?option=com_newsletter','component',1,1,1,1015,0,0,'0000-00-00 00:00:00',0,0,'',0,'',11,12,0,'*',1);
INSERT INTO `#__menu` VALUES (113,'main','com_poll','poll','','poll','index.php?option=com_poll','component',1,1,1,1017,0,0,'0000-00-00 00:00:00',0,0,'',0,'',9,10,0,'*',1);
INSERT INTO `#__menu` VALUES (114,'main','com_projects','projects','','projects','index.php?option=com_projects','component',1,1,1,1019,0,0,'0000-00-00 00:00:00',0,0,'',0,'',33,34,0,'*',1);
INSERT INTO `#__menu` VALUES (116,'main','com_resources','resources','','resources','index.php?option=com_resources','component',1,1,1,1022,0,0,'0000-00-00 00:00:00',0,0,'',0,'',67,68,0,'*',1);
INSERT INTO `#__menu` VALUES (117,'main','com_services','services','','services','index.php?option=com_services','component',1,1,1,1023,0,0,'0000-00-00 00:00:00',0,0,'',0,'',65,66,0,'*',1);
INSERT INTO `#__menu` VALUES (118,'main','com_store','store','','store','index.php?option=com_store','component',1,1,1,1024,0,0,'0000-00-00 00:00:00',0,0,'',0,'',63,64,0,'*',1);
INSERT INTO `#__menu` VALUES (119,'main','com_support','support','','support','index.php?option=com_support','component',1,1,1,1025,0,0,'0000-00-00 00:00:00',0,0,'',0,'',61,62,0,'*',1);
INSERT INTO `#__menu` VALUES (120,'main','com_system','system','','system','index.php?option=com_system','component',1,1,1,1026,0,0,'0000-00-00 00:00:00',0,0,'',0,'',55,56,0,'*',1);
INSERT INTO `#__menu` VALUES (121,'main','com_tags','tags','','tags','index.php?option=com_tags','component',1,1,1,1027,0,0,'0000-00-00 00:00:00',0,0,'',0,'',59,60,0,'*',1);
INSERT INTO `#__menu` VALUES (122,'main','com_tools','tools','','tools','index.php?option=com_tools','component',1,1,1,1028,0,0,'0000-00-00 00:00:00',0,0,'',0,'',57,58,0,'*',1);
INSERT INTO `#__menu` VALUES (123,'main','com_usage','usage','','usage','index.php?option=com_usage','component',1,1,1,1030,0,0,'0000-00-00 00:00:00',0,0,'',0,'',53,54,0,'*',1);
INSERT INTO `#__menu` VALUES (124,'main','com_wiki','wiki','','wiki','index.php?option=com_wiki','component',1,1,1,1032,0,0,'0000-00-00 00:00:00',0,0,'',0,'',51,52,0,'*',1);
INSERT INTO `#__menu` VALUES (125,'main','com_wishlist','wishlist','','wishlist','index.php?option=com_wishlist','component',1,1,1,1033,0,0,'0000-00-00 00:00:00',0,0,'',0,'',49,50,0,'*',1);
INSERT INTO `#__menu` VALUES (126,'main','com_search','search','','search','index.php?option=com_search&task=configure','component',1,1,1,1034,0,0,'0000-00-00 00:00:00',0,0,'',0,'',37,38,0,'*',1);
INSERT INTO `#__menu` VALUES (127,'main','com_forum','forum','','forum','index.php?option=com_forum','component',1,1,1,1009,0,0,'0000-00-00 00:00:00',0,0,'',0,'',43,44,0,'*',1);
INSERT INTO `#__menu` VALUES (128,'main','com_cart','cart','','cart','index.php?option=com_cart','component',1,1,1,1035,0,0,'0000-00-00 00:00:00',0,0,'',0,'',41,42,0,'*',1);
INSERT INTO `#__menu` VALUES (129,'main','com_courses','courses','','courses','index.php?option=com_courses','component',1,1,1,1004,0,0,'0000-00-00 00:00:00',0,0,'',0,'',39,40,0,'*',1);
INSERT INTO `#__menu` VALUES (130,'main','com_dataviewer','dataviewer','','dataviewer','index.php?option=com_dataviewer','component',1,1,1,1018,0,0,'0000-00-00 00:00:00',0,0,'',0,'',35,36,0,'*',1);
INSERT INTO `#__menu` VALUES (131,'main','com_oaipmh','oaipmh','','oaipmh','index.php?option=com_oaipmh','component',1,1,1,1016,0,0,'0000-00-00 00:00:00',0,0,'',0,'',47,48,0,'*',1);
INSERT INTO `#__menu` VALUES (132,'main','com_publications','publications','','publications','index.php?option=com_publications','component',1,1,1,1020,0,0,'0000-00-00 00:00:00',0,0,'',0,'',45,46,0,'*',1);
INSERT INTO `#__menu` VALUES (134,'main','com_collections','collections','','collections','index.php?option=com_collections','component',1,1,1,1037,0,0,'0000-00-00 00:00:00',0,0,'',0,'',5,6,0,'*',1);
INSERT INTO `#__menu` VALUES (135,'main','com_storefront','storefront','','storefront','index.php?option=com_storefront','component',1,1,1,1036,0,0,'0000-00-00 00:00:00',0,0,'',0,'',3,4,0,'*',1);
INSERT INTO `#__menu` VALUES (137,'main','com_time','time','','time','index.php?option=com_time','component',0,1,1,1040,0,0,'0000-00-00 00:00:00',0,0,'',0,'',1,2,0,'*',1);
INSERT INTO `#__menu` VALUES (139,'default','Register','register','','register','index.php?option=com_members&view=register&layout=create','component',1,1,1,1014,23,0,'0000-00-00 00:00:00',0,1,'',0,'',219,220,0,'*',0);
INSERT INTO `#__menu` VALUES (140,'mainmenu','Courses','courses','','discover/courses','index.php?Itemid=','alias',1,41,2,1004,0,0,'0000-00-00 00:00:00',0,1,'',0,'{\"aliasoptions\":\"143\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1}',106,107,0,'*',0);
INSERT INTO `#__menu` VALUES (145,'mainmenu','Forum','forum','','community/forum','index.php?Itemid=','alias',1,76,2,0,0,0,'0000-00-00 00:00:00',0,1,'',0,'{\"aliasoptions\":\"80\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1}',140,141,0,'*',0);
INSERT INTO `#__menu` VALUES (141,'mainmenu','Collections','collections','','discover/collections','index.php?Itemid=','alias',1,41,2,1037,0,0,'0000-00-00 00:00:00',0,1,'',0,'{\"aliasoptions\":\"142\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1}',108,109,0,'*',0);
INSERT INTO `#__menu` VALUES (144,'mainmenu','Blog','blog','','discover/blog','index.php?Itemid=','alias',1,41,2,0,0,0,'0000-00-00 00:00:00',0,1,'',0,'{\"aliasoptions\":\"78\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1}',110,111,0,'*',0);
INSERT INTO `#__menu` VALUES (142,'default','Collections','collections','','collections','index.php?option=com_collections&view=collections&layout=collections','component',1,1,1,1037,0,0,'0000-00-00 00:00:00',0,1,'',0,'{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}',69,70,0,'*',0);
INSERT INTO `#__menu` VALUES (143,'default','Courses','courses','','courses','index.php?option=com_courses&view=courses&layout=intro','component',1,1,1,1004,0,0,'0000-00-00 00:00:00',0,1,'',0,'{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}',71,72,0,'*',0);
INSERT INTO `#__menu` VALUES (146,'default','Newsletter','newsletter','','newsletter','index.php?option=com_newsletter&view=newsletter&layout=view','component',1,1,1,1015,0,0,'0000-00-00 00:00:00',0,1,'',0,'{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}',73,74,0,'*',0);
INSERT INTO `#__menu` VALUES (147,'mainmenu','Newsletter','newsletter','','about/newsletter','index.php?Itemid=','alias',1,7,2,0,0,0,'0000-00-00 00:00:00',0,1,'',0,'{\"aliasoptions\":\"146\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1}',158,159,0,'*',0);
INSERT INTO `#__menu` VALUES (148,'mainmenu','&nbsp;','nbsp','','about/nbsp','','separator',1,7,2,0,0,0,'0000-00-00 00:00:00',0,1,'',0,'{\"menu_image\":\"\",\"menu_text\":1}',160,161,0,'*',0);

--
-- HUBzero sample data for table `#__menu_types`
--

INSERT INTO `#__menu_types` (`id`, `menutype`, `title`, `description`) VALUES (2,'about','About','About Side Menu');
INSERT INTO `#__menu_types` (`id`, `menutype`, `title`, `description`) VALUES (3,'default','Default','default');
INSERT INTO `#__menu_types` (`id`, `menutype`, `title`, `description`) VALUES (4,'legal','Legal','Menu for policies and legal items');

--
-- HUBzero sample data for table `#__migrations`
--

INSERT INTO `#__migrations` (`id`, `file`, `scope`, `hash`, `direction`, `date`, `action_by`)
VALUES
	(1, 'Migration20120101000000Core.php', 'migrations', '9d859ff24ee0f494d85ab78bdf40b1ff', 'up', '2014-09-03 19:13:35', 'root'),
	(2, 'Migration20120101000001Core.php', 'migrations', '4a9f8891218f27622d7065bec5aa7744', 'up', '2014-09-03 19:13:40', 'root'),
	(3, 'Migration20120101000002Core.php', 'migrations', 'c9ce6fbcb031136b3d632be5cdeaafd5', 'up', '2014-09-03 19:13:44', 'root'),
	(4, 'Migration20120101000003Core.php', 'migrations', '375d1bc02488c3ff9c0a458eb12922f8', 'up', '2014-09-03 19:13:47', 'root'),
	(5, 'Migration20120101000004Core.php', 'migrations', 'd0391e65c90255014dd3e57d6f3b53bd', 'up', '2014-09-03 19:13:53', 'root'),
	(6, 'Migration20120101000005Core.php', 'migrations', 'da0691900747a6bdbb2053e6aa326761', 'up', '2014-09-03 19:13:57', 'root'),
	(7, 'Migration20120101000006Core.php', 'migrations', 'a6ca583dab9cc196455b87b9b6b192ec', 'up', '2014-09-03 19:14:01', 'root'),
	(8, 'Migration20121009000000ComWiki.php', 'migrations', '4d38777de32a2742e9bc19a8c16f451f', 'up', '2014-09-03 19:14:12', 'root'),
	(9, 'Migration20121015000000ComTools.php', 'migrations', '105873a4abea1cfabce923a974954050', 'up', '2014-09-03 19:14:12', 'root'),
	(10, 'Migration20121016000000ComCourses.php', 'migrations', '68f8ffa8b5cfdff8f69dc082ade1bba1', 'up', '2014-09-03 19:14:12', 'root'),
	(11, 'Migration20121018000000ComWiki.php', 'migrations', '7a2334999fbd25108a01cdfd00e02962', 'up', '2014-09-03 19:14:12', 'root'),
	(12, 'Migration20121027000000ComCitations.php', 'migrations', 'fa28bbbb0848676966596e9dc33ca2d0', 'up', '2014-09-03 19:14:12', 'root'),
	(13, 'Migration20121130000000ComForum.php', 'migrations', 'a927d10f1b7013d144d50921dc191336', 'up', '2014-09-03 19:14:12', 'root'),
	(14, 'Migration20121217000000ComForum.php', 'migrations', 'becd8037cb2da9b3268e23d54c4b6328', 'up', '2014-09-03 19:14:12', 'root'),
	(15, 'Migration20130101000000ComCourses.php', 'migrations', '1e18fc06847c699ea2f169028ed9c439', 'up', '2014-09-03 19:14:12', 'root'),
	(16, 'Migration20130114000000Core.php', 'migrations', '085352375f2ff65e8c512788462cb35b', 'up', '2014-09-03 19:14:12', 'root'),
	(17, 'Migration20130201000000PlgUserConstantcontact.php', 'migrations', '8eaac8ff756f52e4cb8ae1b633b4e559', 'up', '2014-09-03 19:14:12', 'root'),
	(18, 'Migration20130208000000ComGroups.php', 'migrations', '00f7c4aea09f1ff9e86e271ed66309aa', 'up', '2014-09-03 19:14:12', 'root'),
	(19, 'Migration20130214000000Core.php', 'migrations', 'debe105763913a76dd82b81ff941c8de', 'up', '2014-09-03 19:14:12', 'root'),
	(20, 'Migration20130220000000ComResources.php', 'migrations', '72b11c90bdf8bacff9021a6509b9875f', 'up', '2014-09-03 19:14:12', 'root'),
	(21, 'Migration20130311000000PlgHubzeroComments.php', 'migrations', 'c538f5e482c73e4ffe9b14ca75efa531', 'up', '2014-09-03 19:14:12', 'root'),
	(22, 'Migration20130320000000ComCourses.php', 'migrations', 'b844452d09baf5d4b680432d795f4fca', 'up', '2014-09-03 19:14:12', 'root'),
	(23, 'Migration20130322000000ComCourses.php', 'migrations', '311e009451898df6de6ea90b232bf4fd', 'up', '2014-09-03 19:14:12', 'root'),
	(24, 'Migration20130329000000ComCourses.php', 'migrations', '430df927a67ebda2f485ad9340b1634c', 'up', '2014-09-03 19:14:12', 'root'),
	(25, 'Migration20130331000000ComCourses.php', 'migrations', '13d010e8c42f2855cf05eee3854285d5', 'up', '2014-09-03 19:14:12', 'root'),
	(26, 'Migration20130401000000ComCourses.php', 'migrations', '3c8891353dcbf5ef7a3d33a6ae09017e', 'up', '2014-09-03 19:14:12', 'root'),
	(27, 'Migration20130401000000ComGroups.php', 'migrations', '3dc7cfb1a413fe3bc3fcfddd27ac3ab6', 'up', '2014-09-03 19:14:12', 'root'),
	(28, 'Migration20130403000000ComCourses.php', 'migrations', '3977afdb4209d767be0653ec3a6391d4', 'up', '2014-09-03 19:14:12', 'root'),
	(29, 'Migration20130403000000Core.php', 'migrations', '3d6af0961683f4e77e25f6916ae8c87c', 'up', '2014-09-03 19:14:12', 'root'),
	(30, 'Migration20130404000000ComCitations.php', 'migrations', '96133f48b193a1d76f7a7be31d0dbf5f', 'up', '2014-09-03 19:14:12', 'root'),
	(31, 'Migration20130404000000ComCourses.php', 'migrations', 'b0c569d47023a47001bc5c6ebc45d543', 'up', '2014-09-03 19:14:12', 'root'),
	(32, 'Migration20130410000000ComCourses.php', 'migrations', 'e4ffc5c7220a48bae192446457ae3a72', 'up', '2014-09-03 19:14:12', 'root'),
	(33, 'Migration20130410000000Core.php', 'migrations', '88ceaf7e64db4e4de17707715371140e', 'up', '2014-09-03 19:14:12', 'root'),
	(34, 'Migration20130411000000ComCourses.php', 'migrations', 'f83e4903c93d12c69664d880e5673953', 'up', '2014-09-03 19:14:12', 'root'),
	(35, 'Migration20130412000000ComCourses.php', 'migrations', '196274412289c68de1e160dd9b49e84b', 'up', '2014-09-03 19:14:12', 'root'),
	(36, 'Migration20130413000000ComCourses.php', 'migrations', 'c51e0833db0c5286789b85c793ed4d0a', 'up', '2014-09-03 19:14:12', 'root'),
	(37, 'Migration20130415000000ComSupport.php', 'migrations', '3de99f5f127c19841f04b8d6a1ffd8fd', 'up', '2014-09-03 19:14:12', 'root'),
	(38, 'Migration20130416193151PlgCoursesOutline.php', 'migrations', 'ec5a92145d120ddc3c5750bae38ea5d3', 'up', '2014-09-03 19:14:12', 'root'),
	(39, 'Migration20130423001442ComCourses.php', 'migrations', '9bbcbf50e45f16c1f9f4b1c5443d75db', 'up', '2014-09-03 19:14:12', 'root'),
	(40, 'Migration20130423115530ComTags.php', 'migrations', '1a7b5976b56e44a9f06273c59e93b36b', 'up', '2014-09-03 19:14:12', 'root'),
	(41, 'Migration20130423115913ComWiki.php', 'migrations', '3e5ac2de3a5dc73f15ed5c980fe7bb58', 'up', '2014-09-03 19:14:12', 'root'),
	(42, 'Migration20130423204702PlgCoursesPages.php', 'migrations', '04c82ce82a6707e4a5205ccfb5187799', 'up', '2014-09-03 19:14:12', 'root'),
	(43, 'Migration20130423204715ComCourses.php', 'migrations', '034244a90c4ce86424906f5b69772042', 'up', '2014-09-03 19:14:12', 'root'),
	(44, 'Migration20130423213901ComCourses.php', 'migrations', '2226978242ebb07d139c76e2feb5c289', 'up', '2014-09-03 19:14:12', 'root'),
	(45, 'Migration20130426062338ComCourses.php', 'migrations', '928bcc6458c490c44546eb6b5a94d9a8', 'up', '2014-09-03 19:14:12', 'root'),
	(46, 'Migration20130426070126ComTags.php', 'migrations', '10b87268e6cc90e98745b36983114063', 'up', '2014-09-03 19:14:12', 'root'),
	(47, 'Migration20130426071400Core.php', 'migrations', '5a0f9b902c9cc4c43b4850b4f469d298', 'up', '2014-09-03 19:14:12', 'root'),
	(48, 'Migration20130426071658ComHelp.php', 'migrations', 'd0748f74b9158958ca367ac829cfd497', 'up', '2014-09-03 19:14:13', 'root'),
	(49, 'Migration20130426072033ComCron.php', 'migrations', 'b0278bb91b8f904aa1fa4b680e71b6a7', 'up', '2014-09-03 19:14:13', 'root'),
	(50, 'Migration20130426074801ComSupport.php', 'migrations', 'c608ffbf6d386b85e7175fbfbc62e511', 'up', '2014-09-03 19:14:13', 'root'),
	(51, 'Migration20130429103200PlgGroupsCalendar.php', 'migrations', 'c209ffdaf1cd1892946e9ff38753a574', 'up', '2014-09-03 19:14:13', 'root'),
	(52, 'Migration20130430112401ComCourses.php', 'migrations', '3f1a4136748fe7da64e2e76ad45e1182', 'up', '2014-09-03 19:14:13', 'root'),
	(53, 'Migration20130501120700PlgCronGroups.php', 'migrations', 'f854a44560ef02a1407a70d7c6747e6c', 'up', '2014-09-03 19:14:13', 'root'),
	(54, 'Migration20130506233657ComCourses.php', 'migrations', '81c68decb346f25c4cfa80eadda003b7', 'up', '2014-09-03 19:14:13', 'root'),
	(55, 'Migration20130507030333ComCourses.php', 'migrations', 'ed2f713b568e61b156fbfb18f86b704f', 'up', '2014-09-03 19:14:13', 'root'),
	(56, 'Migration20130507085501ComForum.php', 'migrations', '392b473abb12b4cc83eb59d45d5aeb73', 'up', '2014-09-03 19:14:13', 'root'),
	(57, 'Migration20130507170000PlgMembersProfile.php', 'migrations', 'f9b670bd56e5eb430192576a556005f0', 'up', '2014-09-03 19:14:13', 'root'),
	(58, 'Migration20130512175201ComForum.php', 'migrations', '98b081a12ca344ec4756d33e5c1604e5', 'up', '2014-09-03 19:14:13', 'root'),
	(59, 'Migration20130512175301PlgCoursesDiscussions.php', 'migrations', 'de5ec225357cbf7b82a2575a885c3a23', 'up', '2014-09-03 19:14:13', 'root'),
	(60, 'Migration20130516175532ComFeedback.php', 'migrations', '6587433b05cfb7dd75baa0c68ac0b688', 'up', '2014-09-03 19:14:13', 'root'),
	(61, 'Migration20130517101308ComContent.php', 'migrations', '7dfb2ccdd73de0254fa1c9f6640ff114', 'up', '2014-09-03 19:14:13', 'root'),
	(62, 'Migration20130521160001ComForum.php', 'migrations', '59bdfb0f7773760ea4ffcd065d823a05', 'up', '2014-09-03 19:14:13', 'root'),
	(63, 'Migration20130524101101PlgCoursesDiscussions.php', 'migrations', 'c7c62aa350a8a598baf3de31a05b075f', 'up', '2014-09-03 19:14:13', 'root'),
	(64, 'Migration20130529204838PlgAuthenticationTwitter.php', 'migrations', '21999cd694c4a2c6f221d36f15dc8b39', 'up', '2014-09-03 19:14:13', 'root'),
	(65, 'Migration20130530153638ComCron.php', 'migrations', 'e33fab341344db643e9ba56f93462750', 'up', '2014-09-03 19:14:13', 'root'),
	(66, 'Migration20130531081238PlgCoursesNotes.php', 'migrations', '95f6a849fef71b7951b1eec3c04a0094', 'up', '2014-09-03 19:14:13', 'root'),
	(67, 'Migration20130610123201PlgCoursesDiscussions.php', 'migrations', '623789040dccfd065003c705e199af02', 'up', '2014-09-03 19:14:13', 'root'),
	(68, 'Migration20130617121701ComCourses.php', 'migrations', 'c87da2902fcd4c42c817531b99fff395', 'up', '2014-09-03 19:14:13', 'root'),
	(69, 'Migration20130617171001ComForum.php', 'migrations', 'fae3f4c2e79c5dd61aa13d47ba88747a', 'up', '2014-09-03 19:14:13', 'root'),
	(70, 'Migration20130618144751PlgMembersProfile.php', 'migrations', '39f85d30d6c25ffee6fd8bed8039ae17', 'up', '2014-09-03 19:14:13', 'root'),
	(71, 'Migration20130619181459PlgGroupsAnnouncements.php', 'migrations', 'fba56331387376d9ae5f28166b77b2c8', 'up', '2014-09-03 19:14:13', 'root'),
	(72, 'Migration20130621115001ComSupport.php', 'migrations', '4d086dcd0b1b0696434cd14080054b3d', 'up', '2014-09-03 19:14:13', 'root'),
	(73, 'Migration20130621155138PlgCoursesNotes.php', 'migrations', '40694fd727e927f4f39312f901176275', 'up', '2014-09-03 19:14:13', 'root'),
	(74, 'Migration20130624184902PlgGroupsCalendar.php', 'migrations', '9b45454f204767fc0c6f3a079a8c9f88', 'up', '2014-09-03 19:14:13', 'root'),
	(75, 'Migration20130702181838ComWiki.php', 'migrations', '190377c4e8def55044573f24c5007847', 'up', '2014-09-03 19:14:13', 'root'),
	(76, 'Migration20130703075132ComCourses.php', 'migrations', 'cef0950db16b6dd8bf637341054aa609', 'up', '2014-09-03 19:14:13', 'root'),
	(77, 'Migration20130708082138ComWiki.php', 'migrations', 'e6f637f86a84a63c8ac57e7818dfa474', 'up', '2014-09-03 19:14:13', 'root'),
	(78, 'Migration20130715111246ModIncrementalRegistration.php', 'migrations', '47cbaefce5c432e11280cf2ba3b0a477', 'up', '2014-09-03 19:14:13', 'root'),
	(79, 'Migration20130716202127ComNewsletter.php', 'migrations', '7f0427a8f44024763e02981d081a2ae9', 'up', '2014-09-03 19:14:13', 'root'),
	(80, 'Migration20130717140704PlgCronNewsletter.php', 'migrations', '4227bf712d4d339e8d0cd53c2cf14106', 'up', '2014-09-03 19:14:13', 'root'),
	(81, 'Migration20130723163332ComCourses.php', 'migrations', '0d451a44f9da2ff6fcabbe2b88e3ace8', 'up', '2014-09-03 19:14:13', 'root'),
	(82, 'Migration20130723171332ComCourses.php', 'migrations', 'ee1c86ef882d6ef30de8953103b1bd80', 'up', '2014-09-03 19:14:13', 'root'),
	(83, 'Migration20130725184342ComCourses.php', 'migrations', 'ff2e8775db31c3e8ca356cada9cb2e89', 'up', '2014-09-03 19:14:13', 'root'),
	(84, 'Migration20130729084642ComForum.php', 'migrations', '61bfc81cfff30e5e29661a7c295b4007', 'up', '2014-09-03 19:14:13', 'root'),
	(85, 'Migration20130729130302PlgYsearchCourses.php', 'migrations', '1ca275a7edfb14bdff6826fbd445c945', 'up', '2014-09-03 19:14:13', 'root'),
	(86, 'Migration20130731170234ComCourses.php', 'migrations', '07f14cd52ed816a4d5de7396f2dcf383', 'up', '2014-09-03 19:14:13', 'root'),
	(87, 'Migration20130731203037ComResources.php', 'migrations', 'a7f10ca0a71c48e636d145e07e7b3d81', 'up', '2014-09-03 19:14:13', 'root'),
	(88, 'Migration20130801182039ComPdf2form.php', 'migrations', '0f20a38b11b5457f3a413030b1809628', 'up', '2014-09-03 19:14:13', 'root'),
	(89, 'Migration20130809151809ComTags.php', 'migrations', 'e5d0cec98d604a84ceca1e25f95a70e9', 'up', '2014-09-03 19:14:13', 'root'),
	(90, 'Migration20130809152737ComCourses.php', 'migrations', '10694cc0fd3b15b30254d4f201ab9ade', 'up', '2014-09-03 19:14:13', 'root'),
	(91, 'Migration20130812132139ComCollections.php', 'migrations', '75a8ed41da8ba67499599deee4801a51', 'up', '2014-09-03 19:14:13', 'root'),
	(92, 'Migration20130812182339ComCart.php', 'migrations', '3041c23955421f5e98b4841d3e06d9f5', 'up', '2014-09-03 19:14:13', 'root'),
	(93, 'Migration20130812201731ComStorefront.php', 'migrations', 'bad1e44540cd3757634918929863ee14', 'up', '2014-09-03 19:14:13', 'root'),
	(94, 'Migration20130813195602ComOaipmh.php', 'migrations', '2e62f1439099d09d368536521a33d6da', 'up', '2014-09-03 19:14:13', 'root'),
	(95, 'Migration20130813210535PlgProjectsDatabases.php', 'migrations', 'abefb5b05e69e76d343d43883ff67be3', 'up', '2014-09-03 19:14:14', 'root'),
	(96, 'Migration20130814185755ComNewsletter.php', 'migrations', '36aaf46d71945972e9b8d1a2055abc68', 'up', '2014-09-03 19:14:14', 'root'),
	(97, 'Migration20130814201250ComCourses.php', 'migrations', '7f3a0d9b02dcd74c800d1c5246b14bf5', 'up', '2014-09-03 19:14:14', 'root'),
	(98, 'Migration20130815175354ComDataviewer.php', 'migrations', '2b2951fee852448fa9c4e92710efddfe', 'up', '2014-09-03 19:14:14', 'root'),
	(99, 'Migration20130816143341ComCitations.php', 'migrations', 'c11206a40ab8b0c7b8fdfe0610bbf12b', 'up', '2014-09-03 19:14:14', 'root'),
	(100, 'Migration20130819145850ComCourses.php', 'migrations', '7de4c2e68aaa2adbbc2613fa9156779e', 'up', '2014-09-03 19:14:14', 'root'),
	(101, 'Migration20130820135328ComNewsletter.php', 'migrations', 'ac55cd216a381a8a0f546d2009941475', 'up', '2014-09-03 19:14:14', 'root'),
	(102, 'Migration20130821164314ComStorefront.php', 'migrations', '0b87606e4b6733187cc07a0790b776f3', 'up', '2014-09-03 19:14:14', 'root'),
	(103, 'Migration20130821164628ComCart.php', 'migrations', 'fbefebeab9a70c799cbbc41968086a93', 'up', '2014-09-03 19:14:14', 'root'),
	(104, 'Migration20130826150814ComResources.php', 'migrations', '227a0e97a65419b657308309b1402a2c', 'up', '2014-09-03 19:14:14', 'root'),
	(105, 'Migration20130827143717Core.php', 'migrations', '7e25e6848c5ee7d60b23bafc2d73a790', 'up', '2014-09-03 19:14:14', 'root'),
	(106, 'Migration20130828201526ComPublications.php', 'migrations', 'c8036f7262dda05b07add524f2f4da47', 'up', '2014-09-03 19:14:14', 'root'),
	(107, 'Migration20130828203404Core.php', 'migrations', '4e42d7b290d963dbd40d6d0cbdaae5c4', 'up', '2014-09-03 19:14:14', 'root'),
	(108, 'Migration20130829203107ComProjects.php', 'migrations', '78dc7180fbad54c4842db1ab8dc7d663', 'up', '2014-09-03 19:14:14', 'root'),
	(109, 'Migration20130829211856ComPublications.php', 'migrations', 'befedf94d321d88e2673d88378533d2e', 'up', '2014-09-03 19:14:14', 'root'),
	(110, 'Migration20130830175756ComCourses.php', 'migrations', 'aa7ba7de0263dd6dc53ba9c428fb608d', 'up', '2014-09-03 19:14:14', 'root'),
	(111, 'Migration20130905195600ComCourses.php', 'migrations', '3a77a9ddf5a77f910339dcc9c8cd6f43', 'up', '2014-09-03 19:14:14', 'root'),
	(112, 'Migration20130911070500ComCourses.php', 'migrations', 'fa9471f7390ba8361ebdb5597ef72009', 'up', '2014-09-03 19:14:14', 'root'),
	(113, 'Migration20130916080500ComWiki.php', 'migrations', '01ef84e10af396e560e045a11f01f213', 'up', '2014-09-03 19:14:14', 'root'),
	(114, 'Migration20130918132946ComForum.php', 'migrations', '94fbb1e67fde497c956082a88ca1fb99', 'up', '2014-09-03 19:14:14', 'root'),
	(115, 'Migration20130924000000ComCategories.php', 'migrations', '9d826b54252d765f522935c1bb70d982', 'up', '2014-09-03 19:14:14', 'root'),
	(116, 'Migration20130924000001ComContent.php', 'migrations', 'acf0a04f1c5fc7b1feabb3104a4de62a', 'up', '2014-09-03 19:14:14', 'root'),
	(117, 'Migration20130924000002Core.php', 'migrations', '3f4527ffbdfeeef20c5da83ab70f9833', 'up', '2014-09-03 19:14:14', 'root'),
	(118, 'Migration20130924000003ComBanners.php', 'migrations', '06f8217b7f3cf88e5915b4425de0e7ca', 'up', '2014-09-03 19:14:14', 'root'),
	(119, 'Migration20130924000004ComContacts.php', 'migrations', 'e5b55b821abfaa52cad30d51bb7c33b5', 'up', '2014-09-03 19:14:15', 'root'),
	(120, 'Migration20130924000005Core.php', 'migrations', '649f28e7601c6613a342c816a547f4fe', 'up', '2014-09-03 19:14:15', 'root'),
	(121, 'Migration20130924000006ComFinder.php', 'migrations', '79e8c90e208dfaf60a43111b1630f72d', 'up', '2014-09-03 19:14:15', 'root'),
	(122, 'Migration20130924000007Core.php', 'migrations', '6a2c5938fcf46aad0c724f2b47e01b90', 'up', '2014-09-03 19:14:15', 'root'),
	(123, 'Migration20130924000008Core.php', 'migrations', 'c2cfb7c58f738f9771ca8c5cf0d0fdd5', 'up', '2014-09-03 19:14:15', 'root'),
	(124, 'Migration20130924000009ComMenus.php', 'migrations', '7d36ed6b99bd79101e806abfa9bbcdc0', 'up', '2014-09-03 19:14:15', 'root'),
	(125, 'Migration20130924000010ComMessages.php', 'migrations', '261bb825a6af71667d39f875050fb125', 'up', '2014-09-03 19:14:15', 'root'),
	(126, 'Migration20130924000011ComModules.php', 'migrations', '51725306e1edbf18471e7d840d8c78a0', 'up', '2014-09-03 19:14:15', 'root'),
	(127, 'Migration20130924000012ComNewsfeeds.php', 'migrations', '2c25893333e66f159340119260a11d28', 'up', '2014-09-03 19:14:15', 'root'),
	(128, 'Migration20130924000013Core.php', 'migrations', '7281393178fa6fe1b441f5887010e116', 'up', '2014-09-03 19:14:15', 'root'),
	(129, 'Migration20130924000014ComWeblinks.php', 'migrations', '04d08ca3153b73779b8b307d19689103', 'up', '2014-09-03 19:14:15', 'root'),
	(130, 'Migration20130926143200Core.php', 'migrations', '04771524e2f8b2806f462cf21a57b21f', 'up', '2014-09-03 19:14:15', 'root'),
	(131, 'Migration20130930160944ComBillboards.php', 'migrations', '3abeaa15fe60b65b244f12cef206b52c', 'up', '2014-09-03 19:14:15', 'root'),
	(132, 'Migration20131002133124ComCollections.php', 'migrations', '9493f286bac5a1bbd8d73c176e74c216', 'up', '2014-09-03 19:14:15', 'root'),
	(133, 'Migration20131011164749ComCourses.php', 'migrations', '2d57d06ca62c892eb9b509e5c861127d', 'up', '2014-09-03 19:14:15', 'root'),
	(134, 'Migration20131011210918ComTools.php', 'migrations', '3f8d18135a7db6d6bc9a7b1e3b923e67', 'up', '2014-09-03 19:14:15', 'root'),
	(135, 'Migration20131014103753ComMembers.php', 'migrations', '3348945c25c8c0c1e6425bb8bfb79f2b', 'up', '2014-09-03 19:14:15', 'root'),
	(136, 'Migration20131016184016PlgGroupsAnnouncements.php', 'migrations', '7276c1fc325e6c9bc13b77e31ececa63', 'up', '2014-09-03 19:14:15', 'root'),
	(137, 'Migration20131017133750ComWiki.php', 'migrations', '1203e8a9fc7a3414a39e904c1f6afbc1', 'up', '2014-09-03 19:14:15', 'root'),
	(138, 'Migration20131018163729ComCollections.php', 'migrations', '2da3363e392407adbdc46beffe7885e2', 'up', '2014-09-03 19:14:15', 'root'),
	(139, 'Migration20131021090512ComCourses.php', 'migrations', '60dd497cb78775c78d74a3d0955b947c', 'up', '2014-09-03 19:14:15', 'root'),
	(140, 'Migration20131021211223Core.php', 'migrations', '3ddb3eb4af78c52e9b5d404126cc64b1', 'up', '2014-09-03 19:14:15', 'root'),
	(141, 'Migration20131021225942ComCitations.php', 'migrations', 'd39606737c08df397b855dc3fac4d817', 'up', '2014-09-03 19:14:15', 'root'),
	(142, 'Migration20131022144858ComMembers.php', 'migrations', 'b89dc94db0a52e47639b27d21a244d42', 'up', '2014-09-03 19:14:15', 'root'),
	(143, 'Migration20131024114858ComCourses.php', 'migrations', '5d9fd0d02557a9aca26797ee626f1675', 'up', '2014-09-03 19:14:15', 'root'),
	(144, 'Migration20131024182332Core.php', 'migrations', '3f97532ddd05ce539b67bb45a0aa874b', 'up', '2014-09-03 19:14:15', 'root'),
	(145, 'Migration20131031124923ComCitations.php', 'migrations', '9f62ca16b397428a65eb7bd5e77a034a', 'up', '2014-09-03 19:14:15', 'root'),
	(146, 'Migration20131106150723ComProjects.php', 'migrations', '9745c5569e93d3a479ab6a1aa5fb9a3a', 'up', '2014-09-03 19:14:15', 'root'),
	(147, 'Migration20131106150723PlgYsearchCollections.php', 'migrations', '689fa41eb7e9687e52b656632b99b3d1', 'up', '2014-09-03 19:14:15', 'root'),
	(148, 'Migration20131106150723PlgYsearchProjects.php', 'migrations', '26a90de4fca38b6909df79ee2ed85a32', 'up', '2014-09-03 19:14:16', 'root'),
	(149, 'Migration20131106150723PlgYsearchPublications.php', 'migrations', '1f042842e7460aba9e820a4d2a19d4d4', 'up', '2014-09-03 19:14:16', 'root'),
	(150, 'Migration20131106152023ComCollections.php', 'migrations', 'ae8ebe5cb2acca2a35399618ddcbfc32', 'up', '2014-09-03 19:14:16', 'root'),
	(151, 'Migration20131106153123PlgYsearchCollections.php', 'migrations', 'be94f6f1a6075b75db00828187d8a0ab', 'up', '2014-09-03 19:14:16', 'root'),
	(152, 'Migration20131106154023ComPublications.php', 'migrations', '9c434a945305ec42b9631d8d7e0ef13b', 'up', '2014-09-03 19:14:16', 'root'),
	(153, 'Migration20131108091700ComBlog.php', 'migrations', '43f3ad06466cda7efeaa18b542c73a0c', 'up', '2014-09-03 19:14:16', 'root'),
	(154, 'Migration20131108095500ComAnswers.php', 'migrations', '4ca152ef5eb47fb0837edc14f2e87f25', 'up', '2014-09-03 19:14:16', 'root'),
	(155, 'Migration20131111165410Core.php', 'migrations', '591f0d517a0529dee0b46e722a6f7115', 'up', '2014-09-03 19:14:16', 'root'),
	(156, 'Migration20131111200831ComCourses.php', 'migrations', '6fcad5e995b581746f3f017ab894731f', 'up', '2014-09-03 19:14:16', 'root'),
	(157, 'Migration20131112130740ComUsage.php', 'migrations', 'b6139ffc3c111b8184a25ae10a7629d6', 'up', '2014-09-03 19:14:16', 'root'),
	(158, 'Migration20131112134513PlgCoursesStore.php', 'migrations', '936b280d6b1af9c61b554563c88cd6ba', 'up', '2014-09-03 19:14:16', 'root'),
	(159, 'Migration20131113134600ComTags.php', 'migrations', '88b8e752ca21b1bfd5686bab69591f99', 'up', '2014-09-03 19:14:16', 'root'),
	(160, 'Migration20131113143500ComSupport.php', 'migrations', 'b1c3ba67a3fd651d3a64c1074148cbe1', 'up', '2014-09-03 19:14:16', 'root'),
	(161, 'Migration20131113193815ComResources.php', 'migrations', '323ff48a9a4efbaf43a0cf8415843045', 'up', '2014-09-03 19:14:16', 'root'),
	(162, 'Migration20131206231821ComCourses.php', 'migrations', '7e95d9378e7ab5fb89c7d738a6089845', 'up', '2014-09-03 19:14:16', 'root'),
	(163, 'Migration20131209221353ComUsers.php', 'migrations', 'fc5a8ce93df3b0d4f5224502f6ddfe82', 'up', '2014-09-03 19:14:16', 'root'),
	(164, 'Migration20131216011106PlgCronCourses.php', 'migrations', 'eb3504126f6963e8bb3958bfb2ae6770', 'up', '2014-09-03 19:14:16', 'root'),
	(165, 'Migration20140108233318ComGroups.php', 'migrations', 'cdf56252657c7bd25fa10739c102856b', 'up', '2014-09-03 19:14:16', 'root'),
	(166, 'Migration20140108233319ComGroups.php', 'migrations', '578bbbec8b2bcd11f39bddf3bad742e5', 'up', '2014-09-03 19:14:16', 'root'),
	(167, 'Migration20140108233320PlgEditorsCkeditor.php', 'migrations', 'abb903ceb45edab5976ff9f1d10a6b44', 'up', '2014-09-03 19:14:16', 'root'),
	(168, 'Migration20140108233321PlgGroupsMembers.php', 'migrations', 'eec9f4dc67f3e284a20fb932f3f656a9', 'up', '2014-09-03 19:14:16', 'root'),
	(169, 'Migration20140108233322PlgSystemSupergroup.php', 'migrations', '8fecdaff1338a5e8cc01e5c60d4317f9', 'up', '2014-09-03 19:14:16', 'root'),
	(170, 'Migration20140108233323ModGroupPages.php', 'migrations', 'ab3761d5183d840358ef60b9fd0e4c1b', 'up', '2014-09-03 19:14:16', 'root'),
	(171, 'Migration20140109024336ComGroups.php', 'migrations', '76aa9158d0d23651a3e0d0e40ef78f75', 'up', '2014-09-03 19:14:16', 'root'),
	(172, 'Migration20140109101723ComProjects.php', 'migrations', '09238a379c605f3a3425ee8302aa8adf', 'up', '2014-09-03 19:14:16', 'root'),
	(173, 'Migration20140110125436ComWrapper.php', 'migrations', 'ff92a6b49c9dd2e70b36ff66456f9fa9', 'up', '2014-09-03 19:14:16', 'root'),
	(174, 'Migration20140110130812ComBanners.php', 'migrations', '60a47eb91532a0233598e0c7e734ac0c', 'up', '2014-09-03 19:14:17', 'root'),
	(175, 'Migration20140110132217ComWeblinks.php', 'migrations', '6cf15d40bb0bc226b5894324be84d578', 'up', '2014-09-03 19:14:17', 'root'),
	(176, 'Migration20140110132511ComContact.php', 'migrations', 'e27fd8406523f1de1e439b83b9a2223a', 'up', '2014-09-03 19:14:17', 'root'),
	(177, 'Migration20140110135511ComFinder.php', 'migrations', '127cd73b24131a937794343d49c8bfb4', 'up', '2014-09-03 19:14:17', 'root'),
	(178, 'Migration20140113135231ComSearch.php', 'migrations', 'acddc88f38881626eeca91fb3fd228f3', 'up', '2014-09-03 19:14:17', 'root'),
	(179, 'Migration20140114091331PlgGeocode.php', 'migrations', '54630e3e61b64fd809c643bae6c14465', 'up', '2014-09-03 19:14:17', 'root'),
	(180, 'Migration20140115171149PlgResourcesFindthistext.php', 'migrations', 'b4fb45a492e9bf5d8c6f962880f79c0c', 'up', '2014-09-03 19:14:17', 'root'),
	(181, 'Migration20140117212240ComCourses.php', 'migrations', '4992169ed34a40e5be0848612d25828f', 'up', '2014-09-03 19:14:18', 'root'),
	(182, 'Migration20140121131313PlgCronProjects.php', 'migrations', 'f5b6a7391dbc07d958c33dcb587ebbfe', 'up', '2014-09-03 19:14:18', 'root'),
	(183, 'Migration20140121142313PlgCronPublications.php', 'migrations', '5355a8d3e21c734047ba5b540dc3ee0c', 'up', '2014-09-03 19:14:18', 'root'),
	(184, 'Migration20140130105700ComAnswers.php', 'migrations', '0a1f0101e6cd8c5efd81d9a5d19bf739', 'up', '2014-09-03 19:14:18', 'root'),
	(185, 'Migration20140131091600HubzeroComments.php', 'migrations', '1f48e02b6efc5de9e86fe887cc8346e9', 'up', '2014-09-03 19:14:18', 'root'),
	(186, 'Migration20140206131800ComCitations.php', 'migrations', '94067690ab427a2c68f51db7c0f787cf', 'up', '2014-09-03 19:14:18', 'root'),
	(187, 'Migration20140206141200ComCitations.php', 'migrations', 'ce584bed8964c698a474b5ff1aa543f3', 'up', '2014-09-03 19:14:18', 'root'),
	(188, 'Migration20140207091831PlgContent.php', 'migrations', 'd32e32abee14b548a73be929eb1ea36f', 'up', '2014-09-03 19:14:18', 'root'),
	(189, 'Migration20140211083020PlgEditorsWikitoolbar.php', 'migrations', '2b6902258b464a2e91d8b063e81ac7b6', 'up', '2014-09-03 19:14:18', 'root'),
	(190, 'Migration20140211083120PlgEditorsWikiwyg.php', 'migrations', 'cb14c8925e18ee04e2d1e4504d4de131', 'up', '2014-09-03 19:14:18', 'root'),
	(191, 'Migration20140211154400PlgProjectsLinks.php', 'migrations', '9144fee0d37b25722b2b1e9841864523', 'up', '2014-09-03 19:14:18', 'root'),
	(192, 'Migration20140212162812ComCourses.php', 'migrations', '2b5f32e847322f54c2ed07f87ce3a44f', 'up', '2014-09-03 19:14:18', 'root'),
	(193, 'Migration20140217151012ComCourses.php', 'migrations', '4ffce0e9b7e892007cd151dd066e36ee', 'up', '2014-09-03 19:14:18', 'root'),
	(194, 'Migration20140219221812ComCourses.php', 'migrations', 'deea404cc920735f53459b32a20319ab', 'up', '2014-09-03 19:14:18', 'root'),
	(195, 'Migration20140220183257ComCourses.php', 'migrations', '98f3466f0101fa8d8d6fb4b5ff6d8c8d', 'up', '2014-09-03 19:14:18', 'root'),
	(196, 'Migration20140224112212PlgWiki.php', 'migrations', 'e28b09f1490d2293bcac04496bd248c8', 'up', '2014-09-03 19:14:18', 'root'),
	(197, 'Migration20140225094500ComGroups.php', 'migrations', '4d002f8f0230f753cb0a6c7769d26948', 'up', '2014-09-03 19:14:18', 'root'),
	(198, 'Migration20140303123720PlgGroupsCourses.php', 'migrations', '99258b842adf33a5dfccd4ed8bcac9f4', 'up', '2014-09-03 19:14:18', 'root'),
	(199, 'Migration20140305081020PlgUsageChart.php', 'migrations', 'ff49908bb41d0a83d9e890a02df80387', 'up', '2014-09-03 19:14:18', 'root'),
	(200, 'Migration20140305081320ComMembers.php', 'migrations', 'cd29eed09984a7e937e0bdf4612b9f2b', 'up', '2014-09-03 19:14:18', 'root'),
	(201, 'Migration20140305090721ComCron.php', 'migrations', '00ec508fd29dd51dfbc6a404b8011a89', 'up', '2014-09-03 19:14:18', 'root'),
	(202, 'Migration20140305142845Core.php', 'migrations', 'f99ca841596a4146cf5ef7eba4b291cd', 'up', '2014-09-03 19:14:19', 'root'),
	(203, 'Migration20140310130202ComTags.php', 'migrations', '74ef163a7db2e4110db114013c938aa1', 'up', '2014-09-03 19:14:19', 'root'),
	(204, 'Migration20140311150000ComFeedaggregator.php', 'migrations', 'f7f9b00e8d62a17d1a109f513ec6d088', 'up', '2014-09-03 19:14:19', 'root'),
	(205, 'Migration20140311160400ComFeedaggregator.php', 'migrations', '1bc30baaba9e1b941c38fecd785187e9', 'up', '2014-09-03 19:14:19', 'root'),
	(206, 'Migration20140314080012PlgSupportPublications.php', 'migrations', '8e31e1184dd896cc7c4b54a5e90ea9a3', 'up', '2014-09-03 19:14:19', 'root'),
	(207, 'Migration20140314131113ComKb.php', 'migrations', 'ee0066a58dc5431df923020985c881b4', 'up', '2014-09-03 19:14:19', 'root'),
	(208, 'Migration20140324161600ComResources.php', 'migrations', '717eb7d8a95bb4782108ff02cf44a3d0', 'up', '2014-09-03 19:14:19', 'root'),
	(209, 'Migration20140325093000ComResources.php', 'migrations', 'cd2d13002c43366713b904e8fcd770f3', 'up', '2014-09-03 19:14:19', 'root'),
	(210, 'Migration20140407091900ComResources.php', 'migrations', '13215b8be3e67cbcbb35f24ab98fae1b', 'up', '2014-09-03 19:14:19', 'root'),
	(211, 'Migration20140408121756ComCourses.php', 'migrations', 'e6de7ac64a9352175692c56c686f76e7', 'up', '2014-09-03 19:14:19', 'root'),
	(212, 'Migration20140408190610ComEvents.php', 'migrations', '38526ffe9784e8da23545970d0b99a93', 'up', '2014-09-03 19:14:19', 'root'),
	(213, 'Migration20140410085610ComSupport.php', 'migrations', 'e2a46fb1de57373479c75b35511ebcd3', 'up', '2014-09-03 19:14:19', 'root'),
	(214, 'Migration20140415105610ComTopics.php', 'migrations', 'a422ed5de3500da8c332f817d21fd261', 'up', '2014-09-03 19:14:19', 'root'),
	(215, 'Migration20140416082740ComFeatures.php', 'migrations', '38540f65cade947c02405814a8fc03a8', 'up', '2014-09-03 19:14:20', 'root'),
	(216, 'Migration20140417132300ComFeedaggregator.php', 'migrations', '9450ad27cdfca0e878fef3682e2f1117', 'up', '2014-09-03 19:14:20', 'root'),
	(217, 'Migration20140417134640TplKameleonAdmin.php', 'migrations', 'dc12dc36261dbf9fd59b82b6513877d4', 'up', '2014-09-03 19:14:20', 'root'),
	(218, 'Migration20140417203615ComResources.php', 'migrations', 'a539d6ea0f8fbb7233ef6d5d6d620171', 'up', '2014-09-03 19:14:20', 'root'),
	(219, 'Migration20140421080012PlgTagsPublications.php', 'migrations', '18d9da5aed4b26bdbba99c7ba2013551', 'up', '2014-09-03 19:14:20', 'root'),
	(220, 'Migration20140421112851ComTools.php', 'migrations', '6993fc2600764e1e35b78b7a51a8569b', 'up', '2014-09-03 19:14:20', 'root'),
	(221, 'Migration20140421130020PlgHubzeroSystemplate.php', 'migrations', 'c736baf04657efcca3c222adc7ca33ee', 'up', '2014-09-03 19:14:20', 'root'),
	(222, 'Migration20140421130020PlgHubzeroSystickets.php', 'migrations', '2fe9c4550151025d7f3e10de51bc45de', 'up', '2014-09-03 19:14:20', 'root'),
	(223, 'Migration20140421130020PlgHubzeroSysusers.php', 'migrations', '1b912287e7ab93dec7efea1058e151e9', 'up', '2014-09-03 19:14:20', 'root'),
	(224, 'Migration20140421135022ComTools.php', 'migrations', 'c10911424e592d18b2cd1f62fb155dd8', 'up', '2014-09-03 19:14:20', 'root'),
	(225, 'Migration20140421182216Core.php', 'migrations', '71f39cd9c5e52cc4ee38ac161a01f4bc', 'up', '2014-09-03 19:14:20', 'root'),
	(226, 'Migration20140422082422ComTools.php', 'migrations', 'ca662aede45dc4e2ea8c9a41dd0732cd', 'up', '2014-09-03 19:14:20', 'root'),
	(227, 'Migration20140423131112ComGroups.php', 'migrations', 'af8a0e03e971225764420712983dba4a', 'up', '2014-09-03 19:14:20', 'root'),
	(228, 'Migration20140428094910ComSupport.php', 'migrations', '8d29f576b55a8e066c65a97df3961cdc', 'up', '2014-09-03 19:14:20', 'root'),
	(229, 'Migration20140428183704Core.php', 'migrations', '58ae41533557b4e03b6c676eb74ffa99', 'up', '2014-09-03 19:14:21', 'root'),
	(230, 'Migration20140502184454Core.php', 'migrations', '747dfaee88f169d90a4532022baf621d', 'up', '2014-09-03 19:14:21', 'root'),
	(231, 'Migration20140505141538ComTools.php', 'migrations', 'b5961d1e8b9a87f33464bce67e8a1782', 'up', '2014-09-03 19:14:21', 'root'),
	(232, 'Migration20140505160720PlgSupportTime.php', 'migrations', 'ed84ad1b74460c96b8a6db468adb9d5b', 'up', '2014-09-03 19:14:21', 'root'),
	(233, 'Migration20140506104910PlgMembersFavorites.php', 'migrations', '13069051ff2d774ce0331a93e7a454ca', 'up', '2014-09-03 19:14:21', 'root'),
	(234, 'Migration20140508120000PlgMembersDashboard.php', 'migrations', '878f103169d3e5f71268ae6adc2d9972', 'up', '2014-09-03 19:14:21', 'root'),
	(235, 'Migration20140508122800PlgMembersDashboard.php', 'migrations', '1b7523a669dc229fd2d726e6d5b6d8c6', 'up', '2014-09-03 19:14:21', 'root'),
	(236, 'Migration20140509133410ComSupport.php', 'migrations', '51257ab13c6dda7aaccd5ed5b2b0e642', 'up', '2014-09-03 19:14:21', 'root'),
	(237, 'Migration20140512120000ComPublications.php', 'migrations', '45633a75e5997b41eeb0421d3a8a2a00', 'up', '2014-09-03 19:14:21', 'root'),
	(238, 'Migration20140515130000ComPublications.php', 'migrations', '96f353949933804c367a4a26cef4f2b3', 'up', '2014-09-03 19:14:21', 'root'),
	(239, 'Migration20140519120000ComPublications.php', 'migrations', 'b3bf1b9b66b602c31c7d8c197a5593fe', 'up', '2014-09-03 19:14:21', 'root'),
	(240, 'Migration20140520200100ComUpdate.php', 'migrations', 'db6330986e43897a207b2a69d269ef46', 'up', '2014-09-03 19:14:21', 'root'),
	(241, 'Migration20140521141237ComNewsletter.php', 'migrations', '5d3f829341d20dc72f3343e149244196', 'up', '2014-09-03 19:14:21', 'root'),
	(242, 'Migration20140521145232ComUsers.php', 'migrations', 'db1153ac28ecaca9e82b139a165458a9', 'up', '2014-09-03 19:14:21', 'root'),
	(243, 'Migration20140522100120PlgContentAntispam.php', 'migrations', '3fec3a3a2fe8f6e688d8efb5a00b9935', 'up', '2014-09-03 19:14:21', 'root'),
	(244, 'Migration20140528145010ComRegister.php', 'migrations', '3d0c48b1d3b1b78b078de325e01f929c', 'up', '2014-09-03 19:14:21', 'root'),
	(245, 'Migration20140529150000PlgMembersImpact.php', 'migrations', '2c27e581ce5ee2757365895dfc2798b7', 'up', '2014-09-03 19:14:22', 'root'),
	(246, 'Migration20140529172125ComCourses.php', 'migrations', '4cceede5063636ba9a894a96eb3fb549', 'up', '2014-09-03 19:14:22', 'root'),
	(247, 'Migration20140529192810ComCourses.php', 'migrations', 'd5faed53d7a308b544bf0e425fce3eeb', 'up', '2014-09-03 19:14:22', 'root'),
	(248, 'Migration20140603164434ComCourses.php', 'migrations', '50170eb0e00664f571a656917862a52b', 'up', '2014-09-03 19:14:22', 'root'),
	(249, 'Migration20140605155804ComPublications.php', 'migrations', '8af3b556322071425499649275e812a1', 'up', '2014-09-03 19:14:22', 'root'),
	(250, 'Migration20140606165053ComCourses.php', 'migrations', 'a686ee88116241670c9ea552af41e6ca', 'up', '2014-09-03 19:14:22', 'root'),
	(251, 'Migration20140609160011ComFeedback.php', 'migrations', '99a67a2164361ff55c8c5f980dc09e44', 'up', '2014-09-03 19:14:22', 'root'),
	(252, 'Migration20140611102711ComCourses.php', 'migrations', '7fc25caf3cfc2d18cbd2791b2be77e18', 'up', '2014-09-03 19:14:22', 'root'),
	(253, 'Migration20140611141603ComMembers.php', 'migrations', '6252ca878b3c587d6ffe57303e6a24e0', 'up', '2014-09-03 19:14:22', 'root'),
	(254, 'Migration20140617153609ComTools.php', 'migrations', '74d7bf2ef154f6448de7779141d4f54d', 'up', '2014-09-03 19:14:22', 'root'),
	(255, 'Migration20140623144900Core.php', 'migrations', '9234d45e7361dcb8c4ecd7e4bb6ca77e', 'up', '2014-09-03 19:14:22', 'root'),
	(256, 'Migration20140624123157ComCitations.php', 'migrations', '353651b7f7ba15800ae04290c240e4ff', 'up', '2014-09-03 19:14:22', 'root'),
	(257, 'Migration20140626100712PlgPublicationsGroups.php', 'migrations', '843ac717207969fbc2124440bec55b93', 'up', '2014-09-03 19:14:22', 'root'),
	(258, 'Migration20140626155344ComUsers.php', 'migrations', 'cad0b846df2907cb0986f72426960d59', 'up', '2014-09-03 19:14:22', 'root'),
	(259, 'Migration20140627062357ComSupport.php', 'migrations', '0e26ff5d015903a447ee39d89c9d46d4', 'up', '2014-09-03 19:14:22', 'root'),
	(260, 'Migration20140627091431ComSupport.php', 'migrations', '817a8df1de833da30556dabef799266a', 'up', '2014-09-03 19:14:22', 'root'),
	(261, 'Migration20140627140011PlgResourcesReviews.php', 'migrations', 'e8427197e87ff3104f39fed8ee4f236e', 'up', '2014-09-03 19:14:22', 'root'),
	(262, 'Migration20140630084843ComCollections.php', 'migrations', 'dd4b14226292191927e8fba24006d2fb', 'up', '2014-09-03 19:14:22', 'root'),
	(263, 'Migration20140702071151ComBlog.php', 'migrations', 'da2a6aae5e9a318dcf29bc0d35bb64f5', 'up', '2014-09-03 19:14:22', 'root'),
	(264, 'Migration20140702115751ComForum.php', 'migrations', 'e0329449772180a87e8622a58cc01d3a', 'up', '2014-09-03 19:14:22', 'root'),
	(265, 'Migration20140702122251ComKb.php', 'migrations', '1507677f5be9b06980ae4532d9ab4d1a', 'up', '2014-09-03 19:14:22', 'root'),
	(266, 'Migration20140702130951ComAnswers.php', 'migrations', 'ccd4fb8b9bd1f58935424989101a8e83', 'up', '2014-09-03 19:14:22', 'root'),
	(267, 'Migration20140702160951ComWishlist.php', 'migrations', '166dde2a5560e6fded28b000593d2927', 'up', '2014-09-03 19:14:22', 'root'),
	(268, 'Migration20140703083327PlgResourcesReviews.php', 'migrations', '6988d49f341dea191a049b6595763448', 'up', '2014-09-03 19:14:22', 'root'),
	(269, 'Migration20140703100727ComWiki.php', 'migrations', '3b98a99fc27b7700708c912a14e3f591', 'up', '2014-09-03 19:14:22', 'root'),
	(270, 'Migration20140703163627PlgXmessageHandler.php', 'migrations', '0edf3a6d6c02c5b425670c3a8718cf86', 'up', '2014-09-03 19:14:22', 'root'),
	(271, 'Migration20140709144527ComTags.php', 'migrations', 'f567d99d34b774bf0248e8016ca028dd', 'up', '2014-09-03 19:14:22', 'root'),
	(272, 'Migration20140709174727ModSupportactivity.php', 'migrations', '05c8188c1dbddebe55a30aa7706ae54a', 'up', '2014-09-03 19:14:22', 'root'),
	(273, 'Migration20140714201025ComTime.php', 'migrations', '2b4611b62bea6af6464dc0fa44040fe9', 'up', '2014-09-03 19:14:22', 'root'),
	(274, 'Migration20140716180300ComTools.php', 'migrations', 'f4bea1a995cfc0ba595097c344157115', 'up', '2014-09-03 19:14:22', 'root'),
	(275, 'Migration20140716182939Core.php', 'migrations', '9a4f6fbf07cc092cf3c1b20730d20986', 'up', '2014-09-03 19:14:22', 'root'),
	(276, 'Migration20140721163818PlgTimeSummary.php', 'migrations', 'b87e562c9585c145c186c64659484db0', 'up', '2014-09-03 19:14:22', 'root'),
	(277, 'Migration20140722152439PlgAuthenticationHubzero.php', 'migrations', 'a03d6caa952a5f104974c820cf2056e1', 'up', '2014-09-03 19:14:22', 'root'),
	(278, 'Migration20140730153624ComUsers.php', 'migrations', 'fe303201fcbf7682e0ff3868eb00cfa9', 'up', '2014-09-03 19:14:22', 'root'),
	(279, 'Migration20140730181124PlgSystemHubzero.php', 'migrations', '258f930c1046bc28433c552b93ede87e', 'up', '2014-09-03 19:14:22', 'root'),
	(280, 'Migration20140804153815Core.php', 'migrations', 'd91c99665160703676594596f4afaa29', 'up', '2014-09-03 19:14:22', 'root'),
	(281, 'Migration20140805185942ComMembers.php', 'migrations', '94582da6a04ca7a0f6c4dc5f3cab7fb7', 'up', '2014-09-03 19:14:22', 'root'),
	(282, 'Migration20140805223444PlgGroupsBlog.php', 'migrations', '67b85bdcb3f56032c473a3bb363465f0', 'up', '2014-09-03 19:14:22', 'root'),
	(283, 'Migration20140807143056ComMembers.php', 'migrations', '8ea6301855f4704e70dd5d99435b1d0a', 'up', '2014-09-03 19:14:22', 'root'),
	(284, 'Migration20140807200026ComTime.php', 'migrations', 'db0002cf6ef15caf4f669aefb04a1353', 'up', '2014-09-03 19:14:22', 'root'),
	(285, 'Migration20140808195514ComTools.php', 'migrations', 'cc6ca2062f8b12869a1add55702c8b38', 'up', '2014-09-03 19:14:22', 'root'),
	(286, 'Migration20140813132614ComSupport.php', 'migrations', 'a0693170b8d8fc36659d186f961abb11', 'up', '2014-09-03 19:14:22', 'root'),
	(287, 'Migration20140813200031ComTools.php', 'migrations', 'e6565c74ce47739656b07aec9eeb6ba7', 'up', '2014-09-03 19:14:22', 'root'),
	(288, 'Migration20140814103014ComSupport.php', 'migrations', 'f42305fa77a0e85568fb24d3a32d36a4', 'up', '2014-09-03 19:14:22', 'root'),
	(289, 'Migration20140815061927ComSupport.php', 'migrations', 'a1d1ec3a729db33aa390b3f8c3069758', 'up', '2014-09-03 19:14:23', 'root'),
	(290, 'Migration20140815153140ComCourses.php', 'migrations', 'a433fa0af47d680ef8ec213e83a8c847', 'up', '2014-09-03 19:14:23', 'root'),
	(291, 'Migration20140818160255ComCitations.php', 'migrations', 'ed6748169df1d72672f641e6a3bcd3d6', 'up', '2014-09-03 19:14:23', 'root'),
	(292, 'Migration20140818160800ComSupport.php', 'migrations', 'e2834c531541bf93cc90e814add67a87', 'up', '2014-09-03 19:14:23', 'root'),
	(293, 'Migration20140818161500ComWishlist.php', 'migrations', 'f02263b0feb1c447629c1c3829d3059c', 'up', '2014-09-03 19:14:23', 'root'),
	(294, 'Migration20140818162220PlgTools.php', 'migrations', 'c1d7842636858e67d870f70c3c8c0ea5', 'up', '2014-09-03 19:14:23', 'root'),
	(295, 'Migration20140820171853ComEvents.php', 'migrations', 'b89c1b0b9a8b16acbb1c47e1abbfe452', 'up', '2014-09-03 19:14:23', 'root'),
	(296, 'Migration20140822132824ComUsers.php', 'migrations', 'b85443253a106a48485b00920d2fd386', 'up', '2014-09-03 19:14:23', 'root'),
	(297, 'Migration20140822153500PlgGroupsAnnouncements.php', 'migrations', 'c3022825b4ad406e7fd2cdbeae742e32', 'up', '2014-09-03 19:14:23', 'root'),
	(298, 'Migration20140822154400ComAnswers.php', 'migrations', 'a57759bfcbf23cbcc212f69464f769f8', 'up', '2014-09-03 19:14:23', 'root'),
	(299, 'Migration20140822154900ComBlog.php', 'migrations', '6b7c9403edb226c9a0ad9ab8d64696d1', 'up', '2014-09-03 19:14:23', 'root'),
	(300, 'Migration20140822155500ComCollections.php', 'migrations', '805e29f0df7e534634560e633d0b266d', 'up', '2014-09-03 19:14:23', 'root'),
	(301, 'Migration20140822155900ComCron.php', 'migrations', 'd6587c72ba29ec626972a1e509d11075', 'up', '2014-09-03 19:14:23', 'root'),
	(302, 'Migration20140822161100ComKb.php', 'migrations', '185c7472518d0d76a3c520f1660fb219', 'up', '2014-09-03 19:14:23', 'root'),
	(303, 'Migration20140822161900PlgHubzeroComments.php', 'migrations', '261fa5ec4534dceefa4c24a8f4dc3d43', 'up', '2014-09-03 19:14:23', 'root'),
	(304, 'Migration20140822203559ComPoll.php', 'migrations', 'c9594778fb9517a755c2a9cfad8d4294', 'up', '2014-09-03 19:14:23', 'root'),
	(305, 'Migration20140826120656ComEvents.php', 'migrations', '3acd83ed9bc788374e22ce4f34484060', 'up', '2014-09-03 19:14:23', 'root'),
	(306, 'Migration20140827100656ComPublications.php', 'migrations', 'd2f3fce7ac5706f8ac30279937ba732d', 'up', '2014-09-03 19:14:23', 'root'),
	(307, 'Migration20140828150712PlgWhatsnewPublications.php', 'migrations', 'a255521250e0c84bc4534cabe32812d6', 'up', '2014-09-03 19:14:23', 'root'),
	(308, 'Migration20140829131016PlgMembersDashboard.php', 'migrations', '0692e180dba74d8c185ec0d6baeee077', 'up', '2014-09-03 19:14:23', 'root'),
	(309, 'Migration20140829131400PlgMembersMessages.php', 'migrations', 'c1aa60f4d2fa2c9786a45fc8cd01b1e5', 'up', '2014-09-03 19:14:23', 'root'),
	(310, 'Migration20140829132200ComWiki.php', 'migrations', 'd76e6cd1dcee33d4313bc6ed13f8b382', 'up', '2014-09-03 19:14:23', 'root'),
	(311, 'Migration20140829142600ComCollections.php', 'migrations', 'e016899c6034e9663e9fbb6c15f20de5', 'up', '2014-09-03 19:14:23', 'root'),
	(312, 'Migration20140904174546ComKb.php', 'migrations', 'fad15f5c5ceda64f022ef1bc75ada55f', 'up', '2014-09-20 17:22:57', 'root'),
	(313, 'Migration20140922135214Core.php', 'migrations', 'e506b37f04680b0540937b984991a0e6', 'up', '2014-09-22 13:55:41', 'root');

--
-- HUBzero sample data for table `#__modules`
--

INSERT INTO `#__modules` VALUES (18,'Groups','','',7,'cpanel',0,'0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00',1,'mod_groups',1,1,'{\"type\":\"1\",\"cache\":\"1\"}',1,'');
INSERT INTO `#__modules` VALUES (19,'Events Calendar','','',0,'eventsLeft',0,'0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00',1,'mod_events_cal',1,0,'{\"moduleclass_sfx\":\"\",\"show_nav_prev_month\":\"1\",\"start_day\":\"0\",\"display_last_month\":\"NO\",\"display_last_month_days\":\"0\",\"show_nav_next_month\":\"1\",\"display_next_month\":\"NO\",\"display_next_month_days\":\"0\",\"cache\":\"0\",\"cache_time\":\"900\"}',0,'');
INSERT INTO `#__modules` VALUES (20,'Latest Events','','',0,'eventsRight',0,'0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00',1,'mod_events_latest',1,1,'{\"moduleclass_sfx\":\"\",\"startday\":\"0\",\"max_events\":\"10\",\"mode\":\"2\",\"announcements\":\"0\",\"days\":\"365\",\"display_links\":\"0\",\"display_year\":\"0\",\"display_date_style\":\"0\",\"display_title_style\":\"0\",\"no_repeat\":\"1\",\"char_limit\":\"150\",\"cache\":\"0\",\"cache_time\":\"900\"}',0,'');
INSERT INTO `#__modules` VALUES (21,'Featured Resource','','',0,'featureLeft',0,'0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00',1,'mod_featuredresource',1,1,'{\"catid\":\"\",\"moduleclass_sfx\":\"featured-resource\",\"txt_length\":\"200\",\"minranking\":\"0\",\"tag\":\"\",\"cache\":\"1\",\"cache_time\":\"900\"}',0,'');
INSERT INTO `#__modules` VALUES (22,'Community Poll','','',0,'featureMiddle',0,'0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00',1,'mod_poll',1,1,'{\"formid\":\"\",\"cache\":\"1\"}',0,'');
INSERT INTO `#__modules` VALUES (23,'Featured Tool','','',0,'featureRight',0,'0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00',1,'mod_featuredresource',1,1,'{\"catid\":\"\",\"moduleclass_sfx\":\"featured-resource\",\"txt_length\":\"200\",\"type\":\"tools\",\"minranking\":\"0\",\"tag\":\"\",\"cache\":\"1\",\"cache_time\":\"900\"}',0,'');
INSERT INTO `#__modules` VALUES (24,'Hub Footer', '', '<h2>Helpful Links</h2>\r\n<div id=\"ancillary\" class=\"grid cf\">\r\n\r\n	<div class=\"col span-quarter\">\r\n		<h3>Get Help</h3>\r\n		<ul>\r\n			<li><a href=\"/feedback\">Feedback</a></li>\r\n			<li><a href=\"/login/remind\">Forgot username?</a></li>\r\n			<li><a href=\"/login/reset\">Lost password?</a></li>\r\n			<li><a href=\"/legal/accessibility\">Accessibility Issues</a></li>\r\n			<li><a href=\"/about/contact\">Contact us</a></li>\r\n		</ul>\r\n	</div>\r\n	<div class=\"col span-quarter\">\r\n		<h3>Participate</h3>\r\n		<ul>\r\n			<li><a href=\"/resources/new\">Submit a resource</a></li>\r\n			<li><a href=\"/groups/new\">Create a group</a></li>\r\n			<li><a href=\"/answers\"><span>Answer questions</span></a></li>\r\n			<li><a href=\"/wishlist\"><span>Make a wish</span></a></li>\r\n			<li><a href=\"/forum\"><span>Join the discussion</span></a></li>\r\n		</ul>\r\n	</div>\r\n	<div class=\"col span-quarter\">\r\n		<h3>Discover</h3>\r\n		<ul>\r\n			<li><a href=\"/whatsnew\"><span>What\'s New</span></a></li>\r\n			<li><a href=\"/resources\"><span>Resources</span></a></li>\r\n			<li><a href=\"/wiki\"><span>Wiki</span></a></li>\r\n			<li><a href=\"/tags\"><span>Tags</span></a></li>\r\n			<li><a href=\"/kb\"><span>Knowledge Base</span></a></li>\r\n		</ul>\r\n	</div>\r\n	<div class=\"col span-quarter omega\">\r\n		<h3>About Us</h3>\r\n		<ul>\r\n			<li><a href=\"/about\">Who we are</a></li>\r\n			<li><a href=\"/legal/terms\">Terms of use</a></li>\r\n			<li><a href=\"/legal/privacy\">Privacy Policy</a></li>\r\n			<li><a href=\"/legal/abuse\">Abuse Policy</a></li>\r\n			<li><a href=\"/about/dmcapolicy\">Copyright Infringement</a></li>\r\n		</ul>\r\n	</div>\r\n\r\n</div><!-- / footer nav -->\r\n<div class=\"inner\">\r\n<ul id=\"legalese\">\r\n	<li class=\"policy\">Copyright &copy; 2012 Hubzilla</li>\r\n	<li>Powered by <a href=\"http://hubzero.org\" rel=\"external\">HUBzero<sup>&reg;</sup></a>, a <a href=\"http://www.purdue.edu\" title=\"Purdue University\" rel=\"external\">Purdue</a> project</li>\r\n</ul><!-- / footer #legalese -->\r\n</div>', 1, 'footer', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 0, '{\"prepare_content\":\"0\",\"backgroundimage\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\"}', 0, '*');
INSERT INTO `#__modules` VALUES (25,'Trouble Report','','',0,'helppane',0,'0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00',1,'mod_reportproblems',1,0,'{\"moduleclass_sfx\":\"\",\"cache\":\"0\"}',0,'');
INSERT INTO `#__modules` VALUES (26,'Support Tickets','','',0,'icon',0,'0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00',1,'mod_supporttickets',1,1,'{\"cache\":\"1\"}',1,'');
INSERT INTO `#__modules` VALUES (27,'Resources','','',1,'icon',0,'0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00',1,'mod_resources',1,1,'{\"cache\":\"1\"}',1,'');
INSERT INTO `#__modules` VALUES (28,'Wish List','','',2,'icon',0,'0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00',1,'mod_wishlist',1,1,'{\"wishlist\":\"\",\"showMine\":\"0\",\"cache\":\"1\"}',1,'');
INSERT INTO `#__modules` VALUES (29,'Questions & Answers','','',3,'icon',0,'0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00',1,'mod_answers',1,1,'{\"showMine\":\"0\",\"cache\":\"1\"}',1,'');
INSERT INTO `#__modules` VALUES (30,'Dashboard','','',4,'icon',0,'0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00',0,'mod_dashboard',1,0,'',1,'');
INSERT INTO `#__modules` VALUES (31,'About','','',0,'left',0,'0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00',1,'mod_menu',1,1,'{\"menutype\":\"about\",\"menu_style\":\"list\",\"startLevel\":\"0\",\"endLevel\":\"0\",\"showAllChildren\":\"1\",\"window_open\":\"\",\"show_whitespace\":\"0\",\"cache\":\"1\",\"tag_id\":\"\",\"class_sfx\":\"\",\"moduleclass_sfx\":\"\",\"maxdepth\":\"10\",\"menu_images\":\"0\",\"menu_images_align\":\"0\",\"menu_images_link\":\"0\",\"expand_menu\":\"0\",\"activate_parent\":\"0\",\"full_active_id\":\"0\",\"indent_image\":\"0\",\"indent_image1\":\"\",\"indent_image2\":\"\",\"indent_image3\":\"\",\"indent_image4\":\"\",\"indent_image5\":\"\",\"indent_image6\":\"\",\"spacer\":\"\",\"end_spacer\":\"\"}',0,'');
INSERT INTO `#__modules` VALUES (32,'Legal Menu','','',1,'left',0,'0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00',1,'mod_menu',1,1,'{\"menutype\":\"legal\",\"menu_style\":\"list\",\"startLevel\":\"0\",\"endLevel\":\"0\",\"showAllChildren\":\"0\",\"window_open\":\"\",\"show_whitespace\":\"0\",\"cache\":\"1\",\"tag_id\":\"\",\"class_sfx\":\"\",\"moduleclass_sfx\":\"\",\"maxdepth\":\"10\",\"menu_images\":\"0\",\"menu_images_align\":\"0\",\"menu_images_link\":\"0\",\"expand_menu\":\"0\",\"activate_parent\":\"0\",\"full_active_id\":\"0\",\"indent_image\":\"0\",\"indent_image1\":\"\",\"indent_image2\":\"\",\"indent_image3\":\"\",\"indent_image4\":\"\",\"indent_image5\":\"\",\"indent_image6\":\"\",\"spacer\":\"\",\"end_spacer\":\"\"}',0,'');
INSERT INTO `#__modules` VALUES (33,'My Groups','','',0,'memberDashboard',0,'0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00',1,'mod_mygroups',1,0,'',0,'');
INSERT INTO `#__modules` VALUES (34,'My Drafts','','',6,'memberDashboard',0,'0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00',1,'mod_mycontributions',1,0,'{\"show_tools\":\"1\",\"get_questions\":\"1\",\"get_wishes\":\"1\",\"get_tickets\":\"1\",\"limit_tools\":\"10\",\"limit_other\":\"10\"}',0,'');
INSERT INTO `#__modules` VALUES (35,'My Points','','',8,'memberDashboard',0,'0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00',1,'mod_mypoints',1,1,'',0,'');
INSERT INTO `#__modules` VALUES (36,'My Tools','','',3,'memberDashboard',0,'0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00',1,'mod_mytools',1,0,'',0,'');
INSERT INTO `#__modules` VALUES (37,'My Tickets','','',4,'memberDashboard',0,'0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00',1,'mod_mytickets',1,1,'',0,'');
INSERT INTO `#__modules` VALUES (38,'My Questions','','',9,'memberDashboard',0,'0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00',1,'mod_myquestions',1,0,'',0,'');
INSERT INTO `#__modules` VALUES (39,'My Wishes','','',7,'memberDashboard',0,'0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00',1,'mod_mywishes',1,0,'',0,'');
INSERT INTO `#__modules` VALUES (40,'My Messages','','',5,'memberDashboard',0,'0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00',1,'mod_mymessages',1,0,'',0,'');
INSERT INTO `#__modules` VALUES (41,'My Sessions','','',1,'memberDashboard',0,'0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00',1,'mod_mysessions',1,0,'{\"moduleclass_sfx\":\"\",\"show_storage\":\"1\",\"hubvnc\":\"\"}',0,'');
INSERT INTO `#__modules` VALUES (42,'My Projects','','',2,'memberDashboard',0,'0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00',1,'mod_myprojects',1,1,'{\"moduleclass\":\"md-projects\",\"limit\":\"5\"}',0,'');
INSERT INTO `#__modules` VALUES (43,'Resources','','<ul>\r\n	<li><a href=\"/resources/tools\">Simulation Tools</a></li>\r\n	<li><a href=\"/resources/seminars\">Seminars</a></li>\r\n	<li><a href=\"/resources/workshops\">Workshops</a></li>\r\n	<li><a href=\"/resources/courses\">Courses</a></li>\r\n	<li><a href=\"/resources/teachingmaterials\">Teaching Materials</a></li>\r\n	<li><a href=\"/resources/publications\">Publications</a></li>\r\n	<li><a href=\"/resources/downloads\">Downloads</a></li>\r\n</ul>',10,'memberDashboard',0,'0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00',1,'mod_custom',1,1,'{\"moduleclass_sfx\":\"\"}',0,'');
INSERT INTO `#__modules` VALUES (44,'Dashboard Introduction','','<p>Welcome to your customizable dashboard page!</p>\r\n\r\n<p>To get started, click the \"Personalize\" button towards the top of this page. You will then be presented with a list of modules you may add to your page. You may also, at that time, remove any unwanted modules or rearrange the current modules by drag-and-drop!</p>',11,'memberDashboard',0,'0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00',1,'mod_custom',1,1,'{\"moduleclass_sfx\":\"\"}',0,'');
INSERT INTO `#__modules` VALUES (45,'Notices','','',0,'notices',0,'0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00',1,'mod_notices',1,0,'{\"start_publishing\":\"0000-00-00 00:00:00\",\"stop_publishing\":\"0000-00-00 00:00:00\",\"alertlevel\":\"low\",\"moduleid\":\"\",\"message\":\"\",\"allowClose\":\"0\"}',0,'');
INSERT INTO `#__modules` VALUES (46,'Quotes','','',1,'quotes',0,'0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00',1,'mod_quotes',1,0,'{\"cache\":\"0\",\"moduleclass_sfx\":\"\",\"maxquotes\":\"\"}',0,'');
INSERT INTO `#__modules` VALUES (47,'Search','','',0,'search',0,'0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00',1,'mod_search',1,0,'{\"moduleclass_sfx\":\"\",\"width\":\"20\",\"text\":\"Search\",\"button\":\"\",\"button_pos\":\"right\",\"imagebutton\":\"\",\"button_text\":\"Go\",\"set_itemid\":\"\",\"cache\":\"1\",\"cache_time\":\"900\"}',0,'');
INSERT INTO `#__modules` VALUES (48,'My Submissions','','',7,'submissions',0,'0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00',1,'mod_mysubmissions',1,0,'',0,'');
INSERT INTO `#__modules` VALUES (49,'Browse Content by Tags','','',0,'toptags',0,'0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00',1,'mod_toptags',1,1,'{\"numtags\":\"25\",\"exclude\":\"\",\"message\":\"\",\"sortby\":\"alphabeta\",\"morelnk\":\"0\",\"cache\":\"0\",\"cache_time\":\"900\"}',0,'');
INSERT INTO `#__modules` VALUES (50,'Congratulations','','<div id=\"congrats\">\r\n<h2>Welcome to HUBzero!</h2>\r\n<p>Congratulations! Your new hub is up and running. This is a skeleton site and basic template to serve as a starting point for you to begin building your hub.</p>\r\n</div>',0,'welcome',0,'0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00',1,'mod_custom',1,1,'{\"moduleclass_sfx\":\"\"}',0,'');
INSERT INTO `#__modules` VALUES (51,'Welcome','','<div id=\"welcome\">\r\n<h2>Welcome to our site!</h2>\r\n<p>\r\nThis project has an <a href=\"/about\">important mission</a> of revolutionizing scientific research and educational activities.\r\n</p>\r\n</div>',1,'welcome',0,'0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00',1,'mod_custom',1,1,'{\"moduleclass_sfx\":\"\"}',0,'');
INSERT INTO `#__modules` VALUES (52,'Accessibility Contact','','',1,'accessibilitycontact',0,'0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00',1,'mod_rapid_contact',1,1,'{\"name_label\":\"Name:\",\"email_label\":\"Email:\",\"subject_label\":\"Subject:\",\"message_label\":\"Message:\",\"email_recipient\":\"\",\"button_text\":\"Send Message\",\"page_text\":\"Thank you for your contact.\",\"error_text\":\"Your message could not be sent. Please try again.\",\"no_email\":\"Please write your email\",\"invalid_email\":\"Please write a valid email\",\"from_name\":\"\",\"from_email\":\"\",\"exact_url\":\"1\",\"disable_https\":\"0\",\"pre_text\":\"We welcome your feedback and invite you to let us know if you have trouble accessing this site. Please send us an email using this form and describe the problem in as much detail as possible, including the URL of the page you were on, the type of problem, and any other information that you would deem necessary for us to better diagnose and resolve the issue.\",\"fixed_url\":\"0\",\"fixed_url_address\":\"\",\"enable_anti_spam\":\"1\",\"anti_spam_q\":\"How many eyes has a typical person?\",\"anti_spam_a\":\"2\",\"moduleclass_sfx\":\"\"}',0,'*');
INSERT INTO `#__modules` VALUES (53,'Members','','',6,'cpanel',0,'0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00',1,'mod_members',1,1,'{\"cache\":\"1\"}',1,'*');
INSERT INTO `#__modules` VALUES (54, 'Who\'s Online', '', '', '5', 'cpanel', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_whosonline', '1', '1', '{\"display_limit\":\"25\"}', '1', '*');

--
-- HUBzero sample data for table `#__modules_menu`
--

TRUNCATE `#__modules_menu`;
INSERT INTO `#__modules_menu` VALUES (1,0);
INSERT INTO `#__modules_menu` VALUES (2,0);
INSERT INTO `#__modules_menu` VALUES (3,0);
INSERT INTO `#__modules_menu` VALUES (4,0);
INSERT INTO `#__modules_menu` VALUES (5,0);
INSERT INTO `#__modules_menu` VALUES (6,0);
INSERT INTO `#__modules_menu` VALUES (7,0);
INSERT INTO `#__modules_menu` VALUES (8,0);
INSERT INTO `#__modules_menu` VALUES (10,0);
INSERT INTO `#__modules_menu` VALUES (11,0);
INSERT INTO `#__modules_menu` VALUES (12,0);
INSERT INTO `#__modules_menu` VALUES (13,0);
INSERT INTO `#__modules_menu` VALUES (14,0);
INSERT INTO `#__modules_menu` VALUES (15,0);
INSERT INTO `#__modules_menu` VALUES (16,0);
INSERT INTO `#__modules_menu` VALUES (17,0);
INSERT INTO `#__modules_menu` VALUES (18,0);
INSERT INTO `#__modules_menu` VALUES (19,100);
INSERT INTO `#__modules_menu` VALUES (20,100);
INSERT INTO `#__modules_menu` VALUES (21,100);
INSERT INTO `#__modules_menu` VALUES (22,100);
INSERT INTO `#__modules_menu` VALUES (23,100);
INSERT INTO `#__modules_menu` VALUES (24,0);
INSERT INTO `#__modules_menu` VALUES (25,0);
INSERT INTO `#__modules_menu` VALUES (26,0);
INSERT INTO `#__modules_menu` VALUES (27,0);
INSERT INTO `#__modules_menu` VALUES (28,0);
INSERT INTO `#__modules_menu` VALUES (29,0);
INSERT INTO `#__modules_menu` VALUES (30,0);
INSERT INTO `#__modules_menu` VALUES (31,7);
INSERT INTO `#__modules_menu` VALUES (31,9);
INSERT INTO `#__modules_menu` VALUES (31,10);
INSERT INTO `#__modules_menu` VALUES (31,15);
INSERT INTO `#__modules_menu` VALUES (31,17);
INSERT INTO `#__modules_menu` VALUES (31,19);
INSERT INTO `#__modules_menu` VALUES (31,46);
INSERT INTO `#__modules_menu` VALUES (31,65);
INSERT INTO `#__modules_menu` VALUES (31,66);
INSERT INTO `#__modules_menu` VALUES (31,67);
INSERT INTO `#__modules_menu` VALUES (31,68);
INSERT INTO `#__modules_menu` VALUES (31,97);
INSERT INTO `#__modules_menu` VALUES (32,69);
INSERT INTO `#__modules_menu` VALUES (32,70);
INSERT INTO `#__modules_menu` VALUES (32,71);
INSERT INTO `#__modules_menu` VALUES (32,72);
INSERT INTO `#__modules_menu` VALUES (32,73);
INSERT INTO `#__modules_menu` VALUES (32,74);
INSERT INTO `#__modules_menu` VALUES (32,75);
INSERT INTO `#__modules_menu` VALUES (32,96);
INSERT INTO `#__modules_menu` VALUES (45,0);
INSERT INTO `#__modules_menu` VALUES (46,12);
INSERT INTO `#__modules_menu` VALUES (47,0);
INSERT INTO `#__modules_menu` VALUES (49,100);
INSERT INTO `#__modules_menu` VALUES (50,95);
INSERT INTO `#__modules_menu` VALUES (51,100);
INSERT INTO `#__modules_menu` VALUES (52,75);
INSERT INTO `#__modules_menu` VALUES (53,0);
INSERT INTO `#__modules_menu` VALUES (54,0);

--
-- HUBzero sample data for table `#__password_blacklist`
--

INSERT INTO `#__password_blacklist` (`id`, `word`) VALUES (1,'hubzero');
INSERT INTO `#__password_blacklist` (`id`, `word`) VALUES (2,'test');
INSERT INTO `#__password_blacklist` (`id`, `word`) VALUES (3,'password');
INSERT INTO `#__password_blacklist` (`id`, `word`) VALUES (4,'secret');

--
-- HUBzero sample data for table `#__password_rule`
--

INSERT INTO `#__password_rule` VALUES ('','Must be changed at least every 120 days',0,'Must be changed at least every 120 days','hub',20,10,'notStale','120');
INSERT INTO `#__password_rule` VALUES ('','Must be different than the previous password (re-use of the same password will not be allowed for one (1) year)',0,'Must be different than the previous password (re-use of the same password will not be allowed for one (1) year)','hub',19,9,'notReused','365');
INSERT INTO `#__password_rule` VALUES ('','Must not contain your username',0,'Must not contain your username','hub',18,8,'notUsernameBased','');
INSERT INTO `#__password_rule` VALUES ('','Must not contain your name or parts of your name',0,'Must not contain your name or parts of your name','hub',17,7,'notNameBased','');
INSERT INTO `#__password_rule` VALUES ('','Must not contain easily guessed words',1,'Must not contain easily guessed words','hub',16,6,'notBlacklisted','');
INSERT INTO `#__password_rule` VALUES ('','Must contain more than 4 unique characters',1,'Must contain more than 4 unique characters','hub',15,5,'minUniqueCharacters','5');
INSERT INTO `#__password_rule` VALUES ('','Must be no longer than 16 characters',1,'Must be no longer than 16 characters','hub',14,4,'maxPasswordLength','16');
INSERT INTO `#__password_rule` VALUES ('','Must be at least 8 characters long',1,'Must be at least 8 characters long','hub',13,3,'minPasswordLength','8');
INSERT INTO `#__password_rule` VALUES ('nonalpha','Must contain at least 1 number or punctuation mark',1,'Must contain at least 1 number or punctuation mark','hub',12,2,'minClassCharacters','1');
INSERT INTO `#__password_rule` VALUES ('alpha','Must contain at least 1 letter',1,'Must contain at least 1 letter','hub',11,1,'minClassCharacters','1');

--
-- HUBzero sample data for table `#__publication_blocks`
--

INSERT INTO `#__publication_blocks` (`id`, `block`, `label`, `title`, `status`, `minimum`, `maximum`, `ordering`, `params`, `manifest`) VALUES (1,'content','Content','Publication Content',1,1,5,1,'','');
INSERT INTO `#__publication_blocks` (`id`, `block`, `label`, `title`, `status`, `minimum`, `maximum`, `ordering`, `params`, `manifest`) VALUES (2,'description','Description','Publication Description',1,1,5,2,'','');
INSERT INTO `#__publication_blocks` (`id`, `block`, `label`, `title`, `status`, `minimum`, `maximum`, `ordering`, `params`, `manifest`) VALUES (3,'authors','Authors','Publication Authors',1,1,1,3,'','');
INSERT INTO `#__publication_blocks` (`id`, `block`, `label`, `title`, `status`, `minimum`, `maximum`, `ordering`, `params`, `manifest`) VALUES (4,'extras','Extras','Publication Extra Content',1,0,1,4,'default=1','');
INSERT INTO `#__publication_blocks` (`id`, `block`, `label`, `title`, `status`, `minimum`, `maximum`, `ordering`, `params`, `manifest`) VALUES (5,'license','License','Publication Tags',1,0,1,5,'default=1','');
INSERT INTO `#__publication_blocks` (`id`, `block`, `label`, `title`, `status`, `minimum`, `maximum`, `ordering`, `params`, `manifest`) VALUES (6,'tags','Tags','Publication Tags',1,0,1,6,'default=1','');
INSERT INTO `#__publication_blocks` (`id`, `block`, `label`, `title`, `status`, `minimum`, `maximum`, `ordering`, `params`, `manifest`) VALUES (7,'notes','Notes','Version Release Notes',1,0,1,7,'default=1','');
INSERT INTO `#__publication_blocks` (`id`, `block`, `label`, `title`, `status`, `minimum`, `maximum`, `ordering`, `params`, `manifest`) VALUES (8,'review','Review','Publication Review',1,1,1,8,'default=1','');

--
-- HUBzero sample data for table `#__publication_handlers`
--

INSERT INTO `#__publication_handlers` (`id`, `name`, `label`, `title`, `status`, `about`, `params`) VALUES (1,'imageviewer','Image Viewer','Image Gallery Presenter',1,'','');

--
-- HUBzero sample data for table `#__resource_licenses`
--

INSERT INTO `#__resource_licenses` (`id`, `name`, `text`, `title`, `ordering`, `apps_only`, `main`, `icon`, `url`, `agreement`, `info`) VALUES (1,'cc25-by-nc-sa','You are free:\r\n\r\nto Share — to copy, distribute and transmit the work\r\nto Remix — to adapt the work\r\n\r\nUnder the following conditions:\r\n\r\nAttribution — You must attribute the work in the manner specified by the author or licensor (but not in any way that suggests that they endorse you or your use of the work).\r\nNoncommercial — You may not use this work for commercial purposes.\r\n\r\nShare Alike — If you alter, transform, or build upon this work, you may distribute the resulting work only under the same or similar license to this one.\r\n\r\nWith the understanding that:\r\n\r\nWaiver — Any of the above conditions can be waived if you get permission from the copyright holder.\r\n\r\nPublic Domain — Where the work or any of its elements is in the public domain under applicable law, that status is in no way affected by the license.\r\n\r\nOther Rights — In no way are any of the following rights affected by the license:\r\n- Your fair dealing or fair use rights, or other applicable copyright exceptions and limitations;\r\n- The author\'s moral rights;\r\n- Rights other persons may have either in the work itself or in how the work is used, such as publicity or privacy rights.\r\n\r\nNotice — For any reuse or distribution, you must make clear to others the license terms of this work. The best way to do this is with a link to this web page.','Creative Commons BY-NC-SA 2.5',6,0,NULL,NULL,'http://creativecommons.org/licenses/by-nc-sa/2.5/',0,NULL);
INSERT INTO `#__resource_licenses` (`id`, `name`, `text`, `title`, `ordering`, `apps_only`, `main`, `icon`, `url`, `agreement`, `info`) VALUES (2,'cc30-by-nc-sa','You are free:\r\n\r\nto Share — to copy, distribute and transmit the work\r\nto Remix — to adapt the work\r\n\r\nUnder the following conditions:\r\n\r\nAttribution — You must attribute the work in the manner specified by the author or licensor (but not in any way that suggests that they endorse you or your use of the work).\r\n\r\nNoncommercial — You may not use this work for commercial purposes.\r\n\r\nShare Alike — If you alter, transform, or build upon this work, you may distribute the resulting work only under the same or similar license to this one.\r\n\r\nWith the understanding that:\r\n\r\nWaiver — Any of the above conditions can be waived if you get permission from the copyright holder.\r\n\r\nPublic Domain — Where the work or any of its elements is in the public domain under applicable law, that status is in no way affected by the license.\r\n\r\nOther Rights — In no way are any of the following rights affected by the license:\r\n- Your fair dealing or fair use rights, or other applicable copyright exceptions and limitations;\r\n- The author\'s moral rights;\r\n- Rights other persons may have either in the work itself or in how the work is used, such as publicity or privacy rights.','Creative Commons BY-NC-SA 3.0',7,0,NULL,NULL,'http://creativecommons.org/licenses/by-nc-sa/3.0/',0,NULL);
INSERT INTO `#__resource_licenses` (`id`, `name`, `text`, `title`, `ordering`, `apps_only`, `main`, `icon`, `url`, `agreement`, `info`) VALUES (3,'cc','You are free:\r\n\r\nto Share — to copy, distribute and transmit the work\r\nto Remix — to adapt the work\r\n\r\nUnder the following conditions:\r\n\r\nAttribution — You must attribute the work in the manner specified by the author or licensor (but not in any way that suggests that they endorse you or your use of the work).\r\nNoncommercial — You may not use this work for commercial purposes.\r\n\r\nShare Alike — If you alter, transform, or build upon this work, you may distribute the resulting work only under the same or similar license to this one.\r\n\r\nWith the understanding that:\r\n\r\nWaiver — Any of the above conditions can be waived if you get permission from the copyright holder.\r\n\r\nPublic Domain — Where the work or any of its elements is in the public domain under applicable law, that status is in no way affected by the license.\r\n\r\nOther Rights — In no way are any of the following rights affected by the license:\r\n- Your fair dealing or fair use rights, or other applicable copyright exceptions and limitations;\r\n- The author\'s moral rights;\r\n- Rights other persons may have either in the work itself or in how the work is used, such as publicity or privacy rights.\r\n\r\nNotice — For any reuse or distribution, you must make clear to others the license terms of this work. The best way to do this is with a link to this web page.','Creative Commons',1,0,NULL,NULL,'http://creativecommons.org/licenses/by-nc-sa/2.5/',0,NULL);
INSERT INTO `#__resource_licenses` (`id`, `name`, `text`, `title`, `ordering`, `apps_only`, `main`, `icon`, `url`, `agreement`, `info`) VALUES (4,'cc30-by-nc-nd','You are free:\r\n\r\nto Share — to copy, distribute and transmit the work\r\n\r\nUnder the following conditions:\r\n\r\nAttribution — You must attribute the work in the manner specified by the author or licensor (but not in any way that suggests that they endorse you or your use of the work).\r\n\r\nNoncommercial — You may not use this work for commercial purposes.\r\n\r\nNo Derivative Works — You may not alter, transform, or build upon this work.\r\nWith the understanding that:\r\n\r\nWaiver — Any of the above conditions can be waived if you get permission from the copyright holder.\r\n\r\nPublic Domain — Where the work or any of its elements is in the public domain under applicable law, that status is in no way affected by the license.\r\n\r\nOther Rights — In no way are any of the following rights affected by the license:\r\n- Your fair dealing or fair use rights, or other applicable copyright exceptions and limitations;\r\n- The author\'s moral rights;\r\n- Rights other persons may have either in the work itself or in how the work is used, such as publicity or privacy rights.','Creative Commons BY-NC-ND 3.0',8,0,NULL,NULL,'http://creativecommons.org/licenses/by-nc-nd/3.0/',0,NULL);
INSERT INTO `#__resource_licenses` (`id`, `name`, `text`, `title`, `ordering`, `apps_only`, `main`, `icon`, `url`, `agreement`, `info`) VALUES (5,'cc30-by','You are free:\r\n\r\nto Share — to copy, distribute and transmit the work\r\nto Remix — to adapt the work\r\nto make commercial use of the work\r\n\r\nUnder the following conditions:\r\n\r\nAttribution — You must attribute the work in the manner specified by the author or licensor (but not in any way that suggests that they endorse you or your use of the work).\r\nWith the understanding that:\r\n\r\nWaiver — Any of the above conditions can be waived if you get permission from the copyright holder.\r\n\r\nPublic Domain — Where the work or any of its elements is in the public domain under applicable law, that status is in no way affected by the license.\r\n\r\nOther Rights — In no way are any of the following rights affected by the license:\r\n- Your fair dealing or fair use rights, or other applicable copyright exceptions and limitations;\r\n- The author\'s moral rights;\r\n- Rights other persons may have either in the work itself or in how the work is used, such as publicity or privacy rights.','Creative Commons BY 3.0',2,0,NULL,NULL,'http://creativecommons.org/licenses/by/3.0/',0,NULL);
INSERT INTO `#__resource_licenses` (`id`, `name`, `text`, `title`, `ordering`, `apps_only`, `main`, `icon`, `url`, `agreement`, `info`) VALUES (6,'cc30-by-sa','You are free:\r\n\r\nto Share — to copy, distribute and transmit the work\r\nto Remix — to adapt the work\r\nto make commercial use of the work\r\n\r\nUnder the following conditions:\r\n\r\nAttribution — You must attribute the work in the manner specified by the author or licensor (but not in any way that suggests that they endorse you or your use of the work).\r\n\r\nShare Alike — If you alter, transform, or build upon this work, you may distribute the resulting work only under the same or similar license to this one.\r\nWith the understanding that:\r\n\r\nWaiver — Any of the above conditions can be waived if you get permission from the copyright holder.\r\n\r\nPublic Domain — Where the work or any of its elements is in the public domain under applicable law, that status is in no way affected by the license.\r\n\r\nOther Rights — In no way are any of the following rights affected by the license:\r\n- Your fair dealing or fair use rights, or other applicable copyright exceptions and limitations;\r\n- The author\'s moral rights;\r\n- Rights other persons may have either in the work itself or in how the work is used, such as publicity or privacy rights.','Creative Commons BY-SA 3.0',3,0,NULL,NULL,'http://creativecommons.org/licenses/by-sa/3.0/',0,NULL);
INSERT INTO `#__resource_licenses` (`id`, `name`, `text`, `title`, `ordering`, `apps_only`, `main`, `icon`, `url`, `agreement`, `info`) VALUES (7,'cc30-by-nd','You are free:\r\n\r\nto Share — to copy, distribute and transmit the work\r\nto make commercial use of the work\r\n\r\nUnder the following conditions:\r\n\r\nAttribution — You must attribute the work in the manner specified by the author or licensor (but not in any way that suggests that they endorse you or your use of the work).\r\n\r\nNo Derivative Works — You may not alter, transform, or build upon this work.\r\n\r\nWith the understanding that:\r\n\r\nWaiver — Any of the above conditions can be waived if you get permission from the copyright holder.\r\n\r\nPublic Domain — Where the work or any of its elements is in the public domain under applicable law, that status is in no way affected by the license.\r\n\r\nOther Rights — In no way are any of the following rights affected by the license:\r\n- Your fair dealing or fair use rights, or other applicable copyright exceptions and limitations;\r\nThe author\'s moral rights;\r\n- Rights other persons may have either in the work itself or in how the work is used, such as publicity or privacy rights.','Creative Commons BY-ND 3.0',4,0,NULL,NULL,'http://creativecommons.org/licenses/by-nd/3.0/',0,NULL);
INSERT INTO `#__resource_licenses` (`id`, `name`, `text`, `title`, `ordering`, `apps_only`, `main`, `icon`, `url`, `agreement`, `info`) VALUES (8,'cc30-by-nc','You are free:\r\n\r\nto Share — to copy, distribute and transmit the work\r\nto Remix — to adapt the work\r\n\r\nUnder the following conditions:\r\n\r\nAttribution — You must attribute the work in the manner specified by the author or licensor (but not in any way that suggests that they endorse you or your use of the work).\r\n\r\nNoncommercial — You may not use this work for commercial purposes.\r\n\r\nWith the understanding that:\r\n\r\nWaiver — Any of the above conditions can be waived if you get permission from the copyright holder.\r\n\r\nPublic Domain — Where the work or any of its elements is in the public domain under applicable law, that status is in no way affected by the license.\r\n\r\nOther Rights — In no way are any of the following rights affected by the license:\r\n- Your fair dealing or fair use rights, or other applicable copyright exceptions and limitations;\r\n- The author\'s moral rights;\r\n- Rights other persons may have either in the work itself or in how the work is used, such as publicity or privacy rights.','Creative Commons BY-NC 3.0',5,0,NULL,NULL,'http://creativecommons.org/licenses/by-nc/3.0/',0,NULL);

--
-- HUBzero sample data for table `#__resource_types`
--

INSERT INTO `#__resource_types` VALUES ('1', 'seminars', 'Seminars', '27', 'A lecture of some sort, usually recorded with voice or video.  It may be a graduate or undergraduate level seminar, a lecture for a class, or a tutorial presentation.', '1', '{\"fields\":[{\"default\":\"\",\"name\":\"bio\",\"label\":\"Bio\",\"type\":\"textarea\",\"required\":\"0\"},{\"default\":\"\",\"name\":\"credits\",\"label\":\"Credits\",\"type\":\"textarea\",\"required\":\"0\"},{\"default\":\"\",\"name\":\"sponsoredby\",\"label\":\"Sponsored by\",\"type\":\"textarea\",\"required\":\"0\"}]}', 'plg_share=0\nplg_favorite=0\nplg_versions=0\nplg_reviews=0\nplg_questions=0\nplg_wishlist=0\nplg_usage=0\nplg_related=0\nplg_recommendations=0\nplg_citations=0\nplg_supportingdocs=0\nplg_usagenew=0\nplg_about=1\nplg_abouttool=0');
INSERT INTO `#__resource_types` VALUES ('2', 'workshops', 'Workshops', '27', 'A collection of lectures, seminars, and materials that were presented at a workshop.', '0', 'credits=Credits=textarea=0\nsponsoredby=Sponsored by=textarea=0', 'plg_citations=0\nplg_questions=0\nplg_recommendations=1\nplg_related=1\nplg_reviews=1\nplg_usage=0\nplg_versions=0\nplg_favorite=1\nplg_share=1\nplg_wishlist=0\nplg_supportingdocs=1\nplg_about=1\nplg_abouttool=0');
INSERT INTO `#__resource_types` VALUES ('3', 'publications', 'Publications', '27', 'Articles, technical reports, theses, and other documents, usually in PDF or DOC format.', '1', 'acknowledgments=Acknowledgments=textarea=0\nreferences=References=textarea=0', 'plg_citations=0\nplg_questions=0\nplg_recommendations=1\nplg_related=1\nplg_reviews=1\nplg_usage=0\nplg_versions=0\nplg_favorite=1\nplg_share=1\nplg_wishlist=0\nplg_supportingdocs=1\nplg_about=1\nplg_abouttool=0');
INSERT INTO `#__resource_types` VALUES ('6', 'courses', 'Courses', '27', 'University courses and short courses with lectures and associated teaching materials.', '0', 'credits=Credits=textarea=0\nreferences=References=textarea=0\nsponsoredby=Sponsored by=textarea=0', 'plg_citations=0\nplg_questions=0\nplg_recommendations=1\nplg_related=1\nplg_reviews=1\nplg_usage=0\nplg_versions=0\nplg_favorite=1\nplg_share=1\nplg_wishlist=0\nplg_supportingdocs=1\nplg_about=1\nplg_abouttool=0');
INSERT INTO `#__resource_types` VALUES ('7', 'tools', 'Tools', '27', 'Simulation and modeling tools that can be accessed via a web browser.', '1', 'poweredby=Powered by=textarea=0\ncredits=Credits=textarea=0\nsponsoredby=Sponsored by=textarea=0\nreferences=References=textarea=0', 'plg_citations=1\nplg_questions=1\nplg_recommendations=1\nplg_related=1\nplg_reviews=1\nplg_usage=1\nplg_versions=1\nplg_favorite=1\nplg_share=1\nplg_wishlist=1\nplg_supportingdocs=1\nplg_about=0\nplg_abouttool=1');
INSERT INTO `#__resource_types` VALUES ('9', 'downloads', 'Downloads', '27', 'Spreadsheets, executables, and other items that are available for download but don\\\'t fit into other categories.', '1', '{\"fields\":[{\"default\":\"\",\"name\":\"credits\",\"label\":\"Credits\",\"type\":\"textarea\",\"required\":\"0\"},{\"default\":\"\",\"name\":\"sponsoredby\",\"label\":\"Sponsored by\",\"type\":\"textarea\",\"required\":\"0\"},{\"default\":\"\",\"name\":\"references\",\"label\":\"References\",\"type\":\"text\",\"required\":\"0\"}]}', 'plg_share=1\nplg_favorite=1\nplg_versions=0\nplg_reviews=1\nplg_questions=0\nplg_wishlist=0\nplg_usage=0\nplg_related=1\nplg_recommendations=1\nplg_citations=0\nplg_supportingdocs=1\nplg_usagenew=0\nplg_about=1\nplg_abouttool=0');
INSERT INTO `#__resource_types` VALUES ('11', 'elink', 'External Link', '30', NULL, '1', NULL, NULL);
INSERT INTO `#__resource_types` VALUES ('12', 'ilink', 'Internal Link', '30', NULL, '1', NULL, NULL);
INSERT INTO `#__resource_types` VALUES ('13', 'file', 'File', '30', '', '1', '{\"fields\":[]}', 'linkAction=extension\nplg_share=0\nplg_favorite=0\nplg_versions=0\nplg_reviews=0\nplg_questions=0\nplg_wishlist=0\nplg_usage=0\nplg_related=0\nplg_recommendations=0\nplg_citations=0\nplg_supportingdocs=0\nplg_usagenew=0\nplg_about=0\nplg_abouttool=0');
INSERT INTO `#__resource_types` VALUES ('14', 'presentationslides', 'Presentation Slides', '28', '', '1', '{\"fields\":[]}', 'linkAction=extension\nplg_share=0\nplg_favorite=0\nplg_versions=0\nplg_reviews=0\nplg_questions=0\nplg_wishlist=0\nplg_usage=0\nplg_related=0\nplg_recommendations=0\nplg_citations=0\nplg_supportingdocs=0\nplg_usagenew=0\nplg_about=0\nplg_abouttool=0');
INSERT INTO `#__resource_types` VALUES ('15', 'quicktime', 'Quicktime', '30', NULL, '1', NULL, NULL);
INSERT INTO `#__resource_types` VALUES ('19', 'presentation', 'Presentation (without audio)', '28', NULL, '1', NULL, NULL);
INSERT INTO `#__resource_types` VALUES ('20', 'presentation_audio', 'Presentation (with audio)', '28', NULL, '1', NULL, NULL);
INSERT INTO `#__resource_types` VALUES ('21', NULL, 'Sub Type', '0', NULL, '1', NULL, NULL);
INSERT INTO `#__resource_types` VALUES ('22', 'researchseminars', 'Research Seminars', '21', '', '1', '{\"fields\":[]}', 'linkAction=extension\nplg_share=0\nplg_favorite=0\nplg_versions=0\nplg_reviews=0\nplg_questions=0\nplg_wishlist=0\nplg_usage=0\nplg_related=0\nplg_recommendations=0\nplg_citations=0\nplg_supportingdocs=0\nplg_usagenew=0\nplg_about=0\nplg_abouttool=0');
INSERT INTO `#__resource_types` VALUES ('26', 'flash_paper', 'Flash Paper', '30', NULL, '1', NULL, NULL);
INSERT INTO `#__resource_types` VALUES ('27', NULL, 'Main Types', '0', NULL, '1', NULL, NULL);
INSERT INTO `#__resource_types` VALUES ('28', NULL, 'Logical Type', '0', NULL, '1', NULL, NULL);
INSERT INTO `#__resource_types` VALUES ('29', NULL, 'Group', '0', NULL, '1', NULL, NULL);
INSERT INTO `#__resource_types` VALUES ('30', NULL, 'Type', '0', NULL, '1', NULL, NULL);
INSERT INTO `#__resource_types` VALUES ('31', 'series', 'Series', '27', 'Series are collections of lectures, publications, and other resources presented as a list.  Each series is available as a podcast feed.', '0', 'credits=Credits=textarea=0\nsponsoredby=Sponsored by=textarea=0\nreferences=References=textarea=0', 'plg_citations=0\nplg_questions=0\nplg_recommendations=1\nplg_related=1\nplg_reviews=1\nplg_usage=0\nplg_versions=0\nplg_favorite=1\nplg_share=1\nplg_wishlist=0\nplg_supportingdocs=1\nplg_about=1\nplg_abouttool=0');
INSERT INTO `#__resource_types` VALUES ('32', 'breeze', 'Breeze', '30', NULL, '1', NULL, NULL);
INSERT INTO `#__resource_types` VALUES ('33', 'pdf', 'PDF', '30', NULL, '1', NULL, NULL);
INSERT INTO `#__resource_types` VALUES ('34', 'quiz', 'Quiz', '28', NULL, '1', NULL, NULL);
INSERT INTO `#__resource_types` VALUES ('35', 'powerpoint', 'PowerPoint', '30', NULL, '1', NULL, NULL);
INSERT INTO `#__resource_types` VALUES ('36', 'poster', 'Poster', '28', '', '1', '{\"fields\":[]}', 'linkAction=extension\nplg_share=0\nplg_favorite=0\nplg_versions=0\nplg_reviews=0\nplg_questions=0\nplg_wishlist=0\nplg_usage=0\nplg_related=0\nplg_recommendations=0\nplg_citations=0\nplg_supportingdocs=0\nplg_usagenew=0\nplg_about=0\nplg_abouttool=0');
INSERT INTO `#__resource_types` VALUES ('37', 'player', 'Media Player', '30', NULL, '1', NULL, NULL);
INSERT INTO `#__resource_types` VALUES ('38', 'package', 'Package', '30', NULL, '1', NULL, NULL);
INSERT INTO `#__resource_types` VALUES ('39', 'teachingmaterials', 'Teaching Materials', '27', 'Supplementary materials (study notes, guides, etc.) that don\\\'t quite fit into any of the other categories.', '1', 'references=References=textarea=0', 'plg_citations=0\nplg_questions=0\nplg_recommendations=1\nplg_related=1\nplg_reviews=1\nplg_usage=0\nplg_versions=0\nplg_favorite=1\nplg_share=1\nplg_wishlist=0\nplg_supportingdocs=1\nplg_about=1\nplg_abouttool=0');
INSERT INTO `#__resource_types` VALUES ('40', 'video_stream', 'Video Stream', '28', NULL, '1', NULL, NULL);
INSERT INTO `#__resource_types` VALUES ('41', 'video', 'Video', '30', NULL, '1', NULL, NULL);
INSERT INTO `#__resource_types` VALUES ('48', 'tutorials', 'Tutorials', '21', '', '1', '{\"fields\":[]}', 'linkAction=extension\nplg_share=0\nplg_favorite=0\nplg_versions=0\nplg_reviews=0\nplg_questions=0\nplg_wishlist=0\nplg_usage=0\nplg_related=0\nplg_recommendations=0\nplg_citations=0\nplg_supportingdocs=0\nplg_usagenew=0\nplg_about=0\nplg_abouttool=0');
INSERT INTO `#__resource_types` VALUES ('49', 'podcastaudio', 'Podcast (audio)', '28', '', '1', '{\"fields\":[]}', 'linkAction=extension\nplg_share=0\nplg_favorite=0\nplg_versions=0\nplg_reviews=0\nplg_questions=0\nplg_wishlist=0\nplg_usage=0\nplg_related=0\nplg_recommendations=0\nplg_citations=0\nplg_supportingdocs=0\nplg_usagenew=0\nplg_about=0\nplg_abouttool=0');
INSERT INTO `#__resource_types` VALUES ('50', 'podcastvideo', 'Podcast (video)', '28', '', '1', '{\"fields\":[]}', 'linkAction=extension\nplg_share=0\nplg_favorite=0\nplg_versions=0\nplg_reviews=0\nplg_questions=0\nplg_wishlist=0\nplg_usage=0\nplg_related=0\nplg_recommendations=0\nplg_citations=0\nplg_supportingdocs=0\nplg_usagenew=0\nplg_about=0\nplg_abouttool=0');
INSERT INTO `#__resource_types` VALUES ('51', 'homeworkassignment', 'Homework Assignment', '28', '', '1', '{\"fields\":[]}', 'linkAction=extension\nplg_share=0\nplg_favorite=0\nplg_versions=0\nplg_reviews=0\nplg_questions=0\nplg_wishlist=0\nplg_usage=0\nplg_related=0\nplg_recommendations=0\nplg_citations=0\nplg_supportingdocs=0\nplg_usagenew=0\nplg_about=0\nplg_abouttool=0');
INSERT INTO `#__resource_types` VALUES ('54', 'courselectures', 'Course Lectures', '21', '', '1', '{\"fields\":[]}', 'linkAction=extension\nplg_share=0\nplg_favorite=0\nplg_versions=0\nplg_reviews=0\nplg_questions=0\nplg_wishlist=0\nplg_usage=0\nplg_related=0\nplg_recommendations=0\nplg_citations=0\nplg_supportingdocs=0\nplg_usagenew=0\nplg_about=0\nplg_abouttool=0');
INSERT INTO `#__resource_types` VALUES ('55', 'thesis', 'Ph.D. Thesis', '28', NULL, '1', NULL, NULL);
INSERT INTO `#__resource_types` VALUES ('56', 'publicationpreprint', 'Publication Preprint', '28', '', '1', '{\"fields\":[]}', 'linkAction=extension\nplg_share=0\nplg_favorite=0\nplg_versions=0\nplg_reviews=0\nplg_questions=0\nplg_wishlist=0\nplg_usage=0\nplg_related=0\nplg_recommendations=0\nplg_citations=0\nplg_supportingdocs=0\nplg_usagenew=0\nplg_about=0\nplg_abouttool=0');
INSERT INTO `#__resource_types` VALUES ('57', 'handout', 'Handout', '28', NULL, '1', NULL, NULL);
INSERT INTO `#__resource_types` VALUES ('58', 'undergraduatepresentation', 'Undergraduate Presentation', '21', '', '1', '{\"fields\":[]}', 'linkAction=extension\nplg_share=0\nplg_favorite=0\nplg_versions=0\nplg_reviews=0\nplg_questions=0\nplg_wishlist=0\nplg_usage=0\nplg_related=0\nplg_recommendations=0\nplg_citations=0\nplg_supportingdocs=0\nplg_usagenew=0\nplg_about=0\nplg_abouttool=0');
INSERT INTO `#__resource_types` VALUES ('59', 'manual', 'Manual', '28', NULL, '1', NULL, NULL);
INSERT INTO `#__resource_types` VALUES ('60', 'software_download', 'Software Download', '28', NULL, '1', NULL, NULL);
INSERT INTO `#__resource_types` VALUES ('62', 'hubpresenter', 'HUBpresenter', '30', 'HTML5 Breeze Replacement', '1', NULL, NULL);
INSERT INTO `#__resource_types` VALUES ('63', 'html5video', 'HTML5 Video', '28', 'HTML5 Video with Subtitle support!', '1', NULL, NULL);

--
-- HUBzero sample data for table `#__support_acl_acos`
--

INSERT INTO `#__support_acl_acos` (`id`, `model`, `foreign_key`) VALUES (1,'tickets',0);
INSERT INTO `#__support_acl_acos` (`id`, `model`, `foreign_key`) VALUES (2,'comments',0);
INSERT INTO `#__support_acl_acos` (`id`, `model`, `foreign_key`) VALUES (3,'private_comments',0);

--
-- HUBzero sample data for table `#__support_messages`
--

INSERT INTO `#__support_messages` VALUES (1,'First Contact (no further information needed)','Thank you for using {sitename}, and for reporting this problem.  Your request has been forwarded to a member of our team, and it is being tracked as ticket {ticket#} in our system.  We will keep you informed as we make progress in resolving this issue.\r\n\r\nThanks again for your support!\r\n--the {sitename} team');
INSERT INTO `#__support_messages` VALUES (2,'First Contact (more information is needed)','Thank you for using {sitename}, and for reporting this problem.  Your request has been forwarded to a member of our team, and it is being tracked as ticket {ticket#} in our system.\r\n\r\nIn order to resolve this issue, we need some more information:\r\n\r\nXXXXXXX  Input questions here XXXXXX\r\n\r\nPlease reply back to {siteemail} with the requested information. If we haven\\\'t heard back from you in 48 hours, we\\\'ll assume that you are no longer experiencing the problem, or that you\\\'ve worked around it, and we\\\'ll consider the matter closed.  You can reopen the matter at any time by sending email or by submitting another problem report on our web site.\r\n\r\nThanks again for your support!\r\n--the {sitename} team');
INSERT INTO `#__support_messages` VALUES (3,'Final Contact (closing ticket)','We have not heard back from you so we will assume that you are no longer experiencing the problem, or that you\\\'ve worked around it, and we\\\'ll consider the matter closed.  You can reopen the matter at any time by sending email or by submitting another problem report on our web site.\r\n\r\nThanks again for your support!\r\n--the {sitename} team');
INSERT INTO `#__support_messages` VALUES (4,'Ticket Resolved','Thank you for using {sitename}, and for reporting this problem.  We believe that your issue (ticket {ticket#} in our system) has been resolved. If you continue to have problems please let us know.\r\n\r\nThank you for helping us to improve {sitename}!\r\n--the {sitename} team');
INSERT INTO `#__support_messages` VALUES (5,'Reply to tickets that have been in the queue for a while','Thank you for using {sitename}.  We apologize for not responding to your request sooner.  We have received more support requests than we can handle, and we are working hard to improve our help-desk support.\r\n\r\nYour request was concerning XXXXXXXXXXXXX. \r\n\r\nMany problems have been fixed since your message.  Is this still a problem for you now?  Is there any more information you could give us about this? Please reply back to {siteemail} with any additional information. If we haven\\\'t heard back from you in 48 hours, we\\\'ll assume that you are no longer experiencing the problem, or that it is no longer an issue for you, and we\\\'ll consider the matter closed.  You can reopen the matter at any time by sending email or by submitting another problem report on our web site.\r\n\r\nThanks again for your support!\r\n--the {sitename} team');

--
-- HUBzero sample data for table `#__support_resolutions`
--

INSERT INTO `#__support_resolutions` VALUES (1,'Fixed','fixed');
INSERT INTO `#__support_resolutions` VALUES (2,'Invalid','invalid');
INSERT INTO `#__support_resolutions` VALUES (3,'Won\'t fix','wontfix');
INSERT INTO `#__support_resolutions` VALUES (4,'Duplicate','duplicate');
INSERT INTO `#__support_resolutions` VALUES (5,'Works for me','worksforme');
INSERT INTO `#__support_resolutions` VALUES (6,'Transferred','transferred');
INSERT INTO `#__support_resolutions` VALUES (7,'Answered','answered');

--
-- HUBzero sample data for table `#__support_resolutions`
--

INSERT INTO `#__support_statuses` (`id`, `open`, `title`, `alias`, `color`) VALUES (1,1,'Open','open','');
INSERT INTO `#__support_statuses` (`id`, `open`, `title`, `alias`, `color`) VALUES (2,1,'Waiting response','waiting','');
INSERT INTO `#__support_statuses` (`id`, `open`, `title`, `alias`, `color`) VALUES (3,1,'Waiting review','waitingreview','');
INSERT INTO `#__support_statuses` (`id`, `open`, `title`, `alias`, `color`) VALUES (4,1,'Pending update','pendingupdate','');
INSERT INTO `#__support_statuses` (`id`, `open`, `title`, `alias`, `color`) VALUES (5,0,'Fixed','fixed','');
INSERT INTO `#__support_statuses` (`id`, `open`, `title`, `alias`, `color`) VALUES (6,0,'Invalid','invalid','');
INSERT INTO `#__support_statuses` (`id`, `open`, `title`, `alias`, `color`) VALUES (7,0,'Won\'t fix','wontfix','');
INSERT INTO `#__support_statuses` (`id`, `open`, `title`, `alias`, `color`) VALUES (8,0,'Duplicate','duplicate','');
INSERT INTO `#__support_statuses` (`id`, `open`, `title`, `alias`, `color`) VALUES (9,0,'Works for me','worksforme','');
INSERT INTO `#__support_statuses` (`id`, `open`, `title`, `alias`, `color`) VALUES (10,0,'Transferred','transferred','');
INSERT INTO `#__support_statuses` (`id`, `open`, `title`, `alias`, `color`) VALUES (11,0,'Answered','answered','');

--
-- HUBzero sample data for table `#__tool_licenses`
--

INSERT INTO `#__tool_licenses` VALUES (1,'default','All rights reserved.','Default license',0);
INSERT INTO `#__tool_licenses` VALUES (2,'BSD','Copyright (c) [YEAR], [OWNER]\nAll rights reserved.\n\nRedistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:\n\nRedistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.\nRedistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution.\nNeither the name of the [ORGANIZATION] nor the names of its contributors may be used to endorse or promote products derived from this software without specific prior written permission.\nTHIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS \'AS IS\' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.','BSD',1);
INSERT INTO `#__tool_licenses` VALUES (3,'GPL','[ONE LINE DESCRIPTION]\r\nCopyright (C) [YEAR]  [OWNER]\r\n\r\nThis program is free software: you can redistribute it and/or modify\r\nit under the terms of the GNU General Public License as published by\r\nthe Free Software Foundation, either version 3 of the License, or\r\n(at your option) any later version.\r\n\r\nThis program is distributed in the hope that it will be useful,\r\nbut WITHOUT ANY WARRANTY; without even the implied warranty of\r\nMERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\r\nGNU General Public License below for more details.\r\n\r\n------------------------------------------------------------------------\r\n\r\n                    GNU GENERAL PUBLIC LICENSE\r\n                       Version 3, 29 June 2007\r\n\r\n Copyright (C) 2007 Free Software Foundation, Inc. <http://fsf.org/>\r\n Everyone is permitted to copy and distribute verbatim copies\r\n of this license document, but changing it is not allowed.\r\n\r\n                            Preamble\r\n\r\n  The GNU General Public License is a free, copyleft license for\r\nsoftware and other kinds of works.\r\n\r\n  The licenses for most software and other practical works are designed\r\nto take away your freedom to share and change the works.  By contrast,\r\nthe GNU General Public License is intended to guarantee your freedom to\r\nshare and change all versions of a program--to make sure it remains free\r\nsoftware for all its users.  We, the Free Software Foundation, use the\r\nGNU General Public License for most of our software; it applies also to\r\nany other work released this way by its authors.  You can apply it to\r\nyour programs, too.\r\n\r\n  When we speak of free software, we are referring to freedom, not\r\nprice.  Our General Public Licenses are designed to make sure that you\r\nhave the freedom to distribute copies of free software (and charge for\r\nthem if you wish), that you receive source code or can get it if you\r\nwant it, that you can change the software or use pieces of it in new\r\nfree programs, and that you know you can do these things.\r\n\r\n  To protect your rights, we need to prevent others from denying you\r\nthese rights or asking you to surrender the rights.  Therefore, you have\r\ncertain responsibilities if you distribute copies of the software, or if\r\nyou modify it: responsibilities to respect the freedom of others.\r\n\r\n  For example, if you distribute copies of such a program, whether\r\ngratis or for a fee, you must pass on to the recipients the same\r\nfreedoms that you received.  You must make sure that they, too, receive\r\nor can get the source code.  And you must show them these terms so they\r\nknow their rights.\r\n\r\n  Developers that use the GNU GPL protect your rights with two steps:\r\n(1) assert copyright on the software, and (2) offer you this License\r\ngiving you legal permission to copy, distribute and/or modify it.\r\n\r\n  For the developers\' and authors\' protection, the GPL clearly explains\r\nthat there is no warranty for this free software.  For both users\' and\r\nauthors\' sake, the GPL requires that modified versions be marked as\r\nchanged, so that their problems will not be attributed erroneously to\r\nauthors of previous versions.\r\n\r\n  Some devices are designed to deny users access to install or run\r\nmodified versions of the software inside them, although the manufacturer\r\ncan do so.  This is fundamentally incompatible with the aim of\r\nprotecting users\' freedom to change the software.  The systematic\r\npattern of such abuse occurs in the area of products for individuals to\r\nuse, which is precisely where it is most unacceptable.  Therefore, we\r\nhave designed this version of the GPL to prohibit the practice for those\r\nproducts.  If such problems arise substantially in other domains, we\r\nstand ready to extend this provision to those domains in future versions\r\nof the GPL, as needed to protect the freedom of users.\r\n\r\n  Finally, every program is threatened constantly by software patents.\r\nStates should not allow patents to restrict development and use of\r\nsoftware on general-purpose computers, but in those that do, we wish to\r\navoid the special danger that patents applied to a free program could\r\nmake it effectively proprietary.  To prevent this, the GPL assures that\r\npatents cannot be used to render the program non-free.\r\n\r\n  The precise terms and conditions for copying, distribution and\r\nmodification follow.\r\n\r\n                       TERMS AND CONDITIONS\r\n\r\n  0. Definitions.\r\n\r\n  &quot;This License&quot; refers to version 3 of the GNU General Public License.\r\n\r\n  &quot;Copyright&quot; also means copyright-like laws that apply to other kinds of\r\nworks, such as semiconductor masks.\r\n\r\n  &quot;The Program&quot; refers to any copyrightable work licensed under this\r\nLicense.  Each licensee is addressed as &quot;you&quot;.  &quot;Licensees&quot; and\r\n&quot;recipients&quot; may be individuals or organizations.\r\n\r\n  To &quot;modify&quot; a work means to copy from or adapt all or part of the work\r\nin a fashion requiring copyright permission, other than the making of an\r\nexact copy.  The resulting work is called a &quot;modified version&quot; of the\r\nearlier work or a work &quot;based on&quot; the earlier work.\r\n\r\n  A &quot;covered work&quot; means either the unmodified Program or a work based\r\non the Program.\r\n\r\n  To &quot;propagate&quot; a work means to do anything with it that, without\r\npermission, would make you directly or secondarily liable for\r\ninfringement under applicable copyright law, except executing it on a\r\ncomputer or modifying a private copy.  Propagation includes copying,\r\ndistribution (with or without modification), making available to the\r\npublic, and in some countries other activities as well.\r\n\r\n  To &quot;convey&quot; a work means any kind of propagation that enables other\r\nparties to make or receive copies.  Mere interaction with a user through\r\na computer network, with no transfer of a copy, is not conveying.\r\n\r\n  An interactive user interface displays &quot;Appropriate Legal Notices&quot;\r\nto the extent that it includes a convenient and prominently visible\r\nfeature that (1) displays an appropriate copyright notice, and (2)\r\ntells the user that there is no warranty for the work (except to the\r\nextent that warranties are provided), that licensees may convey the\r\nwork under this License, and how to view a copy of this License.  If\r\nthe interface presents a list of user commands or options, such as a\r\nmenu, a prominent item in the list meets this criterion.\r\n\r\n  1. Source Code.\r\n\r\n  The &quot;source code&quot; for a work means the preferred form of the work\r\nfor making modifications to it.  &quot;Object code&quot; means any non-source\r\nform of a work.\r\n\r\n  A &quot;Standard Interface&quot; means an interface that either is an official\r\nstandard defined by a recognized standards body, or, in the case of\r\ninterfaces specified for a particular programming language, one that\r\nis widely used among developers working in that language.\r\n\r\n  The &quot;System Libraries&quot; of an executable work include anything, other\r\nthan the work as a whole, that (a) is included in the normal form of\r\npackaging a Major Component, but which is not part of that Major\r\nComponent, and (b) serves only to enable use of the work with that\r\nMajor Component, or to implement a Standard Interface for which an\r\nimplementation is available to the public in source code form.  A\r\n&quot;Major Component&quot;, in this context, means a major essential component\r\n(kernel, window system, and so on) of the specific operating system\r\n(if any) on which the executable work runs, or a compiler used to\r\nproduce the work, or an object code interpreter used to run it.\r\n\r\n  The &quot;Corresponding Source&quot; for a work in object code form means all\r\nthe source code needed to generate, install, and (for an executable\r\nwork) run the object code and to modify the work, including scripts to\r\ncontrol those activities.  However, it does not include the work\'s\r\nSystem Libraries, or general-purpose tools or generally available free\r\nprograms which are used unmodified in performing those activities but\r\nwhich are not part of the work.  For example, Corresponding Source\r\nincludes interface definition files associated with source files for\r\nthe work, and the source code for shared libraries and dynamically\r\nlinked subprograms that the work is specifically designed to require,\r\nsuch as by intimate data communication or control flow between those\r\nsubprograms and other parts of the work.\r\n\r\n  The Corresponding Source need not include anything that users\r\ncan regenerate automatically from other parts of the Corresponding\r\nSource.\r\n\r\n  The Corresponding Source for a work in source code form is that\r\nsame work.\r\n\r\n  2. Basic Permissions.\r\n\r\n  All rights granted under this License are granted for the term of\r\ncopyright on the Program, and are irrevocable provided the stated\r\nconditions are met.  This License explicitly affirms your unlimited\r\npermission to run the unmodified Program.  The output from running a\r\ncovered work is covered by this License only if the output, given its\r\ncontent, constitutes a covered work.  This License acknowledges your\r\nrights of fair use or other equivalent, as provided by copyright law.\r\n\r\n  You may make, run and propagate covered works that you do not\r\nconvey, without conditions so long as your license otherwise remains\r\nin force.  You may convey covered works to others for the sole purpose\r\nof having them make modifications exclusively for you, or provide you\r\nwith facilities for running those works, provided that you comply with\r\nthe terms of this License in conveying all material for which you do\r\nnot control copyright.  Those thus making or running the covered works\r\nfor you must do so exclusively on your behalf, under your direction\r\nand control, on terms that prohibit them from making any copies of\r\nyour copyrighted material outside their relationship with you.\r\n\r\n  Conveying under any other circumstances is permitted solely under\r\nthe conditions stated below.  Sublicensing is not allowed; section 10\r\nmakes it unnecessary.\r\n\r\n  3. Protecting Users\' Legal Rights From Anti-Circumvention Law.\r\n\r\n  No covered work shall be deemed part of an effective technological\r\nmeasure under any applicable law fulfilling obligations under article\r\n11 of the WIPO copyright treaty adopted on 20 December 1996, or\r\nsimilar laws prohibiting or restricting circumvention of such\r\nmeasures.\r\n\r\n  When you convey a covered work, you waive any legal power to forbid\r\ncircumvention of technological measures to the extent such circumvention\r\nis effected by exercising rights under this License with respect to\r\nthe covered work, and you disclaim any intention to limit operation or\r\nmodification of the work as a means of enforcing, against the work\'s\r\nusers, your or third parties\' legal rights to forbid circumvention of\r\ntechnological measures.\r\n\r\n  4. Conveying Verbatim Copies.\r\n\r\n  You may convey verbatim copies of the Program\'s source code as you\r\nreceive it, in any medium, provided that you conspicuously and\r\nappropriately publish on each copy an appropriate copyright notice;\r\nkeep intact all notices stating that this License and any\r\nnon-permissive terms added in accord with section 7 apply to the code;\r\nkeep intact all notices of the absence of any warranty; and give all\r\nrecipients a copy of this License along with the Program.\r\n\r\n  You may charge any price or no price for each copy that you convey,\r\nand you may offer support or warranty protection for a fee.\r\n\r\n  5. Conveying Modified Source Versions.\r\n\r\n  You may convey a work based on the Program, or the modifications to\r\nproduce it from the Program, in the form of source code under the\r\nterms of section 4, provided that you also meet all of these conditions:\r\n\r\n    a) The work must carry prominent notices stating that you modified\r\n    it, and giving a relevant date.\r\n\r\n    b) The work must carry prominent notices stating that it is\r\n    released under this License and any conditions added under section\r\n    7.  This requirement modifies the requirement in section 4 to\r\n    &quot;keep intact all notices&quot;.\r\n\r\n    c) You must license the entire work, as a whole, under this\r\n    License to anyone who comes into possession of a copy.  This\r\n    License will therefore apply, along with any applicable section 7\r\n    additional terms, to the whole of the work, and all its parts,\r\n    regardless of how they are packaged.  This License gives no\r\n    permission to license the work in any other way, but it does not\r\n    invalidate such permission if you have separately received it.\r\n\r\n    d) If the work has interactive user interfaces, each must display\r\n    Appropriate Legal Notices; however, if the Program has interactive\r\n    interfaces that do not display Appropriate Legal Notices, your\r\n    work need not make them do so.\r\n\r\n  A compilation of a covered work with other separate and independent\r\nworks, which are not by their nature extensions of the covered work,\r\nand which are not combined with it such as to form a larger program,\r\nin or on a volume of a storage or distribution medium, is called an\r\n&quot;aggregate&quot; if the compilation and its resulting copyright are not\r\nused to limit the access or legal rights of the compilation\'s users\r\nbeyond what the individual works permit.  Inclusion of a covered work\r\nin an aggregate does not cause this License to apply to the other\r\nparts of the aggregate.\r\n\r\n  6. Conveying Non-Source Forms.\r\n\r\n  You may convey a covered work in object code form under the terms\r\nof sections 4 and 5, provided that you also convey the\r\nmachine-readable Corresponding Source under the terms of this License,\r\nin one of these ways:\r\n\r\n    a) Convey the object code in, or embodied in, a physical product\r\n    (including a physical distribution medium), accompanied by the\r\n    Corresponding Source fixed on a durable physical medium\r\n    customarily used for software interchange.\r\n\r\n    b) Convey the object code in, or embodied in, a physical product\r\n    (including a physical distribution medium), accompanied by a\r\n    written offer, valid for at least three years and valid for as\r\n    long as you offer spare parts or customer support for that product\r\n    model, to give anyone who possesses the object code either (1) a\r\n    copy of the Corresponding Source for all the software in the\r\n    product that is covered by this License, on a durable physical\r\n    medium customarily used for software interchange, for a price no\r\n    more than your reasonable cost of physically performing this\r\n    conveying of source, or (2) access to copy the\r\n    Corresponding Source from a network server at no charge.\r\n\r\n    c) Convey individual copies of the object code with a copy of the\r\n    written offer to provide the Corresponding Source.  This\r\n    alternative is allowed only occasionally and noncommercially, and\r\n    only if you received the object code with such an offer, in accord\r\n    with subsection 6b.\r\n\r\n    d) Convey the object code by offering access from a designated\r\n    place (gratis or for a charge), and offer equivalent access to the\r\n    Corresponding Source in the same way through the same place at no\r\n    further charge.  You need not require recipients to copy the\r\n    Corresponding Source along with the object code.  If the place to\r\n    copy the object code is a network server, the Corresponding Source\r\n    may be on a different server (operated by you or a third party)\r\n    that supports equivalent copying facilities, provided you maintain\r\n    clear directions next to the object code saying where to find the\r\n    Corresponding Source.  Regardless of what server hosts the\r\n    Corresponding Source, you remain obligated to ensure that it is\r\n    available for as long as needed to satisfy these requirements.\r\n\r\n    e) Convey the object code using peer-to-peer transmission, provided\r\n    you inform other peers where the object code and Corresponding\r\n    Source of the work are being offered to the general public at no\r\n    charge under subsection 6d.\r\n\r\n  A separable portion of the object code, whose source code is excluded\r\nfrom the Corresponding Source as a System Library, need not be\r\nincluded in conveying the object code work.\r\n\r\n  A &quot;User Product&quot; is either (1) a &quot;consumer product&quot;, which means any\r\ntangible personal property which is normally used for personal, family,\r\nor household purposes, or (2) anything designed or sold for incorporation\r\ninto a dwelling.  In determining whether a product is a consumer product,\r\ndoubtful cases shall be resolved in favor of coverage.  For a particular\r\nproduct received by a particular user, &quot;normally used&quot; refers to a\r\ntypical or common use of that class of product, regardless of the status\r\nof the particular user or of the way in which the particular user\r\nactually uses, or expects or is expected to use, the product.  A product\r\nis a consumer product regardless of whether the product has substantial\r\ncommercial, industrial or non-consumer uses, unless such uses represent\r\nthe only significant mode of use of the product.\r\n\r\n  &quot;Installation Information&quot; for a User Product means any methods,\r\nprocedures, authorization keys, or other information required to install\r\nand execute modified versions of a covered work in that User Product from\r\na modified version of its Corresponding Source.  The information must\r\nsuffice to ensure that the continued functioning of the modified object\r\ncode is in no case prevented or interfered with solely because\r\nmodification has been made.\r\n\r\n  If you convey an object code work under this section in, or with, or\r\nspecifically for use in, a User Product, and the conveying occurs as\r\npart of a transaction in which the right of possession and use of the\r\nUser Product is transferred to the recipient in perpetuity or for a\r\nfixed term (regardless of how the transaction is characterized), the\r\nCorresponding Source conveyed under this section must be accompanied\r\nby the Installation Information.  But this requirement does not apply\r\nif neither you nor any third party retains the ability to install\r\nmodified object code on the User Product (for example, the work has\r\nbeen installed in ROM).\r\n\r\n  The requirement to provide Installation Information does not include a\r\nrequirement to continue to provide support service, warranty, or updates\r\nfor a work that has been modified or installed by the recipient, or for\r\nthe User Product in which it has been modified or installed.  Access to a\r\nnetwork may be denied when the modification itself materially and\r\nadversely affects the operation of the network or violates the rules and\r\nprotocols for communication across the network.\r\n\r\n  Corresponding Source conveyed, and Installation Information provided,\r\nin accord with this section must be in a format that is publicly\r\ndocumented (and with an implementation available to the public in\r\nsource code form), and must require no special password or key for\r\nunpacking, reading or copying.\r\n\r\n  7. Additional Terms.\r\n\r\n  &quot;Additional permissions&quot; are terms that supplement the terms of this\r\nLicense by making exceptions from one or more of its conditions.\r\nAdditional permissions that are applicable to the entire Program shall\r\nbe treated as though they were included in this License, to the extent\r\nthat they are valid under applicable law.  If additional permissions\r\napply only to part of the Program, that part may be used separately\r\nunder those permissions, but the entire Program remains governed by\r\nthis License without regard to the additional permissions.\r\n\r\n  When you convey a copy of a covered work, you may at your option\r\nremove any additional permissions from that copy, or from any part of\r\nit.  (Additional permissions may be written to require their own\r\nremoval in certain cases when you modify the work.)  You may place\r\nadditional permissions on material, added by you to a covered work,\r\nfor which you have or can give appropriate copyright permission.\r\n\r\n  Notwithstanding any other provision of this License, for material you\r\nadd to a covered work, you may (if authorized by the copyright holders of\r\nthat material) supplement the terms of this License with terms:\r\n\r\n    a) Disclaiming warranty or limiting liability differently from the\r\n    terms of sections 15 and 16 of this License; or\r\n\r\n    b) Requiring preservation of specified reasonable legal notices or\r\n    author attributions in that material or in the Appropriate Legal\r\n    Notices displayed by works containing it; or\r\n\r\n    c) Prohibiting misrepresentation of the origin of that material, or\r\n    requiring that modified versions of such material be marked in\r\n    reasonable ways as different from the original version; or\r\n\r\n    d) Limiting the use for publicity purposes of names of licensors or\r\n    authors of the material; or\r\n\r\n    e) Declining to grant rights under trademark law for use of some\r\n    trade names, trademarks, or service marks; or\r\n\r\n    f) Requiring indemnification of licensors and authors of that\r\n    material by anyone who conveys the material (or modified versions of\r\n    it) with contractual assumptions of liability to the recipient, for\r\n    any liability that these contractual assumptions directly impose on\r\n    those licensors and authors.\r\n\r\n  All other non-permissive additional terms are considered &quot;further\r\nrestrictions&quot; within the meaning of section 10.  If the Program as you\r\nreceived it, or any part of it, contains a notice stating that it is\r\ngoverned by this License along with a term that is a further\r\nrestriction, you may remove that term.  If a license document contains\r\na further restriction but permits relicensing or conveying under this\r\nLicense, you may add to a covered work material governed by the terms\r\nof that license document, provided that the further restriction does\r\nnot survive such relicensing or conveying.\r\n\r\n  If you add terms to a covered work in accord with this section, you\r\nmust place, in the relevant source files, a statement of the\r\nadditional terms that apply to those files, or a notice indicating\r\nwhere to find the applicable terms.\r\n\r\n  Additional terms, permissive or non-permissive, may be stated in the\r\nform of a separately written license, or stated as exceptions;\r\nthe above requirements apply either way.\r\n\r\n  8. Termination.\r\n\r\n  You may not propagate or modify a covered work except as expressly\r\nprovided under this License.  Any attempt otherwise to propagate or\r\nmodify it is void, and will automatically terminate your rights under\r\nthis License (including any patent licenses granted under the third\r\nparagraph of section 11).\r\n\r\n  However, if you cease all violation of this License, then your\r\nlicense from a particular copyright holder is reinstated (a)\r\nprovisionally, unless and until the copyright holder explicitly and\r\nfinally terminates your license, and (b) permanently, if the copyright\r\nholder fails to notify you of the violation by some reasonable means\r\nprior to 60 days after the cessation.\r\n\r\n  Moreover, your license from a particular copyright holder is\r\nreinstated permanently if the copyright holder notifies you of the\r\nviolation by some reasonable means, this is the first time you have\r\nreceived notice of violation of this License (for any work) from that\r\ncopyright holder, and you cure the violation prior to 30 days after\r\nyour receipt of the notice.\r\n\r\n  Termination of your rights under this section does not terminate the\r\nlicenses of parties who have received copies or rights from you under\r\nthis License.  If your rights have been terminated and not permanently\r\nreinstated, you do not qualify to receive new licenses for the same\r\nmaterial under section 10.\r\n\r\n  9. Acceptance Not Required for Having Copies.\r\n\r\n  You are not required to accept this License in order to receive or\r\nrun a copy of the Program.  Ancillary propagation of a covered work\r\noccurring solely as a consequence of using peer-to-peer transmission\r\nto receive a copy likewise does not require acceptance.  However,\r\nnothing other than this License grants you permission to propagate or\r\nmodify any covered work.  These actions infringe copyright if you do\r\nnot accept this License.  Therefore, by modifying or propagating a\r\ncovered work, you indicate your acceptance of this License to do so.\r\n\r\n  10. Automatic Licensing of Downstream Recipients.\r\n\r\n  Each time you convey a covered work, the recipient automatically\r\nreceives a license from the original licensors, to run, modify and\r\npropagate that work, subject to this License.  You are not responsible\r\nfor enforcing compliance by third parties with this License.\r\n\r\n  An &quot;entity transaction&quot; is a transaction transferring control of an\r\norganization, or substantially all assets of one, or subdividing an\r\norganization, or merging organizations.  If propagation of a covered\r\nwork results from an entity transaction, each party to that\r\ntransaction who receives a copy of the work also receives whatever\r\nlicenses to the work the party\'s predecessor in interest had or could\r\ngive under the previous paragraph, plus a right to possession of the\r\nCorresponding Source of the work from the predecessor in interest, if\r\nthe predecessor has it or can get it with reasonable efforts.\r\n\r\n  You may not impose any further restrictions on the exercise of the\r\nrights granted or affirmed under this License.  For example, you may\r\nnot impose a license fee, royalty, or other charge for exercise of\r\nrights granted under this License, and you may not initiate litigation\r\n(including a cross-claim or counterclaim in a lawsuit) alleging that\r\nany patent claim is infringed by making, using, selling, offering for\r\nsale, or importing the Program or any portion of it.\r\n\r\n  11. Patents.\r\n\r\n  A &quot;contributor&quot; is a copyright holder who authorizes use under this\r\nLicense of the Program or a work on which the Program is based.  The\r\nwork thus licensed is called the contributor\'s &quot;contributor version&quot;.\r\n\r\n  A contributor\'s &quot;essential patent claims&quot; are all patent claims\r\nowned or controlled by the contributor, whether already acquired or\r\nhereafter acquired, that would be infringed by some manner, permitted\r\nby this License, of making, using, or selling its contributor version,\r\nbut do not include claims that would be infringed only as a\r\nconsequence of further modification of the contributor version.  For\r\npurposes of this definition, &quot;control&quot; includes the right to grant\r\npatent sublicenses in a manner consistent with the requirements of\r\nthis License.\r\n\r\n  Each contributor grants you a non-exclusive, worldwide, royalty-free\r\npatent license under the contributor\'s essential patent claims, to\r\nmake, use, sell, offer for sale, import and otherwise run, modify and\r\npropagate the contents of its contributor version.\r\n\r\n  In the following three paragraphs, a &quot;patent license&quot; is any express\r\nagreement or commitment, however denominated, not to enforce a patent\r\n(such as an express permission to practice a patent or covenant not to\r\nsue for patent infringement).  To &quot;grant&quot; such a patent license to a\r\nparty means to make such an agreement or commitment not to enforce a\r\npatent against the party.\r\n\r\n  If you convey a covered work, knowingly relying on a patent license,\r\nand the Corresponding Source of the work is not available for anyone\r\nto copy, free of charge and under the terms of this License, through a\r\npublicly available network server or other readily accessible means,\r\nthen you must either (1) cause the Corresponding Source to be so\r\navailable, or (2) arrange to deprive yourself of the benefit of the\r\npatent license for this particular work, or (3) arrange, in a manner\r\nconsistent with the requirements of this License, to extend the patent\r\nlicense to downstream recipients.  &quot;Knowingly relying&quot; means you have\r\nactual knowledge that, but for the patent license, your conveying the\r\ncovered work in a country, or your recipient\'s use of the covered work\r\nin a country, would infringe one or more identifiable patents in that\r\ncountry that you have reason to believe are valid.\r\n\r\n  If, pursuant to or in connection with a single transaction or\r\narrangement, you convey, or propagate by procuring conveyance of, a\r\ncovered work, and grant a patent license to some of the parties\r\nreceiving the covered work authorizing them to use, propagate, modify\r\nor convey a specific copy of the covered work, then the patent license\r\nyou grant is automatically extended to all recipients of the covered\r\nwork and works based on it.\r\n\r\n  A patent license is &quot;discriminatory&quot; if it does not include within\r\nthe scope of its coverage, prohibits the exercise of, or is\r\nconditioned on the non-exercise of one or more of the rights that are\r\nspecifically granted under this License.  You may not convey a covered\r\nwork if you are a party to an arrangement with a third party that is\r\nin the business of distributing software, under which you make payment\r\nto the third party based on the extent of your activity of conveying\r\nthe work, and under which the third party grants, to any of the\r\nparties who would receive the covered work from you, a discriminatory\r\npatent license (a) in connection with copies of the covered work\r\nconveyed by you (or copies made from those copies), or (b) primarily\r\nfor and in connection with specific products or compilations that\r\ncontain the covered work, unless you entered into that arrangement,\r\nor that patent license was granted, prior to 28 March 2007.\r\n\r\n  Nothing in this License shall be construed as excluding or limiting\r\nany implied license or other defenses to infringement that may\r\notherwise be available to you under applicable patent law.\r\n\r\n  12. No Surrender of Others\' Freedom.\r\n\r\n  If conditions are imposed on you (whether by court order, agreement or\r\notherwise) that contradict the conditions of this License, they do not\r\nexcuse you from the conditions of this License.  If you cannot convey a\r\ncovered work so as to satisfy simultaneously your obligations under this\r\nLicense and any other pertinent obligations, then as a consequence you may\r\nnot convey it at all.  For example, if you agree to terms that obligate you\r\nto collect a royalty for further conveying from those to whom you convey\r\nthe Program, the only way you could satisfy both those terms and this\r\nLicense would be to refrain entirely from conveying the Program.\r\n\r\n  13. Use with the GNU Affero General Public License.\r\n\r\n  Notwithstanding any other provision of this License, you have\r\npermission to link or combine any covered work with a work licensed\r\nunder version 3 of the GNU Affero General Public License into a single\r\ncombined work, and to convey the resulting work.  The terms of this\r\nLicense will continue to apply to the part which is the covered work,\r\nbut the special requirements of the GNU Affero General Public License,\r\nsection 13, concerning interaction through a network will apply to the\r\ncombination as such.\r\n\r\n  14. Revised Versions of this License.\r\n\r\n  The Free Software Foundation may publish revised and/or new versions of\r\nthe GNU General Public License from time to time.  Such new versions will\r\nbe similar in spirit to the present version, but may differ in detail to\r\naddress new problems or concerns.\r\n\r\n  Each version is given a distinguishing version number.  If the\r\nProgram specifies that a certain numbered version of the GNU General\r\nPublic License &quot;or any later version&quot; applies to it, you have the\r\noption of following the terms and conditions either of that numbered\r\nversion or of any later version published by the Free Software\r\nFoundation.  If the Program does not specify a version number of the\r\nGNU General Public License, you may choose any version ever published\r\nby the Free Software Foundation.\r\n\r\n  If the Program specifies that a proxy can decide which future\r\nversions of the GNU General Public License can be used, that proxy\'s\r\npublic statement of acceptance of a version permanently authorizes you\r\nto choose that version for the Program.\r\n\r\n  Later license versions may give you additional or different\r\npermissions.  However, no additional obligations are imposed on any\r\nauthor or copyright holder as a result of your choosing to follow a\r\nlater version.\r\n\r\n  15. Disclaimer of Warranty.\r\n\r\n  THERE IS NO WARRANTY FOR THE PROGRAM, TO THE EXTENT PERMITTED BY\r\nAPPLICABLE LAW.  EXCEPT WHEN OTHERWISE STATED IN WRITING THE COPYRIGHT\r\nHOLDERS AND/OR OTHER PARTIES PROVIDE THE PROGRAM &quot;AS IS&quot; WITHOUT WARRANTY\r\nOF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING, BUT NOT LIMITED TO,\r\nTHE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR\r\nPURPOSE.  THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THE PROGRAM\r\nIS WITH YOU.  SHOULD THE PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF\r\nALL NECESSARY SERVICING, REPAIR OR CORRECTION.\r\n\r\n  16. Limitation of Liability.\r\n\r\n  IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN WRITING\r\nWILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MODIFIES AND/OR CONVEYS\r\nTHE PROGRAM AS PERMITTED ABOVE, BE LIABLE TO YOU FOR DAMAGES, INCLUDING ANY\r\nGENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE\r\nUSE OR INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT LIMITED TO LOSS OF\r\nDATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY YOU OR THIRD\r\nPARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY OTHER PROGRAMS),\r\nEVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE POSSIBILITY OF\r\nSUCH DAMAGES.\r\n\r\n  17. Interpretation of Sections 15 and 16.\r\n\r\n  If the disclaimer of warranty and limitation of liability provided\r\nabove cannot be given local legal effect according to their terms,\r\nreviewing courts shall apply local law that most closely approximates\r\nan absolute waiver of all civil liability in connection with the\r\nProgram, unless a warranty or assumption of liability accompanies a\r\ncopy of the Program in return for a fee.\r\n','General Public License (GPL)',3);
INSERT INTO `#__tool_licenses` VALUES (4,'NCSA','Copyright (c) [YEAR] [OWNER] \nAll rights reserved.\n\nDeveloped by:	\n			[OWNER]\n			[ORGANIZATION]\n			[URL]\n\nPermission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the \'Software\'), to deal with the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:\n\nRedistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimers. \n\nRedistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimers in the documentation and/or other materials provided with the distribution.\n\nNeither the names of [OWNER],[ORGANIZATION], nor the names of its contributors may be used to endorse or promote products derived from this Software without specific prior written permission.\n\nTHE SOFTWARE IS PROVIDED \'AS IS\', WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE CONTRIBUTORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS WITH THE SOFTWARE.','NCSA Open Source License',2);
INSERT INTO `#__tool_licenses` VALUES (5,'custom','[ONE LINE DESCRIPTION]\nCopyright (C) [YEAR] [OWNER]','custom',5);
INSERT INTO `#__tool_licenses` VALUES (6,'LGPL','[ONE LINE DESCRIPTION]\r\nCopyright (C) [YEAR]  [OWNER]\r\n\r\nThis program is free software: you can redistribute it and/or modify\r\nit under the terms of the GNU Lesser General Public License as published\r\nby the Free Software Foundation, either version 3 of the License, or\r\n(at your option) any later version.\r\n\r\nThis program is distributed in the hope that it will be useful,\r\nbut WITHOUT ANY WARRANTY; without even the implied warranty of\r\nMERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\r\nGNU Lesser General Public License below for more details.\r\n\r\n------------------------------------------------------------------------\r\n\r\n		   GNU LESSER GENERAL PUBLIC LICENSE\r\n                       Version 3, 29 June 2007\r\n\r\n Copyright (C) 2007 Free Software Foundation, Inc. <http://fsf.org/>\r\n Everyone is permitted to copy and distribute verbatim copies\r\n of this license document, but changing it is not allowed.\r\n\r\n\r\n  This version of the GNU Lesser General Public License incorporates\r\nthe terms and conditions of version 3 of the GNU General Public\r\nLicense, supplemented by the additional permissions listed below.\r\n\r\n  0. Additional Definitions. \r\n\r\n  As used herein, &quot;this License&quot; refers to version 3 of the GNU Lesser\r\nGeneral Public License, and the &quot;GNU GPL&quot; refers to version 3 of the GNU\r\nGeneral Public License.\r\n\r\n  &quot;The Library&quot; refers to a covered work governed by this License,\r\nother than an Application or a Combined Work as defined below.\r\n\r\n  An &quot;Application&quot; is any work that makes use of an interface provided\r\nby the Library, but which is not otherwise based on the Library.\r\nDefining a subclass of a class defined by the Library is deemed a mode\r\nof using an interface provided by the Library.\r\n\r\n  A &quot;Combined Work&quot; is a work produced by combining or linking an\r\nApplication with the Library.  The particular version of the Library\r\nwith which the Combined Work was made is also called the &quot;Linked\r\nVersion&quot;.\r\n\r\n  The &quot;Minimal Corresponding Source&quot; for a Combined Work means the\r\nCorresponding Source for the Combined Work, excluding any source code\r\nfor portions of the Combined Work that, considered in isolation, are\r\nbased on the Application, and not on the Linked Version.\r\n\r\n  The &quot;Corresponding Application Code&quot; for a Combined Work means the\r\nobject code and/or source code for the Application, including any data\r\nand utility programs needed for reproducing the Combined Work from the\r\nApplication, but excluding the System Libraries of the Combined Work.\r\n\r\n  1. Exception to Section 3 of the GNU GPL.\r\n\r\n  You may convey a covered work under sections 3 and 4 of this License\r\nwithout being bound by section 3 of the GNU GPL.\r\n\r\n  2. Conveying Modified Versions.\r\n\r\n  If you modify a copy of the Library, and, in your modifications, a\r\nfacility refers to a function or data to be supplied by an Application\r\nthat uses the facility (other than as an argument passed when the\r\nfacility is invoked), then you may convey a copy of the modified\r\nversion:\r\n\r\n   a) under this License, provided that you make a good faith effort to\r\n   ensure that, in the event an Application does not supply the\r\n   function or data, the facility still operates, and performs\r\n   whatever part of its purpose remains meaningful, or\r\n\r\n   b) under the GNU GPL, with none of the additional permissions of\r\n   this License applicable to that copy.\r\n\r\n  3. Object Code Incorporating Material from Library Header Files.\r\n\r\n  The object code form of an Application may incorporate material from\r\na header file that is part of the Library.  You may convey such object\r\ncode under terms of your choice, provided that, if the incorporated\r\nmaterial is not limited to numerical parameters, data structure\r\nlayouts and accessors, or small macros, inline functions and templates\r\n(ten or fewer lines in length), you do both of the following:\r\n\r\n   a) Give prominent notice with each copy of the object code that the\r\n   Library is used in it and that the Library and its use are\r\n   covered by this License.\r\n\r\n   b) Accompany the object code with a copy of the GNU GPL and this license\r\n   document.\r\n\r\n  4. Combined Works.\r\n\r\n  You may convey a Combined Work under terms of your choice that,\r\ntaken together, effectively do not restrict modification of the\r\nportions of the Library contained in the Combined Work and reverse\r\nengineering for debugging such modifications, if you also do each of\r\nthe following:\r\n\r\n   a) Give prominent notice with each copy of the Combined Work that\r\n   the Library is used in it and that the Library and its use are\r\n   covered by this License.\r\n\r\n   b) Accompany the Combined Work with a copy of the GNU GPL and this license\r\n   document.\r\n\r\n   c) For a Combined Work that displays copyright notices during\r\n   execution, include the copyright notice for the Library among\r\n   these notices, as well as a reference directing the user to the\r\n   copies of the GNU GPL and this license document.\r\n\r\n   d) Do one of the following:\r\n\r\n       0) Convey the Minimal Corresponding Source under the terms of this\r\n       License, and the Corresponding Application Code in a form\r\n       suitable for, and under terms that permit, the user to\r\n       recombine or relink the Application with a modified version of\r\n       the Linked Version to produce a modified Combined Work, in the\r\n       manner specified by section 6 of the GNU GPL for conveying\r\n       Corresponding Source.\r\n\r\n       1) Use a suitable shared library mechanism for linking with the\r\n       Library.  A suitable mechanism is one that (a) uses at run time\r\n       a copy of the Library already present on the user\'s computer\r\n       system, and (b) will operate properly with a modified version\r\n       of the Library that is interface-compatible with the Linked\r\n       Version. \r\n\r\n   e) Provide Installation Information, but only if you would otherwise\r\n   be required to provide such information under section 6 of the\r\n   GNU GPL, and only to the extent that such information is\r\n   necessary to install and execute a modified version of the\r\n   Combined Work produced by recombining or relinking the\r\n   Application with a modified version of the Linked Version. (If\r\n   you use option 4d0, the Installation Information must accompany\r\n   the Minimal Corresponding Source and Corresponding Application\r\n   Code. If you use option 4d1, you must provide the Installation\r\n   Information in the manner specified by section 6 of the GNU GPL\r\n   for conveying Corresponding Source.)\r\n\r\n  5. Combined Libraries.\r\n\r\n  You may place library facilities that are a work based on the\r\nLibrary side by side in a single library together with other library\r\nfacilities that are not Applications and are not covered by this\r\nLicense, and convey such a combined library under terms of your\r\nchoice, if you do both of the following:\r\n\r\n   a) Accompany the combined library with a copy of the same work based\r\n   on the Library, uncombined with any other library facilities,\r\n   conveyed under the terms of this License.\r\n\r\n   b) Give prominent notice with the combined library that part of it\r\n   is a work based on the Library, and explaining where to find the\r\n   accompanying uncombined form of the same work.\r\n\r\n  6. Revised Versions of the GNU Lesser General Public License.\r\n\r\n  The Free Software Foundation may publish revised and/or new versions\r\nof the GNU Lesser General Public License from time to time. Such new\r\nversions will be similar in spirit to the present version, but may\r\ndiffer in detail to address new problems or concerns.\r\n\r\n  Each version is given a distinguishing version number. If the\r\nLibrary as you received it specifies that a certain numbered version\r\nof the GNU Lesser General Public License &quot;or any later version&quot;\r\napplies to it, you have the option of following the terms and\r\nconditions either of that published version or of any later version\r\npublished by the Free Software Foundation. If the Library as you\r\nreceived it does not specify a version number of the GNU Lesser\r\nGeneral Public License, you may choose any version of the GNU Lesser\r\nGeneral Public License ever published by the Free Software Foundation.\r\n\r\n  If the Library as you received it specifies that a proxy can decide\r\nwhether future versions of the GNU Lesser General Public License shall\r\napply, that proxy\'s public statement of acceptance of any version is\r\npermanent authorization for you to choose that version for the\r\nLibrary.\r\n\r\n------------------------------------------------------------------------\r\n\r\n                    GNU GENERAL PUBLIC LICENSE\r\n                       Version 3, 29 June 2007\r\n\r\n Copyright (C) 2007 Free Software Foundation, Inc. <http://fsf.org/>\r\n Everyone is permitted to copy and distribute verbatim copies\r\n of this license document, but changing it is not allowed.\r\n\r\n                            Preamble\r\n\r\n  The GNU General Public License is a free, copyleft license for\r\nsoftware and other kinds of works.\r\n\r\n  The licenses for most software and other practical works are designed\r\nto take away your freedom to share and change the works.  By contrast,\r\nthe GNU General Public License is intended to guarantee your freedom to\r\nshare and change all versions of a program--to make sure it remains free\r\nsoftware for all its users.  We, the Free Software Foundation, use the\r\nGNU General Public License for most of our software; it applies also to\r\nany other work released this way by its authors.  You can apply it to\r\nyour programs, too.\r\n\r\n  When we speak of free software, we are referring to freedom, not\r\nprice.  Our General Public Licenses are designed to make sure that you\r\nhave the freedom to distribute copies of free software (and charge for\r\nthem if you wish), that you receive source code or can get it if you\r\nwant it, that you can change the software or use pieces of it in new\r\nfree programs, and that you know you can do these things.\r\n\r\n  To protect your rights, we need to prevent others from denying you\r\nthese rights or asking you to surrender the rights.  Therefore, you have\r\ncertain responsibilities if you distribute copies of the software, or if\r\nyou modify it: responsibilities to respect the freedom of others.\r\n\r\n  For example, if you distribute copies of such a program, whether\r\ngratis or for a fee, you must pass on to the recipients the same\r\nfreedoms that you received.  You must make sure that they, too, receive\r\nor can get the source code.  And you must show them these terms so they\r\nknow their rights.\r\n\r\n  Developers that use the GNU GPL protect your rights with two steps:\r\n(1) assert copyright on the software, and (2) offer you this License\r\ngiving you legal permission to copy, distribute and/or modify it.\r\n\r\n  For the developers\' and authors\' protection, the GPL clearly explains\r\nthat there is no warranty for this free software.  For both users\' and\r\nauthors\' sake, the GPL requires that modified versions be marked as\r\nchanged, so that their problems will not be attributed erroneously to\r\nauthors of previous versions.\r\n\r\n  Some devices are designed to deny users access to install or run\r\nmodified versions of the software inside them, although the manufacturer\r\ncan do so.  This is fundamentally incompatible with the aim of\r\nprotecting users\' freedom to change the software.  The systematic\r\npattern of such abuse occurs in the area of products for individuals to\r\nuse, which is precisely where it is most unacceptable.  Therefore, we\r\nhave designed this version of the GPL to prohibit the practice for those\r\nproducts.  If such problems arise substantially in other domains, we\r\nstand ready to extend this provision to those domains in future versions\r\nof the GPL, as needed to protect the freedom of users.\r\n\r\n  Finally, every program is threatened constantly by software patents.\r\nStates should not allow patents to restrict development and use of\r\nsoftware on general-purpose computers, but in those that do, we wish to\r\navoid the special danger that patents applied to a free program could\r\nmake it effectively proprietary.  To prevent this, the GPL assures that\r\npatents cannot be used to render the program non-free.\r\n\r\n  The precise terms and conditions for copying, distribution and\r\nmodification follow.\r\n\r\n                       TERMS AND CONDITIONS\r\n\r\n  0. Definitions.\r\n\r\n  &quot;This License&quot; refers to version 3 of the GNU General Public License.\r\n\r\n  &quot;Copyright&quot; also means copyright-like laws that apply to other kinds of\r\nworks, such as semiconductor masks.\r\n\r\n  &quot;The Program&quot; refers to any copyrightable work licensed under this\r\nLicense.  Each licensee is addressed as &quot;you&quot;.  &quot;Licensees&quot; and\r\n&quot;recipients&quot; may be individuals or organizations.\r\n\r\n  To &quot;modify&quot; a work means to copy from or adapt all or part of the work\r\nin a fashion requiring copyright permission, other than the making of an\r\nexact copy.  The resulting work is called a &quot;modified version&quot; of the\r\nearlier work or a work &quot;based on&quot; the earlier work.\r\n\r\n  A &quot;covered work&quot; means either the unmodified Program or a work based\r\non the Program.\r\n\r\n  To &quot;propagate&quot; a work means to do anything with it that, without\r\npermission, would make you directly or secondarily liable for\r\ninfringement under applicable copyright law, except executing it on a\r\ncomputer or modifying a private copy.  Propagation includes copying,\r\ndistribution (with or without modification), making available to the\r\npublic, and in some countries other activities as well.\r\n\r\n  To &quot;convey&quot; a work means any kind of propagation that enables other\r\nparties to make or receive copies.  Mere interaction with a user through\r\na computer network, with no transfer of a copy, is not conveying.\r\n\r\n  An interactive user interface displays &quot;Appropriate Legal Notices&quot;\r\nto the extent that it includes a convenient and prominently visible\r\nfeature that (1) displays an appropriate copyright notice, and (2)\r\ntells the user that there is no warranty for the work (except to the\r\nextent that warranties are provided), that licensees may convey the\r\nwork under this License, and how to view a copy of this License.  If\r\nthe interface presents a list of user commands or options, such as a\r\nmenu, a prominent item in the list meets this criterion.\r\n\r\n  1. Source Code.\r\n\r\n  The &quot;source code&quot; for a work means the preferred form of the work\r\nfor making modifications to it.  &quot;Object code&quot; means any non-source\r\nform of a work.\r\n\r\n  A &quot;Standard Interface&quot; means an interface that either is an official\r\nstandard defined by a recognized standards body, or, in the case of\r\ninterfaces specified for a particular programming language, one that\r\nis widely used among developers working in that language.\r\n\r\n  The &quot;System Libraries&quot; of an executable work include anything, other\r\nthan the work as a whole, that (a) is included in the normal form of\r\npackaging a Major Component, but which is not part of that Major\r\nComponent, and (b) serves only to enable use of the work with that\r\nMajor Component, or to implement a Standard Interface for which an\r\nimplementation is available to the public in source code form.  A\r\n&quot;Major Component&quot;, in this context, means a major essential component\r\n(kernel, window system, and so on) of the specific operating system\r\n(if any) on which the executable work runs, or a compiler used to\r\nproduce the work, or an object code interpreter used to run it.\r\n\r\n  The &quot;Corresponding Source&quot; for a work in object code form means all\r\nthe source code needed to generate, install, and (for an executable\r\nwork) run the object code and to modify the work, including scripts to\r\ncontrol those activities.  However, it does not include the work\'s\r\nSystem Libraries, or general-purpose tools or generally available free\r\nprograms which are used unmodified in performing those activities but\r\nwhich are not part of the work.  For example, Corresponding Source\r\nincludes interface definition files associated with source files for\r\nthe work, and the source code for shared libraries and dynamically\r\nlinked subprograms that the work is specifically designed to require,\r\nsuch as by intimate data communication or control flow between those\r\nsubprograms and other parts of the work.\r\n\r\n  The Corresponding Source need not include anything that users\r\ncan regenerate automatically from other parts of the Corresponding\r\nSource.\r\n\r\n  The Corresponding Source for a work in source code form is that\r\nsame work.\r\n\r\n  2. Basic Permissions.\r\n\r\n  All rights granted under this License are granted for the term of\r\ncopyright on the Program, and are irrevocable provided the stated\r\nconditions are met.  This License explicitly affirms your unlimited\r\npermission to run the unmodified Program.  The output from running a\r\ncovered work is covered by this License only if the output, given its\r\ncontent, constitutes a covered work.  This License acknowledges your\r\nrights of fair use or other equivalent, as provided by copyright law.\r\n\r\n  You may make, run and propagate covered works that you do not\r\nconvey, without conditions so long as your license otherwise remains\r\nin force.  You may convey covered works to others for the sole purpose\r\nof having them make modifications exclusively for you, or provide you\r\nwith facilities for running those works, provided that you comply with\r\nthe terms of this License in conveying all material for which you do\r\nnot control copyright.  Those thus making or running the covered works\r\nfor you must do so exclusively on your behalf, under your direction\r\nand control, on terms that prohibit them from making any copies of\r\nyour copyrighted material outside their relationship with you.\r\n\r\n  Conveying under any other circumstances is permitted solely under\r\nthe conditions stated below.  Sublicensing is not allowed; section 10\r\nmakes it unnecessary.\r\n\r\n  3. Protecting Users\' Legal Rights From Anti-Circumvention Law.\r\n\r\n  No covered work shall be deemed part of an effective technological\r\nmeasure under any applicable law fulfilling obligations under article\r\n11 of the WIPO copyright treaty adopted on 20 December 1996, or\r\nsimilar laws prohibiting or restricting circumvention of such\r\nmeasures.\r\n\r\n  When you convey a covered work, you waive any legal power to forbid\r\ncircumvention of technological measures to the extent such circumvention\r\nis effected by exercising rights under this License with respect to\r\nthe covered work, and you disclaim any intention to limit operation or\r\nmodification of the work as a means of enforcing, against the work\'s\r\nusers, your or third parties\' legal rights to forbid circumvention of\r\ntechnological measures.\r\n\r\n  4. Conveying Verbatim Copies.\r\n\r\n  You may convey verbatim copies of the Program\'s source code as you\r\nreceive it, in any medium, provided that you conspicuously and\r\nappropriately publish on each copy an appropriate copyright notice;\r\nkeep intact all notices stating that this License and any\r\nnon-permissive terms added in accord with section 7 apply to the code;\r\nkeep intact all notices of the absence of any warranty; and give all\r\nrecipients a copy of this License along with the Program.\r\n\r\n  You may charge any price or no price for each copy that you convey,\r\nand you may offer support or warranty protection for a fee.\r\n\r\n  5. Conveying Modified Source Versions.\r\n\r\n  You may convey a work based on the Program, or the modifications to\r\nproduce it from the Program, in the form of source code under the\r\nterms of section 4, provided that you also meet all of these conditions:\r\n\r\n    a) The work must carry prominent notices stating that you modified\r\n    it, and giving a relevant date.\r\n\r\n    b) The work must carry prominent notices stating that it is\r\n    released under this License and any conditions added under section\r\n    7.  This requirement modifies the requirement in section 4 to\r\n    &quot;keep intact all notices&quot;.\r\n\r\n    c) You must license the entire work, as a whole, under this\r\n    License to anyone who comes into possession of a copy.  This\r\n    License will therefore apply, along with any applicable section 7\r\n    additional terms, to the whole of the work, and all its parts,\r\n    regardless of how they are packaged.  This License gives no\r\n    permission to license the work in any other way, but it does not\r\n    invalidate such permission if you have separately received it.\r\n\r\n    d) If the work has interactive user interfaces, each must display\r\n    Appropriate Legal Notices; however, if the Program has interactive\r\n    interfaces that do not display Appropriate Legal Notices, your\r\n    work need not make them do so.\r\n\r\n  A compilation of a covered work with other separate and independent\r\nworks, which are not by their nature extensions of the covered work,\r\nand which are not combined with it such as to form a larger program,\r\nin or on a volume of a storage or distribution medium, is called an\r\n&quot;aggregate&quot; if the compilation and its resulting copyright are not\r\nused to limit the access or legal rights of the compilation\'s users\r\nbeyond what the individual works permit.  Inclusion of a covered work\r\nin an aggregate does not cause this License to apply to the other\r\nparts of the aggregate.\r\n\r\n  6. Conveying Non-Source Forms.\r\n\r\n  You may convey a covered work in object code form under the terms\r\nof sections 4 and 5, provided that you also convey the\r\nmachine-readable Corresponding Source under the terms of this License,\r\nin one of these ways:\r\n\r\n    a) Convey the object code in, or embodied in, a physical product\r\n    (including a physical distribution medium), accompanied by the\r\n    Corresponding Source fixed on a durable physical medium\r\n    customarily used for software interchange.\r\n\r\n    b) Convey the object code in, or embodied in, a physical product\r\n    (including a physical distribution medium), accompanied by a\r\n    written offer, valid for at least three years and valid for as\r\n    long as you offer spare parts or customer support for that product\r\n    model, to give anyone who possesses the object code either (1) a\r\n    copy of the Corresponding Source for all the software in the\r\n    product that is covered by this License, on a durable physical\r\n    medium customarily used for software interchange, for a price no\r\n    more than your reasonable cost of physically performing this\r\n    conveying of source, or (2) access to copy the\r\n    Corresponding Source from a network server at no charge.\r\n\r\n    c) Convey individual copies of the object code with a copy of the\r\n    written offer to provide the Corresponding Source.  This\r\n    alternative is allowed only occasionally and noncommercially, and\r\n    only if you received the object code with such an offer, in accord\r\n    with subsection 6b.\r\n\r\n    d) Convey the object code by offering access from a designated\r\n    place (gratis or for a charge), and offer equivalent access to the\r\n    Corresponding Source in the same way through the same place at no\r\n    further charge.  You need not require recipients to copy the\r\n    Corresponding Source along with the object code.  If the place to\r\n    copy the object code is a network server, the Corresponding Source\r\n    may be on a different server (operated by you or a third party)\r\n    that supports equivalent copying facilities, provided you maintain\r\n    clear directions next to the object code saying where to find the\r\n    Corresponding Source.  Regardless of what server hosts the\r\n    Corresponding Source, you remain obligated to ensure that it is\r\n    available for as long as needed to satisfy these requirements.\r\n\r\n    e) Convey the object code using peer-to-peer transmission, provided\r\n    you inform other peers where the object code and Corresponding\r\n    Source of the work are being offered to the general public at no\r\n    charge under subsection 6d.\r\n\r\n  A separable portion of the object code, whose source code is excluded\r\nfrom the Corresponding Source as a System Library, need not be\r\nincluded in conveying the object code work.\r\n\r\n  A &quot;User Product&quot; is either (1) a &quot;consumer product&quot;, which means any\r\ntangible personal property which is normally used for personal, family,\r\nor household purposes, or (2) anything designed or sold for incorporation\r\ninto a dwelling.  In determining whether a product is a consumer product,\r\ndoubtful cases shall be resolved in favor of coverage.  For a particular\r\nproduct received by a particular user, &quot;normally used&quot; refers to a\r\ntypical or common use of that class of product, regardless of the status\r\nof the particular user or of the way in which the particular user\r\nactually uses, or expects or is expected to use, the product.  A product\r\nis a consumer product regardless of whether the product has substantial\r\ncommercial, industrial or non-consumer uses, unless such uses represent\r\nthe only significant mode of use of the product.\r\n\r\n  &quot;Installation Information&quot; for a User Product means any methods,\r\nprocedures, authorization keys, or other information required to install\r\nand execute modified versions of a covered work in that User Product from\r\na modified version of its Corresponding Source.  The information must\r\nsuffice to ensure that the continued functioning of the modified object\r\ncode is in no case prevented or interfered with solely because\r\nmodification has been made.\r\n\r\n  If you convey an object code work under this section in, or with, or\r\nspecifically for use in, a User Product, and the conveying occurs as\r\npart of a transaction in which the right of possession and use of the\r\nUser Product is transferred to the recipient in perpetuity or for a\r\nfixed term (regardless of how the transaction is characterized), the\r\nCorresponding Source conveyed under this section must be accompanied\r\nby the Installation Information.  But this requirement does not apply\r\nif neither you nor any third party retains the ability to install\r\nmodified object code on the User Product (for example, the work has\r\nbeen installed in ROM).\r\n\r\n  The requirement to provide Installation Information does not include a\r\nrequirement to continue to provide support service, warranty, or updates\r\nfor a work that has been modified or installed by the recipient, or for\r\nthe User Product in which it has been modified or installed.  Access to a\r\nnetwork may be denied when the modification itself materially and\r\nadversely affects the operation of the network or violates the rules and\r\nprotocols for communication across the network.\r\n\r\n  Corresponding Source conveyed, and Installation Information provided,\r\nin accord with this section must be in a format that is publicly\r\ndocumented (and with an implementation available to the public in\r\nsource code form), and must require no special password or key for\r\nunpacking, reading or copying.\r\n\r\n  7. Additional Terms.\r\n\r\n  &quot;Additional permissions&quot; are terms that supplement the terms of this\r\nLicense by making exceptions from one or more of its conditions.\r\nAdditional permissions that are applicable to the entire Program shall\r\nbe treated as though they were included in this License, to the extent\r\nthat they are valid under applicable law.  If additional permissions\r\napply only to part of the Program, that part may be used separately\r\nunder those permissions, but the entire Program remains governed by\r\nthis License without regard to the additional permissions.\r\n\r\n  When you convey a copy of a covered work, you may at your option\r\nremove any additional permissions from that copy, or from any part of\r\nit.  (Additional permissions may be written to require their own\r\nremoval in certain cases when you modify the work.)  You may place\r\nadditional permissions on material, added by you to a covered work,\r\nfor which you have or can give appropriate copyright permission.\r\n\r\n  Notwithstanding any other provision of this License, for material you\r\nadd to a covered work, you may (if authorized by the copyright holders of\r\nthat material) supplement the terms of this License with terms:\r\n\r\n    a) Disclaiming warranty or limiting liability differently from the\r\n    terms of sections 15 and 16 of this License; or\r\n\r\n    b) Requiring preservation of specified reasonable legal notices or\r\n    author attributions in that material or in the Appropriate Legal\r\n    Notices displayed by works containing it; or\r\n\r\n    c) Prohibiting misrepresentation of the origin of that material, or\r\n    requiring that modified versions of such material be marked in\r\n    reasonable ways as different from the original version; or\r\n\r\n    d) Limiting the use for publicity purposes of names of licensors or\r\n    authors of the material; or\r\n\r\n    e) Declining to grant rights under trademark law for use of some\r\n    trade names, trademarks, or service marks; or\r\n\r\n    f) Requiring indemnification of licensors and authors of that\r\n    material by anyone who conveys the material (or modified versions of\r\n    it) with contractual assumptions of liability to the recipient, for\r\n    any liability that these contractual assumptions directly impose on\r\n    those licensors and authors.\r\n\r\n  All other non-permissive additional terms are considered &quot;further\r\nrestrictions&quot; within the meaning of section 10.  If the Program as you\r\nreceived it, or any part of it, contains a notice stating that it is\r\ngoverned by this License along with a term that is a further\r\nrestriction, you may remove that term.  If a license document contains\r\na further restriction but permits relicensing or conveying under this\r\nLicense, you may add to a covered work material governed by the terms\r\nof that license document, provided that the further restriction does\r\nnot survive such relicensing or conveying.\r\n\r\n  If you add terms to a covered work in accord with this section, you\r\nmust place, in the relevant source files, a statement of the\r\nadditional terms that apply to those files, or a notice indicating\r\nwhere to find the applicable terms.\r\n\r\n  Additional terms, permissive or non-permissive, may be stated in the\r\nform of a separately written license, or stated as exceptions;\r\nthe above requirements apply either way.\r\n\r\n  8. Termination.\r\n\r\n  You may not propagate or modify a covered work except as expressly\r\nprovided under this License.  Any attempt otherwise to propagate or\r\nmodify it is void, and will automatically terminate your rights under\r\nthis License (including any patent licenses granted under the third\r\nparagraph of section 11).\r\n\r\n  However, if you cease all violation of this License, then your\r\nlicense from a particular copyright holder is reinstated (a)\r\nprovisionally, unless and until the copyright holder explicitly and\r\nfinally terminates your license, and (b) permanently, if the copyright\r\nholder fails to notify you of the violation by some reasonable means\r\nprior to 60 days after the cessation.\r\n\r\n  Moreover, your license from a particular copyright holder is\r\nreinstated permanently if the copyright holder notifies you of the\r\nviolation by some reasonable means, this is the first time you have\r\nreceived notice of violation of this License (for any work) from that\r\ncopyright holder, and you cure the violation prior to 30 days after\r\nyour receipt of the notice.\r\n\r\n  Termination of your rights under this section does not terminate the\r\nlicenses of parties who have received copies or rights from you under\r\nthis License.  If your rights have been terminated and not permanently\r\nreinstated, you do not qualify to receive new licenses for the same\r\nmaterial under section 10.\r\n\r\n  9. Acceptance Not Required for Having Copies.\r\n\r\n  You are not required to accept this License in order to receive or\r\nrun a copy of the Program.  Ancillary propagation of a covered work\r\noccurring solely as a consequence of using peer-to-peer transmission\r\nto receive a copy likewise does not require acceptance.  However,\r\nnothing other than this License grants you permission to propagate or\r\nmodify any covered work.  These actions infringe copyright if you do\r\nnot accept this License.  Therefore, by modifying or propagating a\r\ncovered work, you indicate your acceptance of this License to do so.\r\n\r\n  10. Automatic Licensing of Downstream Recipients.\r\n\r\n  Each time you convey a covered work, the recipient automatically\r\nreceives a license from the original licensors, to run, modify and\r\npropagate that work, subject to this License.  You are not responsible\r\nfor enforcing compliance by third parties with this License.\r\n\r\n  An &quot;entity transaction&quot; is a transaction transferring control of an\r\norganization, or substantially all assets of one, or subdividing an\r\norganization, or merging organizations.  If propagation of a covered\r\nwork results from an entity transaction, each party to that\r\ntransaction who receives a copy of the work also receives whatever\r\nlicenses to the work the party\'s predecessor in interest had or could\r\ngive under the previous paragraph, plus a right to possession of the\r\nCorresponding Source of the work from the predecessor in interest, if\r\nthe predecessor has it or can get it with reasonable efforts.\r\n\r\n  You may not impose any further restrictions on the exercise of the\r\nrights granted or affirmed under this License.  For example, you may\r\nnot impose a license fee, royalty, or other charge for exercise of\r\nrights granted under this License, and you may not initiate litigation\r\n(including a cross-claim or counterclaim in a lawsuit) alleging that\r\nany patent claim is infringed by making, using, selling, offering for\r\nsale, or importing the Program or any portion of it.\r\n\r\n  11. Patents.\r\n\r\n  A &quot;contributor&quot; is a copyright holder who authorizes use under this\r\nLicense of the Program or a work on which the Program is based.  The\r\nwork thus licensed is called the contributor\'s &quot;contributor version&quot;.\r\n\r\n  A contributor\'s &quot;essential patent claims&quot; are all patent claims\r\nowned or controlled by the contributor, whether already acquired or\r\nhereafter acquired, that would be infringed by some manner, permitted\r\nby this License, of making, using, or selling its contributor version,\r\nbut do not include claims that would be infringed only as a\r\nconsequence of further modification of the contributor version.  For\r\npurposes of this definition, &quot;control&quot; includes the right to grant\r\npatent sublicenses in a manner consistent with the requirements of\r\nthis License.\r\n\r\n  Each contributor grants you a non-exclusive, worldwide, royalty-free\r\npatent license under the contributor\'s essential patent claims, to\r\nmake, use, sell, offer for sale, import and otherwise run, modify and\r\npropagate the contents of its contributor version.\r\n\r\n  In the following three paragraphs, a &quot;patent license&quot; is any express\r\nagreement or commitment, however denominated, not to enforce a patent\r\n(such as an express permission to practice a patent or covenant not to\r\nsue for patent infringement).  To &quot;grant&quot; such a patent license to a\r\nparty means to make such an agreement or commitment not to enforce a\r\npatent against the party.\r\n\r\n  If you convey a covered work, knowingly relying on a patent license,\r\nand the Corresponding Source of the work is not available for anyone\r\nto copy, free of charge and under the terms of this License, through a\r\npublicly available network server or other readily accessible means,\r\nthen you must either (1) cause the Corresponding Source to be so\r\navailable, or (2) arrange to deprive yourself of the benefit of the\r\npatent license for this particular work, or (3) arrange, in a manner\r\nconsistent with the requirements of this License, to extend the patent\r\nlicense to downstream recipients.  &quot;Knowingly relying&quot; means you have\r\nactual knowledge that, but for the patent license, your conveying the\r\ncovered work in a country, or your recipient\'s use of the covered work\r\nin a country, would infringe one or more identifiable patents in that\r\ncountry that you have reason to believe are valid.\r\n\r\n  If, pursuant to or in connection with a single transaction or\r\narrangement, you convey, or propagate by procuring conveyance of, a\r\ncovered work, and grant a patent license to some of the parties\r\nreceiving the covered work authorizing them to use, propagate, modify\r\nor convey a specific copy of the covered work, then the patent license\r\nyou grant is automatically extended to all recipients of the covered\r\nwork and works based on it.\r\n\r\n  A patent license is &quot;discriminatory&quot; if it does not include within\r\nthe scope of its coverage, prohibits the exercise of, or is\r\nconditioned on the non-exercise of one or more of the rights that are\r\nspecifically granted under this License.  You may not convey a covered\r\nwork if you are a party to an arrangement with a third party that is\r\nin the business of distributing software, under which you make payment\r\nto the third party based on the extent of your activity of conveying\r\nthe work, and under which the third party grants, to any of the\r\nparties who would receive the covered work from you, a discriminatory\r\npatent license (a) in connection with copies of the covered work\r\nconveyed by you (or copies made from those copies), or (b) primarily\r\nfor and in connection with specific products or compilations that\r\ncontain the covered work, unless you entered into that arrangement,\r\nor that patent license was granted, prior to 28 March 2007.\r\n\r\n  Nothing in this License shall be construed as excluding or limiting\r\nany implied license or other defenses to infringement that may\r\notherwise be available to you under applicable patent law.\r\n\r\n  12. No Surrender of Others\' Freedom.\r\n\r\n  If conditions are imposed on you (whether by court order, agreement or\r\notherwise) that contradict the conditions of this License, they do not\r\nexcuse you from the conditions of this License.  If you cannot convey a\r\ncovered work so as to satisfy simultaneously your obligations under this\r\nLicense and any other pertinent obligations, then as a consequence you may\r\nnot convey it at all.  For example, if you agree to terms that obligate you\r\nto collect a royalty for further conveying from those to whom you convey\r\nthe Program, the only way you could satisfy both those terms and this\r\nLicense would be to refrain entirely from conveying the Program.\r\n\r\n  13. Use with the GNU Affero General Public License.\r\n\r\n  Notwithstanding any other provision of this License, you have\r\npermission to link or combine any covered work with a work licensed\r\nunder version 3 of the GNU Affero General Public License into a single\r\ncombined work, and to convey the resulting work.  The terms of this\r\nLicense will continue to apply to the part which is the covered work,\r\nbut the special requirements of the GNU Affero General Public License,\r\nsection 13, concerning interaction through a network will apply to the\r\ncombination as such.\r\n\r\n  14. Revised Versions of this License.\r\n\r\n  The Free Software Foundation may publish revised and/or new versions of\r\nthe GNU General Public License from time to time.  Such new versions will\r\nbe similar in spirit to the present version, but may differ in detail to\r\naddress new problems or concerns.\r\n\r\n  Each version is given a distinguishing version number.  If the\r\nProgram specifies that a certain numbered version of the GNU General\r\nPublic License &quot;or any later version&quot; applies to it, you have the\r\noption of following the terms and conditions either of that numbered\r\nversion or of any later version published by the Free Software\r\nFoundation.  If the Program does not specify a version number of the\r\nGNU General Public License, you may choose any version ever published\r\nby the Free Software Foundation.\r\n\r\n  If the Program specifies that a proxy can decide which future\r\nversions of the GNU General Public License can be used, that proxy\'s\r\npublic statement of acceptance of a version permanently authorizes you\r\nto choose that version for the Program.\r\n\r\n  Later license versions may give you additional or different\r\npermissions.  However, no additional obligations are imposed on any\r\nauthor or copyright holder as a result of your choosing to follow a\r\nlater version.\r\n\r\n  15. Disclaimer of Warranty.\r\n\r\n  THERE IS NO WARRANTY FOR THE PROGRAM, TO THE EXTENT PERMITTED BY\r\nAPPLICABLE LAW.  EXCEPT WHEN OTHERWISE STATED IN WRITING THE COPYRIGHT\r\nHOLDERS AND/OR OTHER PARTIES PROVIDE THE PROGRAM &quot;AS IS&quot; WITHOUT WARRANTY\r\nOF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING, BUT NOT LIMITED TO,\r\nTHE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR\r\nPURPOSE.  THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THE PROGRAM\r\nIS WITH YOU.  SHOULD THE PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF\r\nALL NECESSARY SERVICING, REPAIR OR CORRECTION.\r\n\r\n  16. Limitation of Liability.\r\n\r\n  IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN WRITING\r\nWILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MODIFIES AND/OR CONVEYS\r\nTHE PROGRAM AS PERMITTED ABOVE, BE LIABLE TO YOU FOR DAMAGES, INCLUDING ANY\r\nGENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE\r\nUSE OR INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT LIMITED TO LOSS OF\r\nDATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY YOU OR THIRD\r\nPARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY OTHER PROGRAMS),\r\nEVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE POSSIBILITY OF\r\nSUCH DAMAGES.\r\n\r\n  17. Interpretation of Sections 15 and 16.\r\n\r\n  If the disclaimer of warranty and limitation of liability provided\r\nabove cannot be given local legal effect according to their terms,\r\nreviewing courts shall apply local law that most closely approximates\r\nan absolute waiver of all civil liability in connection with the\r\nProgram, unless a warranty or assumption of liability accompanies a\r\ncopy of the Program in return for a fee.\r\n','LGPL',4);

--
-- HUBzero sample data for table `#__xorganization_types`
--

INSERT INTO `#__xorganization_types` VALUES (1,'government','Government Agency');
INSERT INTO `#__xorganization_types` VALUES (2,'industry','Industry / Private Company');
INSERT INTO `#__xorganization_types` VALUES (3,'military','Military');
INSERT INTO `#__xorganization_types` VALUES (4,'nationallab','National Laboratory');
INSERT INTO `#__xorganization_types` VALUES (5,'universityfaculty','University / College Faculty');
INSERT INTO `#__xorganization_types` VALUES (6,'universitystaff','University / College Staff');
INSERT INTO `#__xorganization_types` VALUES (7,'universityundergraduate','University / College Undergraduate');
INSERT INTO `#__xorganization_types` VALUES (8,'precollegefacultystaff','K-12 (Pre-College) Faculty or Staff');
INSERT INTO `#__xorganization_types` VALUES (9,'precollegestudent','K-12 (Pre-College) Student');
INSERT INTO `#__xorganization_types` VALUES (10,'unemployed','Retired / Unemployed');
INSERT INTO `#__xorganization_types` VALUES (11,'universitygraduate','University / College Graduate Student');

--
-- HUBzero sample data for table `#__poll_data`
--

INSERT INTO `#__poll_data` VALUES (1,1,'Graduate student',0);
INSERT INTO `#__poll_data` VALUES (2,1,'Undergraduate student',0);
INSERT INTO `#__poll_data` VALUES (3,1,'High school or elementary student',0);
INSERT INTO `#__poll_data` VALUES (4,1,'College faculty',0);
INSERT INTO `#__poll_data` VALUES (5,1,'Professional scientist/engineer',0);
INSERT INTO `#__poll_data` VALUES (6,1,'Retired, but still curious',0);

--
-- HUBzero sample data for table `#__poll_menu`
--

INSERT INTO `#__poll_menu` (`pollid`, `menuid`) VALUES (1,0);

--
-- HUBzero sample data for table `#__polls`
--

INSERT INTO `#__polls` (`id`, `title`, `voters`, `checked_out`, `checked_out_time`, `published`, `access`, `lag`, `open`, `opened`, `closed`) VALUES (1,'Who are you?',0,0,'0000-00-00 00:00:00',1,0,86400,1,NULL,NULL);

--
-- HUBzero sample data for table `#__incremental_registration_labels`
--

INSERT INTO `#__incremental_registration_labels` VALUES (1,'mailPreferenceOption','E-Mail Updates');
