/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;

class RfbProto {
    static final String versionMsg_3_3 = "RFB 003.003\n";
    static final String versionMsg_3_7 = "RFB 003.007\n";
    static final String versionMsg_3_8 = "RFB 003.008\n";
    static final String StandardVendor = "STDV";
    static final String TridiaVncVendor = "TRDV";
    static final String TightVncVendor = "TGHT";
    static final int SecTypeInvalid = 0;
    static final int SecTypeNone = 1;
    static final int SecTypeVncAuth = 2;
    static final int SecTypeTight = 16;
    static final int NoTunneling = 0;
    static final String SigNoTunneling = "NOTUNNEL";
    static final int AuthNone = 1;
    static final int AuthVNC = 2;
    static final int AuthUnixLogin = 129;
    static final String SigAuthNone = "NOAUTH__";
    static final String SigAuthVNC = "VNCAUTH_";
    static final String SigAuthUnixLogin = "ULGNAUTH";
    static final int VncAuthOK = 0;
    static final int VncAuthFailed = 1;
    static final int VncAuthTooMany = 2;
    static final int FramebufferUpdate = 0;
    static final int SetColourMapEntries = 1;
    static final int Bell = 2;
    static final int ServerCutText = 3;
    static final int ClientAction = 32;
    static final int EndOfContinuousUpdates = 150;
    static final String SigEndOfContinuousUpdates = "CUS_EOCU";
    static final int SetPixelFormat = 0;
    static final int FixColourMapEntries = 1;
    static final int SetEncodings = 2;
    static final int FramebufferUpdateRequest = 3;
    static final int KeyboardEvent = 4;
    static final int PointerEvent = 5;
    static final int ClientCutText = 6;
    static final int RequestFBSize = 32;
    static final int PREFIX_TIGHT = 252;
    static final int EnableContinuousUpdates = 150;
    static final String SigEnableContinuousUpdates = "CUC_ENCU";
    static final int VideoRectangleSelection = 151;
    static final String SigVideoRectangleSelection = "VRECTSEL";
    static final int VideoFreeze = 152;
    static final String SigVideoFreeze = "VD_FREEZ";
    static final int EnableVideoHandling = 153;
    static final String SigEnableVideoHandling = "VD_ENABL";
    static final int EncodingRaw = 0;
    static final int EncodingCopyRect = 1;
    static final int EncodingRRE = 2;
    static final int EncodingCoRRE = 4;
    static final int EncodingHextile = 5;
    static final int EncodingZlib = 6;
    static final int EncodingTight = 7;
    static final int EncodingZRLE = 16;
    static final int EncodingCompressLevel0 = -256;
    static final int EncodingQualityLevel0 = -32;
    static final int EncodingXCursor = -240;
    static final int EncodingRichCursor = -239;
    static final int EncodingPointerPos = -232;
    static final int EncodingLastRect = -224;
    static final int EncodingNewFBSize = -223;
    static final String SigEncodingRaw = "RAW_____";
    static final String SigEncodingCopyRect = "COPYRECT";
    static final String SigEncodingRRE = "RRE_____";
    static final String SigEncodingCoRRE = "CORRE___";
    static final String SigEncodingHextile = "HEXTILE_";
    static final String SigEncodingZlib = "ZLIB____";
    static final String SigEncodingTight = "TIGHT___";
    static final String SigEncodingZRLE = "ZRLE____";
    static final String SigEncodingCompressLevel0 = "COMPRLVL";
    static final String SigEncodingQualityLevel0 = "JPEGQLVL";
    static final String SigEncodingXCursor = "X11CURSR";
    static final String SigEncodingRichCursor = "RCHCURSR";
    static final String SigEncodingPointerPos = "POINTPOS";
    static final String SigEncodingLastRect = "LASTRECT";
    static final String SigEncodingNewFBSize = "NEWFBSIZ";
    static final int MaxNormalEncoding = 255;
    static final int HextileRaw = 1;
    static final int HextileBackgroundSpecified = 2;
    static final int HextileForegroundSpecified = 4;
    static final int HextileAnySubrects = 8;
    static final int HextileSubrectsColoured = 16;
    static final int TightMinToCompress = 12;
    static final int TightExplicitFilter = 4;
    static final int TightFill = 8;
    static final int TightJpeg = 9;
    static final int TightMaxSubencoding = 9;
    static final int TightFilterCopy = 0;
    static final int TightFilterPalette = 1;
    static final int TightFilterGradient = 2;
    String host;
    int port;
    Socket sock;
    OutputStream os;
    SessionRecorder rec;
    boolean inNormalProtocol = false;
    VncViewer viewer;
    private DataInputStream is;
    private long numBytesRead = 0L;
    boolean brokenKeyPressed = false;
    boolean wereZlibUpdates = false;
    boolean zlibWarningShown;
    boolean tightWarningShown;
    int numUpdatesInSession;
    boolean timing;
    long timeWaitedIn100us;
    long timedKbits;
    int serverMajor;
    int serverMinor;
    int clientMajor;
    int clientMinor;
    boolean protocolTightVNC;
    CapsContainer tunnelCaps;
    CapsContainer authCaps;
    CapsContainer serverMsgCaps;
    CapsContainer clientMsgCaps;
    CapsContainer encodingCaps;
    private boolean continuousUpdatesActive = false;
    private boolean continuousUpdatesEnding = false;
    private boolean closed;
    String desktopName;
    int framebufferWidth;
    int framebufferHeight;
    int bitsPerPixel;
    int depth;
    boolean bigEndian;
    boolean trueColour;
    int redMax;
    int greenMax;
    int blueMax;
    int redShift;
    int greenShift;
    int blueShift;
    int updateNRects;
    int updateRectX;
    int updateRectY;
    int updateRectW;
    int updateRectH;
    int updateRectEncoding;
    byte[] eventBuf = new byte[72];
    int eventBufLen;
    static final int CTRL_MASK = 2;
    static final int SHIFT_MASK = 1;
    static final int META_MASK = 4;
    static final int ALT_MASK = 8;
    int pointerMask = 0;
    int oldModifiers = 0;

    public long getNumBytesRead() {
        return this.numBytesRead;
    }

    RfbProto(String string, int n, VncViewer vncViewer) throws IOException {
        this.viewer = vncViewer;
        this.host = string;
        this.port = n;
        if (!this.viewer.disableSSL) {
            SocketToMe socketToMe;
            try {
                socketToMe = new SocketToMe(this.host, this.port, vncViewer);
            }
            catch (Exception exception) {
                throw new IOException(exception.getMessage());
            }
            try {
                this.sock = socketToMe.connectSock();
            }
            catch (Exception exception) {
                throw new IOException(exception.getMessage());
            }
        }
        if (this.viewer.socketFactory == null) {
            this.sock = new Socket(this.host, this.port);
            this.sock.setTcpNoDelay(true);
        } else {
            try {
                Class<?> clazz = Class.forName(this.viewer.socketFactory);
                SocketFactory socketFactory = (SocketFactory)clazz.newInstance();
                this.sock = this.viewer.inAnApplet ? socketFactory.createSocket(this.host, this.port, this.viewer) : socketFactory.createSocket(this.host, this.port, this.viewer.mainArgs);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new IOException(exception.getMessage());
            }
        }
        this.is = new DataInputStream(new BufferedInputStream(this.sock.getInputStream(), 16384));
        this.os = this.sock.getOutputStream();
        this.timing = false;
        this.timeWaitedIn100us = 5L;
        this.timedKbits = 0L;
    }

    synchronized void close() {
        try {
            this.sock.close();
            this.closed = true;
            System.out.println("RFB socket closed");
            if (this.rec != null) {
                this.rec.close();
                this.rec = null;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    synchronized boolean closed() {
        return this.closed;
    }

    void readVersionMsg() throws Exception {
        byte[] byArray = new byte[12];
        this.readFully(byArray);
        if (byArray[0] != 82 || byArray[1] != 70 || byArray[2] != 66 || byArray[3] != 32 || byArray[4] < 48 || byArray[4] > 57 || byArray[5] < 48 || byArray[5] > 57 || byArray[6] < 48 || byArray[6] > 57 || byArray[7] != 46 || byArray[8] < 48 || byArray[8] > 57 || byArray[9] < 48 || byArray[9] > 57 || byArray[10] < 48 || byArray[10] > 57 || byArray[11] != 10) {
            throw new Exception("Host " + this.host + " port " + this.port + " is not an RFB server");
        }
        this.serverMajor = (byArray[4] - 48) * 100 + (byArray[5] - 48) * 10 + (byArray[6] - 48);
        this.serverMinor = (byArray[8] - 48) * 100 + (byArray[9] - 48) * 10 + (byArray[10] - 48);
        if (this.serverMajor < 3) {
            throw new Exception("RFB server does not support protocol version 3");
        }
    }

    void writeVersionMsg() throws IOException {
        this.clientMajor = 3;
        if (this.serverMajor > 3 || this.serverMinor >= 8) {
            this.clientMinor = 8;
            this.os.write(versionMsg_3_8.getBytes());
        } else if (this.serverMinor >= 7) {
            this.clientMinor = 7;
            this.os.write(versionMsg_3_7.getBytes());
        } else {
            this.clientMinor = 3;
            this.os.write(versionMsg_3_3.getBytes());
        }
        this.protocolTightVNC = false;
        this.initCapabilities();
    }

    int negotiateSecurity() throws Exception {
        return this.clientMinor >= 7 ? this.selectSecurityType() : this.readSecurityType();
    }

    int readSecurityType() throws Exception {
        int n = this.readU32();
        switch (n) {
            case 0: {
                this.readConnFailedReason();
                return 0;
            }
            case 1: 
            case 2: {
                return n;
            }
        }
        throw new Exception("Unknown security type from RFB server: " + n);
    }

    int selectSecurityType() throws Exception {
        int n;
        int n2 = 0;
        int n3 = this.readU8();
        if (n3 == 0) {
            this.readConnFailedReason();
            return 0;
        }
        byte[] byArray = new byte[n3];
        this.readFully(byArray);
        for (n = 0; n < n3; ++n) {
            if (byArray[n] != 16) continue;
            this.protocolTightVNC = true;
            this.os.write(16);
            return 16;
        }
        for (n = 0; n < n3; ++n) {
            if (byArray[n] != 1 && byArray[n] != 2) continue;
            n2 = byArray[n];
            break;
        }
        if (n2 == 0) {
            throw new Exception("Server did not offer supported security type");
        }
        this.os.write(n2);
        return n2;
    }

    void authenticateNone() throws Exception {
        if (this.clientMinor >= 8) {
            this.readSecurityResult("No authentication");
        }
    }

    void authenticateVNC(String string) throws Exception {
        int n;
        byte[] byArray = new byte[16];
        this.readFully(byArray);
        if (string.length() > 8) {
            string = string.substring(0, 8);
        }
        if ((n = string.indexOf(0)) != -1) {
            string = string.substring(0, n);
        }
        byte[] byArray2 = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
        System.arraycopy(string.getBytes(), 0, byArray2, 0, string.length());
        DesCipher desCipher = new DesCipher(byArray2);
        desCipher.encrypt(byArray, 0, byArray, 0);
        desCipher.encrypt(byArray, 8, byArray, 8);
        this.os.write(byArray);
        this.readSecurityResult("VNC authentication");
    }

    void readSecurityResult(String string) throws Exception {
        int n = this.readU32();
        switch (n) {
            case 0: {
                System.out.println(string + ": success");
                break;
            }
            case 1: {
                if (this.clientMinor >= 8) {
                    this.readConnFailedReason();
                }
                throw new Exception(string + ": failed");
            }
            case 2: {
                throw new Exception(string + ": failed, too many tries");
            }
            default: {
                throw new Exception(string + ": unknown result " + n);
            }
        }
    }

    void readConnFailedReason() throws Exception {
        int n = this.readU32();
        byte[] byArray = new byte[n];
        this.readFully(byArray);
        throw new Exception(new String(byArray));
    }

    void initCapabilities() {
        this.tunnelCaps = new CapsContainer();
        this.authCaps = new CapsContainer();
        this.serverMsgCaps = new CapsContainer();
        this.clientMsgCaps = new CapsContainer();
        this.encodingCaps = new CapsContainer();
        this.authCaps.add(1, StandardVendor, SigAuthNone, "No authentication");
        this.authCaps.add(2, StandardVendor, SigAuthVNC, "Standard VNC password authentication");
        this.serverMsgCaps.add(150, TightVncVendor, SigEndOfContinuousUpdates, "End of continuous updates notification");
        this.clientMsgCaps.add(150, TightVncVendor, SigEnableContinuousUpdates, "Enable/disable continuous updates");
        this.clientMsgCaps.add(151, TightVncVendor, SigVideoRectangleSelection, "Select a rectangle to be treated as video");
        this.clientMsgCaps.add(152, TightVncVendor, SigVideoFreeze, "Disable/enable video rectangle");
        this.clientMsgCaps.add(153, TightVncVendor, SigEnableVideoHandling, "Disable/enable special video handling");
        this.encodingCaps.add(1, StandardVendor, SigEncodingCopyRect, "Standard CopyRect encoding");
        this.encodingCaps.add(2, StandardVendor, SigEncodingRRE, "Standard RRE encoding");
        this.encodingCaps.add(4, StandardVendor, SigEncodingCoRRE, "Standard CoRRE encoding");
        this.encodingCaps.add(5, StandardVendor, SigEncodingHextile, "Standard Hextile encoding");
        this.encodingCaps.add(16, StandardVendor, SigEncodingZRLE, "Standard ZRLE encoding");
        this.encodingCaps.add(6, TridiaVncVendor, SigEncodingZlib, "Zlib encoding");
        this.encodingCaps.add(7, TightVncVendor, SigEncodingTight, "Tight encoding");
        this.encodingCaps.add(-256, TightVncVendor, SigEncodingCompressLevel0, "Compression level");
        this.encodingCaps.add(-32, TightVncVendor, SigEncodingQualityLevel0, "JPEG quality level");
        this.encodingCaps.add(-240, TightVncVendor, SigEncodingXCursor, "X-style cursor shape update");
        this.encodingCaps.add(-239, TightVncVendor, SigEncodingRichCursor, "Rich-color cursor shape update");
        this.encodingCaps.add(-232, TightVncVendor, SigEncodingPointerPos, "Pointer position update");
        this.encodingCaps.add(-224, TightVncVendor, SigEncodingLastRect, "LastRect protocol extension");
        this.encodingCaps.add(-223, TightVncVendor, SigEncodingNewFBSize, "Framebuffer size change");
    }

    void setupTunneling() throws IOException {
        int n = this.readU32();
        if (n != 0) {
            this.readCapabilityList(this.tunnelCaps, n);
            this.writeInt(0);
        }
    }

    int negotiateAuthenticationTight() throws Exception {
        int n = this.readU32();
        if (n == 0) {
            return 1;
        }
        this.readCapabilityList(this.authCaps, n);
        for (int i = 0; i < this.authCaps.numEnabled(); ++i) {
            int n2 = this.authCaps.getByOrder(i);
            if (n2 != 1 && n2 != 2) continue;
            this.writeInt(n2);
            return n2;
        }
        throw new Exception("No suitable authentication scheme found");
    }

    void readCapabilityList(CapsContainer capsContainer, int n) throws IOException {
        byte[] byArray = new byte[4];
        byte[] byArray2 = new byte[8];
        for (int i = 0; i < n; ++i) {
            int n2 = this.readU32();
            this.readFully(byArray);
            this.readFully(byArray2);
            capsContainer.enable(new CapabilityInfo(n2, byArray, byArray2));
        }
    }

    void writeInt(int n) throws IOException {
        byte[] byArray = new byte[]{(byte)(n >> 24 & 0xFF), (byte)(n >> 16 & 0xFF), (byte)(n >> 8 & 0xFF), (byte)(n & 0xFF)};
        this.os.write(byArray);
    }

    void writeClientInit() throws IOException {
        if (this.viewer.options.shareDesktop) {
            this.os.write(1);
        } else {
            this.os.write(0);
        }
        this.viewer.options.disableShareDesktop();
    }

    void readServerInit() throws IOException {
        this.framebufferWidth = this.readU16();
        this.framebufferHeight = this.readU16();
        this.bitsPerPixel = this.readU8();
        this.depth = this.readU8();
        this.bigEndian = this.readU8() != 0;
        this.trueColour = this.readU8() != 0;
        this.redMax = this.readU16();
        this.greenMax = this.readU16();
        this.blueMax = this.readU16();
        this.redShift = this.readU8();
        this.greenShift = this.readU8();
        this.blueShift = this.readU8();
        byte[] byArray = new byte[3];
        this.readFully(byArray);
        int n = this.readU32();
        byte[] byArray2 = new byte[n];
        this.readFully(byArray2);
        this.desktopName = new String(byArray2);
        if (this.protocolTightVNC) {
            int n2 = this.readU16();
            int n3 = this.readU16();
            int n4 = this.readU16();
            this.readU16();
            this.readCapabilityList(this.serverMsgCaps, n2);
            this.readCapabilityList(this.clientMsgCaps, n3);
            this.readCapabilityList(this.encodingCaps, n4);
        }
        if (!this.clientMsgCaps.isEnabled(150)) {
            this.viewer.options.disableContUpdates();
        }
        this.inNormalProtocol = true;
    }

    void startSession(String string) throws IOException {
        this.rec = new SessionRecorder(string);
        this.rec.writeHeader();
        this.rec.write(versionMsg_3_3.getBytes());
        this.rec.writeIntBE(1);
        this.rec.writeShortBE(this.framebufferWidth);
        this.rec.writeShortBE(this.framebufferHeight);
        byte[] byArray = new byte[]{32, 24, 0, 1, 0, -1, 0, -1, 0, -1, 16, 8, 0, 0, 0, 0};
        this.rec.write(byArray);
        this.rec.writeIntBE(this.desktopName.length());
        this.rec.write(this.desktopName.getBytes());
        this.numUpdatesInSession = 0;
        this.zlibWarningShown = false;
        this.tightWarningShown = false;
    }

    void closeSession() throws IOException {
        if (this.rec != null) {
            this.rec.close();
            this.rec = null;
        }
    }

    void setFramebufferSize(int n, int n2) {
        this.framebufferWidth = n;
        this.framebufferHeight = n2;
    }

    int readServerMessageType() throws IOException {
        int n = this.readU8();
        if (this.protocolTightVNC && n == 252) {
            byte[] byArray = new byte[3];
            this.readFully(byArray);
            n = (int)(0xFC000000L | (long)byArray[0] << 16 | (long)byArray[1] << 8 | (long)byArray[2]);
        }
        if (this.rec != null && n == 2) {
            this.rec.writeByte(n);
            if (this.numUpdatesInSession > 0) {
                this.rec.flush();
            }
        }
        return n;
    }

    void readFramebufferUpdate() throws IOException {
        this.skipBytes(1);
        this.updateNRects = this.readU16();
        if (this.rec != null) {
            this.rec.writeByte(0);
            this.rec.writeByte(0);
            this.rec.writeShortBE(this.updateNRects);
        }
        ++this.numUpdatesInSession;
    }

    boolean isRealDecoderEncoding(int n) {
        return n >= 1 && n <= 16;
    }

    void readFramebufferUpdateRectHdr() throws Exception {
        this.updateRectX = this.readU16();
        this.updateRectY = this.readU16();
        this.updateRectW = this.readU16();
        this.updateRectH = this.readU16();
        this.updateRectEncoding = this.readU32();
        if (this.updateRectEncoding == 6 || this.updateRectEncoding == 16 || this.updateRectEncoding == 7) {
            this.wereZlibUpdates = true;
        }
        if (this.rec != null) {
            if (this.numUpdatesInSession > 1) {
                this.rec.flush();
            }
            this.rec.writeShortBE(this.updateRectX);
            this.rec.writeShortBE(this.updateRectY);
            this.rec.writeShortBE(this.updateRectW);
            this.rec.writeShortBE(this.updateRectH);
            if (!this.isRealDecoderEncoding(this.updateRectEncoding) && this.rec != null) {
                this.rec.writeIntBE(this.updateRectEncoding);
            }
        }
        if (this.updateRectEncoding < 0 || this.updateRectEncoding > 255) {
            return;
        }
        if (this.updateRectX + this.updateRectW > this.framebufferWidth || this.updateRectY + this.updateRectH > this.framebufferHeight) {
            throw new Exception("Framebuffer update rectangle too large: " + this.updateRectW + "x" + this.updateRectH + " at (" + this.updateRectX + "," + this.updateRectY + ")");
        }
    }

    String readServerCutText() throws IOException {
        this.skipBytes(3);
        int n = this.readU32();
        byte[] byArray = new byte[n];
        this.readFully(byArray);
        return new String(byArray);
    }

    String readClientAction() throws IOException {
        byte[] byArray = new byte[3];
        this.readFully(byArray);
        int n = this.readU32();
        byte[] byArray2 = new byte[n];
        this.readFully(byArray2);
        return new String(byArray2);
    }

    int readCompactLen() throws IOException {
        int[] nArray = new int[3];
        nArray[0] = this.readU8();
        int n = 1;
        int n2 = nArray[0] & 0x7F;
        if ((nArray[0] & 0x80) != 0) {
            nArray[1] = this.readU8();
            ++n;
            n2 |= (nArray[1] & 0x7F) << 7;
            if ((nArray[1] & 0x80) != 0) {
                nArray[2] = this.readU8();
                ++n;
                n2 |= (nArray[2] & 0xFF) << 14;
            }
        }
        return n2;
    }

    void writeFramebufferUpdateRequest(int n, int n2, int n3, int n4, boolean bl) throws IOException {
        byte[] byArray = new byte[]{3, (byte)(bl ? 1 : 0), (byte)(n >> 8 & 0xFF), (byte)(n & 0xFF), (byte)(n2 >> 8 & 0xFF), (byte)(n2 & 0xFF), (byte)(n3 >> 8 & 0xFF), (byte)(n3 & 0xFF), (byte)(n4 >> 8 & 0xFF), (byte)(n4 & 0xFF)};
        this.os.write(byArray);
    }

    void writeSetPixelFormat(int n, int n2, boolean bl, boolean bl2, int n3, int n4, int n5, int n6, int n7, int n8) throws IOException {
        byte[] byArray = new byte[20];
        byArray[0] = 0;
        byArray[4] = (byte)n;
        byArray[5] = (byte)n2;
        byArray[6] = (byte)(bl ? 1 : 0);
        byArray[7] = (byte)(bl2 ? 1 : 0);
        byArray[8] = (byte)(n3 >> 8 & 0xFF);
        byArray[9] = (byte)(n3 & 0xFF);
        byArray[10] = (byte)(n4 >> 8 & 0xFF);
        byArray[11] = (byte)(n4 & 0xFF);
        byArray[12] = (byte)(n5 >> 8 & 0xFF);
        byArray[13] = (byte)(n5 & 0xFF);
        byArray[14] = (byte)n6;
        byArray[15] = (byte)n7;
        byArray[16] = (byte)n8;
        this.os.write(byArray);
    }

    void writeFixColourMapEntries(int n, int n2, int[] nArray, int[] nArray2, int[] nArray3) throws IOException {
        byte[] byArray = new byte[6 + n2 * 6];
        byArray[0] = 1;
        byArray[2] = (byte)(n >> 8 & 0xFF);
        byArray[3] = (byte)(n & 0xFF);
        byArray[4] = (byte)(n2 >> 8 & 0xFF);
        byArray[5] = (byte)(n2 & 0xFF);
        for (int i = 0; i < n2; ++i) {
            byArray[6 + i * 6] = (byte)(nArray[i] >> 8 & 0xFF);
            byArray[6 + i * 6 + 1] = (byte)(nArray[i] & 0xFF);
            byArray[6 + i * 6 + 2] = (byte)(nArray2[i] >> 8 & 0xFF);
            byArray[6 + i * 6 + 3] = (byte)(nArray2[i] & 0xFF);
            byArray[6 + i * 6 + 4] = (byte)(nArray3[i] >> 8 & 0xFF);
            byArray[6 + i * 6 + 5] = (byte)(nArray3[i] & 0xFF);
        }
        this.os.write(byArray);
    }

    void writeSetEncodings(int[] nArray, int n) throws IOException {
        byte[] byArray = new byte[4 + 4 * n];
        byArray[0] = 2;
        byArray[2] = (byte)(n >> 8 & 0xFF);
        byArray[3] = (byte)(n & 0xFF);
        for (int i = 0; i < n; ++i) {
            byArray[4 + 4 * i] = (byte)(nArray[i] >> 24 & 0xFF);
            byArray[5 + 4 * i] = (byte)(nArray[i] >> 16 & 0xFF);
            byArray[6 + 4 * i] = (byte)(nArray[i] >> 8 & 0xFF);
            byArray[7 + 4 * i] = (byte)(nArray[i] & 0xFF);
        }
        this.os.write(byArray);
    }

    void writeClientCutText(String string) throws IOException {
        byte[] byArray = new byte[8 + string.length()];
        byArray[0] = 6;
        byArray[4] = (byte)(string.length() >> 24 & 0xFF);
        byArray[5] = (byte)(string.length() >> 16 & 0xFF);
        byArray[6] = (byte)(string.length() >> 8 & 0xFF);
        byArray[7] = (byte)(string.length() & 0xFF);
        System.arraycopy(string.getBytes(), 0, byArray, 8, string.length());
        this.os.write(byArray);
    }

    void writeRequestFBSize(int n, int n2) throws IOException {
        byte[] byArray = new byte[]{32, 42, (byte)(n >> 8 & 0xFF), (byte)(n & 0xFF), (byte)(n2 >> 8 & 0xFF), (byte)(n2 & 0xFF)};
        this.os.write(byArray);
    }

    void writePointerEvent(MouseEvent mouseEvent) throws IOException {
        this.writePointerEvent(mouseEvent, false);
    }

    void writePointerEvent(MouseEvent mouseEvent, boolean bl) throws IOException {
        this.writePointerEvent(mouseEvent, bl, false, 0);
    }

    void writePointerEvent(MouseEvent mouseEvent, boolean bl, boolean bl2, int n) throws IOException {
        int n2 = mouseEvent.getModifiers();
        int n3 = 2;
        int n4 = 4;
        int n5 = 8;
        int n6 = 16;
        if (this.viewer.options.reverseMouseButtons2And3) {
            n3 = 4;
            n4 = 2;
        }
        if (bl2) {
            if (bl) {
                if (n < 0) {
                    this.pointerMask = n5;
                    n2 &= 0xFFFFFFF7;
                } else {
                    this.pointerMask = n6;
                    n2 &= 0xFFFFFFFB;
                }
            } else {
                this.pointerMask = 0;
                n2 = n < 0 ? (n2 &= 0xFFFFFFF7) : (n2 &= 0xFFFFFFFB);
            }
        } else if (mouseEvent.getID() == 501) {
            if ((n2 & 8) != 0) {
                this.pointerMask = n3;
                n2 &= 0xFFFFFFF7;
            } else if ((n2 & 4) != 0) {
                this.pointerMask = n4;
                n2 &= 0xFFFFFFFB;
            } else {
                this.pointerMask = 1;
            }
        } else if (mouseEvent.getID() == 502) {
            this.pointerMask = 0;
            if ((n2 & 8) != 0) {
                n2 &= 0xFFFFFFF7;
            } else if ((n2 & 4) != 0) {
                n2 &= 0xFFFFFFFB;
            }
        }
        this.eventBufLen = 0;
        this.writeModifierKeyEvents(n2);
        int n7 = mouseEvent.getX();
        int n8 = mouseEvent.getY();
        if (n7 < 0) {
            n7 = 0;
        }
        if (n8 < 0) {
            n8 = 0;
        }
        this.eventBuf[this.eventBufLen++] = 5;
        this.eventBuf[this.eventBufLen++] = (byte)this.pointerMask;
        this.eventBuf[this.eventBufLen++] = (byte)(n7 >> 8 & 0xFF);
        this.eventBuf[this.eventBufLen++] = (byte)(n7 & 0xFF);
        this.eventBuf[this.eventBufLen++] = (byte)(n8 >> 8 & 0xFF);
        this.eventBuf[this.eventBufLen++] = (byte)(n8 & 0xFF);
        if (this.pointerMask == 0) {
            this.writeModifierKeyEvents(0);
        }
        this.os.write(this.eventBuf, 0, this.eventBufLen);
    }

    void writeKeyEvent(KeyEvent keyEvent) throws IOException {
        int n;
        boolean bl;
        block44: {
            int n2;
            block43: {
                n2 = keyEvent.getKeyChar();
                if (n2 == 0) {
                    n2 = 65535;
                }
                if (n2 == 65535 && ((bl = keyEvent.getKeyCode()) || bl || bl || bl)) {
                    return;
                }
                boolean bl2 = bl = keyEvent.getID() == 401;
                if (!keyEvent.isActionKey()) break block43;
                switch (keyEvent.getKeyCode()) {
                    case 36: {
                        n = 65360;
                        break block44;
                    }
                    case 37: {
                        n = 65361;
                        break block44;
                    }
                    case 38: {
                        n = 65362;
                        break block44;
                    }
                    case 39: {
                        n = 65363;
                        break block44;
                    }
                    case 40: {
                        n = 65364;
                        break block44;
                    }
                    case 33: {
                        n = 65365;
                        break block44;
                    }
                    case 34: {
                        n = 65366;
                        break block44;
                    }
                    case 35: {
                        n = 65367;
                        break block44;
                    }
                    case 155: {
                        n = 65379;
                        break block44;
                    }
                    case 112: {
                        n = 65470;
                        break block44;
                    }
                    case 113: {
                        n = 65471;
                        break block44;
                    }
                    case 114: {
                        n = 65472;
                        break block44;
                    }
                    case 115: {
                        n = 65473;
                        break block44;
                    }
                    case 116: {
                        n = 65474;
                        break block44;
                    }
                    case 117: {
                        n = 65475;
                        break block44;
                    }
                    case 118: {
                        n = 65476;
                        break block44;
                    }
                    case 119: {
                        n = 65477;
                        break block44;
                    }
                    case 120: {
                        n = 65478;
                        break block44;
                    }
                    case 121: {
                        n = 65479;
                        break block44;
                    }
                    case 122: {
                        n = 65480;
                        break block44;
                    }
                    case 123: {
                        n = 65481;
                        break block44;
                    }
                    default: {
                        return;
                    }
                }
            }
            n = n2;
            if (n < 32) {
                if (keyEvent.isControlDown()) {
                    n += 96;
                } else {
                    switch (n) {
                        case 8: {
                            n = 65288;
                            break;
                        }
                        case 9: {
                            n = 65289;
                            break;
                        }
                        case 10: {
                            n = 65293;
                            break;
                        }
                        case 27: {
                            n = 65307;
                        }
                    }
                }
            } else if (n == 127) {
                n = 65535;
            } else if (!(n <= 255 || n >= 65280 && n <= 65535 || n >= 8352 && n <= 8367)) {
                return;
            }
        }
        if (n == 229 || n == 197 || n == 228 || n == 196 || n == 246 || n == 214 || n == 167 || n == 189 || n == 163) {
            if (bl) {
                this.brokenKeyPressed = true;
            }
            if (!bl && !this.brokenKeyPressed) {
                this.eventBufLen = 0;
                this.writeModifierKeyEvents(keyEvent.getModifiers());
                this.writeKeyEvent(n, true);
                this.os.write(this.eventBuf, 0, this.eventBufLen);
            }
            if (!bl) {
                this.brokenKeyPressed = false;
            }
        }
        this.eventBufLen = 0;
        this.writeModifierKeyEvents(keyEvent.getModifiers());
        this.writeKeyEvent(n, bl);
        if (!bl) {
            this.writeModifierKeyEvents(0);
        }
        this.os.write(this.eventBuf, 0, this.eventBufLen);
    }

    void writeKeyEvent(int n, boolean bl) {
        this.eventBuf[this.eventBufLen++] = 4;
        this.eventBuf[this.eventBufLen++] = (byte)(bl ? 1 : 0);
        this.eventBuf[this.eventBufLen++] = 0;
        this.eventBuf[this.eventBufLen++] = 0;
        this.eventBuf[this.eventBufLen++] = (byte)(n >> 24 & 0xFF);
        this.eventBuf[this.eventBufLen++] = (byte)(n >> 16 & 0xFF);
        this.eventBuf[this.eventBufLen++] = (byte)(n >> 8 & 0xFF);
        this.eventBuf[this.eventBufLen++] = (byte)(n & 0xFF);
    }

    void writeModifierKeyEvents(int n) {
        if ((n & 2) != (this.oldModifiers & 2)) {
            this.writeKeyEvent(65507, (n & 2) != 0);
        }
        if ((n & 1) != (this.oldModifiers & 1)) {
            this.writeKeyEvent(65505, (n & 1) != 0);
        }
        if ((n & 4) != (this.oldModifiers & 4)) {
            this.writeKeyEvent(65511, (n & 4) != 0);
        }
        if ((n & 8) != (this.oldModifiers & 8)) {
            this.writeKeyEvent(65513, (n & 8) != 0);
        }
        this.oldModifiers = n;
    }

    void tryEnableContinuousUpdates(int n, int n2, int n3, int n4) throws IOException {
        if (!this.clientMsgCaps.isEnabled(150)) {
            System.out.println("Continuous updates not supported by the server");
            return;
        }
        if (this.continuousUpdatesActive) {
            System.out.println("Continuous updates already active");
            return;
        }
        byte[] byArray = new byte[]{-106, 1, (byte)(n >> 8 & 0xFF), (byte)(n & 0xFF), (byte)(n2 >> 8 & 0xFF), (byte)(n2 & 0xFF), (byte)(n3 >> 8 & 0xFF), (byte)(n3 & 0xFF), (byte)(n4 >> 8 & 0xFF), (byte)(n4 & 0xFF)};
        this.os.write(byArray);
        this.continuousUpdatesActive = true;
        System.out.println("Continuous updates activated");
    }

    void tryDisableContinuousUpdates() throws IOException {
        if (!this.clientMsgCaps.isEnabled(150)) {
            System.out.println("Continuous updates not supported by the server");
            return;
        }
        if (!this.continuousUpdatesActive) {
            System.out.println("Continuous updates already disabled");
            return;
        }
        if (this.continuousUpdatesEnding) {
            return;
        }
        byte[] byArray = new byte[]{-106, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        this.os.write(byArray);
        if (!this.serverMsgCaps.isEnabled(150)) {
            this.continuousUpdatesActive = false;
        } else {
            this.continuousUpdatesEnding = true;
        }
    }

    void endOfContinuousUpdates() {
        this.continuousUpdatesActive = false;
        this.continuousUpdatesEnding = false;
    }

    boolean continuousUpdatesAreActive() {
        return this.continuousUpdatesActive;
    }

    void trySendVideoSelection(Rectangle rectangle) throws IOException {
        if (!this.clientMsgCaps.isEnabled(151)) {
            System.out.println("Video area selection is not supported by the server");
            return;
        }
        if (rectangle.isEmpty()) {
            rectangle = new Rectangle();
        }
        int n = rectangle.x;
        int n2 = rectangle.y;
        int n3 = rectangle.width;
        int n4 = rectangle.height;
        byte[] byArray = new byte[]{-105, 0, (byte)(n >> 8 & 0xFF), (byte)(n & 0xFF), (byte)(n2 >> 8 & 0xFF), (byte)(n2 & 0xFF), (byte)(n3 >> 8 & 0xFF), (byte)(n3 & 0xFF), (byte)(n4 >> 8 & 0xFF), (byte)(n4 & 0xFF)};
        this.os.write(byArray);
        System.out.println("Video rectangle selection message sent");
    }

    void trySendVideoFreeze(boolean bl) throws IOException {
        if (!this.clientMsgCaps.isEnabled(152)) {
            System.out.println("VideoFreeze is not supported by the server");
            return;
        }
        byte[] byArray = new byte[]{-104, (byte)(bl ? 1 : 0)};
        this.os.write(byArray);
        System.out.println("VideoFreeze(" + byArray[1] + ") selection message sent");
    }

    void trySendVideoEnable(boolean bl) throws IOException {
        if (!this.clientMsgCaps.isEnabled(153)) {
            System.out.println("EnableVideoHandling is not supported by the server");
            return;
        }
        byte[] byArray = new byte[]{-103, (byte)(bl ? 1 : 0)};
        this.os.write(byArray);
        System.out.println("EnableVideoHandling(" + byArray[1] + ") message sent");
    }

    public void startTiming() {
        this.timing = true;
        if (this.timeWaitedIn100us > 10000L) {
            this.timedKbits = this.timedKbits * 10000L / this.timeWaitedIn100us;
            this.timeWaitedIn100us = 10000L;
        }
    }

    public void stopTiming() {
        this.timing = false;
        if (this.timeWaitedIn100us < this.timedKbits / 2L) {
            this.timeWaitedIn100us = this.timedKbits / 2L;
        }
    }

    public long kbitsPerSecond() {
        return this.timedKbits * 10000L / this.timeWaitedIn100us;
    }

    public long timeWaited() {
        return this.timeWaitedIn100us;
    }

    public void readFully(byte[] byArray) throws IOException {
        this.readFully(byArray, 0, byArray.length);
    }

    public void readFully(byte[] byArray, int n, int n2) throws IOException {
        long l = 0L;
        if (this.timing) {
            l = System.currentTimeMillis();
        }
        this.is.readFully(byArray, n, n2);
        if (this.timing) {
            int n3;
            long l2 = System.currentTimeMillis();
            long l3 = (l2 - l) * 10L;
            if (l3 > (long)((n3 = n2 * 8 / 1000) * 1000)) {
                l3 = n3 * 1000;
            }
            if (l3 < (long)(n3 / 4)) {
                l3 = n3 / 4;
            }
            this.timeWaitedIn100us += l3;
            this.timedKbits += (long)n3;
        }
        this.numBytesRead += (long)n2;
    }

    final int available() throws IOException {
        return this.is.available();
    }

    final int skipBytes(int n) throws IOException {
        int n2 = this.is.skipBytes(n);
        this.numBytesRead += (long)n2;
        return n2;
    }

    final int readU8() throws IOException {
        int n = this.is.readUnsignedByte();
        ++this.numBytesRead;
        return n;
    }

    final int readU16() throws IOException {
        int n = this.is.readUnsignedShort();
        this.numBytesRead += 2L;
        return n;
    }

    final int readU32() throws IOException {
        int n = this.is.readInt();
        this.numBytesRead += 4L;
        return n;
    }
}

