/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.ScrollPane;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.EOFException;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.net.UnknownHostException;
import java.util.Date;
import netscape.javascript.JSObject;

public class VncViewer
extends Applet
implements Runnable,
WindowListener,
ComponentListener {
    boolean inAnApplet = true;
    boolean inSeparateFrame = false;
    String[] mainArgs;
    RfbProto rfb;
    Thread rfbThread;
    Frame vncFrame;
    Container vncContainer;
    ScrollPane desktopScrollPane;
    GridBagLayout gridbag;
    ButtonPanel buttonPanel;
    Label connStatusLabel;
    VncCanvas vc;
    OptionsFrame options;
    ClipboardFrame clipboard;
    RecordingFrame rec;
    Object recordingSync;
    String sessionFileName;
    boolean recordingActive;
    boolean recordingStatusChanged;
    String cursorUpdatesDef;
    String eightBitColorsDef;
    String socketFactory;
    String host;
    int port;
    String passwordParam;
    int vncserverport;
    boolean showControls;
    boolean offerRelogin;
    boolean showOfflineDesktop;
    int deferScreenUpdates;
    int deferCursorUpdates;
    int deferUpdateRequests;
    int debugStatsExcludeUpdates;
    int debugStatsMeasureUpdates;
    boolean isSigned;
    boolean showLocalCursor;
    boolean showRemoteCursor;
    boolean disableSSL;
    boolean setServerSize;
    boolean GET;
    String CONNECT;
    String urlPrefix;
    String httpsPort;
    String oneTimeKey;
    String serverCert;
    String proxyHost;
    String proxyPort;
    boolean forceProxy;
    boolean ignoreProxy;
    boolean trustAllVncCerts;
    boolean trustUrlVncCert;
    boolean debugCerts;
    boolean debugKeyboard;
    boolean mapF5_to_atsign;
    boolean forbid_Ctrl_Alt;
    public static Applet refApplet;
    JSObject jso = null;
    int[] encodingsSaved;
    int nEncodingsSaved;

    public static void main(String[] stringArray) {
        VncViewer vncViewer = new VncViewer();
        vncViewer.mainArgs = stringArray;
        vncViewer.inAnApplet = false;
        vncViewer.inSeparateFrame = true;
        vncViewer.init();
        vncViewer.start();
    }

    public void init() {
        if (this.inAnApplet) {
            if (this.jso == null) {
                try {
                    this.jso = JSObject.getWindow((Applet)this);
                }
                catch (Exception exception) {
                    String string = exception.getMessage();
                    System.out.println("Can't get JSObject: " + string);
                }
            }
            this.javascript("cancelTimeout()");
        }
        this.readParameters();
        refApplet = this;
        if (this.inSeparateFrame) {
            this.vncFrame = new Frame("TightVNC");
            if (!this.inAnApplet) {
                this.vncFrame.add("Center", this);
            }
            this.vncContainer = this.vncFrame;
        } else {
            this.vncContainer = this;
        }
        this.recordingSync = new Object();
        this.options = new OptionsFrame(this);
        this.clipboard = new ClipboardFrame(this);
        if (RecordingFrame.checkSecurity()) {
            this.rec = new RecordingFrame(this);
        }
        this.sessionFileName = null;
        this.recordingActive = false;
        this.recordingStatusChanged = false;
        this.cursorUpdatesDef = null;
        this.eightBitColorsDef = null;
        if (this.inSeparateFrame) {
            this.vncFrame.addWindowListener(this);
            this.vncFrame.addComponentListener(this);
        }
        this.rfbThread = new Thread(this);
        this.rfbThread.start();
    }

    public void update(Graphics graphics) {
    }

    public void run() {
        this.gridbag = new GridBagLayout();
        this.vncContainer.setLayout(this.gridbag);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        if (this.showControls) {
            this.buttonPanel = new ButtonPanel(this);
            this.gridbag.setConstraints(this.buttonPanel, gridBagConstraints);
            this.vncContainer.add(this.buttonPanel);
        }
        try {
            Serializable serializable;
            this.connectAndAuthenticate();
            this.doProtocolInitialisation();
            if (this.showControls && this.rfb.clientMsgCaps.isEnabled(153)) {
                this.buttonPanel.addVideoOffButton();
            }
            if (this.showControls && this.rfb.clientMsgCaps.isEnabled(151)) {
                this.buttonPanel.addSelectButton();
            }
            if (this.showControls && this.rfb.clientMsgCaps.isEnabled(152)) {
                this.buttonPanel.addVideoFreezeButton();
            }
            if (this.options.autoScale && this.inSeparateFrame) {
                try {
                    serializable = this.vncContainer.getToolkit().getScreenSize();
                }
                catch (Exception exception) {
                    serializable = new Dimension(0, 0);
                }
                this.createCanvas(((Dimension)serializable).width - 32, ((Dimension)serializable).height - 32);
            } else {
                this.createCanvas(0, 0);
            }
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            if (this.inSeparateFrame) {
                serializable = new Panel();
                ((Container)serializable).setLayout(new FlowLayout(0, 0, 0));
                ((Container)serializable).add(this.vc);
                this.desktopScrollPane = new ScrollPane(0);
                gridBagConstraints.fill = 1;
                this.gridbag.setConstraints(this.desktopScrollPane, gridBagConstraints);
                this.desktopScrollPane.add((Component)serializable);
                this.desktopScrollPane.setWheelScrollingEnabled(false);
                if (!this.options.autoScale) {
                    this.vc.isFirstSizeAutoUpdate = false;
                }
                this.vncFrame.add(this.desktopScrollPane);
                this.vncFrame.setTitle(this.rfb.desktopName);
                this.vncFrame.pack();
                this.vc.resizeDesktopFrame();
            } else {
                this.gridbag.setConstraints(this.vc, gridBagConstraints);
                this.add(this.vc);
                this.validate();
            }
            if (this.showControls) {
                this.buttonPanel.enableButtons();
            }
            this.moveFocusToDesktop();
            this.processNormalProtocol();
        }
        catch (NoRouteToHostException noRouteToHostException) {
            this.fatalError("Network error: no route to server: " + this.host, noRouteToHostException);
        }
        catch (UnknownHostException unknownHostException) {
            this.fatalError("Network error: server name unknown: " + this.host, unknownHostException);
        }
        catch (ConnectException connectException) {
            this.fatalError("Network error: could not connect to server: " + this.host + ":" + this.port, connectException);
        }
        catch (EOFException eOFException) {
            if (this.showOfflineDesktop) {
                eOFException.printStackTrace();
                System.out.println("Network error: remote side closed connection");
                if (this.vc != null) {
                    this.vc.enableInput(false);
                }
                if (this.inSeparateFrame) {
                    this.vncFrame.setTitle(this.rfb.desktopName + " [disconnected]");
                }
                if (this.rfb != null && !this.rfb.closed()) {
                    this.rfb.close();
                }
                if (this.showControls && this.buttonPanel != null) {
                    this.buttonPanel.disableButtonsOnDisconnect();
                    if (this.inSeparateFrame) {
                        this.vncFrame.pack();
                    } else {
                        this.validate();
                    }
                }
            } else {
                this.fatalError("Network error: remote side closed connection", eOFException);
            }
        }
        catch (IOException iOException) {
            String string = iOException.getMessage();
            if (string != null && string.length() != 0) {
                this.fatalError("Network Error: " + string, iOException);
            } else {
                this.fatalError(iOException.toString(), iOException);
            }
        }
        catch (Exception exception) {
            String string = exception.getMessage();
            if (string != null && string.length() != 0) {
                this.fatalError("Error: " + string, exception);
            }
            this.fatalError(exception.toString(), exception);
        }
    }

    void createCanvas(int n, int n2) throws IOException {
        this.vc = null;
        try {
            Class<?> clazz = Class.forName("java.awt.Graphics2D");
            clazz = Class.forName("java.awt.event.MouseWheelEvent");
            clazz = Class.forName("VncCanvas2");
            Class[] classArray = new Class[]{this.getClass(), Integer.TYPE, Integer.TYPE};
            Constructor<?> constructor = clazz.getConstructor(classArray);
            Object[] objectArray = new Object[]{this, new Integer(n), new Integer(n2)};
            this.vc = (VncCanvas)constructor.newInstance(objectArray);
        }
        catch (Exception exception) {
            System.out.println("Warning: Java 2D API is not available");
        }
        if (this.vc == null) {
            this.vc = new VncCanvas(this, n, n2);
        }
    }

    void processNormalProtocol() throws Exception {
        while (true) {
            try {
                while (true) {
                    this.vc.processNormalProtocol();
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                System.out.println("Out of bounds exception.");
                continue;
            }
            catch (Exception exception) {
                if (this.rfbThread == null) {
                    System.out.println("Ignoring RFB socket exceptions because applet is stopping");
                    return;
                }
                throw exception;
            }
            break;
        }
    }

    void connectAndAuthenticate() throws Exception {
        int n;
        this.showConnectionStatus("Initializing...");
        if (this.inSeparateFrame) {
            this.vncFrame.pack();
            this.vncFrame.show();
        } else {
            this.validate();
        }
        this.showConnectionStatus("Connecting to " + this.host + ", port " + this.port + "...");
        this.rfb = new RfbProto(this.host, this.port, this);
        this.showConnectionStatus("Connected to server");
        this.rfb.readVersionMsg();
        this.showConnectionStatus("RFB server supports protocol version " + this.rfb.serverMajor + "." + this.rfb.serverMinor);
        this.rfb.writeVersionMsg();
        this.showConnectionStatus("Using RFB protocol version " + this.rfb.clientMajor + "." + this.rfb.clientMinor);
        int n2 = this.rfb.negotiateSecurity();
        if (n2 == 16) {
            this.showConnectionStatus("Enabling TightVNC protocol extensions");
            this.rfb.setupTunneling();
            n = this.rfb.negotiateAuthenticationTight();
        } else {
            n = n2;
        }
        switch (n) {
            case 1: {
                this.showConnectionStatus("No authentication needed");
                this.rfb.authenticateNone();
                break;
            }
            case 2: {
                this.showConnectionStatus("Performing standard VNC authentication");
                if (this.passwordParam != null) {
                    this.rfb.authenticateVNC(this.passwordParam);
                    break;
                }
                String string = this.askPassword();
                this.rfb.authenticateVNC(string);
                break;
            }
            default: {
                throw new Exception("Unknown authentication scheme " + n);
            }
        }
    }

    void showConnectionStatus(String string) {
        if (string == null) {
            if (this.vncContainer.isAncestorOf(this.connStatusLabel)) {
                this.vncContainer.remove(this.connStatusLabel);
            }
            return;
        }
        System.out.println(string);
        if (this.connStatusLabel == null) {
            this.connStatusLabel = new Label("Status: " + string);
            this.connStatusLabel.setFont(new Font("Helvetica", 0, 12));
        } else {
            this.connStatusLabel.setText("Status: " + string);
        }
        if (!this.vncContainer.isAncestorOf(this.connStatusLabel)) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.insets = new Insets(20, 30, 20, 30);
            this.gridbag.setConstraints(this.connStatusLabel, gridBagConstraints);
            this.vncContainer.add(this.connStatusLabel);
        }
        if (this.inSeparateFrame) {
            this.vncFrame.pack();
        } else {
            this.validate();
        }
    }

    String askPassword() throws Exception {
        this.showConnectionStatus(null);
        AuthPanel authPanel = new AuthPanel(this);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.ipadx = 100;
        gridBagConstraints.ipady = 50;
        this.gridbag.setConstraints(authPanel, gridBagConstraints);
        this.vncContainer.add(authPanel);
        if (this.inSeparateFrame) {
            this.vncFrame.pack();
        } else {
            this.validate();
        }
        authPanel.moveFocusToDefaultField();
        String string = authPanel.getPassword();
        this.vncContainer.remove(authPanel);
        return string;
    }

    void doProtocolInitialisation() throws IOException {
        this.rfb.writeClientInit();
        this.rfb.readServerInit();
        if (this.setServerSize) {
            this.requestResize(this.getSize().width, this.getSize().height);
            this.rfb.framebufferWidth = this.getSize().width;
            this.rfb.framebufferHeight = this.getSize().height;
        }
        System.out.println("Desktop name is " + this.rfb.desktopName);
        System.out.println("Desktop size is " + this.rfb.framebufferWidth + " x " + this.rfb.framebufferHeight);
        this.setEncodings();
        this.showConnectionStatus(null);
    }

    void setEncodings() {
        this.setEncodings(false);
    }

    void autoSelectEncodings() {
        this.setEncodings(true);
    }

    void setEncodings(boolean bl) {
        if (this.options == null || this.rfb == null || !this.rfb.inNormalProtocol) {
            return;
        }
        int n = this.options.preferredEncoding;
        if (n == -1) {
            long l = this.rfb.kbitsPerSecond();
            if (this.nEncodingsSaved < 1) {
                System.out.println("Using Tight/ZRLE encodings");
                n = 7;
            } else if (l > 2000L && this.encodingsSaved[0] != 5) {
                System.out.println("Throughput " + l + " kbit/s - changing to Hextile encoding");
                n = 5;
            } else if (l < 1000L && this.encodingsSaved[0] != 7) {
                System.out.println("Throughput " + l + " kbit/s - changing to Tight/ZRLE encodings");
                n = 7;
            } else {
                if (bl) {
                    return;
                }
                n = this.encodingsSaved[0];
            }
        } else if (bl) {
            return;
        }
        int[] nArray = new int[20];
        int n2 = 0;
        System.out.println("PreferredEncoding is " + n);
        nArray[n2++] = n;
        if (this.options.useCopyRect) {
            nArray[n2++] = 1;
        }
        if (n != 7) {
            nArray[n2++] = 7;
        }
        if (n != 16) {
            nArray[n2++] = 16;
        }
        if (n != 5) {
            nArray[n2++] = 5;
        }
        if (n != 6) {
            nArray[n2++] = 6;
        }
        if (n != 4) {
            nArray[n2++] = 4;
        }
        if (n != 2) {
            nArray[n2++] = 2;
        }
        if (this.options.compressLevel >= 0 && this.options.compressLevel <= 9) {
            nArray[n2++] = -256 + this.options.compressLevel;
        }
        if (this.options.jpegQuality >= 0 && this.options.jpegQuality <= 9) {
            nArray[n2++] = -32 + this.options.jpegQuality;
        }
        if (this.options.requestCursorUpdates) {
            nArray[n2++] = -240;
            nArray[n2++] = -239;
            if (!this.options.ignoreCursorUpdates) {
                nArray[n2++] = -232;
            }
        }
        nArray[n2++] = -224;
        nArray[n2++] = -223;
        boolean bl2 = false;
        if (n2 != this.nEncodingsSaved) {
            bl2 = true;
        } else {
            for (int i = 0; i < n2; ++i) {
                if (nArray[i] == this.encodingsSaved[i]) continue;
                bl2 = true;
                break;
            }
        }
        if (bl2) {
            try {
                this.rfb.writeSetEncodings(nArray, n2);
                if (this.vc != null) {
                    this.vc.softCursorFree();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.encodingsSaved = nArray;
            this.nEncodingsSaved = n2;
        }
    }

    void setCutText(String string) {
        try {
            if (this.rfb != null && this.rfb.inNormalProtocol) {
                this.rfb.writeClientCutText(string);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setRecordingStatus(String string) {
        Object object = this.recordingSync;
        synchronized (object) {
            this.sessionFileName = string;
            this.recordingStatusChanged = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean checkRecordingStatus() throws IOException {
        Object object = this.recordingSync;
        synchronized (object) {
            if (this.recordingStatusChanged) {
                this.recordingStatusChanged = false;
                if (this.sessionFileName != null) {
                    this.startRecording();
                    return true;
                }
                this.stopRecording();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startRecording() throws IOException {
        Object object = this.recordingSync;
        synchronized (object) {
            if (!this.recordingActive) {
                this.cursorUpdatesDef = this.options.choices[this.options.cursorUpdatesIndex].getSelectedItem();
                this.eightBitColorsDef = this.options.choices[this.options.eightBitColorsIndex].getSelectedItem();
                this.options.choices[this.options.cursorUpdatesIndex].select("Disable");
                this.options.choices[this.options.cursorUpdatesIndex].setEnabled(false);
                this.options.setEncodings();
                this.options.choices[this.options.eightBitColorsIndex].select("No");
                this.options.choices[this.options.eightBitColorsIndex].setEnabled(false);
                this.options.setColorFormat();
            } else {
                this.rfb.closeSession();
            }
            System.out.println("Recording the session in " + this.sessionFileName);
            this.rfb.startSession(this.sessionFileName);
            this.recordingActive = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stopRecording() throws IOException {
        Object object = this.recordingSync;
        synchronized (object) {
            if (this.recordingActive) {
                this.options.choices[this.options.cursorUpdatesIndex].select(this.cursorUpdatesDef);
                this.options.choices[this.options.cursorUpdatesIndex].setEnabled(true);
                this.options.setEncodings();
                this.options.choices[this.options.eightBitColorsIndex].select(this.eightBitColorsDef);
                this.options.choices[this.options.eightBitColorsIndex].setEnabled(true);
                this.options.setColorFormat();
                this.rfb.closeSession();
                System.out.println("Session recording stopped.");
            }
            this.sessionFileName = null;
            this.recordingActive = false;
        }
    }

    void readParameters() {
        this.host = this.readParameter("HOST", !this.inAnApplet);
        if (this.host == null) {
            this.host = this.getCodeBase().getHost();
            if (this.host.equals("")) {
                this.fatalError("HOST parameter not specified");
            }
        }
        Date date = new Date();
        System.out.println("-\nSSL VNC Java Applet starting.  " + date);
        this.port = 5900;
        String string = this.readParameter("PORT", false);
        if (string != null) {
            this.port = Integer.parseInt(string);
        }
        this.readPasswordParameters();
        this.vncserverport = 0;
        string = this.readParameter("VNCSERVERPORT", false);
        if (string != null) {
            this.vncserverport = Integer.parseInt(string);
        }
        if (this.port == 0 && this.vncserverport == 0) {
            this.fatalError("Neither PORT nor VNCSERVERPORT parameters specified");
        }
        if (this.port == 0) {
            System.out.println("using vncserverport: '" + this.vncserverport + "' for PORT.");
            this.port = this.vncserverport;
        }
        if (this.inAnApplet && (string = this.readParameter("Open New Window", false)) != null && string.equalsIgnoreCase("Yes")) {
            this.inSeparateFrame = true;
        }
        this.showControls = true;
        string = this.readParameter("Show Controls", false);
        if (string != null && string.equalsIgnoreCase("No")) {
            this.showControls = false;
        }
        this.offerRelogin = true;
        string = this.readParameter("Offer Relogin", false);
        if (string != null && string.equalsIgnoreCase("No")) {
            this.offerRelogin = false;
        }
        this.showOfflineDesktop = false;
        string = this.readParameter("Show Offline Desktop", false);
        if (string != null && string.equalsIgnoreCase("Yes")) {
            this.showOfflineDesktop = true;
        }
        this.deferScreenUpdates = this.readIntParameter("Defer screen updates", 20);
        this.deferCursorUpdates = this.readIntParameter("Defer cursor updates", 10);
        this.deferUpdateRequests = this.readIntParameter("Defer update requests", 0);
        this.debugStatsExcludeUpdates = this.readIntParameter("DEBUG_XU", 0);
        this.debugStatsMeasureUpdates = this.readIntParameter("DEBUG_CU", 0);
        System.out.println("Checking security environment...");
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            try {
                securityManager.checkPropertyAccess("user.dir");
                System.out.println("Not running in sandbox");
            }
            catch (SecurityException securityException) {
                System.out.println("Running in sandbox");
            }
        }
        this.socketFactory = this.readParameter("SocketFactory", false);
        this.disableSSL = true;
        string = this.readParameter("DisableSSL", false);
        if (string != null && string.equalsIgnoreCase("No")) {
            this.disableSSL = false;
        }
        this.httpsPort = this.readParameter("httpsPort", false);
        this.CONNECT = this.readParameter("CONNECT", false);
        if (this.CONNECT != null) {
            this.CONNECT = this.CONNECT.replaceAll(" ", ":");
        }
        this.GET = false;
        string = this.readParameter("GET", false);
        if (string != null && string.equalsIgnoreCase("Yes")) {
            this.GET = true;
        }
        if (string != null && string.equalsIgnoreCase("1")) {
            this.GET = true;
        }
        this.urlPrefix = this.readParameter("urlPrefix", false);
        if (this.urlPrefix != null) {
            this.urlPrefix = this.urlPrefix.replaceAll("%2F", "/");
            this.urlPrefix = this.urlPrefix.replaceAll("%2f", "/");
            this.urlPrefix = this.urlPrefix.replaceAll("_2F_", "/");
            if (this.urlPrefix.indexOf("/") != 0) {
                this.urlPrefix = "/" + this.urlPrefix;
            }
        } else {
            this.urlPrefix = "";
        }
        System.out.println("urlPrefix: '" + this.urlPrefix + "'");
        this.oneTimeKey = this.readParameter("oneTimeKey", false);
        if (this.oneTimeKey != null) {
            System.out.println("oneTimeKey is set.");
        }
        this.serverCert = this.readParameter("serverCert", false);
        if (this.serverCert != null) {
            System.out.println("serverCert is set.");
        }
        this.forceProxy = false;
        this.proxyHost = null;
        this.proxyPort = null;
        string = this.readParameter("forceProxy", false);
        if (string != null) {
            if (string.equalsIgnoreCase("Yes")) {
                this.forceProxy = true;
            } else if (string.equalsIgnoreCase("No")) {
                this.forceProxy = false;
            } else {
                this.forceProxy = true;
                String[] stringArray = string.split(" ");
                this.proxyHost = new String(stringArray[0]);
                this.proxyPort = stringArray.length >= 2 ? new String(stringArray[1]) : new String("8080");
            }
        }
        if ((string = this.readParameter("proxyHost", false)) != null) {
            this.proxyHost = new String(string);
        }
        if ((string = this.readParameter("proxyPort", false)) != null) {
            this.proxyPort = new String(string);
        }
        if (this.proxyHost != null && this.proxyPort == null) {
            this.proxyPort = new String("8080");
        }
        this.ignoreProxy = false;
        string = this.readParameter("ignoreProxy", false);
        if (string != null && string.equalsIgnoreCase("Yes")) {
            this.ignoreProxy = true;
        }
        this.trustAllVncCerts = false;
        string = this.readParameter("trustAllVncCerts", false);
        if (string != null && string.equalsIgnoreCase("Yes")) {
            this.trustAllVncCerts = true;
        }
        this.trustUrlVncCert = false;
        string = this.readParameter("trustUrlVncCert", false);
        if (string != null && string.equalsIgnoreCase("Yes")) {
            this.trustUrlVncCert = true;
        }
        this.debugCerts = false;
        string = this.readParameter("debugCerts", false);
        if (string != null && string.equalsIgnoreCase("Yes")) {
            this.debugCerts = true;
        }
        this.debugKeyboard = false;
        string = this.readParameter("debugKeyboard", false);
        if (string != null && string.equalsIgnoreCase("Yes")) {
            this.debugKeyboard = true;
        }
        this.mapF5_to_atsign = false;
        string = this.readParameter("mapF5_to_atsign", false);
        if (string != null && string.equalsIgnoreCase("Yes")) {
            this.mapF5_to_atsign = true;
        }
        this.forbid_Ctrl_Alt = false;
        string = this.readParameter("forbid_Ctrl_Alt", false);
        if (string != null && string.equalsIgnoreCase("Yes")) {
            this.forbid_Ctrl_Alt = true;
        }
        this.isSigned = false;
        string = this.readParameter("signed", false);
        if (string != null && string.equalsIgnoreCase("Yes")) {
            this.isSigned = true;
        }
        this.setServerSize = false;
        string = this.readParameter("SetServerSize", false);
        if (string != null && string.equalsIgnoreCase("Yes")) {
            this.setServerSize = true;
        }
        this.showLocalCursor = false;
        string = this.readParameter("ShowLocalCursor", false);
        if (string != null && string.equalsIgnoreCase("Yes")) {
            this.showLocalCursor = true;
        }
        this.showRemoteCursor = true;
        string = this.readParameter("ShowRemoteCursor", false);
        if (string != null && string.equalsIgnoreCase("No")) {
            this.showRemoteCursor = false;
        }
    }

    private void readPasswordParameters() {
        String string = this.readParameter("ENCPASSWORD", false);
        if (string == null) {
            this.passwordParam = this.readParameter("PASSWORD", false);
        } else {
            Object object;
            byte[] byArray = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
            int n = string.length() / 2;
            if (n > 8) {
                n = 8;
            }
            for (int i = 0; i < n; ++i) {
                object = string.substring(i * 2, i * 2 + 2);
                Integer n2 = new Integer(Integer.parseInt((String)object, 16));
                byArray[i] = n2.byteValue();
            }
            byte[] byArray2 = new byte[]{23, 82, 107, 6, 35, 78, 88, 7};
            object = new DesCipher(byArray2);
            ((DesCipher)object).decrypt(byArray, 0, byArray, 0);
            this.passwordParam = new String(byArray);
        }
    }

    public String readParameter(String string, boolean bl) {
        if (this.inAnApplet) {
            String string2 = this.getParameter(string);
            if (string2 == null && bl) {
                this.fatalError(string + " parameter not specified");
            }
            return string2;
        }
        for (int i = 0; i < this.mainArgs.length; i += 2) {
            if (!this.mainArgs[i].equalsIgnoreCase(string)) continue;
            try {
                return this.mainArgs[i + 1];
            }
            catch (Exception exception) {
                if (bl) {
                    this.fatalError(string + " parameter not specified");
                }
                return null;
            }
        }
        if (bl) {
            this.fatalError(string + " parameter not specified");
        }
        return null;
    }

    int readIntParameter(String string, int n) {
        String string2 = this.readParameter(string, false);
        int n2 = n;
        if (string2 != null) {
            try {
                n2 = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return n2;
    }

    void moveFocusToDesktop() {
        if (this.vncContainer != null) {
            this.vncContainer.setFocusCycleRoot(true);
            this.vncContainer.setFocusTraversalKeysEnabled(false);
            if (this.vc != null && this.vncContainer.isAncestorOf(this.vc)) {
                this.vc.requestFocus();
            }
        }
    }

    public synchronized void disconnect() {
        System.out.println("Disconnecting");
        if (this.vc != null) {
            double d = (double)(System.currentTimeMillis() - this.vc.statStartTime) / 1000.0;
            double d2 = (double)Math.round((double)this.vc.statNumUpdates / d * 100.0) / 100.0;
            long l = this.vc.statNumPixelRects;
            long l2 = this.vc.statNumTotalRects - this.vc.statNumPixelRects;
            System.out.println("Updates received: " + this.vc.statNumUpdates + " (" + l + " rectangles + " + l2 + " pseudo), " + d2 + " updates/sec");
            long l3 = l - this.vc.statNumRectsTight - this.vc.statNumRectsZRLE - this.vc.statNumRectsHextile - this.vc.statNumRectsRaw - this.vc.statNumRectsCopy;
            System.out.println("Rectangles: Tight=" + this.vc.statNumRectsTight + "(JPEG=" + this.vc.statNumRectsTightJPEG + ") ZRLE=" + this.vc.statNumRectsZRLE + " Hextile=" + this.vc.statNumRectsHextile + " Raw=" + this.vc.statNumRectsRaw + " CopyRect=" + this.vc.statNumRectsCopy + " other=" + l3);
            long l4 = this.vc.statNumBytesDecoded;
            long l5 = this.vc.statNumBytesEncoded;
            if (l5 > 0L) {
                double d3 = (double)Math.round((double)l4 / (double)l5 * 1000.0) / 1000.0;
                System.out.println("Pixel data: " + this.vc.statNumBytesDecoded + " bytes, " + this.vc.statNumBytesEncoded + " compressed, ratio " + d3);
            }
        }
        if (this.rfb != null && !this.rfb.closed()) {
            this.rfb.close();
        }
        this.options.dispose();
        this.clipboard.dispose();
        if (this.rec != null) {
            this.rec.dispose();
        }
        if (this.inAnApplet) {
            this.showMessage("Disconnected");
        } else {
            System.exit(0);
        }
    }

    public synchronized void fatalError(String string) {
        System.out.println(string);
        if (this.inAnApplet) {
            Thread.currentThread().stop();
        } else {
            System.exit(1);
        }
    }

    public synchronized void fatalError(String string, Exception exception) {
        if (this.rfb != null && this.rfb.closed()) {
            System.out.println("RFB thread finished");
            return;
        }
        System.out.println(string);
        exception.printStackTrace();
        if (this.rfb != null) {
            this.rfb.close();
        }
        if (this.inAnApplet) {
            this.showMessage(string);
        } else {
            System.exit(1);
        }
    }

    void showMessage(String string) {
        this.vncContainer.removeAll();
        Label label = new Label(string, 1);
        label.setFont(new Font("Helvetica", 0, 12));
        if (this.offerRelogin) {
            Panel panel = new Panel(new GridLayout(0, 1));
            Panel panel2 = new Panel(new FlowLayout(0));
            panel2.add(panel);
            this.vncContainer.setLayout(new FlowLayout(0, 30, 16));
            this.vncContainer.add(panel2);
            Panel panel3 = new Panel(new FlowLayout(1));
            panel3.add(label);
            panel.add(panel3);
            panel.add(new ReloginPanel(this));
        } else {
            this.vncContainer.setLayout(new FlowLayout(0, 30, 30));
            this.vncContainer.add(label);
        }
        if (this.inSeparateFrame) {
            this.vncFrame.pack();
        } else {
            this.validate();
        }
    }

    public void stop() {
        System.out.println("Stopping applet");
        this.rfbThread = null;
    }

    public void destroy() {
        System.out.println("Destroying applet");
        this.vncContainer.removeAll();
        this.options.dispose();
        this.clipboard.dispose();
        if (this.rec != null) {
            this.rec.dispose();
        }
        if (this.rfb != null && !this.rfb.closed()) {
            this.rfb.close();
        }
        if (this.inSeparateFrame) {
            this.vncFrame.dispose();
        }
    }

    public void enableInput(boolean bl) {
        this.vc.enableInput(bl);
    }

    public void componentResized(ComponentEvent componentEvent) {
        if (componentEvent.getComponent() == this.vncFrame && this.options.autoScale && this.vc != null && !this.vc.isFirstSizeAutoUpdate) {
            this.vc.updateFramebufferSize();
        }
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        System.out.println("Closing window");
        if (this.rfb != null) {
            this.disconnect();
        }
        this.vncContainer.hide();
        if (!this.inAnApplet) {
            System.exit(0);
        }
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void refresh() {
        if (this.rfb == null) {
            return;
        }
        try {
            this.rfb.writeFramebufferUpdateRequest(0, 0, this.rfb.framebufferWidth, this.rfb.framebufferHeight, false);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void requestResize(int n, int n2) {
        if (this.rfb == null) {
            return;
        }
        if (n > 4096 || n < 0) {
            System.out.println("ERROR in requestResize: Invalid width " + Integer.toString(n));
        }
        if (n2 > 4096 || n2 < 0) {
            System.out.println("ERROR in requestResize: Invalid height " + Integer.toString(n));
        }
        try {
            this.rfb.writeRequestFBSize(n, n2);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void forceSize() {
        int n;
        int n2;
        if (this.rfb == null) {
            n2 = this.getSize().width;
            n = this.getSize().height;
        } else {
            n2 = this.rfb.framebufferWidth;
            n = this.rfb.framebufferHeight;
        }
        if (this.inSeparateFrame) {
            if (this.vc != null) {
                this.vc.setSize(n2, n);
            }
            this.vncFrame.pack();
            this.refresh();
            return;
        }
        this.setSize(n2, n);
        String string = Integer.toString(n2);
        String string2 = Integer.toString(n);
        System.out.println("forceSize(" + string + "," + string2 + ")");
        this.javascript("forceSize(" + string + "," + string2 + ")");
        this.setSize(n2, n);
        this.refresh();
    }

    public void clientAction(String string) {
        this.javascript("clientAction('" + string + "')");
    }

    public void javascript(String string) {
        if (!this.inAnApplet) {
            return;
        }
        if (this.jso == null) {
            System.out.println("JSObject is NULL");
            return;
        }
        try {
            this.jso.eval(string);
            System.out.println("Executed: " + string);
        }
        catch (Exception exception) {
            System.out.println("javascript: Can't call: " + string);
        }
    }

    public void popout() {
        this.vncContainer.removeAll();
        if (this.inSeparateFrame) {
            this.inSeparateFrame = false;
            this.vncFrame.dispose();
            this.vncFrame = null;
            this.vncContainer = this;
        } else {
            this.inSeparateFrame = true;
            this.vncFrame = new Frame("TightVNC");
            this.vncFrame.setTitle(this.rfb.desktopName);
            this.vncFrame.setResizable(true);
            this.vncFrame.addWindowListener(this);
            this.vncContainer = this.vncFrame;
        }
        this.gridbag = new GridBagLayout();
        this.vncContainer.setLayout(this.gridbag);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        if (this.showControls) {
            this.buttonPanel = new ButtonPanel(this);
            this.gridbag.setConstraints(this.buttonPanel, gridBagConstraints);
            this.vncContainer.add(this.buttonPanel);
        }
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.gridbag.setConstraints(this.vc, gridBagConstraints);
        this.vncContainer.add(this.vc);
        if (this.inSeparateFrame) {
            this.vncFrame.pack();
            this.vncFrame.show();
            this.vc.addComponentListener((ComponentListener)new /* Unavailable Anonymous Inner Class!! */);
        } else {
            this.validate();
            this.forceSize();
        }
    }
}

