<?php
/**
 * HUBzero CMS
 *
 * Copyright 2005-2015 Purdue University. All rights reserved.
 *
 * This file is part of: The HUBzero(R) Platform for Scientific Collaboration
 *
 * The HUBzero(R) Platform for Scientific Collaboration (HUBzero) is free
 * software: you can redistribute it and/or modify it under the terms of
 * the GNU Lesser General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any
 * later version.
 *
 * HUBzero is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * HUBzero is a registered trademark of Purdue University.
 *
 * @package   hubzero-cms
 * @author    Ilya Shunko <ishunko@purdue.edu>
 * @copyright Copyright 2005-2015 Purdue University. All rights reserved.
 * @license   http://www.gnu.org/licenses/lgpl-3.0.html LGPLv3
 */

require_once(PATH_CORE . DS . 'components' . DS . 'com_storefront' . DS . 'models' . DS . 'Warehouse.php');
require_once(PATH_CORE . DS . 'components' . DS . 'com_cart' . DS . 'lib' . DS . 'auditors' . DS . 'BaseAuditor.php');

class Audit
{

	/**
	 * Constructor
	 * @param 	Object  Product info
	 * @param   int     Cart ID
	 * @param   int     User ID
	 * @return 	Void
	 */
	public static function getAuditor($pInfo, $crtId)
	{
		$pId = $pInfo->pId;

		$warehouse = new StorefrontModelWarehouse();
		// Get product type
		$pType = $warehouse->getProductTypeInfo($pInfo->ptId);

		$type = $pType['ptName'];
		$model = $pType['ptModel'];

		// Find if there are auditors for this product's type and model
		$auditorsPath = PATH_CORE . DS . 'components' . DS . 'com_cart' . DS . 'lib' . DS . 'auditors';

		$auditorClass = str_replace(' ', '_', ucwords(strtolower($model))) . '_Auditor';
		if (file_exists($auditorsPath . DS . $auditorClass . '.php'))
		{
			// Include the auditor file
			include_once($auditorsPath . DS . $auditorClass . '.php');
			return new $auditorClass($type, $pId, $crtId);
		}
		else
		{
			return new BaseAuditor($type);
		}
	}
}