<?php
/**
 * @package		Joomla.Site
 * @subpackage	com_users
 * @copyright	Copyright (C) 2005 - 2014 Open Source Matters, Inc. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_HZEXEC_') or die();

/**
 * Users Html Helper
 *
 * @package		Joomla.Site
 * @subpackage	com_users
 * @since		1.6
 */

abstract class JHtmlUsers
{
	public static function value($value)
	{
		if (is_string($value)) {
			$value = trim($value);
		}
		if (empty($value)) {
			return Lang::txt('COM_USERS_PROFILE_VALUE_NOT_FOUND');
		}
		else {
			return htmlspecialchars($value);
		}
	}
	public static function spacer($value)
	{
		return '';
	}

	public static function helpsite($value)
	{
		if (empty($value))
		{
			return self::value($value);
		}
		else
		{
			$version = new JVersion();
			$jver = explode( '.', $version->getShortVersion() );

			$pathToXml = PATH_CORE.'/help/helpsites.xml';

			$text = $value;
			if (!empty($pathToXml) && $xml = JFactory::getXML($pathToXml))
			{
				foreach ($xml->sites->site as $site)
				{
					if ((string)$site->attributes()->url == $value)
					{
						$text = (string)$site;
						break;
					}
				}
			}

			$value = htmlspecialchars($value);
			if (substr ($value, 0, 4) == "http") {
				return '<a href="'.$value.'">'.$text.'</a>';
			}
			else {
				return '<a href="http://'.$value.'">'.$text.'</a>';
			}
		}
	}

	public static function templatestyle($value)
	{
		if (empty($value))
		{
			return self::value($value);
		}
		else
		{
			$db = App::get('db');
			$query = $db->getQuery(true);
			$query->select('title');
			$query->from('#__template_styles');
			$query->where('id = '.$db->quote($value));
			$db->setQuery($query);
			$title = $db->loadResult();
			if ($title) {
				return htmlspecialchars($title);
			}
			else {
				return self::value('');
			}
		}
	}

	public static function admin_language($value)
	{
		if (empty($value))
		{
			return self::value($value);
		}
		else
		{
			$path = Lang::getLanguagePath(PATH_APP, $value);
			$file = "$value.xml";

			$result = null;
			if (is_file("$path/$file"))
			{
				$result = Lang::parseXMLLanguageFile("$path/$file");
			}

			if ($result)
			{
				return htmlspecialchars($result['name']);
			}
			else
			{
				return self::value('');
			}
		}
	}

	public static function language($value)
	{
		if (empty($value))
		{
			return self::value($value);
		}
		else
		{
			$path = Lang::getLanguagePath(PATH_CORE, $value);
			$file = "$value.xml";

			$result = null;
			if (is_file("$path/$file"))
			{
				$result = Lang::parseXMLLanguageFile("$path/$file");
			}

			if ($result)
			{
				return htmlspecialchars($result['name']);
			}
			else
			{
				return self::value('');
			}
		}
	}

	public static function editor($value)
	{
		if (empty($value))
		{
			return self::value($value);
		}
		else
		{
			$db = App::get('db');
			$lang = Lang::getRoot();
			$query = $db->getQuery(true);
			$query->select('name');
			$query->from('#__extensions');
			$query->where('element = '.$db->quote($value));
			$query->where('folder = '.$db->quote('editors'));
			$db->setQuery($query);
			$title = $db->loadResult();
			if ($title)
			{
				$lang->load("plg_editors_$value.sys", PATH_APP, null, false, true) ||
				$lang->load("plg_editors_$value.sys", PATH_CORE . '/plugins/editors/' . $value, null, false, true);
				$lang->load($title.'.sys');
				return Lang::txt($title);
			}
			else
			{
				return self::value('');
			}
		}
	}
}
