<?php
/**
 * HUBzero CMS
 *
 * Copyright 2005-2015 HUBzero Foundation, LLC.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 *
 * HUBzero is a registered trademark of Purdue University.
 *
 * @package   hubzero-cms
 * @author    Nicholas J. Kisseberth <nkissebe@purdue.edu>
 * @copyright Copyright 2005-2015 HUBzero Foundation, LLC.
 * @license   http://opensource.org/licenses/MIT MIT
 */

// No direct access
defined('_HZEXEC_') or die();

$this->css('register');
?>
<header id="content-header">
	<h2>Racial and Ethnic Heritage Identification</h2>
</header>

<section class="main section">
	<p>We are committed to supporting diversity and underrepresented minorities in science education, and this information helps us better demonstrate success toward that goal, allowing us to continue providing this service to you.  Please provide this information if you feel comfortable doing so.</p>
	<p><strong>This information will not affect the level of service you receive!</strong></p>
	<p><strong>All users are asked to clarify if they are of Hispanic origin or descent, but only United States citizens and Permanent Resident Visa holders need answer the Racial Background section.</strong></p>
	<ul>
		<li>
			Hispanic or Latino<br />
			Persons of Cuban, Mexican, Puerto Rican, Central or South American, or other Spanish culture of origin, regardless of race.  Ethnic subgroups are listed here for selection, or you may enter another subgroup if your culture is not listed.
		</li>
		<li>
			American Indian or Alaska Native<br />
			Persons having origins in any of the original peoples of North and South America (including Central America), and who maintains cultural identification through tribal affiliation or community recognition.
		</li>
		<li>
			Asian<br />
			Persons having origins in any of the original peoples of the Far East, Southeast Asia or the Indian subcontinent, including for example, Cambodia, China, India, Japan, Korea, Malaysia, Pakistan, the Philippine Islands, Thailand, and Vietnam.
		</li>
		<li>
			Black or African American<br />
			Persons having origins in any of the black racial groups of Africa.
		</li>
		<li>
			Native Hawaiian or Other Pacific Islander<br />
			Persons having origins in any of the original peoples of Hawaii, Guam, Samoa, or other Pacific Islands.
		</li>
		<li>
			White<br />
			Persons having origins in any of the original peoples of Europe, the Middle East, or North Africa.
		</li>
		<li>
			Do not wish to reveal<br />
			You may select this if you would prefer to not disclose this information.
		</li>
	</ul>
</section>
