<?php
/**
 * @package		Joomla.Administrator
 * @subpackage	com_modules
 * @copyright	Copyright (C) 2005 - 2014 Open Source Matters, Inc. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_HZEXEC_') or die();

/**
 * View to edit a module.
 *
 * @static
 * @package		Joomla.Administrator
 * @subpackage	com_modules
 * @since		1.6
 */
class ModulesViewModule extends JViewLegacy
{
	protected $form;
	protected $item;
	protected $state;

	/**
	 * Display the view
	 */
	public function display($tpl = null)
	{
		$this->form  = $this->get('Form');
		$this->item  = $this->get('Item');
		$this->state = $this->get('State');

		// Check for errors.
		if (count($errors = $this->get('Errors')))
		{
			App::abort(500, implode("\n", $errors));
			return false;
		}

		$this->addToolbar();
		parent::display($tpl);
	}

	/**
	 * Add the page title and toolbar.
	 *
	 * @since	1.6
	 */
	protected function addToolbar()
	{
		Request::setVar('hidemainmenu', true);

		$isNew      = ($this->item->id == 0);
		$checkedOut = !($this->item->checked_out == 0 || $this->item->checked_out == User::get('id'));
		$canDo      = ModulesHelper::getActions($this->state->get('filter.category_id'), $this->item->id);
		$item       = $this->get('Item');

		Toolbar::title( Lang::txt('COM_MODULES_MANAGER_MODULE', Lang::txt($this->item->module)), 'module.png');

		// If not checked out, can save the item.
		if (!$checkedOut && ($canDo->get('core.edit') || $canDo->get('core.create') ))
		{
			Toolbar::apply('module.apply');
			Toolbar::save('module.save');
		}
		if (!$checkedOut && $canDo->get('core.create'))
		{
			Toolbar::save2new('module.save2new');
		}
			// If an existing item, can save to a copy.
		if (!$isNew && $canDo->get('core.create'))
		{
			Toolbar::save2copy('module.save2copy');
		}
		if (empty($this->item->id))
		{
			Toolbar::cancel('module.cancel');
		}
		else
		{
			Toolbar::cancel('module.cancel', 'JTOOLBAR_CLOSE');
		}

		// Get the help information for the menu item.
		$lang = Lang::getRoot();

		$help = $this->get('Help');
		if ($lang->hasKey($help->url))
		{
			$debug = $lang->setDebug(false);
			$url = Lang::txt($help->url);
			$lang->setDebug($debug);
		}
		else
		{
			$url = null;
		}
		Toolbar::help('module'); //$help->key, false, $url);
	}
}
