<?php
/**
 * HUBzero CMS
 *
 * Copyright 2005-2015 HUBzero Foundation, LLC.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 *
 * HUBzero is a registered trademark of Purdue University.
 *
 * @package   hubzero-cms
 * @author    Shawn Rice <zooley@purdue.edu>
 * @copyright Copyright 2005-2015 HUBzero Foundation, LLC.
 * @license   http://opensource.org/licenses/MIT MIT
 */

// No direct access
defined('_HZEXEC_') or die();

/**
 * Courses Plugin class for course offerings
 */
class plgCoursesOfferings extends \Hubzero\Plugin\Plugin
{
	/**
	 * Affects constructor behavior. If true, language files will be loaded automatically.
	 *
	 * @var  boolean
	 */
	protected $_autoloadLanguage = true;

	/**
	 * Return data on a course view (this will be some form of HTML)
	 *
	 * @param   object  $course  Current course
	 * @param   string  $active  Current active area
	 * @return  array
	 */
	public function onCourseView($course, $active=null)
	{
		// Check that there are any offerings to show
		if ($course->offerings(array('state' => 1, 'sort_Dir' => 'ASC'), true)->total() <= 0)
		{
			return;
		}

		// Can this plugin respond, based on the current access settings?
		$respond = false;
		switch ($this->params->get('plugin_access', 'anyone'))
		{
			case 'managers':
				$memberships = $course->offering()->membership();

				if (count($memberships) > 0)
				{
					foreach ($memberships as $membership)
					{
						if (!$membership->get('student'))
						{
							$respond = true;
							break;
						}
					}
				}
			break;

			case 'members':
				if (count($course->offering()->membership()) > 0)
				{
					$respond = true;
				}
			break;

			case 'registered':
				if (!User::isGuest())
				{
					$respond = true;
				}
			break;

			case 'anyone':
			default:
				$respond = true;
			break;
		}

		if (!$respond)
		{
			return;
		}

		// Prepare response
		$response = with(new \Hubzero\Base\Object)
			->set('name', $this->_name)
			->set('title', Lang::txt('PLG_COURSES_' . strtoupper($this->_name)));

		// Check if our area is in the array of areas we want to return results for
		if ($response->get('name') == $active)
		{
			$view = $this->view('default', 'overview');
			$view->set('option', Request::getCmd('option', 'com_courses'))
			     ->set('controller', Request::getWord('controller', 'course'))
			     ->set('course', $course)
			     ->set('name', $this->_name);

			$response->set('html', $view->loadTemplate());
		}

		// Return the output
		return $response;
	}
}

