<?php
/**
 * Copyright 2010-2013 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License").
 * You may not use this file except in compliance with the License.
 * A copy of the License is located at
 *
 * http://aws.amazon.com/apache2.0
 *
 * or in the "license" file accompanying this file. This file is distributed
 * on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied. See the License for the specific language governing
 * permissions and limitations under the License.
 */

namespace Aws\Ec2\Enum;

use Aws\Common\Enum;

/**
 * Contains enumerable InstanceStateName values
 */
class InstanceStateName extends Enum
{
    const PENDING = 'pending';
    const RUNNING = 'running';
    const SHUTTING_DOWN = 'shutting-down';
    const TERMINATED = 'terminated';
    const STOPPING = 'stopping';
    const STOPPED = 'stopped';
}
