<?php
/**
 * @package		HUBzero CMS
 * @author		Alissa Nedossekina <alisa@purdue.edu>
 * @copyright	Copyright 2009 by Purdue Research Foundation, West Lafayette, IN 47906
 * @license		http://www.gnu.org/licenses/gpl-2.0.html GPLv2
 *
 * Copyright 2009 by Purdue Research Foundation, West Lafayette, IN 47906.
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License,
 * version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die( 'Restricted access' );

//----------------------------------------------------------
// Wish Attachments class
//----------------------------------------------------------

class WishAttachment extends JTable 
{
	var $id          = NULL;  // @var int(11) Primary key
	var $wish     = NULL;  // @var int(11)
	var $filename    = NULL;  // @var varchar(255)
	var $description = NULL;  // @var varchar(255)

	//-----------

	function __construct( &$db ) 
	{
		parent::__construct( '#__wish_attachments', 'id', $db );
	}
	
	//-----------
	
	function check() 
	{
		if ($this->wish == NULL) {
			$this->setError( JText::_('Error: wish not found.') );
			return false;
		}
		if (trim( $this->filename ) == '') {
			$this->setError( JText::_('Error: attachment not found.') );
			return false;
		}

		return true;
	}
	
	//-----------
	
	function getID() 
	{
		$this->_db->setQuery( "SELECT id FROM $this->_tbl WHERE filename='".$this->filename."' AND description='".$this->description."' AND wish=".$this->wish );
		$id = $this->_db->loadResult();
		$this->id = $id;
	}
	
	//-----------

	function parse($text)
	{
		$f = '/\{attachment#[0-9]*\}/sU';
		return preg_replace_callback($f, array(&$this,'getAttachment'), $text);
	}
	
	//-----------
	
	function getAttachment($matches)
	{
		$match = $matches[0];
		$tokens = split('#',$match);
		$id = intval(end($tokens));
		
		$this->_db->setQuery( "SELECT filename, description FROM $this->_tbl WHERE id=".$id );
		$a = $this->_db->loadRow();
		
		if ($this->output == 'web') {
			if (is_file($this->uppath.DS.$a[0])) {
				if (eregi( "bmp|gif|jpg|jpe|jpeg|tif|tiff|png", $a[0] )) {
					$size = getimagesize($this->uppath.DS.$a[0]);
					if ($size[0] > 300) {
						$img = '<a href="'.$this->webpath.'/'.$a[0].'" rel="lightbox" title="'.$a[1].'"><img src="'.$this->webpath.'/'.$a[0].'" alt="'.$a[1].'" width="300" /></a>';
					} else {
						$img = '<img src="'.$this->webpath.'/'.$a[0].'" alt="'.$a[1].'" />';
					}
					return $img;
				} else {
					$html  = '<a href="'.$this->webpath.'/'.$a[0].'" title="'.$a[1].'">';
					$html .= ($a[1]) ? $a[1] : $a[0];
					$html .= '</a>';
					return $html;
				}
			} else {
				return '[attachment #'.$id.' not found]';
			}
		} else {
			return $this->webpath.'/'.$a[0];
		}
	}
	
	//-----------
	
	function deleteAttachment( $filename, $wish ) 
	{
		$this->_db->setQuery( "DELETE FROM $this->_tbl WHERE filename='".$filename."' AND wish=".$wish );
		if (!$this->_db->query()) {
			return $this->_db->getErrorMsg();
		}
		return true;
	}
	
	//-----------
	
	function loadAttachment($filename=NULL, $wish=NULL)
	{
		if ($filename === NULL) {
			return false;
		}
		if ($wish === NULL) {
			return false;
		}
		$this->_db->setQuery( "SELECT * FROM $this->_tbl WHERE filename='$filename' AND wish='$wish'" );
		return $this->_db->loadObject( $this );
	}
}
?>
