<?php
/**
 * @package		HUBzero CMS
 * @author		Shawn Rice <zooley@purdue.edu>
 * @copyright	Copyright 2005-2009 by Purdue Research Foundation, West Lafayette, IN 47906
 * @license		http://www.gnu.org/licenses/gpl-2.0.html GPLv2
 *
 * Copyright 2005-2009 by Purdue Research Foundation, West Lafayette, IN 47906.
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License,
 * version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die( 'Restricted access' );

# Warning: This page is automatically generated by logsum_summary
# Swaroop Shivarajapura

print "
<p>The nanoHUB is a rich, web-based resource for research, education and collaboration in nanotechnology.
The nanoHUB hosts <a href='resources'>over 1600 resources</a> which will help you learn about nanotechnology, including <a href='resources/presentations'>Online Presentations</a>, <a href='resources/courses'>Courses</a>, <a href='resources/learningmodules'>Learning Modules</a>, <a href='podcast'>Podcasts</a>, <a href='resources/animations'>Animations</a>, <a href='resources/teachingmaterials'>Teaching Materials</a>, and more.  Most importantly, the nanoHUB offers <a href='tools'>simulation tools</a> which you can access from your web browser, so you can not only learn about but also simulate nanotechnology devices. The nanoHUB also provides collaboration environment via <a href='resources/1242'>Workspaces</a>, <a href='collaboration/rooms'>Online meetings</a> and <a href='support/groups'>User groups</a>.</p>

<p>Resources come from over <a href='members/contributors/'>600 contributors</a> in the nanoscience community, and are used by <a href='/usage'>thousands of users</a> from over 170 countries around the world.  Most of our users come from academic institutions and use nanoHUB as part of their research and educational activities.  But we also have users from national labs and from industry.</p>
";
print '<p>
nanoHUB has now <a href="citations" title="go to citations">cited over 260 times</a> in the scientific literature.  About 60 percent of the citations stem from authors not affiliated with the NCN. Over 200 of the citations refer to nanotechnology research, with over 150 of them citing concrete resource usage.  A <a href="usage/tools/?&top=9&period=14" title="tool ranking by citations">list of tools ranked by citations </a> is available.  20 citations elaborate on nanoHUB use in education and over 30 refer to nanoHUB as an example of a national cyberinfrastructure.</p>';
print "
<div align='center'><img src = 'site/stats/world_users.gif' title='nanoHUB users from all around the world'></div>
";
print "&nbsp;<a href='usage'><b>Detailed Usage Analysis...</b></a>";

print "<!--";

print "<table widht='50%'>";
print "<th colspan=2>Usage Overview for past 12 months.</th>";
print "<tr>";
print "<td>nanoHUB Users:</td>";
print "<td>26,196 total users that includes 5,901 Simulation users and 20,295 Unregistered users</td>";
print "</tr>";
print "<tr>";
print "<th colspan=2>&nbsp;</td>";
print "</tr>";
print "<tr>";
print "<td>Online Simulations:</td>";
print "<td>59 simulation tools used by 5,901 unique users who ran 226.899 jobs utilizing > 414 days of CPU time</td>";
print "</tr>";
print "<tr>";
print "<td>Online Presentations:</td>";
print "<td>523 presentations viewed by 11,471 users</td>";
print "</tr>";
print "<tr>";
print "<td>Courses:</td>";
print "<td>10 courses viewed by 6,170 users</td>";
print "</tr>";
print "<tr>";
print "<td>Series:</td>";
print "<td>13 series viewed by 6,076 users</td>";
print "</tr>";
print "<tr>";
print "<td>Workshops:</td>";
print "<td>17 workshops viewed by 2,391 users</td>";
print "</tr>";
print "<tr>";
print "<td>Podcasts:</td>";
print "<td>165 podcasts downloaded by 4,434 users</td>";
print "</tr>";

print "<tr>";
print "<th colspan=2>&nbsp;</td>";
print "</tr>";

print "<tr>";
print "<td>Contributors:</td>";
print "<td>384 Contributors contributed over 760 Resources</td>";
print "</tr>";
print "<tr>";
print "<td>Online Meetings:</td>";
print "<td>1,461 online meeting sessions with 1,712 user sessions</td>";
print "</tr>";
print "<tr>";
print "<td>Workspaces:</td>";
print "<td>124 users shared tool/workspace sessions</td>";
print "</tr>";
print "<tr>";
print "<td>nanoFORGE Projects:</td>";
print "<td>88 tools under development</td>";
print "</tr>";

print "<tr>";
print "<th colspan=2>&nbsp;</td>";
print "</tr>";

print "<tr>";
print "<td>New Accounts Created:</td>";
print "<td>7,607</td>";
print "</tr>";
print "<tr>";
print "<td>Visits:</td>";
print "<td>1,058,670</td>";
print "</tr>";
print "<tr>";
print "<td>Web Server Hits:</td>";
print "<td>26,510,586</td>";
print "</tr>";
print "</table>";

print "-->";

?>
