# @package      hubzero-cms
dnl # @file         hub-ssl.m4
# @author       Nicholas J. Kisseberth <nkissebe@purdue.edu>
# @copyright    Copyright (c) 2005-2012 HUBzero Foundation, LLC.
# @license      http://www.gnu.org/licenses/lgpl-3.0.html LGPLv3
#
# Copyright (c) 2005-2012 HUBzero Foundation, LLC.
#
# This file is part of: The HUBzero(R) Platform for Scientific Collaboration
#
# The HUBzero(R) Platform for Scientific Collaboration (HUBzero) is free
# software: you can redistribute it and/or modify it under the terms of
# the GNU Lesser General Public License as published by the Free Software
# Foundation, either version 3 of the License, or (at your option) any
# later version.
#
# HUBzero is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
# HUBzero is a registered trademark of HUBzero Foundation, LLC.

dnl
ifdef(`HUBNAME',`',`define(`HUBNAME',example)')dnl
ifdef(`FQDN',`',`undefine(`USE_CANONICAL_HOSTNAME')')dnl
ifdef(`DOCUMENT_ROOT',`',`define(`DOCUMENT_ROOT',`/var/www/HUBNAME')')dnl
ifdef(`FQDN',`',`define(`FQDN',example.com)')dnl
ifdef(`BASEDN',`',`define(`BASEDN',`dc=HUBNAME')')dnl
ifdef(`SSLCERTFILE',`',`define(`SSLCERTFILE',/etc/ssl/certs/ssl-cert-snakeoil.pem)')dnl
ifdef(`SSLCERTKEYFILE',`',`define(`SSLCERTKEYFILE',/etc/ssl/private/ssl-cert-snakeoil.key)')dnl
ifdef(`SEARCHDN',`',`define(`SEARCHDN',`cn=search,BASEDN')')dnl
ifdef(`DBHOST',`define(`DBHOST',`localhost')')dnl
ifdef(`DBNAME',`define(`DBNAME',`HUBNAME')')dnl
ifdef(`DBUSER',`define(`DBUSER',`HUBNAME')')dnl
changecom(`//')dnl
dnl
# Secure HUBzero Website Definition
#
# DO NOT MODIFY THIS FILE DIRECTLY!!!!
# This file is automatically generated from /etc/apache2/sites-m4/HUBNAME
# and can get recreated on demand by `''hzcms' and other tools
changecom(`#')
<VirtualHost *:443>
	DocumentRoot DOCUMENT_ROOT
	TraceEnable off
	RewriteEngine on
	ServerSignature off
	ServerName FQDN

ifdef(`USE_CANONICAL_HOSTNAME',`	# Force requests to use canonical hostname
	RewriteCond %{HTTP_HOST} !^FQDN$ [NC]
	RewriteCond %{HTTP_HOST} !^$
	RewriteRule ^/(.*) https://FQDN}/$1 [L,R]

')dnl
dnl
ifdef(`USE_FILEXFER',`	# Define filexfer-xlate map
	RewriteMap	filexfer-xlate	prg:/usr/bin/filexfer-xlate

')dnl
dnl
	RewriteRule ^(.*/)?(\.svn|\.git|\.hg)/ - [R=404,L]
	RewriteRule ^/site/wishlist/(.*)(\.htm|\.html)$ - [R=404,L,NC]
	
	<Directory />
		Order Deny,Allow
		Deny from all
		Options None
		AllowOverride None
	</Directory>

	<Directory DOCUMENT_ROOT>
		RewriteEngine On
		Order Allow,Deny
		Allow from all
		Options FollowSymLinks
		AllowOverride None
		DirectoryIndex index.php index.html

ifdef(`USE_FILEXFER',`		# Define filexfer rule
		RewriteRule ^filexfer/(.*)	${filexfer-xlate:$1|nothing} [P,QSA,L]

')dnl
dnl
		RewriteCond %{REQUEST_FILENAME} !-f
		RewriteCond %{REQUEST_FILENAME} !-d
ifdef(`USE_SUBVERSION',`		# Don't redirect subversion urls to cms
		RewriteCond %{REQUEST_URI} !^/tools/[^/]+/svn($|/)
)dnl
dnl
ifdef(`USE_TRAC',`		# Don't redirect trac urls to cms
		RewriteCond %{REQUEST_URI} !^/tools/[^/]+/(pygments|admin|prefs|chrome|log|login|wiki|timeline|roadmap|timeline|browser|search|about|diff|changeset|logout|settings|raw-attachment|attachment|export)($|/)
)dnl
dnl
		RewriteRule (.*) index.php
	</Directory>

	<Directory DOCUMENT_ROOT/site/protected>
		Order Deny,Allow
		Deny from All
		Options None
		AllowOverride None
	</Directory>
dnl
ifdef(`USE_TRAC',`
	# Enable trac urls
	<Directory /usr/share/pyshared/trac/htdocs>
		Options FollowSymLinks
		AllowOverride None
		Order allow,deny
		Allow from all
	</Directory>

	Alias /trac/ "/usr/share/pyshared/trac/htdocs/"

	<LocationMatch /tools/[^/]+((/($|pygments|admin|prefs|chrome|log|login|wiki|roadmap|timeline|browser|search|about|diff|changeset|logout|settings|raw-attachment|attachment|export)($|/)))>
		SetHandler mod_python
		PythonInterpreter main_interpreter
		PythonHandler trac.web.modpython_frontend
		PythonOption TracUriRoot /tools
		PythonOption TracEnvParentDir "/opt/trac/tools"
	</LocationMatch>

	<LocationMatch /tools/[^/]+/login>
		AuthType Basic
		AuthName "Trac Repository [HUBNAME]"
		AuthBasicProvider ldap
		AuthzLDAPAuthoritative off
		AuthLDAPURL ldap://localhost/ou=users,BASEDN?uid?sub?(cn=*)
		AuthLDAPBindDN "SEARCHDN"
ifdef(`SEARCHPW',`		AuthLDAPBindPassword "SEARCHPW"')
		Require valid-user
	</LocationMatch>
')dnl
dnl
dnl
ifdef(`USE_SUBVERSION',`
	# Enable subversion urls (defined seperately)
	Include /etc/apache2/HUBNAME.conf.d/svn.con[f]
')dnl
dnl
dnl
ifdef(`USE_WEBDAV',`
	# Enable webdav urls
	DavLockDB /var/lock/apache2/DavLock

	Alias /webdav /webdav
	RewriteMap lc int:tolower
	RewriteRule ^/webdav(/.*) /webdav/home/${lc:%{LA-U:REMOTE_USER}}$1 [L]
	<Directory /webdav>
		DirectoryIndex .None.file.not.exists
		Options Indexes
		IndexOptions FancyIndexing SuppressDescription
		AllowOverride None
		Order Allow,Deny
		Allow from all
		DAV On
		AuthType Basic
		AuthName "WebDAV Server [HUBNAME]"
		AuthBasicProvider ldap
		AuthzLDAPAuthoritative off
		AuthLDAPURL ldap://localhost/ou=users,BASEDN?uid
		AuthLDAPBindDN "SEARCHDN"
ifdef(`SEARCHPW',`		AuthLDAPBindPassword "SEARCHPW"')
		Require valid-user
		AddType text/plain .php .phtml .pht .phps .php3 .php3p .php4 .php5 .php6
		<FilesMatch ".+">
		        SetHandler default-handler
		</FilesMatch>
	</Directory>
')dnl
dnl

	LogLevel warn
	LogFormat "%{%Y-%m-%d %H:%M:%S %Z}t %P %u \"%r\" %>s %B %a \"%{Referer}i\" \"%{User-Agent}i\" %{SSL_PROTOCOL}x %T %D %{userid}n %{jsession}n %{site}C %{auth}n %{component}n %{view}n %{task}n %{action}n %{item}n" hublog
	ErrorLog ${APACHE_LOG_DIR}/HUBNAME-error-ssl.log
	CustomLog ${APACHE_LOG_DIR}/HUBNAME-access.log hublog

	SSLEngine On
	SSLCipherSuite ALL:!ADH:!EXPORT56:+HIGH:+MEDIUM:+EXP:SSLv3:!DES:!NULL:!RC2:!RC4
	SSLCertificateFile SSLCERTFILE
	SSLCertificateKeyFile SSLCERTKEYFILE

	# Compensation for MSIE client flaws
	SetEnvIf User-Agent ".*MSIE [1-5].*" nokeepalive ssl-unclean-shutdown downgrade-1.0 force-response-1.0
	SetEnvIf User-Agent ".*MSIE [6-9].*" ssl-unclean-shutdown
	<Limit POST>
		SetEnvIf User-Agent ".*MSIE [6-9].*" nokeepalive ssl-unclean-shutdown
	</Limit>

	<Location /site>
		AddType text/plain .php .phtml .pht .phps .php3 .php3p .php4 .php5 .php6
		php_admin_value engine Off
	</Location>

	AddType application/x-font-ttf .ttf
	AddType application/vnd.ms-fontobject .eot
	AddType application/x-font-opentype .otf
	AddType application/x-font-woff .woff

</VirtualHost>

ifdef(`USE_FILEXFER',`	# Define rewrite lock because of filexfer
	RewriteLock /var/lock/apache2/RewriteLock
')dnl

ifdef(`USE_VNCPROXY',`
# Enable vncproxy
vncProxy On
vncProxyDBDriver mysql
vncProxyDBDParams host=DBHOST,user=DBUSER,pass=DBPASS,dbname=DBNAME
vncProxyHelper "/usr/bin/vncproxy %t"

')dnl
