/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

class VncTrustManager
implements X509TrustManager {
    public static final int DEFAULT = 1;
    public static final int ALL = 2;
    public static final int SERVER = 4;
    public static final int URL = 8;
    public static final int ONE = 16;
    int mode = 1;
    boolean debug = false;
    boolean debug_certs = false;
    Certificate[] trustallCerts = null;
    Certificate[] trustsrvCerts = null;
    Certificate[] trusturlCerts = null;
    String cert_fail;
    X509TrustManager sunJSSEX509TrustManager;

    public String getTrustModeName() {
        if (this.mode == 1) {
            return "DEFAULT";
        }
        if (this.mode == 2) {
            return "ALL";
        }
        if (this.mode == 4) {
            return "SERVER";
        }
        if (this.mode == 8) {
            return "URL";
        }
        if (this.mode == 16) {
            return "ONE";
        }
        return "(unknown)";
    }

    public void setTrustMode(int n) {
        this.mode = (n & 1) == 1 ? 1 : ((n & 2) == 2 ? 2 : ((n & 4) == 4 ? 4 : ((n & 8) == 8 ? 8 : ((n & 0x10) == 16 ? 16 : 1))));
    }

    public int getTrustMode() {
        return this.mode;
    }

    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    VncTrustManager() throws KeyStoreException, IOException, NoSuchAlgorithmException, Exception {
        KeyStore keyStore = null;
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("SunX509", "SunJSSE");
        trustManagerFactory.init(keyStore);
        TrustManager[] trustManagerArray = trustManagerFactory.getTrustManagers();
        for (int i = 0; i < trustManagerArray.length; ++i) {
            if (!(trustManagerArray[i] instanceof X509TrustManager)) continue;
            this.sunJSSEX509TrustManager = (X509TrustManager)trustManagerArray[i];
            return;
        }
        throw new Exception("Couldn't initialize");
    }

    public X509Certificate[] getAcceptedIssuers() {
        if ((this.mode & 1) == 1) {
            return this.sunJSSEX509TrustManager.getAcceptedIssuers();
        }
        return null;
    }

    public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        String string2;
        block7: {
            string2 = "";
            if ((this.mode & 2) == 2) {
                return;
            }
            if ((this.mode & 1) == 1) {
                try {
                    this.sunJSSEX509TrustManager.checkClientTrusted(x509CertificateArray, string);
                }
                catch (CertificateException certificateException) {
                    if (this.mode != 1) break block7;
                    throw certificateException;
                }
            }
        }
        if ((this.mode & 4) == 4) {
            string2 = string2.length() == 0 ? "SRV" : string2 + ",SRV";
        }
        if ((this.mode & 8) == 8) {
            string2 = string2.length() == 0 ? "URL" : string2 + ",URL";
        }
        if ((this.mode & 0x10) == 16) {
            string2 = string2.length() == 0 ? "ONE" : string2 + ",ONE";
        }
        throw new CertificateException("No Clients (" + string2 + ")");
    }

    public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        block30: {
            this.dbg("checkServerTrusted(): start");
            if ((this.mode & 2) == 2) {
                this.dbg("checkServerTrusted(): end [accepted, all]");
                return;
            }
            if ((this.mode & 1) == 1) {
                try {
                    this.sunJSSEX509TrustManager.checkServerTrusted(x509CertificateArray, string);
                    this.dbg("checkServerTrusted(): end [accepted, default]");
                    return;
                }
                catch (CertificateException certificateException) {
                    if (this.mode != 1) break block30;
                    this.dbg("checkServerTrusted(): end [rejected, default]");
                    throw certificateException;
                }
            }
        }
        if (x509CertificateArray == null) {
            this.dbg("checkServerTrusted(): end [rejected, no this-certs]");
            throw new CertificateException("No this-certs array.");
        }
        if (x509CertificateArray.length < 1) {
            this.dbg("checkServerTrusted(): end [rejected, empty this-certs]");
            throw new CertificateException("No this-certs Certs.");
        }
        if ((this.mode & 8) == 8) {
            if (this.mode == 8) {
                if (this.trusturlCerts == null) {
                    this.dbg("checkServerTrusted(): end [rejected, url, no certs");
                    throw new CertificateException("No Trust url Certs array.");
                }
                if (this.trusturlCerts.length < 1) {
                    this.dbg("checkServerTrusted(): end [rejected, url, empty certs");
                    throw new CertificateException("No Trust url Certs.");
                }
                if (x509CertificateArray.length != this.trusturlCerts.length) {
                    this.dbg("checkServerTrusted(): end [rejected, url, trivial cert mismatch");
                    throw new CertificateException("certs.length != trusturlCerts.length " + x509CertificateArray.length + " " + this.trusturlCerts.length);
                }
            }
            if (this.trusturlCerts != null && this.trusturlCerts.length > 0 && x509CertificateArray.length == this.trusturlCerts.length) {
                boolean bl = true;
                for (int i = 0; i < x509CertificateArray.length; ++i) {
                    if (this.trusturlCerts[i].equals(x509CertificateArray[i])) continue;
                    bl = false;
                    this.dbg("checkServerTrusted(): URL cert mismatch at i=" + i);
                    this.dbg("checkServerTrusted(): URL cert mismatch cert" + x509CertificateArray[i]);
                    this.dbg("checkServerTrusted(): URL cert mismatch  url" + this.trusturlCerts[i]);
                    if (this.cert_fail != null) continue;
                    this.cert_fail = "cert-mismatch";
                }
                if (!bl && this.mode == 8) {
                    this.dbg("checkServerTrusted(): [rejected, URL, mismatch]");
                    throw new CertificateException("Server Cert Chain != URL Cert Chain.");
                }
                this.dbg("checkServerTrusted(): end [accepted, URL, trusturlCerts[i] matches certs[i] i=0:" + (x509CertificateArray.length - 1) + "]");
                return;
            }
        }
        if ((this.mode & 4) == 4) {
            if (this.mode == 4) {
                if (this.trustsrvCerts == null) {
                    throw new CertificateException("No Trust srv Certs array.");
                }
                if (this.trustsrvCerts.length < 1) {
                    throw new CertificateException("No Trust srv Certs.");
                }
                if (x509CertificateArray.length != this.trustsrvCerts.length) {
                    throw new CertificateException("certs.length != trustsrvCerts.length " + x509CertificateArray.length + " " + this.trustsrvCerts.length);
                }
            }
            if (this.trustsrvCerts != null && this.trustsrvCerts.length > 0 && x509CertificateArray.length == this.trustsrvCerts.length) {
                boolean bl = true;
                for (int i = 0; i < x509CertificateArray.length; ++i) {
                    if (this.trustsrvCerts[i].equals(x509CertificateArray[i])) continue;
                    bl = false;
                    this.dbg("SRV: cert mismatch at i=" + i);
                    this.dbg("SRV: cert mismatch cert" + x509CertificateArray[i]);
                    this.dbg("SRV: cert mismatch  srv" + this.trustsrvCerts[i]);
                    if (this.cert_fail != null) continue;
                    this.cert_fail = "server-cert-mismatch";
                }
                if (!bl && this.mode == 4) {
                    throw new CertificateException("Server Cert Chain != serverCert Applet Parameter Cert Chain.");
                }
                this.dbg("checkServerTrusted(): end [trustsrvCerts[i] matches certs[i] i=0:" + (x509CertificateArray.length - 1) + "]");
                return;
            }
        }
        if ((this.mode & 0x10) == 16) {
            if (this.mode == 16) {
                if (this.trustallCerts == null) {
                    throw new CertificateException("No Trust All Server Certs array.");
                }
                if (this.trustallCerts.length < 1) {
                    throw new CertificateException("No Trust All Server Certs.");
                }
                if (x509CertificateArray.length != this.trustallCerts.length) {
                    throw new CertificateException("certs.length != trustallCerts.length " + x509CertificateArray.length + " " + this.trustallCerts.length);
                }
            }
            if (this.trustallCerts != null && this.trustallCerts.length > 0 && x509CertificateArray.length == this.trustallCerts.length) {
                boolean bl = true;
                for (int i = 0; i < x509CertificateArray.length; ++i) {
                    if (this.trustallCerts[i].equals(x509CertificateArray[i])) continue;
                    bl = false;
                    this.dbg("ONE: cert mismatch at i=" + i);
                    this.dbg("ONE: cert mismatch cert" + x509CertificateArray[i]);
                    this.dbg("ONE: cert mismatch  all" + this.trustallCerts[i]);
                }
                if (!bl && this.mode == 16) {
                    throw new CertificateException("Server Cert Chain != TRUSTALL Cert Chain.");
                }
                this.dbg("checkServerTrusted(): end [trustallCerts[i] matches certs[i] i=0:" + (x509CertificateArray.length - 1) + "]");
                return;
            }
        }
        this.dbg("checkServerTrusted(): end [unknown trust mode?]");
    }

    boolean browser_cert_match(boolean bl, String string) {
        String string2 = "Browser URL accept previously accepted cert";
        if (bl) {
            return false;
        }
        if ((string != null || this.trustsrvCerts != null) && this.cert_fail == null) {
            this.cert_fail = "server-cert-mismatch";
        }
        if (this.trustallCerts != null && this.trusturlCerts != null && this.trustallCerts.length == this.trusturlCerts.length) {
            boolean bl2 = true;
            for (int i = 0; i < this.trusturlCerts.length; ++i) {
                if (this.trustallCerts[i].equals(this.trusturlCerts[i])) continue;
                this.dbg("BCM: cert mismatch at i=" + i);
                this.dbg("BCM: cert mismatch  url" + this.trusturlCerts[i]);
                this.dbg("BCM: cert mismatch  all" + this.trustallCerts[i]);
                bl2 = false;
            }
            if (bl2) {
                System.out.println(string2);
                if (this.cert_fail == null) {
                    this.cert_fail = "did-not-fail";
                }
                return true;
            }
            if (this.cert_fail == null) {
                this.cert_fail = "cert-mismatch";
            }
            return false;
        }
        if (this.cert_fail == null) {
            this.cert_fail = "missing-certs";
        }
        return false;
    }

    private void dbg(String string) {
        if (this.debug) {
            System.out.println(string);
        }
    }

    public String getFailMsg() {
        return this.cert_fail;
    }

    public void setDebugCerts(boolean bl) {
        this.debug_certs = bl;
    }

    public void setTrustAllCerts(Certificate[] certificateArray) {
        this.trustallCerts = certificateArray;
    }

    public Certificate[] getTrustAllCerts() {
        return this.trustallCerts;
    }

    public void setTrustSrvCerts(Certificate[] certificateArray) {
        this.trustsrvCerts = certificateArray;
    }

    public Certificate[] getTrustSrvCerts() {
        return this.trustsrvCerts;
    }

    public void setTrustUrlCerts(Certificate[] certificateArray) {
        this.trusturlCerts = certificateArray;
    }

    public Certificate[] getTrustUrlCerts() {
        return this.trusturlCerts;
    }
}

