#!/usr/bin/env python
#
# @package      hubzero-forge
# @file         getExternalGITexternal.py
# @author       Steven M. Clark <clarks@purdue.edu>
# @copyright    Copyright (c) 2005-2018 HUBzero Foundation, LLC.
# @license      http://opensource.org/licenses/MIT MIT
#
# Copyright (c) 2005-2018 HUBzero Foundation, LLC.
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.
#
# HUBzero is a registered trademark of HUBzero Foundation, LLC.
#
#----------------------------------------------------------------------
#  USAGE:
#    installtool ?flags? <project>
#
#    where ?flags? includes:
#      -gitURL ........... URL for external GIT repository
#
#----------------------------------------------------------------------

import os
import sys
import stat
import argparse
import glob
import re
import shutil
import subprocess
import traceback
import time

HUBCONFIGURATIONFILE = 'hubconfiguration.php'
GITHOMEDIRECTORY     = os.path.join(os.sep,'opt','gitExternal','tools')

os.umask(0o022)

# this is an easy way to exec commands and catch errors:
def exit_on_error(command):
   child = subprocess.Popen(command,
                            shell=False,
                            stdout=subprocess.PIPE,
                            stderr=subprocess.PIPE,
                            close_fds=True,
                            universal_newlines=True)
   stdOutput,stdError = child.communicate()
   exitStatus = child.returncode
   if exitStatus != 0:
      sys.stderr.write("FAILED: %s\n" % (command))
      if stdError:
         sys.stderr.write("%s\n" % (stdError))
      if stdOutput:
         sys.stderr.write("%s\n" % (stdOutput))

   return(exitStatus,stdOutput,stdError)

#
# use these procedures to exec git commands
#
def gitLocal(gitArgs,
             gitPath=None):
   if gitPath:
      currentPath = os.getcwd()
      os.chdir(gitPath)

   command = ['git'] + gitArgs
   exitStatus,stdOutput,stdError = exit_on_error(command)

   if gitPath:
      os.chdir(currentPath)

   return(exitStatus,stdOutput,stdError)

#
#----------------------------------------------------------------------
# Parse all command line options
#----------------------------------------------------------------------
#
parser = argparse.ArgumentParser(description="Install git repository for any tool development project on a HUBzero site.")
parser.add_argument('--project',required=True,help="project shortname")
parser.add_argument('--gitURL',required=True,help="URL for external GIT repository")

args = parser.parse_args()

#print(args)

options = {}
options['project'] = args.project
options['gitURL']  = args.gitURL

repoPath = os.path.join(GITHOMEDIRECTORY,options['project'])
#
# Update HUB copy of exteral repository
#
if os.path.isdir(repoPath):
   gitLocal(['pull'],gitPath=repoPath)

#   for gitTop in (repoPath,):
#      for gitfile in glob.iglob(gitTop):
#         gitfileMode = os.lstat(gitfile).st_mode
##        add group write
#         gitfileMode |= stat.S_IWGRP
##        remove all other permissions
#         gitfileMode &= ~stat.S_IRWXO
#         if os.path.isdir(gitfile):
##           add set group id to directory
#            gitfileMode |= stat.S_ISGID
#         os.chmod(gitfile,gitfileMode)
#         try:
#            shutil.chown(gitfile,group=apacheGroup)
#         except:
#            import grp
#            apacheGroupId = grp.getgrnam(apacheGroup).gr_gid
#            os.chown(gitfile,-1,apacheGroupId)
else:
   sys.stderr.write("GIT repository does not exist at %s.\n" % (repoPath))
   sys.exit(1)

sys.exit(0)
