module.exports = function(hg, done) {
	hg.event.observe('onStartBoot', function(client) {
		var getSql = function(id) {
			var sql = 'SELECT DISTINCT ' +
					'\'aliases\' AS domain, concat(\'tag:\', tagid) AS id, jt.tag AS tag, jt.raw_tag AS title, description AS body ' +
				'FROM jos_tags_object jto ' +
				'INNER JOIN jos_tags jt ' +
					'ON jt.id = jto.tagid AND NOT jt.admin';
			return sql + (id ? ' WHERE tagid = ' + (1*id) : '');
		};
		hg.tag_to_id = {};

		var addAlias = function(client, id, none, done) {
			var sql = 'SELECT DISTINCT ' +
				'\'tag-aliases\' AS domain, tag AS id, raw_tag AS title, tag_id ' +
				'FROM jos_tags_substitute' + (id ? ' WHERE id = ' + (1*id) : '');
			client.query(sql, function(err, results) {
				if (err) {
					hg.log('no tag aliases available: ' + err);
					return;
				}
				if (!results.length && none) {
					none();
				}
				results.forEach(function(res) {
					if (res.title.indexOf('\'') != -1) {
						return;
					}
					hg.add(res);
					hg.connect('fold-tag', 'tag-aliases', res.id, 'aliases', 'tag:' + res.tag_id);
				});
				if (done) {
					done();
				}
			});
		};

		var count = 0;
		client.query(getSql(), function(err, results) {
			if (err) {
				throw err;
			}
			hg.log(results.length + ' tags');
			results.forEach(function(res) {
				hg.tag_to_id[res.tag] = res.id;
				hg.addWithCommonConnections(res);
			});

			sql = 'SELECT DISTINCT objectid AS to_tag, tagid AS from_tag, label FROM jos_tags_object WHERE tbl = \'tags\' AND label IS NOT NULL';
			// add in tag<->tag relationships
			client.query(sql, function(err, results) {
				if (err) {
					throw err;
				}
				hg.log(results.length + ' tag<->tag relationships');
				results.forEach(function(res) {
					hg.connect(res.label, 'aliases', 'tag:' + res.from_tag, 'aliases', 'tag:' + res.to_tag);
				});
				hg.event.emit('onTagsLoaded', [client]);
			});
			addAlias(client, null, null, done);
		});

		hg.event.observe('onUpdateTagsSubstitute', function(client, row) {
			addAlias(client, row.id, function() {
				hg.remove('tag-aliases', row.id);
			});
		});

		hg.event.observe('onInsertTagsSubstitute', function(client, row) {
			addAlias(client, row.id);
		});

		hg.event.observe('onDeleteTagsSubstitute', function(client, row) {
			hg.remove('tag-aliases', row.id);
		});

		var tableMap = {
			'answers': null, 
			'blog': null,
			'citations': 'citations',
			'courses': null,
			'events': 'events',
			'forum': 'discussions',
			'groups': 'groups',
			'publications': null,
			'resources': 'resources',
			'support': null,
			'wiki': null, /// @TODO could be topics or group wiki 
			'wishlist': 'wishes'
		};
		
		hg.event.observe('onInsertTagsObject', function(client, row) {
			client.query('SELECT t.tagid, jto.tbl, jto.objectid FROM jos_tags t INNER JOIN jos_tags_object jto ON jto.tagid = t.id AND jto.id = ' + (1*row.id), function(err, results) {
				if (err) {
					throw err;
				}
				if (results.length) {
					var tbl = tableMap[results[0].tbl];
					if (tbl) {
						hg.connect('alias', 'aliases', 'tag:' + results[0].tagid, tbl, results[0].objectid);
					}
				}
			});
		});

		hg.event.observe('onDeleteTagsObject', function(client, row) {
			var notes = JSON.parse(row.note);
			var tbl = tableMap[notes.table];
			if (tbl) {
				hg.disconnect('alias', 'aliases', 'tag:' + notes.tag_id, tbl, row.notes.other_id);
			}
			else {
				console.log('WARNING: no map for tags-object tbl: ' + row.note);
			}
		});


		hg.event.observe('onInsertTags', function(client, row) {
			client.query(getSql(row.id), function(err, results) {
				if (err) {
					throw err;
				}
				if (results.length) {
					results.forEach(function(res) {
						hg.tag_to_id[res.tag] = res.id;
						hg.addWithCommonConnections(res);
					});
				}
				else {
					hg.remove('aliases', 'tag:' + row.id);
				}
			});
		});

		hg.event.observe('onDeleteTags', function(client, row) {
			hg.remove('aliases', 'tag:' + row.id);
		});
	});
};
