var parts = [
	function(fs, base) {
		return [
			'HUBGRAPH.CONF',
			'=============',
			'Please update /etc/hubgraph.conf to contain this information, filling in the appropriate parameters for your MySQL connection.',
			'It is recommended that the MySQL account have read/write access to the table hg_update_queue and read-only access to the rest of the database.',
			'',
			'\n\n#>/etc/hubgraph.conf',
			fs.readFileSync(base + '/conf/hubgraph.conf.distrib', {'encoding': 'utf8'}).replace(/%HG_ROOT%/g, base)
		];
	},
	function(fs, base) {
		var nodePath = fs.realpathSync(base + '/..');
		return [
			'MYSQL TRIGGERS',
			'==============',
			'Hubgraph updates with triggers. Usually, triggers must be installed my the MySQL root user.',
			'This script requires a valid connection in hubgraph.conf. It doesn\'t make any changes direction, but it uses the connection to do some introspection on the current state of your CMS database.',
			'To see the definitions of these triggers:',
			'	NODE_PATH=' + nodePath + ' node -e \'require("hubgraph-hubzero").generateTriggers();\'',
			'To install the triggers, pipe to MySQL (or if you you wish to make edits, pipe to a file and pipe that to MySQL):',
			'	NODE_PATH=' + nodePath + ' node -e \'require("hubgraph-hubzero").generateTriggers();\' | mysql -u root -p {your database name}'
		];
	},
	function(fs, base) {
		return [
			'COM_HUBGRAPH',
			'============',
			'You should install the Joomla! component that is synced to this version of hubgraph to your document root.',
			'	cp -r ' + fs.realpathSync(base + '/..') + '/com_hubgraph {your document root}/components',
			'After doing this, if you\'re installing for the first time (should be good if you\'re upgrading), log in to your hub with a Super Administrator account and visit:',
			'	http://{your host}/hubgraph?task=settings',
			'Make sure the host and port correspond with your settings in hubgraph.conf.'
		];
	}
];

module.exports = function() {
	var fs = require('fs'),
		base = fs.realpathSync(__dirname + '/../');
	var idx = 0;
	parts[0](fs, base).forEach(function(str) { console.log(str); });
	console.log('I did that, continue > ');
	process.stdin.on('data', function() { 
		if (++idx < parts.length) {
			parts[idx](fs, base).forEach(function(str) { console.log(str); });
			console.log('continue > ');
		}
		else {
			process.exit();
		}
	}); 
	// hubgraph.conf

	// triggers
	// component
	// joomla config
};
