module.exports = function(hg, done) {
	hg.event.observe('onWarehouseProjectsLoaded', function(client) {
		var sql = [
			'select ',
				't.expid "id",',
				'\'experiments\' "domain",',
				't.name "name",',
				't.title "title",', 
				't.description "body",',
				't.start_date "date",',
				't.end_date "end_date",',
				't.viewable "viewable",',
				'\'https://nees.org/warehouse/experiment/\' || t.expid || \'/project/\' || t.projid "link",',
				't.projid "standalone_id",',
				'\'projects\' "standalone_domain"',
			'from Experiment t'
		].join("\n");
		client.execute(sql, [], function(err, results) {
		        if (err) { 
				throw err; 	
			}
			results.forEach(function(res) {
				res.group_id = hg.select('projects', res.standalone_id).use().items[0].group_id;
				hg.addWithCommonConnections(res);
				hg.connect('parent', 'projects', res.standalone_id, 'experiments', res.id);
			});
			hg.event.emit('onWarehouseExperimentsLoaded', [client]);
		});
	});
	done();
};
