module.exports = function(hg, done) {
	hg.event.observe('onWarehouseConnect', function(client, mysql) {
		mysql.query('SELECT cn, gidNumber FROM jos_xgroups', function(err, results) {
			if (err) {
				throw err;
			}
			var groupMap = {};
			results.forEach(function(res) {
				groupMap[res.cn] = res.gidNumber;
			});
		
			var sql = [
				'select p.projid "id",', 
					'\'projects\' "domain",',
					'p.name "name",',
					'replace(lower(p.name), \'-\', \'_\') "group_cn",',
					'p.title "title",',
					'p.description "body",',
					'p.start_date "date",',
					'p.end_date "end_date",',
					'p.viewable "viewable",',
					'\'https://nees.org/warehouse/project/\' || p.projid "link"',
				'from Project p'
			].join('\n');
			console.log(sql);
			client.execute(sql, [], function(err, results) {
			        if (err) { 
					throw err; 	
				}
				results.forEach(function(res) {
					res.group_id = groupMap[res.group_cn];
					hg.addWithCommonConnections(res);
				});
				hg.event.emit('onWarehouseProjectsLoaded', [client]);
			});
		});
	});
	done();
};
