module.exports = function(hg, done) {
	if (!hg.conf.warehouse) {
		done();
		return;
	}
/*
	hg.event.observe('onStartUpdate', function() {
		if (hg.conf.warehouse.updateInterval) {
			client.query('TRUNCATE TABLE hg_update_queue');
			setInterval(function() {
				console.log(' - tick - ');
				client.query('SELECT * FROM hg_update_queue', function(err, results) {
					if (err) {
						throw err;
					}
					console.log(results);
					results.forEach(function(res) {
						if (res.notes) {
							res.notes = JSON.parse(res.notes);
						}
						hg.event.emit('on' + res.action[0] + res.action.substr(1).toLowerCase() + res.table_name[0].toUpperCase() + res.table_name.substr(1), [client, res]);
					});
					client.query('DELETE FROM hg_update_queue WHERE table_name = \'resources\' OR table_name = \'content\' OR table_name = \'events\'');
				});
			}, hg.conf.hubgraph.updateInterval*1000);
		}
	});
*/
	hg.event.observe('onMysqlConnect', function(mysql) {
		hg.log('Connecting to Oracle...');
		var oracle = require('oracle');
		var opts = {
			'tns'     : hg.conf.warehouse.tns,
			'user'    : hg.conf.warehouse.user,
			'password': hg.conf.warehouse.password
		};
		oracle.connect(opts, function(err, conn) {
			if (err) {
				throw err;
			}
			console.log('oracle connected');
			hg.event.observe('onExtensionResourcesWarehouseLoaded', function() {
				console.log('loaded oracle extensions');
				hg.event.emit('onWarehouseConnect', [conn, mysql]);
				done();
			});
			hg.requireJsExtension('resources/warehouse');
		});
	});
};
