module.exports = function(hg) {
	var weightLink = function(item) {
		switch (item.type) {
			case 'user':
				var rv = 0, member = hg.select('members', item.id).use().items[0];
				for (var k in member.contributions) {
					rv += member.contributions[k];
				}
				return rv;
			default:
				return hg.select('aliases', item.type + ':' + item.id).out('alias').items.length;
		}
	};
	var reQuote = function(str) {
		return str.replace(new RegExp('[.\\\\+*?\\[\\^\\]$(){}=!<>|:\\/-]', 'g'), '\\$&');
	}
	hg.views.complete = function(args) {
		var rv = {
			'links': {},
			'completions': []
		};
		var trailingSpace = /\s$/.test(args.terms),
		          lcterms = args.terms.toLowerCase().replace(/^\s+|\s+$/g, '');
		if (!lcterms) {
			return rv;
		}
		var   neg = {}, negAr = [],
		    negRe = null,
		    terms = lcterms.split(/[^-_'/\\\w]+/).filter(function(term) { 
			if (/^-/.test(term)) {
				var stem = hg.stem(term.replace(/^-/, ''));
				neg[stem] = 1;
				negAr.push(stem);
				return false;
			}
			return true;
		}),
		     orig = terms,
		       re = new RegExp('(' + terms.map(reQuote).join('|') + ')', 'ig'),
		   prefix = terms.slice(0, terms.length - 1),
		usedStems = {}
			;
		
		if (negAr.length) {
			negRe = new RegExp('(' + negAr.map(reQuote).join('|') + ')', 'i');
		}
		
		usedStems[hg.stem(orig[orig.length - 1])] = 1;
		rv.completions = hg.completeTerm(orig[orig.length - 1])
			.filter(function(term) {
				var stem = hg.stem(term[0]), ok = !usedStems[stem];
				usedStems[stem] = 1;
				return ok && !neg[stem] && hg.getWordCount(term[0]) > 1;
			})
			.map(function(term) { 
				return (prefix == '' ? '' : prefix + ' ') + term[0];
			});

		var termStems = {}, termStemLength = 0;
		terms.map(hg.stem).forEach(function(stem) {
			termStems[stem] = 1;
			++termStemLength;
		});

		if (trailingSpace || hg.getWordCount(orig[orig.length - 1]) > 10) {
			var text = hg.selectText(terms.join(' '));
			text.items.forEach(function(t) {
				t.titleSum = 0, t.bodySum = 0;
				hg.select('text', t.id).out('title-word').items.forEach(function(item) {
					t.titleSum += item.weight
				});
				hg.select('text', t.id).out('body-word').items.forEach(function(item) {
					t.bodySum += item.weight
				});
			});



			rv.completions = rv.completions.concat(text
				.filter(function(item) {
					var stems = {}, count = 0, hasOther = false;
					item.id.split(' ').forEach(function(stem) {
						stems[stem] = 1;
					});
					for (var k in stems) {
						if (neg[k]) {
							return false;
						}
						if (termStems[k]) { 
							++count;
						}
						else if (k.length > 2) {
							hasOther = true;
						}
					}
					return hasOther && count == termStemLength;
				})
				.filter(function(item) {
					var found = false;
					rv.completions.forEach(function(other) {
						if (!other.id || other.id.indexOf(item.id) == 0) {
							found = true;
							return false;
						}
					});
					return !found;
				})
				.sort(function(a, b) {
					if (a.weight > b.weight) {
						return -1;
					}
					if (b.weight > a.weight) {
						return 1;
					}
					if (a.titleSum > b.titleSum) {
						return -1;
					}
					if (b.titleSum > a.titleSum) {
						return 1;
					}
					if (a.bodySum > b.bodySum) {
						return -1;
					}
					if (b.bodySum > a.bodySum) {
						return 1;
					}
					return 0;
				})
				.limit(args.limit || 40)
				.items.map(function(item) {
					return hg.unstem(item.id);
				}))
			;
		}
		var words = {}, wordList = [];
		rv.completions.forEach(function(word) {
			if (!words[word]) {
				words[word] = 1;
				wordList.push(word);
			}
		});
		rv.links = {};
		var t = hg.selectText(wordList.join(' '))
			.filter(function(item) {
				var all = item.id.match(re);
				if (all && all.length >= terms.length) {
					return true;
				}
				var stems = {}, count = 0;
				item.id.split(' ').forEach(function(stem) {
					stems[stem] = 1;
				});
				for (var k in stems) {
					if (termStems[k]) { 
						++count;
					}
				}
				return count == termStemLength;
			})
			.out('title-word', 'aliases')
				.use()
				.items
					.map(function(item) {
						var type = item.id.match(/(.*):(.*)/);
						if (!type) {
							item.weight = 0;
							return { 'weight': 0 };
						}
						item.type = type[1];
						item.id = type[2];
						rv.links[item.type] = [];
						item.weight = weightLink(item);
						return item;
					})
					.filter(function(item) {
						return item.weight > 0 && (!negRe || !negRe.test(item.title));
					})
					.sort(function(a, b) {
						if (a.weight > b.weight) {
							return -1;
						}
						if (b.weight > a.weight) {
							return 1;
						}
						return 0;
					})
					.forEach(function(item) {
						rv.links[item.type].push([item.id, item.title]);
					})
			;
		return rv;
	};
};
