module.exports = function(hg, done) {
	hg.event.observe('onCitationsLoaded', function(client) {
		var cols = null;
		var getSql = function(id) {
			var priv = cols.privacy ? 'g.privacy': 'NULL',
				disc = cols.join_policy ? 'g.join_policy' : cols.discoverability ? 'g.discoverability' : 'NULL';
			return 'SELECT \'groups\' AS domain, g.gidNumber AS id, g.type AS group_type, g.cn AS cn, g.description AS title, coalesce(g.public_desc, \'\') AS body, CAST(concat(\'/groups/\', g.cn) AS CHAR) AS link, ' +
				'(SELECT CAST(group_concat(DISTINCT jto.tagid separator \'\\n\') AS CHAR) FROM jos_tags_object jto INNER JOIN jos_tags jt ON jt.id = jto.tagid WHERE jto.tbl = \'groups\' AND jto.objectid = g.gidNumber) AS tag_ids, ' + 
				priv + ' AS privacy, ' + 
				disc + ' AS discoverability, ' +
				'(SELECT COUNT(DISTINCT uidNumber) FROM jos_xgroups_members me WHERE me.gidNumber = g.gidNumber) AS member_count ' +
				'FROM jos_xgroups g WHERE g.type = 1 OR g.type = 3' + (id ? ' AND g.gidNumber = ' + (id*1) : '')
		};

		var query = function(client, cb, id) {
			if (!cols) {
				client.getColumnMap('jos_xgroups', function(c) {
					cols = c;
					query(client, cb, id);
				});
				return;
			}
			client.query(getSql(id), function(err, results) {
				if (err) {
					throw err;
				}
				cb(results);
			});
		};

		hg.groupPerms = {};

		query(client, function(results) {
			results.forEach(function(res) {
				hg.add({'domain': 'aliases', 'id': 'group:' + res.id, 'title': res.title});
				hg.addWithCommonConnections(res);
				hg.groupPerms[res.id] = {'privacy': res.privacy, 'discoverability': res.discoverability, 'params': res.params};
			});
			done();
			hg.event.emit('onGroupsLoaded', [client]);
		});

		hg.event.observe('onUpdateGroups', function(client, row) {
			query(client, function(results) {
				if (results.length) {
					results.forEach(function(res) {
						hg.add({'domain': 'aliases', 'id': 'groups:' + res.id, 'title': res.title, 'body': res.body});
						hg.addWithCommonConnections(res);
						hg.groupPerms[res.id] = {'privacy': res.privacy, 'discoverability': res.discoverability, 'params': res.params};
					});
				}
				else {
					hg.remove('groups', row.id);
				}
			}, row.id);
		});

		hg.event.observe('onInsertGroups', function(client, row) {
			query(client, function(results) {
				results.forEach(function(res) {
					hg.add({'domain': 'aliases', 'id': 'groups:' + res.id});
					hg.addWithCommonConnections(res);
					hg.groupPerms[res.id] = {'privacy': res.privacy, 'discoverability': res.discoverability, 'params': res.params};
				});
			}, row.id);
		});

		hg.event.observe('onDeleteGroups', function(client, row) {
			hg.remove('groups', row.id);
		});
	});
};
