module.exports = function(hg, done) {
	hg.event.observe('onKbLoaded', function(client) {
		var getSql = function(id) {
			var sql = 'SELECT \'questions\' AS domain, q.id, q.subject AS title, q.question AS body, q.created AS date, ' +
				'CASE WHEN q.anonymous THEN NULL ELSE (SELECT id FROM jos_users WHERE username = q.created_by LIMIT 1) END AS contributor_ids, ' +
				'CAST(concat(\'/answers/question/\', q.id) AS CHAR) AS link,' +
				'(SELECT group_concat(DISTINCT jto.tagid separator \'\\n\') FROM jos_tags_object jto INNER JOIN jos_tags jt ON jt.id = jto.tagid WHERE jto.tbl = \'answers\' AND jto.objectid = q.id) AS tag_ids ' +
				'FROM jos_answers_questions q ' +
				'WHERE q.state != 2';
			return id ? sql + ' AND q.id = ' + (1*id) : sql;
		};

		var add = function(res) {
			client.query(
				'SELECT \'answers\' AS domain, r.id, r.question_id AS standalone_id, \'questions\' AS standalone_domain, r.answer AS body, r.created AS date, ' +
				'CASE WHEN r.anonymous THEN NULL ELSE (SELECT id FROM jos_users WHERE username = r.created_by) END AS contributor_ids ' +
				'FROM jos_answers_responses r ' +
				'WHERE r.question_id = ' + res.id,
				function(err2, results2) {
					if (err2) {
						throw err2;
					}
					res.answer_count = results2.length;
					res.type = res.answer_count == 0 ? 'pending' : 'answered';
					hg.addWithCommonConnections(res);
					results2.forEach(function(res2) {
						res2.parent_ids = [res2.standalone_id];
						hg.addWithCommonConnections(res2);
						hg.connect('parent', 'questions', res.id, 'answers', res2.id);
					});
				}
			);
		};

		var sql = getSql();
		client.query(sql, function(err, results) {
			if (err) {
				throw err;
			}
			hg.log(results.length + ' questions');
			results.forEach(add);
			done();
			hg.event.emit('onQuestionsLoaded', [client]);
		});
	});

	hg.event.observe('onUpdateAnswersQuestions', function(client, row) {
		var sql = getSql(row.id);
		client.query(sql, function(err, results) {
			if (err) {
				throw err;
			}
			if (!results.length) {
				hg.remove('questions', row.id);
			}
			else {
				results.forEach(add);
			}
		});
	});

	hg.event.observe('onInsertAnswersQuestions', function(client, row) {
		var sql = getSql(row.id);
		client.query(sql, function(err, results) {
			if (err) {
				throw err;
			}
			results.forEach(add);
		});
	});

	hg.event.observe('onDeleteAnswersQuestions', function(client, row) {
		hg.remove('questions', row.id);
	});

	var delegate = function(client, row) {
		client.query('SELECT question_id FROM jos_answers_responses WHERE id = ' + (1*row.id), function(err, results) {
			if (err) {
				throw err;
			}
			hg.event.trigger('onUpdateAnswersQuestions', {'id': results[0].question_id});
		});
	};
	hg.event.observe('onUpdateAnswersResponses', delegate);
	hg.event.observe('onInsertAnswersResponses', delegate);

	hg.event.observe('onDeleteAnswersResponses', function(client, row) {
		hg.remove('answers', row.id);
	});

};
