module.exports = function(hg, done) {
	hg.event.observe('onKbLoaded', function(client) {
		var getSql = function(id) {
			return 'SELECT \'wishes\' AS domain, wli.id, wli.subject AS title, wli.about AS body, concat(\'/wishlist/\', wl.category, \'/\', wl.referenceid, \'/wish/\', wli.id) AS link, ' +
				'wli.proposed AS date, wl.title AS section, wli.proposed_by AS contributor_ids, wli.ranking, ' +
				'(SELECT group_concat(DISTINCT jto.tagid separator \'\\n\') FROM jos_tags_object jto INNER JOIN jos_tags jt ON jt.id = jto.tagid WHERE jto.tbl = \'wishlist\' AND jto.objectid = wli.id) AS tag_ids, ' +
//				'(' +
//					'(SELECT count(*) FROM jos_comments AS CC WHERE CC.referenceid=wli.id AND CC.state=0 AND CC.category=\'wish\') + ' +
//					'(SELECT count(*) FROM jos_comments AS CC JOIN jos_comments AS C2 ON C2.id=CC.referenceid AND C2.category=\'wish\' WHERE CC.state=0 AND CC.category=\'wishcomment\' AND C2.referenceid=wli.id) + ' +
//					'(SELECT count(*) FROM jos_comments AS CC JOIN jos_comments AS C2 ON C2.id=CC.referenceid AND C2.category=\'wishcomment\' JOIN jos_comments AS C3 ON C3.id=C2.referenceid AND C3.category=\'wish\' WHERE CC.state=0 AND CC.category=\'wishcomment\' AND C3.referenceid=wli.id)' +
//				') AS comment_count, ' + 
				'(SELECT SUM(amount) FROM jos_users_transactions WHERE referenceid = wli.id AND category = \'wish\' AND type=\'hold\') AS bounty, ' +
				'(SELECT COUNT(*) FROM jos_vote_log AS v WHERE v.helpful = \'yes\' AND v.category =\'wish\' AND v.referenceid = wli.id) AS positive, ' +
				'(SELECT COUNT(*) FROM jos_vote_log AS v WHERE v.helpful = \'no\' AND v.category = \'wish\' AND v.referenceid = wli.id) AS negative, ' +
				'(SELECT COUNT(*) FROM jos_wishlist_vote AS m WHERE m.wishid = wli.id) AS votes, ' +
				'(SELECT xp.name FROM jos_xprofiles AS xp WHERE xp.uidNumber = wli.granted_by ) AS granted_by, ' +
				'(SELECT xp.name FROM jos_xprofiles AS xp WHERE xp.uidNumber = wli.assigned ) AS assigned_to, ' +
				'(SELECT AVG(m.importance) FROM jos_wishlist_vote AS m WHERE m.wishid = wli.id) AS average_imp, ' +
				'(SELECT AVG(m.effort) FROM jos_wishlist_vote AS m WHERE m.wishid = wli.id AND m.effort != 6) AS average_effort, ' +
				'CASE ' +
					' WHEN status = 0 THEN CASE WHEN accepted THEN \'accepted\' ELSE \'new\' END ' +
					' WHEN granted THEN \'granted\' ' +
					' WHEN status = 3 THEN \'rejected\' ' +
				'END AS logical_type ' +
				'FROM jos_wishlist_item wli ' +
				'INNER JOIN jos_wishlist wl ON wl.id = wli.wishlist AND wl.public = 1 ' +
				'WHERE NOT wli.private AND (wli.status = 0 OR wli.status = 1 OR wli.status = 3)' + (id ? ' AND wli.id = ' + (1*id) : '');
		};
		var add = function(res) {
//			res.feedback = (res.positive + res.negative)/5 + res.comment_count;
			res.logical_type = res.granted_by ? 'granted' : 'pending';
			if (!res.bounty) {
				res.bounty = 0;
			}
			else {
				res.type = 'Bounties';
			}
			hg.addWithCommonConnections(res);
		};
		client.query(getSql(), function(err, results) {
			if (err) {
				throw err;
			}
			hg.log(results.length + ' wishes');
			results.forEach(add);
			done();
			hg.event.emit('onWishlistsLoaded', [client]);
		});

		hg.event.observe('onUpdateWishlistItem', function(client, row) {
			client.query(getSql(row.id), function(err, results) {
				if (err) {
					throw err;
				}
				if (results.length) {
					results.forEach(add);
				}
				else {
					hg.remove('wishes', row.id);
				}
			});
		});

		var updateWish = function(client, row) {
			client.query(getSql(row.id), function(err, results) {
				if (err) {
					throw err;
				}
				if (results.length) {
					results.forEach(add);
				}
				else {
					hg.remove('wishes', row.id);
				}
			});
		};

		hg.event.observe('onInsertWishlistItem', updateWish);

		hg.event.observe('onDeleteWishlistItem', function(client, row) {
			hg.remove('wishes', row.id);
		});

		// changes to wishlist_vote log the wish id, not the vote id. we just rebuild the wish when a vote happens (or unhappens)
		hg.event.observe('onUpdateWishlistVote', updateWish);
		hg.event.observe('onInsertWishlistVote', updateWish);
		hg.event.observe('onDeleteWishlistVote', updateWish);
	});
};
