module.exports = function(hg, done) {
	hg.event.observe('onContentLoaded', function(client) {
		var getSql = function(id) {
			var rv = [];
			['scope_id', 'group_id'].forEach(function(groupCol) {
				var sql = 'SELECT \'discussions\' AS domain, f.id, f.title, f.access, ' +
					'coalesce(f.comment, \'\') AS body, g.gidNumber AS group_ids, CASE WHEN f.parent > 0 THEN f.parent ELSE f.id END as thread, ' +
					'(CASE WHEN ' + (groupCol == 'scope_id' ? 'f.scope_id > 0 AND f.scope=\'group\'' : 'f.group_id > 0') + ' THEN ' +
						'concat(\'/groups/\', g.cn, \'/forum/\', CASE WHEN s.alias IS NOT NULL THEN concat(s.alias, \'/\') ELSE \'\' END, CASE WHEN c.alias IS NOT NULL THEN concat(c.alias, \'/\') ELSE \'\' END, CASE WHEN f.parent > 0 THEN f.parent ELSE f.id END) ' +
					'ELSE ' +
						'concat(\'/forum/\', coalesce(concat(s.alias, \'/\', coalesce(concat(c.alias, \'/\'), \'\'))), CASE WHEN f.parent > 0 THEN f.parent ELSE f.id END) ' +
					'END) AS link, f.created AS date, CASE WHEN c.alias = \'discussions\' THEN \'\' ELSE c.alias END AS section, f.parent AS parent_id, ' +
					'(SELECT CAST(group_concat(DISTINCT jto.tagid separator \'\\n\') AS CHAR) FROM jos_tags_object jto INNER JOIN jos_tags jt ON jt.id = jto.tagid WHERE jto.tbl = \'forum\' AND jto.objectid = f.id) AS tag_ids ' +
					'FROM jos_forum_posts f ' +
					'LEFT JOIN jos_forum_categories c ON c.id = f.category_id ' +
					'LEFT JOIN jos_forum_sections s ON s.id = c.section_id ' + 
					'LEFT JOIN jos_xgroups g ON g.gidNumber = f.' + groupCol + ' ' + 
					'WHERE f.state = 1 AND f.scope != \'course\'';
				rv.push(id ? sql + ' AND f.id = ' + (id*1) : sql);
			});
			return rv;
		};

		var query = function(client, cb, id) {
			getSql(id).forEach(function(sql) {
				client.query(sql, function(err, results) {
					if (err) {
						if (err.message.indexOf('ER_BAD_FIELD_ERROR') == -1) {
							console.log(err.message);
							throw err;
						}
						return;
					}
					cb(results);
				});
			});
		};

		query(client, function(results) {
			results.forEach(hg.addWithCommonConnections);
			done();
			hg.event.emit('onDiscussionsLoaded', [client]);
		});
	});
	
	hg.event.observe('onUpdateForumPosts', function(client, row) {
		query(client, function(results) {
			if (results.length) {
				results.forEach(hg.addWithCommonConnections);
			}
			else {
				hg.remove('discussions', row.id);
			}
		}, row.id);
	});

	hg.event.observe('onInsertForumPosts', function(client, row) {
		query(client, function(results) {
			results.forEach(hg.addWithCommonConnections);
		}, row.id);
	});

	hg.event.observe('onDeleteForumPosts', function(client, row) {
		hg.remove('discussions', row.id);
	});
};
