module.exports = function(hg, done) {
	var client;
	hg.event.observe('onStartUpdate', function() {
		if (hg.conf.hubgraph.seconds_per_update) {
			client.query('TRUNCATE TABLE hg_update_queue');
			setInterval(function() {
				client.query('SELECT * FROM hg_update_queue', function(err, results) {
					if (err) {
						throw err;
					}
					results.forEach(function(res) {
						if (res.notes) {
							res.notes = JSON.parse(res.notes);
						}
						hg.event.emit('on' + res.action[0] + res.action.substr(1).toLowerCase() + res.table_name[0].toUpperCase() + res.table_name.substr(1), [client, res]);
					});
					client.query('TRUNCATE TABLE hg_update_queue');
				});
			}, hg.conf.hubgraph.seconds_per_update*1000);
		}
	});
	hg.event.observe('onExtensionResourcesStarted', function(isResume) {
		hg.log('Connecting to MySQL...');
		var mysql = require('mysql');
		var opts = {
			'host': hg.conf.mysql.host ? hg.conf.mysql.host : 'localhost',
			'port': hg.conf.mysql.port ? hg.conf.mysql.port : 3306,
			'database': hg.conf.mysql.database,
			'user': hg.conf.mysql.user,
			'password': hg.conf.mysql.password
		};
		if (parseInt(opts.port) != opts.port) {
			opts.socketPath = opts.port;
			delete opts.host;
			delete opts.port;
		}
		var connect = function() {
			client = mysql.createConnection(opts);
			client.getColumnMap = function(table, cb) {
				this.query('SHOW CREATE TABLE ' + table, function(err, results) {
					if (err) {
						throw err;
					}
					if (!results[0]['Create Table']) {
						throw new Error('unable to get table definition for ' + table);
					}
					var lines = results[0]['Create Table'].split('\n');
					lines.shift();
					var rv = {};
					for (var len = lines.length - 1; len >= 0; --len) {
						var ma;
						if (!(ma = lines[len].match(/^\s*`(.*?)`/))) {
							continue;
						}
						rv[ma[1]] = true;
					}
					cb(rv);
				});
			};

  		  	client.connect();
			client.on('error', function(err) {
				if (err.code !== 'PROTOCOL_CONNECTION_LOST') {
					throw err;
				}
	
				hg.log('reconnecting mysql');
				hg.save(hg.conf.hubgraph.root);
				connect();
				hg.event.emit('onMysqlReconnect', [client]);
			});
		};
		connect();
		done();
		hg.event.emit('onMysqlConnect', [client]);
		hg.event.observe('onStop', function() {
			client.end();
		});
	});

	hg.stripslashes = function(str) {
		if (str == null) {
			return null;
		}
		return str.replace(/\\+/g, '\\').replace(/(?:\\(.))+/g, '$1');
	};
	hg.cleanupBody = function(str) {
		if (str == null) {
			return '';
		}
		return hg.stripslashes(str)
			.replace(/(\\r|\\n)/g, '')
			.replace(/\[\[Resource\(([^)]+)\)\]\]/gi, ' $1 ')
			.replace(/=|\[\[Image.*?\]\]/gi, ' ')
			.replace(/\[BR\]/gi, ' ')
			.replace(/\[+(.*?)\]+/g, ' $1 ')
			.replace(/\{+(.*?)\}+/g, ' $1 ')
			.replace(/\{\{\{\s*#!html(.*?)\}\}\}/g, ' $1 ')
			.replace(/(?:(?:<.*?(?:>|$))|(?:{.*?(?:}|$))|[\ \r\n\t]+)/g, ' ')
			.replace(/[\\\[\]\{\}]+/g, '')
			.replace(/<.*?>/g, '')
			.replace(/&nbsp;/g, ' ')
			.replace(/\s+/g, ' ')
			;
	};
	var cats = {};
	var aliases = {};
	var years = {};
	hg.add({'domain': 'meta', 'id': 'domains'});
	hg.add({'domain': 'domains', 'id': 'aliases'});
	hg.addWithCommonConnections = function(res) {
		if (res.title) {
			res.title = hg.cleanupBody(res.title);
		}
		if (res.body) {
			res.body = hg.cleanupBody(res.body);
		}
		if (res.link) {
			res.link = res.link.toString() + ''; // bug in some node-mysql versions returns concat(...) fields as a Buffer, need to stringify
			if (res.link.indexOf("\n") != -1) {
				res.link = res.link.split(/[\r\n]+/);
			}
		}
		var idKey = /_ids$/;
		for (var k in res) {
			if (idKey.test(k)) {
				res[k] = hg.split(res[k]);
			}
		}
		hg.add(res);
		var domain = res.domain;
		if (!cats[domain]) {
			hg.add({'domain': 'domains', 'id': domain, 'title': domain});
			hg.connect('domain', 'meta', 'domains', 'domains', domain);
			cats[domain] = true;
		}
		hg.connect('domain', 'domains', domain, domain, res.id);
		if (res.alias) {
			if (!aliases[res.alias]) {
				hg.add({'domain': 'aliases', 'id': res.alias});
				aliases[res.alias] = true;
			}
			hg.connect('alias', 'aliases', res.alias, domain, res.id);
		}
		['category', 'section', 'type', 'logical_type'].forEach(function(cat) {
			if (!res[cat]) {
				return;
			}
			var val = res[cat];
			if (!cats[domain + '~' + val]) {
				hg.add({'domain': 'domains', 'id': domain + '~' + val, 'title': domain + ' ' + val});
				hg.connect('domain', 'meta', 'domains', 'domains', domain + '~' + val);
				hg.connect('subdomain', 'domains', domain, 'domains', domain + '~' + val); 
				cats[domain + '~' + val] = true;
			}
			hg.connect('domain', 'domains', domain + '~' + val, domain, res.id);
			if (cat == 'type' && res.publication_title) {
				var dm = domain + '~' + val + '~' + res.publication_title;
				if (!cats[dm]) {
					hg.add({'domain': 'domains', 'id': dm, 'title': dm});
					hg.connect('domain', 'meta', 'domains', 'domains', dm);
					hg.connect('subdomain', 'domains', domain, 'domains', dm); 
					cats[domain + '~' + val] = true;
				}
				hg.connect('domain', 'domains', dm, domain, res.id);
			}
		});

		if (res.contributor_ids) {
			res.contributor_ids.forEach(function(cid) {
				hg.connect('alias', 'aliases', 'user:' + cid, domain, res.id);
			});
		}
		if (res.group_ids) {
			res.group_ids.forEach(function(gid) {
				hg.connect('alias', 'aliases', 'group:' + gid, domain, res.id);
			});
		}

		if (res.tag_ids) {
			res.tag_ids.forEach(function(tid) {
				hg.connect('alias', 'aliases', 'tag:' + tid, domain, res.id);
			});
		}

		if (res.parent_ids) {
			res.parent_ids.forEach(function(pid) {
				hg.connect('parent', domain, pid, domain, res.id);
			});
		}

		if (res.date) {
			var yr = (new Date(res.date)).getFullYear();
			if (!years[yr]) {
				hg.add({'domain': 'years', 'id': yr});
				years[yr] = true;
			}
			hg.connect('timeframe', 'years', yr, domain, res.id);
		}
	};
};
