module.exports = function(hg, done) {
	var cols = {};

	var getSql = function(id) {
		var sql = 'SELECT \'blogs\' AS domain, e.id, e.title, e.content AS body, e.created_by AS contributor_ids, state, ' +
			'CASE WHEN state = 1 THEN 0 WHEN state = 2 THEN 2 ELSE NULL END AS access, ' +
			'\'blogs\' AS standalone_domain, e.id AS \'standalone_id\', ' +
			'CAST(CONCAT(\'/members/\', e.created_by, \'/blog/\', YEAR(e.publish_up), \'/\', LPAD(MONTH(e.publish_up), 2, \'0\'), \'/\', alias)  AS CHAR) AS link, ' +
			'(SELECT group_concat(DISTINCT jto.tagid separator \'\\n\') FROM jos_tags_object jto INNER JOIN jos_tags jt ON jt.id = jto.tagid WHERE jto.tbl = \'blog\' AND jto.objectid = e.id) AS tag_ids ' +
			'FROM jos_blog_entries e ' +
			'INNER JOIN jos_xprofiles xp ON xp.uidNumber = e.created_by AND xp.public ' +
			'WHERE publish_up <= UTC_TIMESTAMP() AND state != -1';

		return id ? sql + ' AND e.id = ' + (id * 1) : sql;
	};

	var getComments = function(client, cb, id) {
		if (!cols.comments) {
			client.getColumnMap('jos_blog_comments', function(c) {
				cols.comments = c;
				getComments(client, cb, id);
			});
			return;
		}
		client.query(getCommentSql(id), cb);
	};
	var getCommentSql = function(id) {
		var sql = 'SELECT \'blog comments\' AS domain, c.id, c.content AS body, c.created_by AS contributor_ids, ' +
			'\'blogs\' AS standalone_domain, entry_id AS standalone_id, e.state, ' +
			'CASE WHEN e.state = 1 THEN 0 WHEN e.state = 2 THEN 2 ELSE NULL END AS access, ' +
			'CAST(CONCAT(\'/members/\', e.created_by, \'/blog/\', YEAR(e.publish_up), \'/\', LPAD(MONTH(e.publish_up), 2, \'0\'), \'/\', alias)  AS CHAR) AS link ' +
			'FROM jos_blog_comments c ' +
			'INNER JOIN jos_blog_entries e ON e.id = c.entry_id AND e.state != -1 ' +
			'INNER JOIN jos_xprofiles xp ON xp.uidNumber = e.created_by AND xp.public ' +
			'WHERE ' + (cols.comments.state ? 'c.state != -1' : '1');
		return id ? sql + ' AND c.id = ' + (id * 1) : sql;
	};

	var blogAdd = function(res) {
		if (res.state == 0) {
			res.owner_only = res.contributor_ids;
		}
		hg.addWithCommonConnections(res);
	};

	hg.event.observe('onResourcesLoaded', function(client) {
		var sql = getSql();

		client.query(sql, function(err, results) {
			if (err) {
				throw err;
			}
			hg.log(results.length + ' blogs');
			results.forEach(blogAdd);

			getComments(client, function(err, results) {
				if (err) {
					throw err;
				}
				hg.log(results.length + ' blog comments');
				results.forEach(blogAdd);
				done();
				hg.event.emit('onBlogsLoaded', [client]);
			});
		});
	});

	hg.event.observe('onUpdateBlogEntries', function(client, row) {
		var sql = getSql(row.id);
		client.query(sql, function(err, results) {
			if (err) {
				throw err;
			}
			if (!results.length) {
				hg.remove('blogs', row.id);
			}
			else {
				results.forEach(hg.addWithCommonConnections);
			}
		});
	});

	hg.event.observe('onInsertBlogEntries', function(client, row) {
		var sql = getSql(row.id);
		client.query(sql, function(err, results) {
			if (err) {
				throw err;
			}
			results.forEach(hg.addWithCommonConnections);
		});
	});

	hg.event.observe('onDeleteBlogEntries', function(client, row) {
		hg.remove('blogs', row.id);
	});
};

