module.exports = function(hg, done) {
	hg.event.observe('onContentLoaded', function(client) {
		var getSql = function(id) {
			var sql = 'SELECT \'knowledge base articles\' AS domain, f.title, created AS date, f.id, c.title AS logical_type, s.title AS type, ' +
				'CAST(concat(coalesce(f.params, \'\'), coalesce(f.`fulltxt`, \'\')) AS CHAR) AS body, ' +
				'CAST(concat(\'/kb/\', coalesce(concat(s.alias, \'/\'), \'\'), f.alias) AS CHAR) AS link ' +
				'FROM jos_faq f ' +
				'LEFT JOIN jos_faq_categories s ON s.id = f.section ' +
				'LEFT JOIN jos_faq_categories c ON c.id = f.category ' +
				'WHERE f.state = 1';
			return id ? sql + ' AND f.id = ' + (1*id) : sql;
		};
		var sql = getSql();
		hg.log(sql);
		client.query(sql, function(err, results) {
			if (err) {
				throw err;
			}
			hg.log(results.length + ' kb articles');
			results.forEach(hg.addWithCommonConnections);
			done();
			hg.event.emit('onKbLoaded', [client]);
		});

		hg.event.observe('onUpdateFaq', function(client, row) {
			var sql = getSql(row.id);
			client.query(sql, function(err, results) {
				if (err) {
					throw err;
				}
				if (!results.length) {
					hg.remove('knowledge base articles', row.id);
				}
				else {
					results.forEach(hg.addWithCommonConnections);
				}
			});
		});

		hg.event.observe('onInsertFaq', function(client, row) {
			var sql = getSql(row.id);
			client.query(sql, function(err, results) {
				if (err) {
					throw err;
				}
				results.forEach(hg.addWithCommonConnections);
			});
		});

		hg.event.observe('onDeleteFaq', function(client, row) {
			hg.remove('knowledge base articles', row.id);
		});
	});
};
