module.exports = function(hg, done) {
	var getSql = function(id) {
		return [
			'SELECT \'publications\' AS domain, p.id, v.title, CONCAT(v.abstract, v.description) AS body, ',
			'CONCAT(\'index.php?option=com_publication&id=\', CASE WHEN p.alias = \'\' THEN p.id ELSE p.alias END) AS link, ',
			'v.published_up AS date, c.name AS type, p.access, p.group_owner AS group_ids, ',
			'(SELECT GROUP_CONCAT(a.user_id ORDER BY a.ordering separator \'\\n\') FROM jos_publication_authors a WHERE a.publication_version_id = v.id AND a.status=1) AS contributor_ids',
			'FROM jos_publications p ',
			'INNER JOIN jos_publication_versions v ON v.id = (SELECT MAX(id) FROM jos_publication_versions WHERE publication_id = p.id AND state = 1 AND (published_up AND NOW() > published_up) AND (NOT published_down OR NOW() < published_down)) ',
			'LEFT JOIN jos_publication_categories c ON c.id = p.category',
			(id ? 'WHERE p.id = ' + id : '')
		].join("\n");
	};
	hg.event.observe('onContentLoaded', function(client) {
		client.query(getSql(), function(err, results) {
			if (err) {
				throw err;
			}
			hg.log(results.length + ' publications');
			results.forEach(hg.addWithCommonConnections);
		});
		done();
		hg.event.emit('onPublicationsLoaded', [client]);
	});
};
