module.exports = function(hg, done) {
	hg.event.observe('onTagsLoaded', function(client) {
		var getSql = function(id) {
			return 'SELECT ' +
				'params, CASE WHEN xp.public THEN registerDate ELSE NULL END AS date, \'members\' AS domain, xp.uidNumber AS id, ' +
				'CASE WHEN xp.public THEN xp.organization ELSE NULL END AS organization, xp.public, ' +
				'CASE WHEN xp.picture IS NOT NULL AND xp.picture != \'\' AND xp.public THEN CAST(concat(\'/site/members/\', CASE WHEN xp.uidNumber < 0 THEN \'n\' ELSE \'\' END, lpad(ABS(xp.uidNumber), 5, \'0\'), \'/\', xp.picture) AS CHAR) ELSE NULL END AS img_href, ' +
				'CASE WHEN xp.public THEN concat(\'/members/\', CASE WHEN xp.uidNumber < 0 THEN concat(\'n\', xp.uidNumber * -1) ELSE xp.uidNumber END) ELSE NULL END AS link, ' +
				'CASE WHEN xp.name = \'\' OR xp.name IS NULL THEN concat(coalesce(givenName, \'\'), coalesce(concat(\' \', middleName, \' \'), \' \'), coalesce(surname, \' \')) ELSE xp.name END AS title, ' +
				'(SELECT CAST(group_concat(DISTINCT jto.tagid separator \'\\n\') AS CHAR) FROM jos_tags_object jto INNER JOIN jos_tags jt ON jt.id = jto.tagid WHERE jto.tbl = \'xprofiles\' AND jto.objectid = xp.uidNumber) AS tag_ids ' +
			'FROM jos_xprofiles xp ' +
			'LEFT JOIN jos_xprofiles_bio xpb ON xpb.uidNumber = xp.uidNumber ' +
			(id ? ' WHERE xp.uidNumber = ' + (1*id) : '')
		};

		var orgs = {};
		var add = function(res, idx) {
			res.access = {};
			res.params.split(',').forEach(function(param) {
				var ma = param.match(/access_([^:=]+)[:=](.+)/);
				if (ma) {
					res.access[ma[1].replace(/[^a-z]/g, '')] = ma[2].replace(/[^\d]/g, '')*1;
				}
			});
			if (res.access.tags !== undefined && res.access.tags !== 0) {
				res.tag_ids = '';
			}

			res.organization = hg.stripslashes(res.organization);
			hg.addWithCommonConnections(res);
			if (!orgs[res.organization]) {
				hg.add({'title': res.organization, 'id': 'org:' + res.organization, 'domain': 'aliases'});
				orgs[res.organization] = true;
			}
			hg.add({'domain': 'aliases', 'id': 'user:' + res.id, 'title': res.title});
			hg.connect('alias', 'aliases', 'org:' + res.organization, 'members', res.id);
		};

		client.query(getSql(), function(err, results) {
			if (err) {
				throw err;
			}

			hg.add({'domain': 'domains', 'id': 'members'});
			hg.log(results.length + ' users');
			results.forEach(add);
			client.query('SELECT DISTINCT \'aliases\' AS domain, CAST(CONCAT(\'user:\', authorid) AS CHAR) AS id, name AS title FROM jos_author_assoc WHERE authorid NOT IN (SELECT id FROM jos_users)', function(err, results) {
				if (err) {
					throw err;
				}
				hg.log(results.length + ' virtual users');
				results.forEach(hg.addWithCommonConnections);
				done();
				hg.event.emit('onUsersLoaded', [client]);
			});
		});

		hg.event.observe('onUpdateXprofiles', function(client, row) {
			client.query(getSql(row.id), function(err, results) {
				if (err) {
					throw err;
				}
				if (results.length) {
					results.forEach(add);
				}
				else {
					hg.remove('members', row.id);
				}
			});
		});

		hg.event.observe('onInsertXprofiles', function(client, row) {
			client.query(getSql(row.id), function(err, results) {
				if (err) {
					throw err;
				}
				if (results.length) {
					results.forEach(add);
				}
				else {
					hg.remove('members', row.id);
				}
			});
		});

		hg.event.observe('onDeleteXprofiles', function(client, row) {
			hg.remove('members', row.id);
		});
	});
};
