module.exports = function(hg, done) {
	var getSql = function(id) {
		var sql = [
			'SELECT DISTINCT \'resources\' AS domain, r.id, CAST(concat(\'/resources/\', coalesce(CASE WHEN r.alias = \'\' THEN NULL ELSE r.alias END, r.id)) AS CHAR) AS link, r.alias AS alias, ',
			'r.title AS title, ',
			'substring_index(path, \'/\', -1) AS filename, hits, ',
			'coalesce(CASE WHEN dtd.body = \'\' THEN NULL ELSE dtd.body END, CASE WHEN r.`fulltxt` = \'\' THEN NULL ELSE r.`fulltxt` END, introtext, \'\') AS body, r.standalone, r.access, ',
			'tp.type AS type, ltp.type AS logical_type, r.publish_up AS date, ',
			'(SELECT CAST(concat(CASE WHEN rta.level0 THEN \'0\' ELSE \'\' END, CASE WHEN rta.level1 THEN \'1\' ELSE \'\' END, CASE WHEN rta.level2 THEN \'2\' ELSE \'\' END, CASE WHEN rta.level3 THEN \'3\' ELSE \'\' END, CASE WHEN rta.level4 THEN \'4\' ELSE \'\' END, CASE WHEN rta.level5 THEN \'5\' ELSE \'\' END) AS CHAR) FROM jos_resource_taxonomy_audience rta WHERE rta.rid = r.id LIMIT 1) AS levels, ' +
			'(SELECT gidNumber FROM jos_xgroups WHERE cn = group_owner) AS group_ids,',
			'(SELECT CAST(group_concat(parent_id order by ordering separator \'\\n\') AS CHAR) FROM jos_resource_assoc ra WHERE ra.child_id = r.id) AS parent_ids,',
			'(SELECT CAST(group_concat(child_id order by ordering separator \'\\n\') AS CHAR) FROM jos_resource_assoc ra WHERE ra.parent_id = r.id) AS child_ids,',
			'(SELECT CAST(group_concat(aa.authorid ORDER BY ordering SEPARATOR \'\\n\') AS CHAR) FROM jos_author_assoc aa WHERE aa.subtable = \'resources\' AND aa.subid = r.id AND aa.role != \'submitter\') AS contributor_ids, ',
			'(SELECT CAST(group_concat(DISTINCT jto.tagid separator \'\\n\') AS CHAR) FROM jos_tags_object jto INNER JOIN jos_tags jt ON jt.id = jto.tagid WHERE jto.tbl = \'resources\' AND jto.objectid = r.id) AS tag_ids ',
			'FROM jos_resources r',
			'LEFT JOIN jos_document_resource_rel drr ON drr.resource_id = r.id', 
			'LEFT JOIN jos_document_text_data dtd ON dtd.id = drr.document_id',
			'LEFT JOIN jos_resource_types tp ON tp.id = r.type',
			'LEFT JOIN jos_resource_types ltp ON ltp.id = r.logical_type',
			'LEFT JOIN jos_tool jt ON jt.toolname = r.alias',
			'WHERE r.published = 1 AND (jt.state IS NULL OR jt.state != 8) AND ',
			'	NOW() > r.publish_up AND (NOT r.publish_down OR NOW() < r.publish_down) AND',
			'	(r.standalone OR r.logical_type)'
		];
		if (id) {
			sql.push('AND r.id = ' + (id * 1));
		}
		return sql.join("\n");
	};
	var clean = function(res) {
		res.parent_ids = hg.split(res.parent_ids);
		res.child_ids = hg.split(res.child_ids);
		res.contributor_ids = hg.split(res.contributor_ids);
		res.group_ids = hg.split(res.group_ids);
		res.tag_ids = hg.split(res.tag_ids);
		var level_map = {};
		(res.levels ? res.levels.match(/\d/g) : []).forEach(function(lvl) {
			level_map[lvl*1] = 1;
		});
		res.levels = level_map;
		res.standalone = res.standalone == 1;
		if (!res.standalone) {
			res.link = '/resources/' + res.parent_ids[0] + '/play?resid=' + res.id;
		}
		res.body = hg.cleanupBody(res.body);
		res.title = hg.stripslashes(res.title);

		return res;
	};
	var resources = {};
	var added = {};
	var add = function(resource) {
//			if (added.hasOwnProperty(resource.id)) {
//				return;
//			}
			added[resource.id] = true;
			hg.addWithCommonConnections(resource);
			if (resource.alias) {
				hg.add({'domain': 'aliases', 'id': resource.alias, 'title': resource.alias});
				hg.connect('alias', 'aliases', resource.alias, 'resources', resource.id, 50);
			}
		};
	var addNew = function(id) {
		var res = resources[id];
		if (res.standalone) {
			resources[res.id].standalone_id = res.id;
			add(res);
			hg.connect('standalone', 'resources', res.id, 'resources', res.id);
		}
		else {
			var found_parent = false;
			for (var idx = 0; idx < res.parent_ids.length; ++idx) {
				if (resources[res.parent_ids[idx]]) {
					if (resources[res.parent_ids[idx]].standalone) {
						found_parent = true;
						resources[res.id].standalone_id = res.parent_ids[idx];
						add(res);
						add(resources[res.parent_ids[idx]]);
						hg.connect('standalone', 'resources', res.id, 'resources', res.parent_ids[idx]);
						break;
					}
					resources[res.parent_ids[idx]].parent_ids.forEach(function(sid) {
						res.parent_ids.push(sid);
					});
				}
			}
		}	
	};	
	hg.event.observe('onUpdateResources', function(client, row) {
		var sql = getSql(row.id);
		client.query(sql, function(err, results) {
			if (err) {
				throw err;
			}
			if (!results.length) {
				hg.remove('resources', row.id);
			}
			else {
				results.forEach(function(res) {
					resources[res.id] = clean(res);
					addNew(res.id);
				});
			}
		});
	});

	hg.event.observe('onInsertResources', function(client, row) {
		var sql = getSql(row.id);
		client.query(sql, function(err, results) {
			if (err) {
				throw err;
			}
			results.forEach(function(res) {
				resources[res.id] = clean(res);
				addNew(res.id);
			});
		});
	});

	hg.event.observe('onDeleteResources', function(client, row) {
		hg.remove('resources', row.id);
	});
/*	
	hg.event.observe('onUpdateTick', function(client) {
		client.query(sql, function(err, results) {
			if (err) {
				throw err;
			}
			var resources = {};
			results.forEach(function(res) {
				resources[res.id] = clean(res);
			});

			for (var id in resources) {
				if (added.hasOwnProperty(id)) {
					hg.add(resources[id]);
				}
				else {
					addNew(resources, id);
				}
			}
			for (var id in added) {
				if (!resources[id]) {
					hg.remove('resources', id);
					delete(added[id]);
				}
			}
		});
	}); */

	hg.event.observe('onGroupsLoaded', function(client) {
		var sql = getSql();
		
		client.query(sql, function(err, results) {
			if (err) {
				throw err;
			}
			hg.log(results.length + ' resources');
			results.forEach(function(res) {
				resources[res.id] = clean(res);
			});
			for (var id in resources) {
				addNew(id);
			}
//			hg.select('domains', 'resources').out('subdomain').use().items.forEach(function(item) {
//				item.count = hg.select('domains', item.id).out('domain').items.length;
//				hg.add(item);
//			});
			done();
			hg.event.emit('onResourcesLoaded', [client]);
		});
	});
};
