module.exports = function(hg) {
var weights = {
	'titleTitle' : 1,    // words shared by both titles 
	'titleBody'  : 0.1,  // words that match between the title of one vertex and the body of another
	'bodyBody'   : 0.01, // words shared by both bodies
	'alias'      : 0.5   // various links, like tags, contributors, publication, etc. this weight is further influenced by the edges' weights which vary by type
};
hg.views.related = function(args) {
	// pick out center vertex
	var origin = hg.select(args.domain, args.id).use();
	// bail if it's not found or is invisible
	if (!origin.items[0] || !hg.views.filterVisible(origin.items[0], args)) {
		return;
	}

	var
		// pools of text vertices linked by the resource
		words = {
			'title': origin.in('title-word'),
			'body' : origin.in('body-word')
		},
		// things we might want to consider for relatedness
		matches = {
			'titleTitle': words.title.out('title-word'), 
			'titleBody' : words.title.out('body-word').union(words.body.out('title-word')),
			'bodyBody'  : words.body.out('body-word'),
			'alias'     : origin.in('alias') 
		}
		;
	// apply weights
	for (var k in matches) {
		matches[k].scaleWeights(weights[k]);
	}

	// glue together components
	return matches.titleTitle
		.union(matches.titleBody)
		.union(matches.bodyBody)
		.union(matches.alias)
		// lookup attributes (until use()d, selections are only domain, id pairs. we 
		// need the rest of the columns to apply permissions and format results)
		.use()
		.filter(function(item) {
			// not the supplied resource (presumably the user is aware the resource is 
			// closely related to itself) and also not something the user isn't allowed
			// to see
			return (item.domain != args.domain || item.id != args.id) && hg.views.filterVisible(item, args);
		})
		// selections are naturally sorted descending by weight, so we can 
		// just grab the top N
		.limit(args.limit || 10)
		// not required, but for debugging I rescale the accumulated weights so that
		// the best result is 1.0 and the others are 0-1.0
		.normalizeWeights()
		// escape the hubgraph selection object and just reference the array of 
		// results
		.items
			// only need to return a small subset of info about the results
			.map(function(item) {
				return [item.domain, item.link, item.title, item.weight];
			})
		;
}
};
