# @package      hubzero-mailgateway
# @file         rpm.mk
# @author       David Benham <dbenham@purdue.edu>
# @copyright    Copyright (c) 2010-2014 HUBzero Foundation, LLC.
# @license      http://www.gnu.org/licenses/lgpl-3.0.html LGPLv3
#
# Copyright (c) 2010-2014 HUBzero Foundation, LLC.
#
# This file is part of: The HUBzero(R) Platform for Scientific Collaboration
#
# The HUBzero(R) Platform for Scientific Collaboration (HUBzero) is free
# software: you can redistribute it and/or modify it under the terms of
# the GNU Lesser General Public License as published by the Free Software
# Foundation, either version 3 of the License, or (at your option) any
# later version.
#
# HUBzero is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
# HUBzero is a registered trademark of HUBzero Foundation, LLC.
#

USRLIB=$(DESTDIR)/usr/lib
ETC=$(DESTDIR)/etc

all:
	@true

install:
	install --mode 0755 -D python/mailproc.py $(USRLIB)/hubzero/bin/mailproc/mailproc.py
	install --mode 0755 -D python/processgroupforumpost.py $(USRLIB)/hubzero/bin/mailproc/processgroupforumpost.py
	install --mode 0755 -D python/processsupportemail.py $(USRLIB)/hubzero/bin/mailproc/processsupportemail.py
	install --mode 0755 -D python/processticketcomment.py $(USRLIB)/hubzero/bin/mailproc/processticketcomment.py
	install --mode 0755 -D python/filecopy.py $(USRLIB)/hubzero/bin/mailproc/filecopy.py
	install --mode 0755 -D python/process_emailbounces.py $(USRLIB)/hubzero/bin/mailproc/process_emailbounces.py
	install --mode 0755 -D hubzero-mailgateway.logrotate.rpm $(ETC)/logrotate.d/hubmailgateway

collectfiles:
	cp /usr/lib/hubzero/bin/mailproc/mailproc.py python/mailproc.py
	cp /usr/lib/hubzero/bin/mailproc/processgroupforumpost.py python/processgroupforumpost.py
	cp /usr/lib/hubzero/bin/mailproc/processsupportemail.py python/processsupportemail.py
	cp /usr/lib/hubzero/bin/mailproc/processticketcomment.py python/processticketcomment.py
	cp /usr/lib/hubzero/bin/mailproc/filecopy.py python/filecopy.py
	cp /etc/logrotate.d/hubmailgateway ./hubzero-mailgateway.logrotate.rpm

uninstall:
	@true

postinst:
	install --mode 0744 --owner root --group root -D hubmailgateway /etc/logrotate.d/hubmailgateway

clean:
	@true

.PHONY: all install uninstall postinst clean
