#!/bin/sh
#
# @package      hubzero-mw-service
# @file         make_xvnc_cert.sh
# @author       Nicholas J. Kisseberth <nkissebe@purdue.edu>
# @copyright    Copyright (c) 2010-2011 Purdue University. All rights reserved.
# @license      http://www.gnu.org/licenses/lgpl-3.0.html LGPLv3
#
# Copyright (c) 2010-2011 Purdue University
# All rights reserved.
#
# This file is part of: The HUBzero(R) Platform for Scientific Collaboration
#
# The HUBzero(R) Platform for Scientific Collaboration (HUBzero) is free
# software: you can redistribute it and/or modify it under the terms of
# the GNU Lesser General Public License as published by the Free Software
# Foundation, either version 3 of the License, or (at your option) any
# later version.
#
# HUBzero is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
# HUBzero is a registered trademark of Purdue University.
#

PEMFILE="/etc/hubzero/xvnc.pem"

# Generate new certs if needed
if [ -e $PEMFILE ]; then
  echo "You already have an SSL pem file for xvnc; not replacing"
else
  echo "Creating generic self-signed certificate: $PEMFILE"
  echo "(replace with hand-crafted or authorized one if needed)."
  cd /etc/mw
  PATH=$PATH:/usr/bin/ssl
  FQDN=`hostname -f`
  MAILNAME=`cat /etc/mailname 2> /dev/null || hostname -f`
  (openssl req -new -x509 -days 365 -nodes -out $PEMFILE.cert -keyout $PEMFILE.key  > /dev/null 2>&1 <<+
.
.
.
HUBzero Middleware
$FQDN
$FQDN
root@$MAILNAME
+
  ) || echo "Warning : Bad SSL config, can't generate certificate."
  cat $PEMFILE.cert $PEMFILE.key > $PEMFILE
  rm $PEMFILE.cert $PEMFILE.key

  if [ -e $PEMFILE ]; then
    chown root $PEMFILE || true
    chgrp root $PEMFILE || true
    chmod 0600 $PEMFILE || true
  fi
fi
