/**
 * @package		HUBzero
 * @author		Rick Kennell <kennell@purdue.edu>
 * @copyright	Copyright 2005-2009 by Purdue Research Foundation, West Lafayette, IN 47906
 * @license		http://www.gnu.org/licenses/gpl-2.0.html GPLv2
 *
 * Copyright 2005-2009 by Purdue Research Foundation, West Lafayette, IN 47906.
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License,
 * version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

//
// VNC server utility to tell clients to perform an action
//

#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <sys/time.h>
#include <sys/types.h>
#include <unistd.h>
#include <errno.h>
#include <malloc.h>

#include <signal.h>
#include <X11/X.h>
#include <X11/Xlib.h>
#include <X11/Xatom.h>
#include <X11/Xutil.h>
#include <X11/keysym.h>
#include "vncExt.h"

char* programName = 0;
Display* dpy;
int vncExtEventBase, vncExtErrorBase;

int main(int argc, char** argv)
{
  programName = argv[0];

  if (argc < 2) {
    fprintf(stderr,"syntax: %s action to send\n", programName);
    exit(1);
  }

  char *display = getenv("DISPLAY");
  if (display == NULL) {
    fprintf(stderr,"%s: No DISPLAY variable set", programName);
    exit(1);
  }

  if (!(dpy = XOpenDisplay(display))) {
    fprintf(stderr,"%s: unable to open display \"%s\"\n",
            programName, display);
    exit(1);
  }

  if (!XVncExtQueryExtension(dpy, &vncExtEventBase, &vncExtErrorBase)) {
    fprintf(stderr,"No VNC extension on display %s\n", display);
    exit(1);
  }

  // Determine the string length.
  int len=0;
  int i;
  for(i=1; i<argc; i++) {
    if (i > 1)
      len += 1;  // arguments are separated by space
    len += strlen(argv[i]);
  }

  char *str = calloc(1, len + 1);
  for(i=1; i<argc; i++) {
    if (i > 1)
      strcat(str," ");
    strcat(str,argv[i]);
  }

  if (!XVncExtClientAction(dpy, str, len)) {
    fprintf(stderr,"%s: failed\n", programName);
    exit(1);
  }

  XCloseDisplay(dpy);

  return 0;
}

