/**
 * @package      hubzero-mw-session
 * @file         clientaction/clientaction.c
 * @author       Rick Kennell <kennell@purdue.edu>
 * @copyright    Copyright (c) 2005-2014 HUBzero Foundation, LLC.
 * @license      http://www.gnu.org/licenses/lgpl-3.0.html LGPLv3
 *
 * Copyright (c) 2005-2014 HUBzero Foundation, LLC.
 *
 * This file is part of: The HUBzero(R) Platform for Scientific Collaboration
 *
 * The HUBzero(R) Platform for Scientific Collaboration (HUBzero) is free
 * software: you can redistribute it and/or modify it under the terms of
 * the GNU Lesser General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any
 * later version.
 *
 * HUBzero is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * HUBzero is a registered trademark of HUBzero Foundation, LLC.
 *
 */

//
// VNC server utility to tell clients to perform an action
//

#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <sys/time.h>
#include <sys/types.h>
#include <unistd.h>
#include <errno.h>
#include <malloc.h>

#include <signal.h>
#include <X11/X.h>
#include <X11/Xlib.h>
#include <X11/Xatom.h>
#include <X11/Xutil.h>
#include <X11/keysym.h>
#include "vncExt.h"

char* programName = 0;
Display* dpy;
int vncExtEventBase, vncExtErrorBase;

int main(int argc, char** argv)
{
  programName = argv[0];

  if (argc < 2) {
    fprintf(stderr,"syntax: %s action to send\n", programName);
    exit(1);
  }

  char *display = getenv("DISPLAY");
  if (display == NULL) {
    fprintf(stderr,"%s: No DISPLAY variable set", programName);
    exit(1);
  }

  if (!(dpy = XOpenDisplay(display))) {
    fprintf(stderr,"%s: unable to open display \"%s\"\n",
            programName, display);
    exit(1);
  }

  if (!XVncExtQueryExtension(dpy, &vncExtEventBase, &vncExtErrorBase)) {
    fprintf(stderr,"No VNC extension on display %s\n", display);
    exit(1);
  }

  // Determine the string length.
  int len=0;
  int i;
  for(i=1; i<argc; i++) {
    if (i > 1)
      len += 1;  // arguments are separated by space
    len += strlen(argv[i]);
  }

  char *str = calloc(1, len + 1);
  for(i=1; i<argc; i++) {
    if (i > 1)
      strcat(str," ");
    strcat(str,argv[i]);
  }

  if (!XVncExtClientAction(dpy, str, len)) {
    fprintf(stderr,"%s: failed\n", programName);
    exit(1);
  }

  XCloseDisplay(dpy);

  return 0;
}
