#!/bin/sh
# @package      hubzero-mw2-exec-service
# @file         make_xvnv_cert.sh
# @copyright    Copyright (c) 2016-2020 The Regents of the University of California.
# @license      http://opensource.org/licenses/MIT MIT
#
# Copyright (c) 2016-2020 The Regents of the University of California.
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.
#
# HUBzero is a registered trademark of The Regents of the University of California.
#

PEMFILE="/etc/mw-service/xvnc.pem"

# Generate self-signed XVNC certificate used by stunnel, if needed
# stunnel: provide SSL service and proxy service between web server 
# and execution host's X11 server running inside a container with a private IP
if [ -e $PEMFILE ]; then
  echo "You already have an SSL pem file for xvnc; not replacing"
else
  echo "Creating generic self-signed certificate: $PEMFILE"
  echo "(replace with hand-crafted or authorized one if needed)."
  cd /etc/mw-service
  PATH=$PATH:/usr/bin/ssl
  FQDN=`hostname -f`
  MAILNAME=`cat /etc/mailname 2> /dev/null || hostname -f`
  (openssl req -new -x509 -days 365 -nodes -out $PEMFILE.cert -keyout $PEMFILE.key  > /dev/null 2>&1 <<+
.
.
.
HUBzero Middleware
$FQDN
$FQDN
root@$MAILNAME
+
  ) || echo "Warning : Bad SSL config, can't generate certificate."
  cat $PEMFILE.cert $PEMFILE.key > $PEMFILE
  rm $PEMFILE.cert $PEMFILE.key

  if [ -e $PEMFILE ]; then
    chown root $PEMFILE || true
    chgrp root $PEMFILE || true
    chmod 0600 $PEMFILE || true
  fi
fi
