/**
 * @file       globals.h
 * @copyright  Copyright (c) 2016-2020 The Regents of the University of California.
 * @license    http://www.gnu.org/licenses/lgpl-3.0.html LGPLv3
 *
 * Copyright (c) 2016-2020 The Regents of the University of California.
 *
 * This file is part of: The HUBzero(R) Platform for Scientific Collaboration
 *
 * The HUBzero(R) Platform for Scientific Collaboration (HUBzero) is free
 * software: you can redistribute it and/or modify it under the terms of
 * the GNU Lesser General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any
 * later version.
 *
 * HUBzero is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * HUBzero is a registered trademark of The Regents of the University of California.
 */

#ifndef __GLOBALS_H__
#define __GLOBALS_H__

#include <stdint.h>
#include <limits.h>
#include "path.h"

extern char *source_dir;
extern char log_file[PATH_MAX];
extern const char *black_list[];
extern int black_list_size;

extern uint64_t max_write_bytes;

extern char *mountpoint;
extern char *fuse_options;
extern char source_user[100];
extern int  source_uid;
extern char source_group[100];
extern int  source_gid;
extern int do_debug;
extern int do_foreground;
extern int no_mtab;

extern path_list_t *open_files;

void debug(const char *format, ...);
void error(const char *format, ...);

// TODO: This should really go somewhere else...
void update_mwb(void);

#endif // __GLOBALS_H__

