import ConfigParser
import os

hubzeroConfFileLocation = "/etc/hubzero.conf"

def getHubzeroConfigOption(headerName, optionName):

	if not os.path.exists(hubzeroConfFileLocation):
		raise Exception("Cannot find hubzeroConfFileLocation:" + hubzeroConfFileLocation)

	config = ConfigParser.ConfigParser()
	config.readfp(open(hubzeroConfFileLocation))

	return config.get(headerName, optionName)
	

def getHubDefaultSite():
	return getHubzeroConfigOption("default", "site")
