# @package      hubzero-python
# @file         db.py
# @author       David Benham <dbenham@purdue.edu>
# @copyright    Copyright (c) 2012 HUBzero Foundation, LLC.
# @license      http://www.gnu.org/licenses/lgpl-3.0.html LGPLv3
#
# Copyright (c) 2012 HUBzero Foundation, LLC.
#
# This file is part of: The HUBzero(R) Platform for Scientific Collaboration
#
# The HUBzero(R) Platform for Scientific Collaboration (HUBzero) is free
# software: you can redistribute it and/or modify it under the terms of
# the GNU Lesser General Public License as published by the Free Software
# Foundation, either version 3 of the License, or (at your option) any
# later version.
#
# HUBzero is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
# HUBzero is a registered trademark of HUBzero Foundation, LLC.
#

import MySQLdb

class mySql:

	db = None
	dbHost = ""
	dbName = ""
	dbPW = ""
	dbUsername = ""

	def _db_connect(self):
		self.db = MySQLdb.connect(host=self.dbHost, 
		                          user=self.dbUsername, 
		                          db=self.dbName,
		                          passwd=self.dbPW
		                          )


	def __init__(self, _dbHost, _dbName, _dbUsername, _dbPW):
		self.dbHost = _dbHost
		self.dbName = _dbName
		self.dbPW = _dbPW
		self.dbUsername = _dbUsername
		self._db_connect()

	
	def execInsertQuery(self, sql, data):
		"""
		Insert query that returns the pkid of the last inserted row
		"""
		cursor = self.db.cursor()
		cursor.execute(sql, data)
		newID = cursor.lastrowid
		cursor.close()
		return newID

		
	def execQuery(self, sql, data):
		"""
		Generic query executor
		"""
		cursor = self.db.cursor()
		cursor.execute(sql, data)
		cursor.close()


	def execSelectQuery(self, sql, data):
		"""
		Return results in list of lists for caller
		"""
		cursor = self.db.cursor()
		cursor.execute(sql, data)
		results = cursor.fetchall()	
		cursor.close()
		return results
	
	
	def execSelectQueryScalar(self, sql, data):
		"""
		When you're looking for an easy way to get only a single value from a query returned
		"""
		results = self.execSelectQuery(sql, data)
		if len(results) == 0:
			return None
		else:	
			return results[0][0]
	