# @package      hubzero-python
# @file         group.py
# @author       David Benham <dbenham@purdue.edu>
# @copyright    Copyright (c) 2012 HUBzero Foundation, LLC.
# @license      http://www.gnu.org/licenses/lgpl-3.0.html LGPLv3
#
# Copyright (c) 2012 HUBzero Foundation, LLC.
#
# This file is part of: The HUBzero(R) Platform for Scientific Collaboration
#
# The HUBzero(R) Platform for Scientific Collaboration (HUBzero) is free
# software: you can redistribute it and/or modify it under the terms of
# the GNU Lesser General Public License as published by the Free Software
# Foundation, either version 3 of the License, or (at your option) any
# later version.
#
# HUBzero is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
# HUBzero is a registered trademark of HUBzero Foundation, LLC.
#

import datetime
import hubzero.config.passwords
import hubzero.utilities.misc
import hubzero.config.webconfig
import hubzero.data.db
import ldap
import ldap.modlist


def _del_jos_xgroups(db, name):
	sql = "DELETE FROM jos_xgroups WHERE `CN`=%s "
	data = (name)
	db.execQuery(sql, data)


def _add_ldap_group(groupName, groupDescription, gidNumber):
	hubLDAPAcctMgrDN = hubzero.config.webconfig.getComponentParam("com_system", "ldap_managerdn")
	hubLDAPAcctMgrPW = hubzero.config.webconfig.getComponentParam("com_system", "ldap_managerpw")
	hubLDAPBaseDN = hubzero.config.webconfig.getComponentParam("com_system", "ldap_basedn")

	l = ldap.open("localhost")
	l.simple_bind_s(hubLDAPAcctMgrDN, hubLDAPAcctMgrPW)
	
	dn = "cn=" + groupName + ",ou=groups," + hubLDAPBaseDN
	attrs = {}
	attrs['objectclass'] = ['posixGroup', 'top']
	attrs['cn'] = groupName
	attrs['gidNumber'] = str(gidNumber)
	attrs['description'] = groupDescription
	ldif = ldap.modlist.addModlist(attrs)
	print "adding group with dn: " + dn
	l.add_s(dn, ldif)


def _del_ldap_group(groupName):
	# get ldapManagerUserDN and PW
	hubLDAPAcctMgrDN = hubzero.config.webconfig.getComponentParam("com_system", "ldap_managerdn")
	hubLDAPAcctMgrPW = hubzero.config.webconfig.getComponentParam("com_system", "ldap_managerpw")
	hubLDAPBaseDN = hubzero.config.webconfig.getComponentParam("com_system", "ldap_basedn")

	l = ldap.open("localhost")
	l.simple_bind_s(hubLDAPAcctMgrDN, hubLDAPAcctMgrPW)

	dn = "cn=" + groupName + ",ou=groups," + hubLDAPBaseDN
	print dn
	l.delete_s(dn)


def _insert_jos_xgroups(db, name, description):
	sql =  "INSERT INTO jos_xgroups ( `cn`, `description`, `published`, `type`, `access`, `public_desc`, `private_desc`, `restrict_msg`, "
	sql += "`join_policy`, `privacy`, `discussion_email_autosubscribe`, `logo`, `overview_type`, `overview_content`, `plugins`, `created`,"
	sql += "`created_by`, `params`) " 
	sql += "VALUES (" + '%s,'*17 + "%s );" 

	data = (name, description, 0, 1, 0, '', '', '',   1, 1, 0, '', None, None, None, datetime.datetime.now(), None, None)
	gidNumber = db.execInsertQuery(sql, data)
	return gidNumber


def _insert_jos_xgroups_members(db, gidNumber, uidNumber):
	sql =  "INSERT INTO jos_xgroups_members(gidNumber, uidNumber) "
	sql += "VALUES ( %s, %s );" 

	data = (gidNumber, uidNumber)
	gidNumber = db.execQuery(sql, data)

	
def delhubgroup(groupName):
	# grab config options
	dbPW = hubzero.config.passwords.getMySqlPW()
	db =  hubzero.data.db.mySql("localhost", "myhub", "myhub", dbPW)
	_del_ldap_group(groupName)
	_del_jos_xgroups(db, groupName)


def addhubgroup(db, groupName, groupDescription):
	gidNumber = _insert_jos_xgroups(db, groupName, groupDescription)
	return gidNumber	