# @package      hubzero-python
# @file         useradd.py
# @author       David Benham <dbenham@purdue.edu>
# @copyright    Copyright (c) 2012 HUBzero Foundation, LLC.
# @license      http://www.gnu.org/licenses/lgpl-3.0.html LGPLv3
#
# Copyright (c) 2012 HUBzero Foundation, LLC.
#
# This file is part of: The HUBzero(R) Platform for Scientific Collaboration
#
# The HUBzero(R) Platform for Scientific Collaboration (HUBzero) is free
# software: you can redistribute it and/or modify it under the terms of
# the GNU Lesser General Public License as published by the Free Software
# Foundation, either version 3 of the License, or (at your option) any
# later version.
#
# HUBzero is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
# HUBzero is a registered trademark of HUBzero Foundation, LLC.
#

import datetime
import hubzero.config.passwords
import hubzero.data.db

def insert_jos_users(name, username, email, usertype="Registered", gid=18):
	sql = "INSERT INTO `jos_users` (`name`, `username`, `email`, `password`, `usertype`, `block`, `sendEmail`, `gid`, `registerDate`, `lastvisitDate`, `activation`, `params`)"
	sql += "VALUES (%s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s);"
	data = (name, username, email, 'NOPASSWORD', usertype, 0, 1, gid, datetime.datetime.now(), '0000-00-00 00:00:00', '', '');
	userid = db.execQuery(sql, data)
	return userid

def insert_jos_core_acl_aro():
	sql = "INSERT INTO `jos_core_acl_aro` (`id`, `section_value`, `value`, `order_value`, `name`, `hidden`) "
	sql += "VALUES (%s, %s, %s, %s, %s, %s)"
	data = ( )
	cursor.execute (sql, data)
	id = cursor.lastrowid
	
def insert_jos_core_acl_groups_aro_map():
	sql = "INSERT INTO `jos_core_acl_groups_aro_map` (`group_id`, `section_value`, `aro_id`) "
	sql += "VALUES (%s, %s, %s)"

def insert_jos_xprofiles():
	sql = "INSERT INTO `jos_xprofiles` (`uidNumber`, `name`, `username`, `email`, `registerDate`, `gidNumber`, `homeDirectory`, `loginShell`, "
	sql += "`ftpShell`, `userPassword`, `gid`, `orgtype`, `organization`, `countryresident`, `countryorigin`, `gender`, `url`, `reason`, "
	sql += "`mailPreferenceOption`, `usageAgreement`, `jobsAllowed`, `modifiedDate`, `emailConfirmed`, `regIP`, `regHost`, `nativeTribe`, `phone`, "
	sql += "`proxyPassword`, `proxyUidNumber`, `givenName`, `middleName`, `surname`, `picture`, `vip`, `public`, `params`, `note`, `shadowExpire`) "
	sql += "VALUES (" + '%s'*37 + " ,%s );" 

def addhubuser(username, gid):
	# grab config options
	dbPW = hubzero.config.passwords.getConfigOption("MYSQL-ROOT")
	db =  hubzero.data.db.mySql("localhost", "myhub", dbPW, "myhub")

	userid = insert_jos_users("test", "testUsaername", "email@email.com")
	
	
	
				  
                  