# @package      hubzero-python
# @file         webconfig.py
# @author       David Benham <dbenham@purdue.edu>
# @copyright    Copyright (c) 2012 HUBzero Foundation, LLC.
# @license      http://www.gnu.org/licenses/lgpl-3.0.html LGPLv3
#
# Copyright (c) 2012 HUBzero Foundation, LLC.
#
# This file is part of: The HUBzero(R) Platform for Scientific Collaboration
#
# The HUBzero(R) Platform for Scientific Collaboration (HUBzero) is free
# software: you can redistribute it and/or modify it under the terms of
# the GNU Lesser General Public License as published by the Free Software
# Foundation, either version 3 of the License, or (at your option) any
# later version.
#
# HUBzero is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
# HUBzero is a registered trademark of HUBzero Foundation, LLC.
#

import hubzero.config.hubzerositeconfig
import re
import os

def getWebConfigOption(optionName):
	
	# get the locaiton of the web config file
	defaultSite = hubzero.config.hubzerositeconfig.getHubzeroConfigOption("DEFAULT", "site")
	wwwDocRoot = hubzero.config.hubzerositeconfig.getHubzeroConfigOption(defaultSite, "DocumentRoot")	
	
	# read config values from file
	file = open(wwwDocRoot + "/configuration.php")
	configValues = file.read()
	file.close()
	
	# hubconfig might still be around, if so, dump this file into our search string... we're gonna assume no variable
	if os.path.exists(wwwDocRoot + "/hubconfiguration.php"):
		file = open(wwwDocRoot + "/hubconfiguration.php")
		hubconfigFileContents = file.read()
		file.close()
		configValues += hubconfigFileContents
	
	#print "configValues"
	#print wwwDocRoot + "/configuration.php"
	#print configValues	
	
	# grep for right line
	regEx = "var\s*\$" + optionName + "\s*=\s*'(.*)';"
	m = re.search(regEx, configValues, re.MULTILINE | re.IGNORECASE)

	# return whatever we find, if not found, this will be none type
	if m:
		return m.group(1)
	else:
		return ""
		    
		    
def getWebConfigDBPassword():
	return getWebConfigOption("password")

def getWebConfigDBUsername():
	return getWebConfigOption("user")

def getWebConfigDBName():
	return getWebConfigOption("db")