# @package      hubzero-python
# @file         hubzerositeconfig.py
# @copyright    Copyright (c) 2012-2020 The Regents of the University of California.
# @license      http://opensource.org/licenses/MIT MIT
#
# Copyright (c) 2012-2020 The Regents of the University of California.
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.
#
# HUBzero is a registered trademark of The Regents of the University of California.
#

import ConfigParser
import os

hubzeroConfFileLocation = "/etc/hubzero.conf"


def getHubzeroConfigOption(headerName, optionName, default = None):

	if not os.path.exists(hubzeroConfFileLocation):
		raise Exception("Cannot find hubzeroConfFileLocation:" + hubzeroConfFileLocation)

	config = ConfigParser.ConfigParser()

	config.readfp(open(hubzeroConfFileLocation))

	try:
		value = config.get(headerName, optionName)
	except ConfigParser.NoOptionError:
		value = default
	except ConfigParser.NoSectionError:
		value = default

	return value
	

def setHubzeroConfigOption(headerName, optionName, optionValue):

	if not os.path.exists(hubzeroConfFileLocation):
		raise Exception("Cannot find hubzeroConfFileLocation:" + hubzeroConfFileLocation)

	config = ConfigParser.ConfigParser()

	with open(hubzeroConfFileLocation,"r+") as f:
		config.readfp(f)

		if not config.has_section(headerName):
			config.add_section(headerName)

		config.set(headerName, optionName, optionValue)
		f.seek(0)
		config.write(f)
		f.truncate()

def removeHubzeroConfigOption(headerName, optionName):

	if not os.path.exists(hubzeroConfFileLocation):
		raise Exception("Cannot find hubzeroConfFileLocation:" + hubzeroConfFileLocation)

	config = ConfigParser.ConfigParser()

	with open(hubzeroConfFileLocation,"r+") as f:
		config.readfp(f)

		if config.has_section(headerName):
			config.remove_option(headerName, optionName)
			f.seek(0)
			config.write(f)
			f.truncate()

def getHubDefaultSite():
	return getHubzeroConfigOption("DEFAULT", "site")
