#!/bin/sh

# Fail script on error.
set -e

host_os=`uname -s`
echo $system

base_dir=/apps/rappture
tar_dir=$base_dir/tars
build_dir=$base_dir/`date +%Y%m%d`
mkdir -p $build_dir

stage1_flags="--with-expat \
--with-zlib"
stage2_flags=""
stage3_flags="--with-vtk"
rappture_flags=""

MAKE=make
case $host_os in
   *Darwin* )
      DYLD_LIBRARY_PATH=$build_dir/lib
      export DYLD_LIBRARY_PATH
      ;;
   *Linux*  )
      LD_LIBRARY_PATH=$build_dir/lib
      export LD_LIBRARY_PATH
      ;;
   *FreeBSD* )
      MAKE=gmake
      LD_LIBRARY_PATH=$build_dir/lib
      export LD_LIBRARY_PATH
      ;;
esac

PATH=/usr/local/bin:/usr/bin:/bin:/usr/X11R6/bin:/usr/bin/X11:/usr/X11/bin:/usr/openwin/bin:$build_dir/bin

export MAKE PATH


stage1() {
    pwd=`pwd`
    if test -d "distrib/stage1" ; then 
      cd distrib/stage1
    else 
      mkdir -p distrib/stage1
      cd distrib/stage1
      ../../runtime/configure --prefix=$build_dir --exec_prefix=$build_dir \
       $stage1_flags
    fi
    ${MAKE} all
    ${MAKE} install
    cd $pwd
}

stage2() {
    pwd=`pwd`
    if test -d "distrib/stage2" ; then 
      cd distrib/stage2
    else 
      mkdir -p distrib/stage2
      cd distrib/stage2
      ../../runtime/configure --prefix=$build_dir --exec_prefix=$build_dir \
       $stage2_flags
    fi
    ${MAKE} all
    ${MAKE} install
    cd $pwd
}

stage3() {
    pwd=`pwd`
    if test -d "distrib/stage3" ; then 
      cd distrib/stage3
    else 
      mkdir -p distrib/stage3
      cd distrib/stage3
      ../../runtime/configure --prefix=$build_dir --exec_prefix=$build_dir \
       $stage3_flags
    fi
    ${MAKE} all
    ${MAKE} install
    cd $pwd
}

rappture() {
    pwd=`pwd`
    if test -d "distrib/stage.rappture" ; then
      cd distrib/stage.rappture
    else 
      mkdir -p distrib/stage.rappture
      cd distrib/stage.rappture
      ../../rappture/configure --prefix=$build_dir --exec_prefix=$build_dir \
       $rappture_flags
    fi
    ${MAKE} all
    ${MAKE} install
    ${MAKE} package
    ${MAKE} distrib
    ${MAKE} runtime-distrib
    if ! test -d $tar_dir ; then
        mkdir -p $tar_dir
    fi
    cp rappture*.tar.gz $tar_dir
    cd $pwd
}

stage1
stage2
stage3
rappture

exit 0
