[comment {-*- tcl -*- doctools manpage}]
[manpage_begin transfer::data::destination n 0.1]
[copyright {2006 Andreas Kupries <andreas_kupries@users.sourceforge.net>}]
[moddesc   {Data transfer facilities}]
[titledesc {Data destination}]
[require Tcl                         8.4]
[require snit                        [opt 1.0]]
[require transfer::data::destination [opt 0.1]]
[description]
[keywords transfer copy channel {data destination}]
[para]

This package provides objects mainly describing the destination of a
data transfer. They are also able to initiate the reception of
information from a channel into the described destination.


[section API]

[list_begin definitions]

[call [cmd transfer::data::destination] \
	[arg object] \
	[opt [arg options]...]]

This command creates and configures a new destination
[arg object]. The fully qualified name of the object command is
returned as the result of the command.

[nl]

The recognized options are listed below. It should be noted that all
are semi-exclusive, each specifying a different type of destination
and associated information. If these options are specified more than
once then the last option specified is used to actually configure the
object.


[list_begin opt]

[opt_def -channel  [arg handle]]

This option specifies that the destination of the data is a channel,
and its associated argument is the handle of the channel to write the
received data to.

[opt_def -file     [arg path]]

This option specifies that the destination of the data is a file, and
its associated argument is the path of the file to write the received
data to.

[opt_def -variable [arg varname]]

This option specifies that the destination of the data is a variable,
and its associated argument contains the name of the variable to write
the received data to. The variable is assumed to be global or
namespaced, anchored at the global namespace.

[list_end]


[call [arg object] [method destroy]]

This method destroys the object. Doing so while the object is busy
with the reception of information from a channel will cause errors
later on, when the reception completes and tries to access the now
missing data structures of the destroyed object.


[call [arg object] [method put] [arg chunk]]

The main receptor method. Saves the received [arg chunk] of data into
the configured destination. It has to be called for each piece of data
received.


[call [arg object] [method done]]

The secondary receptor method. Finalizes the receiver. It has to be
called when the receiving channel signals EOF. Afterward neither
itself nor method [method put] can be called anymore.


[call [arg object] [method valid] [arg msgvar]]

This method checks the configuration of the object for validity. It
returns a boolean flag as result, whose value is [const True] if the
object is valid, and [const False] otherwise. In the latter case the
variable whose name is stored in [arg msgvar] is set to an error
message describing the problem found with the configuration. Otherwise
this variable is not touched.

[call [arg object] [method receive] [arg channel] [arg done]]

This method initiates the reception of data from the specified
[arg channel]. The received data will be stored into the configured
destination, via calls to the methods [method put] and [method done].

When the reception completes the command prefix [arg done] is invoked,
with the number of received characters appended to it as the sole
additional argument.

[list_end]

[manpage_end]
