/*=========================================================================

  Program:   Visualization Toolkit
  Module:    $RCSfile: vtkVectorText.cxx,v $

  Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
  All rights reserved.
  See Copyright.txt or http://www.kitware.com/Copyright.htm for details.

     This software is distributed WITHOUT ANY WARRANTY; without even
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/
#include "vtkVectorText.h"

#include "vtkCellArray.h"
#include "vtkInformation.h"
#include "vtkInformationVector.h"
#include "vtkObjectFactory.h"
#include "vtkPoints.h"
#include "vtkPolyData.h"
#include "vtkPolyDataReader.h"
#include "vtkTransformPolyDataFilter.h"

#include <locale.h>

vtkCxxRevisionMacro(vtkVectorText, "$Revision: 1.38 $");
vtkStandardNewMacro(vtkVectorText);

typedef struct {
  float x;
  float y;
} VTK_VECTOR_TEXT_POINT;

typedef struct {
  int p1;
  int p2;
  int p3;
} VTK_VECTOR_TEXT_TRIANGLE;

typedef struct {
  float width;
  const VTK_VECTOR_TEXT_POINT *points;
  int ptCount;
  const VTK_VECTOR_TEXT_TRIANGLE *triangles;
  int triCount;
} VTK_VECTOR_TEXT_GLYPH;

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_33 [] = {
{ 0.28000,-0.07186}, { 0.43164,-0.07143}, { 0.27689, 0.07714}, { 0.43472, 0.07714}, { 0.32000, 0.20134}, 
{ 0.40000, 0.20243}, { 0.31429, 0.20550}, { 0.27277, 0.76857}, { 0.43848, 0.76857}, { 0.27693, 1.02571}, 
{ 0.43429, 1.02615},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_33 [] = { 
{ 2, 1, 3}, { 2, 0, 1}, { 7, 6, 5}, { 6, 4, 5}, { 8, 7, 5}, { 7, 8, 9}, {10, 9, 8},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_34 [] = {
{ 0.25714, 0.63563}, { 0.32571, 0.63563}, { 0.50286, 0.63642}, { 0.25143, 0.63946}, { 0.33143, 0.63840}, 
{ 0.33462, 0.64286}, { 0.49673, 0.64286}, { 0.57714, 0.63757}, { 0.58093, 0.64286}, { 0.21335, 0.84286}, 
{ 0.36680, 0.84286}, { 0.46177, 0.84286}, { 0.61522, 0.84286}, { 0.21295, 1.02000}, { 0.46134, 1.02000}, 
{ 0.61563, 1.02000}, { 0.36571, 1.02307}, { 0.46550, 1.02571}, { 0.21714, 1.02615}, { 0.36000, 1.02723}, 
{ 0.61143, 1.02615},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_34 [] = { 
{ 3, 5, 9}, { 7, 6, 2}, { 4, 5, 1}, { 6, 8, 12}, { 0, 1, 5}, { 6,12,11}, { 3, 0, 5},
{ 7, 8, 6}, {11,12,14}, {13, 9,10}, {10, 9,  5}, {15,14,12}, {19,18,10}, {18,13,10},
{17,14,20}, {14,15,20}, {16, 19, 10},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_35 [] = {
{ 0.22286,-0.09100}, { 0.32571,-0.09236}, { 0.56832,-0.08857}, { 0.67429,-0.09201}, { 0.28193, 0.22000}, 
{ 0.39470, 0.22000}, { 0.63009, 0.22000}, { 0.15385, 0.23143}, { 0.27429, 0.22723}, { 0.40571, 0.22723}, 
{ 0.62286, 0.22723}, { 0.74857, 0.22680}, { 0.97454, 0.23143}, { 0.15385, 0.33429}, { 0.97454, 0.33429}, 
{ 0.30344, 0.34000}, { 0.65201, 0.34000}, { 0.77084, 0.34000}, { 0.42286, 0.34010}, { 0.42034, 0.34571}, 
{ 0.36041, 0.60286}, { 0.70748, 0.60286}, { 0.82034, 0.60286}, { 0.47429, 0.60626}, { 0.15385, 0.61429}, 
{ 0.35429, 0.61009}, { 0.70286, 0.60951}, { 0.82857, 0.61009}, { 0.97454, 0.61429}, { 0.15385, 0.71714}, 
{ 0.37714, 0.72134}, { 0.50286, 0.72191}, { 0.72571, 0.72134}, { 0.85143, 0.72156}, { 0.97143, 0.72025}, 
{ 0.38605, 0.72857}, { 0.49823, 0.72857}, { 0.73335, 0.72857}, { 0.84613, 0.72857}, { 0.45143, 1.04160}, 
{ 0.55735, 1.04286}, { 0.80000, 1.04243}, { 0.90521, 1.04286},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_35 [] = { 
{ 6, 2, 3}, { 5, 0, 1}, { 0, 5, 4}, {18, 9,10}, {11, 6, 3}, { 4, 9, 8}, {13, 8,15},
{17, 6,11}, { 9, 4, 5}, {13, 7, 8}, {17,12,14}, { 8, 9,15}, {15,19,20}, {16, 6,17},
{12,17,11}, {18,10,16}, {10, 6,16}, {21,16,17}, {18,19, 9}, {15, 9,19}, {20,30,25},
{23,20,19}, {34,33,28}, {29,24,25}, {29,25,30}, {27,21,22}, {33,21,27}, {20,23,30},
{22,21,17}, {33,27,28}, {31,26,32}, {35,30,23}, {32,38,37}, {31,35,23}, {21,32,26},
{26,31,23}, {32,21,38}, {41,37,38}, {36,35,31}, {38,21,33}, {40,39,36}, {42,41,38},
{39,35,36},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_36 [] = {
{ 0.52571,-0.22882}, { 0.59429,-0.22991}, { 0.52000,-0.09942}, { 0.60571,-0.09385}, { 0.40571,-0.07057}, 
{ 0.72730,-0.06571}, { 0.33143,-0.03465}, { 0.80571,-0.01813}, { 0.51429, 0.01891}, { 0.52152, 0.02571}, 
{ 0.60571, 0.02014}, { 0.84571, 0.02168}, { 0.25669, 0.04286}, { 0.66857, 0.03800}, { 0.44571, 0.04535}, 
{ 0.70984, 0.06571}, { 0.74535, 0.10571}, { 0.74857, 0.11079}, { 0.74902, 0.11143}, { 0.37057, 0.12857}, 
{ 0.90538, 0.12857}, { 0.20823, 0.15143}, { 0.35748, 0.16286}, { 0.77395, 0.16857}, { 0.35429, 0.17310}, 
{ 0.35177, 0.18000}, { 0.78134, 0.21429}, { 0.92152, 0.21429}, { 0.19580, 0.22571}, { 0.33480, 0.25429}, 
{ 0.77395, 0.29429}, { 0.91177, 0.32286}, { 0.76000, 0.32921}, { 0.72571, 0.36972}, { 0.89355, 0.37429}, 
{ 0.64690, 0.40857}, { 0.65143, 0.40706}, { 0.64000, 0.41109}, { 0.60571, 0.41986}, { 0.52109, 0.43714}, 
{ 0.85714, 0.43270}, { 0.38857, 0.49216}, { 0.79429, 0.48902}, { 0.72571, 0.52437}, { 0.30454, 0.54571}, 
{ 0.60260, 0.56286}, { 0.52043, 0.58571}, { 0.26286, 0.59570}, { 0.46857, 0.59800}, { 0.39429, 0.65095}, 
{ 0.22857, 0.67295}, { 0.36823, 0.70000}, { 0.75429, 0.77624}, { 0.21907, 0.78571}, { 0.35891, 0.78571}, 
{ 0.89184, 0.79714}, { 0.37714, 0.85001}, { 0.72571, 0.86144}, { 0.87470, 0.86571}, { 0.24571, 0.89016}, 
{ 0.68571, 0.90956}, { 0.44000, 0.92036}, { 0.60571, 0.94469}, { 0.83179, 0.94571}, { 0.28000, 0.94629}, 
{ 0.51429, 0.94891}, { 0.34286, 1.00607}, { 0.75429, 1.01579}, { 0.38286, 1.02784}, { 0.52043, 1.06571}, 
{ 0.60260, 1.06571}, { 0.52260, 1.12286}, { 0.60043, 1.12286},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_36 [] = {
{ 3, 8, 2}, { 2, 8, 4}, {19,12, 6}, {13,11,15}, { 9, 8,10}, { 3, 2, 1}, { 8, 3,10},
{ 5,13,10}, {15,11,16}, { 7,13, 5}, { 4,14, 6}, { 2, 0, 1}, { 5,10, 3}, {12,22,21},
{14, 4, 8}, {13, 7,11}, {11,18,16}, {20,23,18}, {18,17,16}, {20,18,11}, {19, 6,14},
{28,21,29}, {26,23,20}, {12,19,22}, {25,22,24}, {21,22,25}, {21,25,29}, {26,27,30},
{27,26,20}, {31,32,30}, {31,30,27}, {40,33,32}, {37,43,38}, {34,32,31}, {38,39, 9},
{40,32,34}, {38, 9,10}, {43,33,42}, {37,36,43}, {39,38,43}, {42,33,40}, {35,36,37},
{33,43,36}, {39,45,46}, {48,41,39}, {45,39,43}, {41,48,44}, {47,51,50}, {46,62,65},
{48,39,46}, {44,49,47}, {49,44,48}, {54,53,50}, {51,47,49}, {53,56,59}, {53,54,56},
{66,64,56}, {55,58,52}, {58,57,52}, {54,50,51}, {59,56,64}, {67,60,63}, {60,57,63},
{66,61,68}, {61,66,56}, {68,65,69}, {65,62,69}, {62,46,45}, {63,57,58}, {62,60,67},
{68,61,65}, {71,70,72}, {70,62,67}, {62,70,69}, {71,69,70},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_37 [] = {
{ 0.46713,-0.11143}, { 0.57143,-0.11215}, { 1.19429,-0.11252}, { 1.10286,-0.10252}, { 1.26444,-0.09429}, 
{ 1.05143,-0.07759}, { 1.31429,-0.06384}, { 1.14857,-0.01538}, { 1.18857,-0.01807}, { 0.98857,-0.01364}, 
{ 1.22286,-0.00771}, { 1.36784,-0.00286}, { 1.11302, 0.00286}, { 1.26436, 0.03143}, { 1.07787, 0.04857}, 
{ 0.95748, 0.05429}, { 1.39681, 0.06571}, { 1.28680, 0.09429}, { 1.05866, 0.14000}, { 1.40991, 0.14571}, 
{ 0.94134, 0.15143}, { 0.94134, 0.21429}, { 1.29295, 0.21429}, { 1.06134, 0.23714}, { 1.40723, 0.23714}, 
{ 0.95748, 0.30000}, { 1.39387, 0.30000}, { 1.07787, 0.30571}, { 1.27429, 0.30371}, { 1.09561, 0.33429}, 
{ 1.23429, 0.35465}, { 1.36616, 0.36286}, { 1.13143, 0.36327}, { 1.16571, 0.37277}, { 1.20571, 0.36899}, 
{ 1.00045, 0.38571}, { 1.32000, 0.41543}, { 1.06857, 0.44498}, { 1.24571, 0.45681}, { 0.48000, 0.46420}, 
{ 1.15429, 0.46723}, { 0.38857, 0.47462}, { 0.55016, 0.48286}, { 0.60000, 0.51330}, { 0.30286, 0.52704}, 
{ 0.43429, 0.56177}, { 0.47429, 0.55907}, { 0.26857, 0.57284}, { 0.50857, 0.56943}, { 0.65355, 0.57429}, 
{ 0.39873, 0.58000}, { 0.55007, 0.60857}, { 0.24530, 0.62571}, { 0.36359, 0.62571}, { 0.68252, 0.64286}, 
{ 0.56680, 0.64857}, { 0.23050, 0.69429}, { 0.34437, 0.71714}, { 0.57866, 0.72286}, { 0.69563, 0.72286}, 
{ 0.22705, 0.79143}, { 0.34705, 0.81429}, { 0.69295, 0.81429}, { 0.56891, 0.85429}, { 0.67959, 0.87714}, 
{ 0.24530, 0.88286}, { 0.36359, 0.88286}, { 0.38132, 0.91143}, { 0.54286, 0.90975}, { 0.52000, 0.93179}, 
{ 0.65465, 0.93429}, { 0.41714, 0.94041}, { 0.47429, 0.94950}, { 0.29143, 0.96914}, { 0.60571, 0.99258}, 
{ 0.32000, 0.99868}, { 0.38286, 1.03395}, { 0.53714, 1.03184}, { 1.06857, 1.04249}, { 1.17287, 1.04286}, 
{ 0.48000, 1.04395},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_37 [] = {
{ 0, 1,78}, {10, 4, 6}, { 2, 8, 3}, { 9,14,15}, { 4,10, 8}, { 3, 7, 5}, { 7, 3, 8},
{10, 6,13}, {12, 5, 7}, { 5,12, 9}, { 4, 8, 2}, {13,16,17}, {17,19,22}, {14, 9,12},
{15,18,20}, {11,13, 6}, {13,11,16}, {17,16,19}, {18,15,14}, {21,20,18}, {21,23,25},
{22,26,28}, {23,21,18}, {24,22,19}, {25,27,35}, {35,29,37}, {22,24,26}, {28,31,30},
{27,25,23}, {31,28,26}, {27,29,35}, {36,30,31}, {38,34,30}, {38,33,34}, {37,32,40},
{32,33,40}, {38,30,36}, {32,37,29}, {40,33,38}, {42,46,39}, {47,53,52}, {48,43,51},
{39,46,41}, {41,50,44}, {56,57,60}, {45,41,46}, {42,48,46}, {48,42,43}, {50,41,45},
{53,47,44}, {51,49,55}, {54,55,49}, {53,44,50}, {49,51,43}, {55,54,58}, {59,58,54},
{57,56,52}, {57,52,53}, {60,61,65}, {58,62,63}, {57,61,60}, {62,64,63}, {65,66,73},
{66,65,61}, {73,66,75}, {58,59,62}, {63,64,68}, {70,69,68}, {67,75,66}, {70,68,64},
{76,71,72}, {75,67,76}, {74,69,70}, {71,76,67}, {69,77,72}, {72,77,80}, {77,69,74},
{76,72,80}, {79,78, 1},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_38 [] = {
{ 0.58857,-0.08966}, { 1.03429,-0.09235}, { 0.48000,-0.08395}, { 0.66286,-0.07673}, { 0.40000,-0.05914}, 
{ 0.72000,-0.05641}, { 0.98286,-0.05473}, { 0.35429,-0.03393}, { 0.78857,-0.01678}, { 1.12629, 0.00857}, 
{ 0.29143, 0.02168}, { 0.52571, 0.02991}, { 0.57714, 0.02764}, { 0.62286, 0.03756}, { 0.46857, 0.04645}, 
{ 0.87429, 0.05495}, { 0.69714, 0.07393}, { 0.42132, 0.08286}, { 1.04571, 0.07868}, { 0.24486, 0.08857}, 
{ 0.75011, 0.11714}, { 0.22327, 0.14000}, { 0.37927, 0.14571}, { 0.78349, 0.16286}, { 0.96893, 0.16286}, 
{ 0.96571, 0.16717}, { 0.96457, 0.16857}, { 0.95937, 0.18000}, { 0.35580, 0.22571}, { 0.20991, 0.25429}, 
{ 0.36319, 0.28857}, { 0.86286, 0.29600}, { 1.02437, 0.31143}, { 0.22645, 0.32857}, { 0.40418, 0.36286}, 
{ 0.40571, 0.36454}, { 0.41330, 0.37429}, { 1.05421, 0.40857}, { 0.28418, 0.42571}, { 0.92000, 0.44119}, 
{ 0.53714, 0.46770}, { 0.37143, 0.50250}, { 0.66758, 0.54000}, { 0.46406, 0.55714}, { 0.78704, 0.62571}, 
{ 0.59429, 0.63146}, { 0.37714, 0.68444}, { 0.69296, 0.70000}, { 0.85355, 0.71714}, { 0.35681, 0.73429}, 
{ 0.50200, 0.75143}, { 0.49756, 0.76286}, { 0.49502, 0.76857}, { 0.72891, 0.76857}, { 0.86966, 0.76857}, 
{ 0.34748, 0.82000}, { 0.73295, 0.82000}, { 0.48764, 0.82571}, { 0.87236, 0.83143}, { 0.49714, 0.86089}, 
{ 0.35849, 0.87143}, { 0.71429, 0.87650}, { 0.52000, 0.89555}, { 0.69714, 0.89846}, { 0.37964, 0.91714}, 
{ 0.84657, 0.91714}, { 0.55429, 0.92073}, { 0.65714, 0.92498}, { 0.60000, 0.93277}, { 0.81868, 0.95714}, 
{ 0.42857, 0.97582}, { 0.76571, 1.00436}, { 0.51429, 1.02723}, { 0.72000, 1.02723}, { 0.59429, 1.04437}, 
{ 0.64571, 1.04395},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_38 [] = {
{ 7,17,10}, { 3,13, 0}, { 2,14, 4}, { 6,18,15}, {17, 7, 4}, { 9,18, 6}, { 9, 6, 1},
{ 8,16, 5}, { 0,12, 2}, {17, 4,14}, { 2,11,14}, {12, 0,13}, {13, 5,16}, {15,24,20},
{16, 8,20}, {13, 3, 5}, { 2,12,11}, {10,17,19}, {21,28,29}, {15,20, 8}, {20,24,23},
{40,23,31}, {24,25,26}, {19,22,21}, {31,23,27}, {22,19,17}, {18,24,15}, {28,21,22},
{29,30,33}, {31,32,39}, {23,24,26}, {30,29,28}, {23,26,27}, {33,30,38}, {32,31,27},
{38,36,41}, {38,34,36}, {34,38,30}, {36,34,35}, {39,32,37}, {42,40,31}, {40,41,36},
{42,44,47}, {45,43,40}, {40,43,41}, {50,46,43}, {50,49,46}, {45,40,42}, {48,53,47},
{45,42,47}, {49,52,55}, {53,48,56}, {50,43,45}, {57,60,55}, {52,50,51}, {49,50,52},
{48,47,44}, {54,56,48}, {56,65,61}, {60,59,64}, {59,60,57}, {65,56,58}, {52,57,55},
{64,59,70}, {58,56,54}, {59,62,70}, {68,74,72}, {65,69,61}, {70,66,72}, {63,71,67},
{63,61,69}, {70,62,66}, {67,73,68}, {71,63,69}, {73,67,71}, {68,72,66}, {74,68,75},
{75,68,73},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_39 [] = {
{ 0.25143, 0.63563}, { 0.24571, 0.63946}, { 0.32571, 0.63757}, { 0.32950, 0.64286}, { 0.21034, 0.83714}, 
{ 0.36379, 0.83714}, { 0.20991, 1.02000}, { 0.36420, 1.02000}, { 0.21408, 1.02571}, { 0.36000, 1.02615},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_39 [] = {
{ 1, 0, 3}, { 2, 3, 0}, { 1, 3, 4}, { 7, 6, 4}, { 5, 4, 3}, { 7, 4, 5}, { 8, 6, 9},
{ 6, 7, 9},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_40 [] = {
{ 0.50857,-0.39522}, { 0.59429,-0.39447}, { 0.44000,-0.30784}, { 0.51787,-0.24857}, { 0.32530,-0.09429}, 
{ 0.43748,-0.05429}, { 0.26899, 0.06571}, { 0.38134, 0.20286}, { 0.23580, 0.27714}, { 0.37605, 0.38000}, 
{ 0.23848, 0.41429}, { 0.39320, 0.53429}, { 0.27177, 0.59714}, { 0.43748, 0.71143}, { 0.47216, 0.80286}, 
{ 0.36086, 0.82000}, { 0.45714, 0.97936}, { 0.59573, 1.04286}, { 0.50857, 1.04395},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_40 [] = {
{ 2, 3, 4}, { 0, 3, 2}, { 3, 0, 1}, { 6, 4, 5}, { 3, 5, 4}, { 6, 7, 8}, { 7, 6, 5},
{ 9,10, 8}, { 9, 8, 7}, {10,11,12}, {10, 9,11}, {12,13,15}, {12,11,13}, {14,15,13},
{16,15,14}, {17,18,16}, {17,16,14},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_41 [] = {
{ 0.24000,-0.39447}, { 0.33143,-0.39258}, { 0.40616,-0.28857}, { 0.31641,-0.24857}, { 0.48784,-0.14000}, 
{ 0.39681,-0.05429}, { 0.55538, 0.03143}, { 0.45295, 0.20286}, { 0.59580, 0.23714}, { 0.59848, 0.37429}, 
{ 0.45823, 0.38000}, { 0.44723, 0.49429}, { 0.56252, 0.59714}, { 0.41714, 0.64134}, { 0.47343, 0.82000}, 
{ 0.34857, 0.83301}, { 0.37714, 0.97936}, { 0.23855, 1.04286}, { 0.32571, 1.04395},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_41 [] = {
{ 0, 1, 3}, { 2, 3, 1}, { 3, 4, 5}, { 3, 2, 4}, { 5, 6, 7}, { 6, 5, 4}, { 7, 8,10},
{ 8, 9,10}, {11,10, 9}, { 8, 7, 6}, {11,12,13}, {13,14,15}, {12,11, 9}, {14,13,12},
{15,16,17}, {16,15,14}, {16,18,17},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_42 [] = {
{ 0.33143, 0.58250}, { 0.33714, 0.58223}, { 0.53714, 0.58250}, { 0.54286, 0.58194}, { 0.36213, 0.61429}, 
{ 0.25587, 0.63714}, { 0.25266, 0.64286}, { 0.62655, 0.64286}, { 0.25393, 0.64857}, { 0.43429, 0.73293}, 
{ 0.44000, 0.73049}, { 0.36715, 0.78000}, { 0.50714, 0.78000}, { 0.35429, 0.78613}, { 0.63429, 0.80816}, 
{ 0.19309, 0.82571}, { 0.68389, 0.82571}, { 0.19177, 0.83143}, { 0.68530, 0.83143}, { 0.38857, 0.86213}, 
{ 0.39523, 0.86571}, { 0.48000, 0.86242}, { 0.47660, 0.86571}, { 0.34657, 0.88286}, { 0.58857, 0.90823}, 
{ 0.22286, 0.92522}, { 0.22857, 0.92848}, { 0.64571, 0.92816}, { 0.65143, 0.92675}, { 0.49295, 1.02000}, 
{ 0.38134, 1.03714}, { 0.38550, 1.04286}, { 0.49143, 1.04021}, { 0.48571, 1.04437},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_42 [] = {
{ 2,12,10}, { 8, 4,11}, { 8, 5, 4}, { 8, 6, 5}, { 4, 0, 1}, { 2, 3,12}, { 0, 4, 5},
{12, 9,10}, { 9,11, 4}, {19,11,21}, {14,24,12}, {26,25,17}, {16,18,14}, {13,23,15},
{19,21,20}, {11,19,13}, {33,31,30}, {24,21,12}, {12,21, 9}, {21,11, 9}, {26,17,23},
{12, 3, 7}, {27,24,18}, {13,19,23}, {23,17,15}, {20,21,22}, {18,24,14}, {28,27,18},
{33,30,20}, {29,20,22}, {29,33,20}, {32,33,29},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_43 [] = {
{ 0.52836, 0.10571}, { 0.64878, 0.10571}, { 0.52420, 0.11143}, { 0.65295, 0.11143}, { 0.52420, 0.39714}, 
{ 0.65295, 0.39714}, { 0.22857, 0.40546}, { 0.52000, 0.40329}, { 0.66286, 0.40437}, { 0.95168, 0.40857}, 
{ 0.22437, 0.52286}, { 0.95277, 0.52286}, { 0.22857, 0.52900}, { 0.52311, 0.53429}, { 0.65403, 0.53429}, 
{ 0.94857, 0.52900}, { 0.52528, 0.82571}, { 0.65186, 0.82571}, { 0.53143, 0.82991}, { 0.64571, 0.82991},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_43 [] = {
{ 1, 2, 0}, { 1, 3, 2}, { 4, 2, 3}, { 5, 4, 3}, {12, 6, 7}, {14, 4, 8}, { 9,15, 8},
{ 8, 4, 5}, { 9,11,15}, {12, 7,13}, { 6,12,10}, { 7, 4,13}, {14, 8,15}, {17,19,18},
{14,13, 4}, {17,18,16}, {17,16,13}, {17,13,14},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_44 [] = {
{ 0.30286,-0.28607}, { 0.30857,-0.28726}, { 0.33714,-0.27355}, { 0.36571,-0.25275}, { 0.27329,-0.23714}, 
{ 0.38670,-0.23143}, { 0.30286,-0.21582}, { 0.39914,-0.21429}, { 0.32115,-0.19714}, { 0.41355,-0.18571}, 
{ 0.33800,-0.16857}, { 0.42327,-0.15714}, { 0.34605,-0.14571}, { 0.43277,-0.10000}, { 0.35580,-0.08286}, 
{ 0.35472,-0.07714}, { 0.28571,-0.07295}, { 0.34857,-0.07295}, { 0.28000,-0.06878}, { 0.27957, 0.07714}, 
{ 0.43168, 0.07714}, { 0.28571, 0.08134}, { 0.42857, 0.08025},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_44 [] = {
{ 0, 6, 4}, { 0, 1, 2}, { 0, 2, 6}, { 3, 6, 2}, { 8, 5,10}, { 5, 7,10}, { 6, 5, 8},
{ 5, 6, 3}, {10, 7,12}, { 9,12, 7}, {12,13,14}, {11,12, 9}, {12,11,13}, {18,17,19},
{17,21,19}, {15,14,13}, {15,13,17}, {21,17,22}, {17,20,22}, {18,16,17}, {20,17,13},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_45 [] = {
{ 0.19118, 0.26000}, { 0.19429, 0.25689}, { 0.60000, 0.25580}, { 0.60615, 0.26000}, { 0.19118, 0.38571}, 
{ 0.60615, 0.38571}, { 0.19429, 0.38882}, { 0.60000, 0.38991},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_45 [] = {
{ 6, 1, 2}, { 6, 0, 1}, { 6, 2, 7}, { 6, 4, 0}, { 7, 2, 3}, { 5, 7, 3},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_46 [] = {
{ 0.28571,-0.07295}, { 0.42286,-0.07295}, { 0.42857,-0.07186}, { 0.27848,-0.06571}, { 0.28000,-0.06878}, 
{ 0.43277,-0.06571}, { 0.27848, 0.07143}, { 0.43277, 0.07143}, { 0.27957, 0.07714}, { 0.43168, 0.07714}, 
{ 0.28571, 0.08134}, { 0.42286, 0.08134}, { 0.42857, 0.08025},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_46 [] = {
{ 0, 3, 4}, { 3, 0, 1}, { 8, 6,10}, { 5, 1, 2}, { 3, 1, 5}, { 6, 3, 5}, { 6, 7,11},
{ 6, 5, 7}, {10, 6,11}, { 9,12,11}, { 9,11, 7},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_47 [] = {
{ 0.14389,-0.08857}, { 0.14857,-0.09256}, { 0.25004,-0.08857}, { 0.56235, 1.04286}, { 0.46286, 1.04358},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_47 [] = {
{ 2, 0, 1}, { 4, 0, 2}, { 3, 4, 2},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_48 [] = {
{ 0.53714,-0.09009}, { 0.59429,-0.09009}, { 0.66857,-0.07673}, { 0.43429,-0.06723}, { 0.73143,-0.05070}, 
{ 0.34286,-0.00972}, { 0.80571, 0.01025}, { 0.54857, 0.02152}, { 0.61714, 0.02891}, { 0.30241, 0.03714}, 
{ 0.65714, 0.04645}, { 0.46857, 0.05007}, { 0.42473, 0.08857}, { 0.70286, 0.08454}, { 0.26645, 0.10000}, 
{ 0.86943, 0.11143}, { 0.39955, 0.12286}, { 0.73800, 0.13429}, { 0.23748, 0.18000}, { 0.37034, 0.19714}, 
{ 0.76252, 0.20286}, { 0.91236, 0.26000}, { 0.21866, 0.26571}, { 0.35621, 0.26571}, { 0.77823, 0.28857}, 
{ 0.34437, 0.40286}, { 0.92680, 0.40286}, { 0.20420, 0.40857}, { 0.78705, 0.54000}, { 0.20723, 0.58000}, 
{ 0.92420, 0.58571}, { 0.35277, 0.64286}, { 0.22177, 0.69429}, { 0.76571, 0.72437}, { 0.89966, 0.74000}, 
{ 0.37756, 0.76286}, { 0.74498, 0.79143}, { 0.26073, 0.82571}, { 0.85927, 0.84857}, { 0.42473, 0.85429}, 
{ 0.70439, 0.85429}, { 0.46286, 0.88902}, { 0.66286, 0.89007}, { 0.30241, 0.90000}, { 0.51009, 0.91143}, 
{ 0.58286, 0.91823}, { 0.80725, 0.92857}, { 0.77714, 0.95829}, { 0.38350, 0.98000}, { 0.71429, 0.99927}, 
{ 0.46286, 1.01681}, { 0.65714, 1.01959}, { 0.53714, 1.02991},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_48 [] = {
{ 2, 8, 1}, { 0, 7, 3}, { 5,16, 9}, { 2,10, 8}, { 0, 1, 8}, { 7, 0, 8}, {12,16, 5},
{11, 3, 7}, { 3,12, 5}, {15,20,17}, {11,12, 3}, {13, 6,17}, { 6,13, 4}, { 9,16,14},
{10, 4,13}, {14,19,18}, { 4,10, 2}, {15,17, 6}, {19,14,16}, {21,24,20}, {23,18,19},
{22,25,27}, {24,26,28}, {23,22,18}, {21,20,15}, {26,24,21}, {22,23,25}, {29,27,25},
{29,31,32}, {28,30,33}, {31,29,25}, {30,28,26}, {32,35,37}, {46,40,36}, {30,34,33},
{32,31,35}, {43,39,48}, {43,37,35}, {38,36,33}, {38,33,34}, {42,40,49}, {48,41,50},
{39,43,35}, {47,40,46}, {46,36,38}, {41,44,50}, {45,52,44}, {42,51,45}, {41,48,39},
{49,40,47}, {50,44,52}, {52,45,51}, {42,49,51},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_49 [] = {
{ 0.58286,-0.07186}, { 0.70857,-0.07186}, { 0.30857, 0.62908}, { 0.31429, 0.62657}, { 0.38286, 0.65641}, 
{ 0.30785, 0.75143}, { 0.57714, 0.77731}, { 0.47429, 0.85616}, { 0.56384, 0.94000}, { 0.62857, 1.02915}, 
{ 0.70857, 1.02882},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_49 [] = {
{ 6, 0, 1}, { 2, 4, 5}, { 7, 5, 4}, { 2, 3, 4}, { 6, 8, 7}, { 6, 7, 4}, {10, 8, 6},
{10, 6, 1}, {10, 9, 8},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_50 [] = {
{ 0.18857,-0.06878}, { 0.91429,-0.06878}, { 0.18748,-0.04286}, { 0.19849, 0.00857}, { 0.91429, 0.05164}, 
{ 0.38142, 0.06000}, { 0.22943, 0.07714}, { 0.46286, 0.15868}, { 0.30286, 0.17832}, { 0.38286, 0.25813}, 
{ 0.58413, 0.43143}, { 0.78286, 0.44454}, { 0.67543, 0.52286}, { 0.85355, 0.53429}, { 0.72045, 0.58000}, 
{ 0.89756, 0.62571}, { 0.75470, 0.64286}, { 0.35168, 0.70000}, { 0.91236, 0.70000}, { 0.77295, 0.71143}, 
{ 0.21403, 0.71714}, { 0.77295, 0.74571}, { 0.22605, 0.79143}, { 0.37143, 0.79804}, { 0.90244, 0.80857}, 
{ 0.75429, 0.81228}, { 0.38902, 0.83143}, { 0.24359, 0.84286}, { 0.73143, 0.84689}, { 0.42454, 0.87143}, 
{ 0.86607, 0.88857}, { 0.68000, 0.89070}, { 0.28000, 0.90629}, { 0.49143, 0.90823}, { 0.58857, 0.91866}, 
{ 0.82857, 0.93555}, { 0.31597, 0.94571}, { 0.37714, 0.98784}, { 0.76000, 0.98657}, { 0.44571, 1.01470}, 
{ 0.69143, 1.01470}, { 0.53714, 1.02991}, { 0.62857, 1.02723},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_50 [] = {
{ 3, 2, 0}, { 3, 5, 6}, { 1, 5, 0}, { 5, 3, 0}, { 1, 4, 5}, { 6, 5, 8}, { 7, 8, 5},
{ 9, 8, 7}, { 9, 7,10}, {11,10, 7}, {10,11,12}, {12,11,14}, {16,15,18}, {16,18,19},
{13,14,11}, {14,13,16}, {21,24,25}, {15,16,13}, {21,19,18}, {23,27,22}, {17,23,22},
{24,21,18}, {27,23,32}, {17,22,20}, {31,42,34}, {30,28,25}, {26,32,23}, {40,31,38},
{35,28,30}, {36,32,26}, {29,36,26}, {34,41,33}, {33,37,29}, {36,29,37}, {33,39,37},
{30,25,24}, {28,38,31}, {38,28,35}, {39,33,41}, {31,40,42}, {41,34,42},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_51 [] = {
{ 0.52571,-0.09009}, { 0.63429,-0.08395}, { 0.45143,-0.07756}, { 0.37143,-0.04498}, { 0.74286,-0.04771}, 
{ 0.30857, 0.00132}, { 0.81714, 0.00439}, { 0.54286, 0.02152}, { 0.60000, 0.02420}, { 0.64661, 0.03714}, 
{ 0.27429, 0.03952}, { 0.46857, 0.04073}, { 0.42857, 0.06759}, { 0.70857, 0.07561}, { 0.88213, 0.08286}, 
{ 0.23429, 0.10772}, { 0.38812, 0.11714}, { 0.74535, 0.11714}, { 0.91109, 0.14571}, { 0.77823, 0.19143}, 
{ 0.20764, 0.20857}, { 0.92723, 0.22571}, { 0.34286, 0.23215}, { 0.78437, 0.27143}, { 0.92723, 0.27714}, 
{ 0.75429, 0.36430}, { 0.89927, 0.38571}, { 0.72571, 0.40132}, { 0.86857, 0.43270}, { 0.67429, 0.43927}, 
{ 0.48000, 0.45284}, { 0.48571, 0.44966}, { 0.54857, 0.46152}, { 0.60000, 0.46109}, { 0.83429, 0.46686}, 
{ 0.72693, 0.52286}, { 0.49034, 0.55714}, { 0.49714, 0.56395}, { 0.78857, 0.56473}, { 0.58286, 0.57109}, 
{ 0.82857, 0.60921}, { 0.67429, 0.61616}, { 0.70400, 0.64857}, { 0.85294, 0.65429}, { 0.72680, 0.70571}, 
{ 0.87009, 0.72286}, { 0.35429, 0.72298}, { 0.22175, 0.74571}, { 0.72991, 0.76286}, { 0.72151, 0.80286}, 
{ 0.86244, 0.80857}, { 0.38857, 0.82064}, { 0.69143, 0.85832}, { 0.84571, 0.85587}, { 0.26241, 0.87143}, 
{ 0.43429, 0.87829}, { 0.64571, 0.89641}, { 0.48571, 0.90723}, { 0.29330, 0.91714}, { 0.60571, 0.91252}, 
{ 0.53143, 0.91823}, { 0.80384, 0.92286}, { 0.36000, 0.97750}, { 0.73143, 0.98213}, { 0.44571, 1.01681}, 
{ 0.65714, 1.01470}, { 0.52000, 1.02991}, { 0.60000, 1.02723},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_51 [] = {
{ 3,11, 5}, { 9, 8, 1}, { 1, 8, 0}, { 4, 9, 1}, { 9, 4,13}, { 7, 0, 8}, { 6,13, 4},
{17,13, 6}, { 2,11, 3}, { 2, 0, 7}, { 5,16,10}, {12, 5,11}, {10,16,15}, {11, 2, 7},
{16, 5,12}, {17,14,19}, {14,17, 6}, {20,15,22}, {19,18,23}, {22,15,16}, {14,18,19},
{21,23,18}, {23,26,25}, {23,21,24}, {26,28,25}, {30,32,36}, {25,34,27}, {35,32,33},
{35,29,27}, {25,28,34}, {29,35,33}, {26,23,24}, {37,36,32}, {39,32,35}, {35,27,34},
{37,32,39}, {30,31,32}, {39,35,41}, {38,41,35}, {38,42,41}, {40,42,38}, {42,40,44},
{40,43,44}, {44,43,48}, {45,48,43}, {47,46,54}, {49,48,50}, {50,48,45}, {49,53,52},
{63,52,61}, {53,49,50}, {46,51,54}, {58,54,51}, {58,55,62}, {62,55,64}, {66,57,60},
{61,52,53}, {55,58,51}, {59,67,60}, {52,63,56}, {56,65,59}, {55,57,64}, {64,57,66},
{65,56,63}, {67,66,60}, {67,59,65},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_52 [] = {
{ 0.64571,-0.07295}, { 0.64000,-0.06878}, { 0.77143,-0.06878}, { 0.77403, 0.18571}, { 0.16265, 0.19143}, 
{ 0.63429, 0.18882}, { 0.92000, 0.19408}, { 0.15891, 0.31143}, { 0.91735, 0.31143}, { 0.29653, 0.31714}, 
{ 0.63740, 0.31714}, { 0.77714, 0.31403}, { 0.16571, 0.32228}, { 0.16616, 0.32286}, { 0.63429, 0.79380}, 
{ 0.77186, 1.02000}, { 0.66857, 1.02282}, { 0.76571, 1.02420},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_52 [] = {
{ 2, 1, 0}, { 1, 3, 5}, { 1, 2, 3}, { 3,10, 5}, { 9, 4, 5}, { 4, 9, 7}, { 6,11, 3},
{ 8,11, 6}, { 7, 9,13}, {15,16,14}, { 9, 5,10}, { 7,13,12}, {13,14,16}, {11,10, 3},
{14,13, 9}, {14,10,11}, {15,17,16}, {15,14,11},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_53 [] = {
{ 0.52571,-0.09009}, { 0.61714,-0.08665}, { 0.44571,-0.07673}, { 0.73143,-0.05179}, { 0.35429,-0.03759}, 
{ 0.78914,-0.01429}, { 0.30286, 0.00241}, { 0.53714, 0.02152}, { 0.62857, 0.03184}, { 0.84115, 0.03714}, 
{ 0.46857, 0.03927}, { 0.66286, 0.04645}, { 0.26286, 0.04921}, { 0.42286, 0.06759}, { 0.71429, 0.08439}, 
{ 0.88045, 0.09429}, { 0.23343, 0.10000}, { 0.38812, 0.10571}, { 0.74535, 0.12286}, { 0.35748, 0.16857}, 
{ 0.77294, 0.18000}, { 0.91681, 0.18000}, { 0.20420, 0.20857}, { 0.34286, 0.22376}, { 0.78705, 0.23714}, 
{ 0.93295, 0.27143}, { 0.79009, 0.31714}, { 0.93252, 0.33429}, { 0.77714, 0.38420}, { 0.91681, 0.42000}, 
{ 0.34857, 0.43034}, { 0.75641, 0.43143}, { 0.23088, 0.44857}, { 0.72000, 0.47868}, { 0.40000, 0.48400}, 
{ 0.68000, 0.50784}, { 0.86902, 0.51714}, { 0.46857, 0.52437}, { 0.53143, 0.53848}, { 0.57714, 0.53848}, 
{ 0.58857, 0.53621}, { 0.60000, 0.53580}, { 0.82286, 0.56972}, { 0.38494, 0.59714}, { 0.77714, 0.60535}, 
{ 0.48571, 0.64244}, { 0.69714, 0.64327}, { 0.56571, 0.65848}, { 0.61714, 0.65848}, { 0.43891, 0.87714}, 
{ 0.44571, 0.88395}, { 0.88043, 0.88857}, { 0.88043, 1.00857}, { 0.33714, 1.01182},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_53 [] = {
{ 7, 1, 8}, { 7, 0, 1}, { 7, 2, 0}, { 2,10, 4}, { 6,13,12}, { 3, 8, 1}, { 3,11, 8},
{10, 2, 7}, { 4,13, 6}, {11, 3,14}, {19,16,12}, { 3, 5,14}, { 9,14, 5}, {10,13, 4},
{22,19,23}, {18,15,20}, {17,12,13}, {15,14, 9}, {14,15,18}, {19,12,17}, {25,26,24},
{20,21,24}, {21,20,15}, {22,16,19}, {25,24,21}, {26,25,27}, {29,28,26}, {29,26,27},
{43,37,45}, {36,31,29}, {34,32,30}, {31,36,33}, {31,28,29}, {32,34,43}, {48,47,41},
{45,38,47}, {42,33,36}, {41,39,40}, {38,39,47}, {37,38,45}, {47,39,41}, {44,33,42},
{43,34,37}, {46,33,44}, {35,46,41}, {33,46,35}, {46,48,41}, {32,43,53}, {43,49,53},
{49,50,53}, {53,50,52}, {50,51,52},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_54 [] = {
{ 0.55429,-0.09009}, { 0.66857,-0.08034}, { 0.43429,-0.06213}, { 0.75429,-0.04607}, { 0.34857,-0.00972}, 
{ 0.81143,-0.00439}, { 0.59429, 0.02152}, { 0.51339, 0.03143}, { 0.85188, 0.04286}, { 0.67429, 0.04645}, 
{ 0.46286, 0.05579}, { 0.27384, 0.07714}, { 0.41714, 0.09597}, { 0.73143, 0.09597}, { 0.89355, 0.11714}, 
{ 0.38771, 0.14000}, { 0.91177, 0.16857}, { 0.77294, 0.17429}, { 0.22816, 0.18571}, { 0.36530, 0.19714}, 
{ 0.78705, 0.24857}, { 0.92680, 0.25429}, { 0.35320, 0.26000}, { 0.78665, 0.30571}, { 0.20420, 0.31143}, 
{ 0.35320, 0.31143}, { 0.92723, 0.31714}, { 0.36657, 0.37429}, { 0.77395, 0.37429}, { 0.75429, 0.41841}, 
{ 0.39179, 0.42571}, { 0.89756, 0.44286}, { 0.72000, 0.46418}, { 0.43429, 0.47258}, { 0.19891, 0.50571}, 
{ 0.33714, 0.50495}, { 0.48000, 0.50213}, { 0.66857, 0.50086}, { 0.86241, 0.50571}, { 0.55429, 0.52134}, 
{ 0.61143, 0.51866}, { 0.80403, 0.56857}, { 0.42286, 0.58821}, { 0.74286, 0.60943}, { 0.34134, 0.63143}, 
{ 0.50857, 0.62823}, { 0.68000, 0.63252}, { 0.57714, 0.64134}, { 0.21563, 0.66000}, { 0.77714, 0.74697}, 
{ 0.37502, 0.75714}, { 0.90966, 0.76286}, { 0.25673, 0.80286}, { 0.41901, 0.83143}, { 0.73143, 0.85191}, 
{ 0.45143, 0.86686}, { 0.87343, 0.87714}, { 0.30036, 0.88286}, { 0.68000, 0.89514}, { 0.50286, 0.90086}, 
{ 0.51429, 0.90530}, { 0.52000, 0.90784}, { 0.60571, 0.91866}, { 0.83846, 0.92857}, { 0.35429, 0.94384}, 
{ 0.40571, 0.98150}, { 0.76000, 0.99229}, { 0.49143, 1.01748}, { 0.68571, 1.02041}, { 0.56571, 1.02991},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_54 [] = {
{ 2,10, 4}, { 6, 1, 9}, { 3, 5,13}, { 0, 7, 2}, { 3, 9, 1}, { 1, 6, 0}, { 9, 3,13},
{ 7, 0, 6}, {10, 2, 7}, {20,26,23}, { 4,12,11}, {13, 8,17}, { 4,10,12}, {11,19,18},
{17,21,20}, {15,11,12}, {11,15,19}, {16,17,14}, {18,22,24}, { 8,14,17}, { 8,13, 5},
{24,35,34}, {22,18,19}, {20,21,26}, {28,23,26}, {21,17,16}, {24,27,35}, {24,22,25},
{28,31,29}, {31,28,26}, {24,25,27}, {32,41,37}, {30,35,27}, {34,44,48}, {35,33,42},
{43,37,41}, {46,39,40}, {32,29,38}, {38,29,31}, {33,35,30}, {33,36,42}, {42,36,45},
{45,39,47}, {36,39,45}, {37,46,40}, {41,32,38}, {46,37,43}, {47,39,46}, {44,34,35},
{48,50,52}, {48,44,50}, {49,56,54}, {57,53,64}, {57,52,50}, {54,66,58}, {51,56,49},
{62,69,61}, {53,57,50}, {61,59,60}, {59,65,55}, {65,64,55}, {58,68,62}, {55,64,53},
{66,54,63}, {63,54,56}, {65,59,67}, {69,62,68}, {67,59,61}, {69,67,61}, {68,58,66},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_55 [] = {
{ 0.37143,-0.07186}, { 0.50286,-0.07186}, { 0.36723,-0.06571}, { 0.37335, 0.02000}, { 0.52991, 0.11143}, 
{ 0.40379, 0.18571}, { 0.59787, 0.35143}, { 0.47387, 0.41429}, { 0.66857, 0.51873}, { 0.53355, 0.55143}, 
{ 0.63384, 0.72857}, { 0.80893, 0.76286}, { 0.74359, 0.88286}, { 0.21714, 0.88546}, { 0.92379, 0.91143}, 
{ 0.21403, 1.00857}, { 0.92311, 1.00857},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_55 [] = {
{ 3, 0, 1}, { 2, 0, 3}, { 3, 4, 5}, { 4, 3, 1}, { 6, 7, 5}, { 6, 5, 4}, { 9, 7, 6},
{10, 9, 8}, { 8, 9, 6}, {10,11,12}, {11,10, 8}, {15,13,12}, {12,14,16}, {15,12,16},
{11,14,12},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_56 [] = {
{ 0.53143,-0.08966}, { 0.62857,-0.08665}, { 0.45143,-0.07605}, { 0.73714,-0.05641}, { 0.38857,-0.05343}, 
{ 0.34286,-0.02616}, { 0.79429,-0.02250}, { 0.28571, 0.02445}, { 0.58857, 0.02152}, { 0.50857, 0.02823}, 
{ 0.85258, 0.03143}, { 0.66937, 0.04286}, { 0.45143, 0.05070}, { 0.71429, 0.07296}, { 0.41143, 0.07868}, 
{ 0.24000, 0.09016}, { 0.89927, 0.10571}, { 0.37669, 0.12286}, { 0.76613, 0.14000}, { 0.21462, 0.15714}, 
{ 0.35849, 0.16286}, { 0.92109, 0.17429}, { 0.78705, 0.22000}, { 0.34437, 0.22571}, { 0.20420, 0.27143}, 
{ 0.92680, 0.27143}, { 0.78437, 0.28286}, { 0.34748, 0.28857}, { 0.77143, 0.32947}, { 0.91470, 0.33429}, 
{ 0.21714, 0.34118}, { 0.37502, 0.36286}, { 0.73296, 0.39143}, { 0.89057, 0.39143}, { 0.24359, 0.40286}, 
{ 0.41883, 0.41429}, { 0.69143, 0.42722}, { 0.27275, 0.44286}, { 0.85714, 0.43841}, { 0.46286, 0.44371}, 
{ 0.50286, 0.45748}, { 0.63429, 0.45470}, { 0.58286, 0.46420}, { 0.80507, 0.48286}, { 0.33143, 0.49007}, 
{ 0.40456, 0.52286}, { 0.72693, 0.52286}, { 0.32000, 0.57616}, { 0.54857, 0.57580}, { 0.62286, 0.58319}, 
{ 0.82082, 0.58571}, { 0.49714, 0.58657}, { 0.66286, 0.60073}, { 0.28527, 0.61429}, { 0.44571, 0.61582}, 
{ 0.70439, 0.63714}, { 0.85759, 0.63714}, { 0.25756, 0.67143}, { 0.72657, 0.67143}, { 0.39849, 0.68286}, 
{ 0.87470, 0.68286}, { 0.74134, 0.72857}, { 0.38705, 0.73429}, { 0.88109, 0.76857}, { 0.24764, 0.77429}, 
{ 0.73395, 0.79714}, { 0.39470, 0.80286}, { 0.87177, 0.82000}, { 0.71641, 0.83714}, { 0.27216, 0.86571}, 
{ 0.44000, 0.87296}, { 0.84486, 0.88286}, { 0.66286, 0.89179}, { 0.48000, 0.90086}, { 0.61714, 0.91184}, 
{ 0.54286, 0.91823}, { 0.31846, 0.93429}, { 0.80571, 0.93555}, { 0.38286, 0.98616}, { 0.72000, 0.99800}, 
{ 0.43429, 1.01008}, { 0.53143, 1.02991}, { 0.61714, 1.02723},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_56 [] = {
{ 0, 9, 2}, {12, 4, 2}, { 1, 8, 0}, { 6,11, 3}, { 5,14, 7}, { 9, 0, 8}, { 8, 1,11},
{ 4,12, 5}, {13,11, 6}, { 1, 3,11}, {12, 2, 9}, { 5,12,14}, {13,10,18}, { 7,17,15},
{10,13, 6}, {15,20,19}, { 7,14,17}, {18,16,22}, {16,18,10}, {20,15,17}, {19,23,24},
{16,21,22}, {22,25,26}, {23,19,20}, {24,27,30}, {25,22,21}, {27,24,23}, {31,34,30},
{31,37,34}, {29,28,26}, {31,30,27}, {29,26,25}, {33,28,29}, {28,33,32}, {36,32,43},
{37,31,44}, {40,45,39}, {44,39,45}, {43,32,38}, {35,44,31}, {42,48,40}, {44,35,39},
{41,46,42}, {36,46,41}, {32,33,38}, {48,42,49}, {46,36,43}, {48,45,40}, {42,46,49},
{51,45,48}, {49,46,52}, {47,54,53}, {52,46,55}, {53,59,57}, {45,54,47}, {45,51,54},
{50,55,46}, {59,53,54}, {50,58,55}, {58,50,61}, {57,62,64}, {61,63,65}, {56,61,50},
{57,59,62}, {60,61,56}, {64,66,69}, {63,67,65}, {64,62,66}, {63,61,60}, {71,68,65},
{76,69,66}, {72,68,77}, {71,65,67}, {76,70,78}, {70,76,66}, {74,82,75}, {80,78,70},
{79,72,77}, {74,72,79}, {80,73,75}, {80,75,81}, {68,71,77}, {73,80,70}, {82,81,75},
{82,74,79},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_57 [] = {
{ 0.50286,-0.09009}, { 0.56000,-0.09009}, { 0.42857,-0.07673}, { 0.64571,-0.07395}, { 0.36000,-0.04771}, 
{ 0.74286,-0.02616}, { 0.28759, 0.01429}, { 0.51429, 0.02152}, { 0.57143, 0.02420}, { 0.80115, 0.02571}, 
{ 0.47429, 0.02891}, { 0.42857, 0.05007}, { 0.64000, 0.04943}, { 0.24930, 0.07714}, { 0.39314, 0.08286}, 
{ 0.85229, 0.10000}, { 0.70902, 0.11143}, { 0.37057, 0.12286}, { 0.22177, 0.17429}, { 0.34857, 0.18947}, 
{ 0.75109, 0.19714}, { 0.89395, 0.20286}, { 0.75429, 0.20739}, { 0.75681, 0.21429}, { 0.90966, 0.27143}, 
{ 0.50286, 0.30152}, { 0.42857, 0.31605}, { 0.61714, 0.31462}, { 0.37714, 0.33787}, { 0.70286, 0.35759}, 
{ 0.78705, 0.37429}, { 0.32000, 0.37846}, { 0.58286, 0.42152}, { 0.50286, 0.42891}, { 0.63429, 0.43184}, 
{ 0.78286, 0.43630}, { 0.92723, 0.43714}, { 0.26286, 0.44350}, { 0.45143, 0.45107}, { 0.68571, 0.45750}, 
{ 0.41587, 0.47714}, { 0.23787, 0.48857}, { 0.74498, 0.52286}, { 0.36359, 0.55143}, { 0.21522, 0.55714}, 
{ 0.92680, 0.56286}, { 0.76571, 0.57009}, { 0.34437, 0.63143}, { 0.77823, 0.63714}, { 0.20462, 0.69429}, 
{ 0.77866, 0.69429}, { 0.91236, 0.70000}, { 0.35429, 0.74118}, { 0.76571, 0.76404}, { 0.21756, 0.77429}, 
{ 0.38286, 0.80921}, { 0.87343, 0.82571}, { 0.40759, 0.84286}, { 0.72571, 0.84118}, { 0.24527, 0.84857}, 
{ 0.69143, 0.87527}, { 0.84000, 0.88221}, { 0.47429, 0.89641}, { 0.28571, 0.90975}, { 0.63429, 0.90784}, 
{ 0.54857, 0.91866}, { 0.33143, 0.95527}, { 0.76000, 0.96331}, { 0.39629, 0.99714}, { 0.68571, 1.00437}, 
{ 0.49714, 1.02723}, { 0.57714, 1.02991},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_57 [] = {
{ 3, 8, 1}, { 2,11, 4}, { 0, 7, 2}, { 8, 3,12}, { 4,14, 6}, { 0, 1, 8}, { 6,17,13},
{10, 2, 7}, { 7, 0, 8}, { 5,12, 3}, {12, 5,16}, { 2,10,11}, { 4,11,14}, { 5, 9,16},
{18,13,19}, {16,15,20}, {15,23,20}, { 6,14,17}, {13,17,19}, {21,23,15}, {22,20,23},
{23,24,30}, {16, 9,15}, {23,21,24}, {25,32,26}, {27,32,25}, {38,28,26}, {43,41,37},
{34,29,39}, {33,26,32}, {29,34,27}, {30,36,35}, {34,32,27}, {36,30,24}, {28,38,31},
{31,38,37}, {35,39,29}, {38,26,33}, {39,35,42}, {42,35,36}, {40,37,38}, {44,41,43},
{42,36,46}, {44,47,49}, {43,37,40}, {48,46,45}, {36,45,46}, {51,50,48}, {52,54,49},
{47,44,43}, {50,51,53}, {51,48,45}, {59,54,52}, {59,55,63}, {52,49,47}, {53,61,58},
{56,53,51}, {55,59,52}, {53,56,61}, {66,63,57}, {55,57,63}, {62,68,57}, {58,67,60},
{67,58,61}, {68,66,57}, {60,69,64}, {68,62,70}, {60,67,69}, {64,71,65}, {65,70,62},
{70,65,71}, {64,69,71},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_58 [] = {
{ 0.28571,-0.07295}, { 0.42857,-0.07186}, { 0.28000,-0.06878}, { 0.43277,-0.06571}, { 0.27957, 0.07714}, 
{ 0.28571, 0.08134}, { 0.42857, 0.08025}, { 0.27957, 0.57429}, { 0.28571, 0.57009}, { 0.43168, 0.57429}, 
{ 0.27848, 0.71714}, { 0.43277, 0.71714}, { 0.28265, 0.72286}, { 0.42857, 0.72329},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_58 [] = {
{ 2, 5, 4}, { 2, 0, 5}, { 0, 3, 5}, { 6, 5, 3}, { 0, 1, 3}, { 7, 8,10}, {10,11,13},
{ 9,10, 8}, {12,10,13}, {11,10, 9},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_59 [] = {
{ 0.30857,-0.28726}, { 0.36571,-0.25275}, { 0.27323,-0.23714}, { 0.39543,-0.22000}, { 0.32384,-0.19143}, 
{ 0.33756,-0.16857}, { 0.42327,-0.15714}, { 0.43277,-0.10000}, { 0.35472,-0.07714}, { 0.28571,-0.07295}, 
{ 0.34857,-0.07295}, { 0.28000,-0.06878}, { 0.27957, 0.07714}, { 0.43168, 0.07714}, { 0.27957, 0.57429}, 
{ 0.43168, 0.57429}, { 0.28265, 0.72286}, { 0.42857, 0.72329},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_59 [] = {
{ 2, 1, 4}, { 5, 4, 3}, { 0, 1, 2}, { 5, 6, 8}, { 3, 4, 1}, { 6, 5, 3}, { 6, 7, 8},
{11,10,12}, {12,10,13}, { 8, 7,10}, {11, 9,10}, {13,10, 7}, {17,16,15}, {15,16,14},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_60 [] = {
{ 0.94857, 0.09939}, { 0.95269, 0.10571}, { 0.95236, 0.22571}, { 0.22894, 0.40857}, { 0.38919, 0.46571}, 
{ 0.38919, 0.47143}, { 0.22748, 0.52857}, { 0.23192, 0.53429}, { 0.95098, 0.70571}, { 0.95216, 0.83143}, 
{ 0.94857, 0.83523},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_60 [] = {
{ 4, 0, 2}, { 5, 7, 6}, { 4, 3, 0}, { 0, 1, 2}, { 7, 8,10}, { 4, 5, 3}, { 5, 6, 3},
{ 8, 9,10}, { 7, 5, 8},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_61 [] = {
{ 0.22857, 0.23975}, { 0.94857, 0.23975}, { 0.22437, 0.35714}, { 0.95277, 0.35714}, { 0.22857, 0.36329}, 
{ 0.94857, 0.36329}, { 0.22857, 0.57385}, { 0.94857, 0.57385}, { 0.22437, 0.58000}, { 0.95277, 0.58000}, 
{ 0.22857, 0.69740}, { 0.94857, 0.69740},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_61 [] = {
{ 0, 4, 2}, { 0, 1, 5}, { 4, 0, 5}, { 3, 5, 1}, {11, 7, 9}, {10, 6, 7}, {10, 7,11},
{ 8, 6,10},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_62 [] = {
{ 0.23429, 0.09914}, { 0.22857, 0.10169}, { 0.22748, 0.22571}, { 0.23192, 0.23143}, { 0.95116, 0.40857}, 
{ 0.79073, 0.46571}, { 0.79073, 0.47143}, { 0.95236, 0.52857}, { 0.22897, 0.70571}, { 0.22857, 0.83287}, 
{ 0.23429, 0.83563},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_62 [] = {
{ 1, 0, 2}, { 3, 2, 0}, { 3, 0, 5}, { 4, 7, 5}, { 4, 5, 0}, { 6, 5, 7}, { 6,10, 8},
{ 8,10, 9}, {10, 6, 7},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_63 [] = {
{ 0.47429,-0.07186}, { 0.62021,-0.07143}, { 0.47118, 0.07714}, { 0.62329, 0.07714}, { 0.49979, 0.19714}, 
{ 0.62021, 0.19714}, { 0.49563, 0.20286}, { 0.49563, 0.27714}, { 0.63681, 0.31714}, { 0.50816, 0.34571}, 
{ 0.65714, 0.36350}, { 0.53669, 0.41429}, { 0.70857, 0.42384}, { 0.57868, 0.47143}, { 0.82857, 0.53597}, 
{ 0.86902, 0.58571}, { 0.73258, 0.62000}, { 0.90437, 0.65429}, { 0.76086, 0.66000}, { 0.77522, 0.70000}, 
{ 0.91580, 0.70000}, { 0.34857, 0.71338}, { 0.21034, 0.73429}, { 0.77866, 0.75143}, { 0.91807, 0.76857}, 
{ 0.22605, 0.80857}, { 0.76571, 0.80375}, { 0.38286, 0.82144}, { 0.73714, 0.85191}, { 0.25098, 0.87143}, 
{ 0.89143, 0.86730}, { 0.43597, 0.88857}, { 0.86812, 0.90571}, { 0.67429, 0.90616}, { 0.48571, 0.91800}, 
{ 0.62857, 0.92538}, { 0.29296, 0.93429}, { 0.54857, 0.93277}, { 0.81143, 0.96670}, { 0.35429, 0.98821}, 
{ 0.76571, 0.99800}, { 0.44571, 1.02891}, { 0.69714, 1.02680}, { 0.53143, 1.04395}, { 0.60000, 1.04437},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_63 [] = {
{ 2, 1, 3}, { 2, 0, 1}, { 7, 6, 4}, { 7, 4, 5}, { 8, 9, 7}, {11,10,13}, { 8, 7, 5},
{ 8,10,11}, { 9, 8,11}, {13,12,16}, {12,13,10}, {14,16,12}, {14,15,16}, {16,15,18},
{17,18,15}, {17,23,19}, {17,19,18}, {20,23,17}, {29,27,36}, {26,32,28}, {21,25,22},
{26,23,24}, {27,29,25}, {24,23,20}, {36,31,39}, {28,40,33}, {30,26,24}, {35,44,37},
{31,36,27}, {27,25,21}, {31,34,41}, {42,33,40}, {28,38,40}, {39,31,41}, {38,28,32},
{26,30,32}, {42,35,33}, {41,34,43}, {43,37,44}, {34,37,43}, {44,35,42},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_64 [] = {
{ 0.92571,-0.39563}, { 1.16571,-0.38109}, { 0.74857,-0.37236}, { 0.65143,-0.34613}, { 1.33143,-0.33070}, 
{ 0.54286,-0.29914}, { 0.86286,-0.27866}, { 1.06286,-0.28134}, { 1.45650,-0.26000}, { 0.73714,-0.25387}, 
{ 1.21143,-0.25387}, { 0.43429,-0.22384}, { 0.62286,-0.21216}, { 1.32144,-0.20857}, { 1.55582,-0.17429}, 
{ 0.53714,-0.16099}, { 0.52571,-0.15258}, { 0.53143,-0.15669}, { 0.33714,-0.11650}, { 1.45143,-0.11561}, 
{ 0.46286,-0.09260}, { 0.80000,-0.07295}, { 1.20571,-0.07252}, { 1.09714,-0.06891}, { 0.71429,-0.06252}, 
{ 1.49714,-0.06187}, { 1.63260,-0.06000}, { 0.29629,-0.04857}, { 1.29714,-0.04498}, { 0.90857,-0.03629}, 
{ 1.03384,-0.02571}, { 0.62857,-0.01582}, { 0.40486,-0.00857}, { 0.59429, 0.01873}, { 1.41143, 0.03296}, 
{ 0.82857, 0.03907}, { 0.77714, 0.04327}, { 1.01143, 0.04414}, { 1.20000, 0.05050}, { 1.16989, 0.06571}, 
{ 1.25143, 0.06086}, { 0.90857, 0.06821}, { 0.72000, 0.07561}, { 0.54771, 0.09429}, { 1.15580, 0.09429}, 
{ 0.24420, 0.10000}, { 0.35748, 0.11143}, { 0.96000, 0.10725}, { 0.68527, 0.11714}, { 1.33841, 0.11714}, 
{ 1.51579, 0.15714}, { 0.66177, 0.17429}, { 1.41355, 0.20286}, { 1.03514, 0.20857}, { 0.65295, 0.23143}, 
{ 0.22437, 0.23714}, { 0.51277, 0.23714}, { 0.33563, 0.24857}, { 1.45355, 0.27714}, { 1.07177, 0.31143}, 
{ 1.58478, 0.31143}, { 0.65966, 0.32857}, { 1.48319, 0.36857}, { 0.53184, 0.39714}, { 0.23277, 0.40286}, 
{ 0.34478, 0.40857}, { 1.60420, 0.42571}, { 1.08420, 0.44286}, { 0.71514, 0.48857}, { 0.25184, 0.49429}, 
{ 1.49295, 0.49429}, { 0.57229, 0.50000}, { 1.60109, 0.52857}, { 1.05714, 0.54144}, { 0.75846, 0.55143}, 
{ 0.38645, 0.55714}, { 1.47681, 0.58571}, { 1.01143, 0.59527}, { 0.81714, 0.60331}, { 1.58605, 0.60857}, 
{ 1.12878, 0.61429}, { 0.65714, 0.62418}, { 0.86286, 0.62319}, { 0.96571, 0.62151}, { 0.92571, 0.62991}, 
{ 0.42857, 0.64350}, { 1.44571, 0.66730}, { 0.32359, 0.67714}, { 1.06048, 0.68286}, { 0.74857, 0.69641}, 
{ 1.15429, 0.71588}, { 1.28235, 0.71714}, { 1.00571, 0.71800}, { 0.82857, 0.73109}, { 0.92000, 0.74152}, 
{ 1.52657, 0.75143}, { 0.51275, 0.75714}, { 0.37669, 0.76286}, { 1.38286, 0.76132}, { 0.59493, 0.82571}, 
{ 1.30857, 0.82821}, { 1.45561, 0.84857}, { 0.47429, 0.87296}, { 0.73143, 0.89681}, { 1.18286, 0.89580}, 
{ 1.08571, 0.92395}, { 1.37143, 0.92400}, { 0.92000, 0.93580}, { 0.58286, 0.95188}, { 1.30857, 0.96371}, 
{ 0.71429, 1.00899}, { 1.18286, 1.01470}, { 0.92000, 1.04437}, { 1.01143, 1.04395},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_64 [] = {
{ 0, 6, 2}, { 1, 7, 0}, { 6, 0, 7}, { 7, 1,10}, { 2, 9, 3}, { 3,12, 5}, { 9, 2, 6},
{10, 4,13}, { 4,10, 1}, {15, 5,12}, { 5,15,11}, {13, 8,19}, {12, 3, 9}, { 8,13, 4},
{11,20,18}, {11,15,16}, {17,16,15}, {14,19, 8}, {26,25,14}, {20,11,16}, {22,38,23},
{25,19,14}, {23,39,30}, {30,39,37}, {27,46,45}, {18,32,27}, {32,18,20}, {21,36,24},
{35,29,41}, {24,42,31}, {29,35,21}, {22,28,40}, {38,22,40}, {34,49,40}, {33,31,48},
{36,21,35}, {37,47,41}, {33,48,43}, {43,51,56}, {44,37,39}, {34,40,28}, {47,37,53},
{50,52,34}, {38,39,23}, {52,49,34}, {37,44,53}, {27,32,46}, {42,24,36}, {48,31,42},
{37,41,29}, {45,57,55}, {53,44,59}, {51,54,56}, {52,50,58}, {58,60,62}, {43,48,51},
{45,46,57}, {56,61,63}, {64,55,57}, {91,80,44}, {60,58,50}, {62,66,70}, {56,54,61},
{44,80,67}, {59,44,67}, {71,63,61}, {64,65,69}, {67,80,73}, {65,64,57}, {66,62,60},
{68,71,61}, {71,68,81}, {69,75,87}, {72,70,66}, {74,81,68}, {77,73,80}, {70,79,76},
{75,69,65}, {83,77,88}, {87,85,97}, {81,74,89}, {89,78,93}, {86,76,79}, {70,72,79},
{74,78,89}, {88,77,80}, {75,85,87}, {82,84,94}, {91,90,80}, {86,95,98}, {78,82,93},
{ 92, 83, 88}, { 93, 82, 94}, { 84, 83, 92}, { 94, 84, 92}, { 97, 96,102}, { 95, 86, 79},
{102, 99,108}, { 95,101, 98}, { 96, 97, 85}, { 96, 99,102}, { 98,101,100}, {103,108, 99},
{100,109,104}, {106,100,101}, {108,103,110}, {105,113,107}, {100,106,109}, {104,111,105},
{107,112,110}, {111,104,109}, {113,105,111}, {112,107,113}, {107,110,103},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_65 [] = {
{ 0.14455,-0.07143}, { 1.00000,-0.07252}, { 1.15573,-0.07143}, { 0.29143,-0.07103}, { 0.40981, 0.25429}, 
{ 0.86857, 0.25754}, { 0.45714, 0.37713}, { 0.82478, 0.38000}, { 0.45462, 0.38571}, { 0.58538, 0.73429}, 
{ 0.63429, 0.90068}, { 0.56000, 1.02454}, { 0.71429, 1.02644},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_65 [] = {
{ 5, 1, 2}, { 0, 8,11}, { 6, 4, 5}, {12,10, 7}, { 0, 3, 4}, { 0, 4, 8}, { 6, 5, 7},
{ 6, 8, 4}, { 7, 5, 2}, { 8, 9,11}, { 9,10,11}, {12, 7, 2}, {11,10,12},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_66 [] = {
{ 0.25714,-0.07186}, { 0.78286,-0.06723}, { 0.86857,-0.04899}, { 0.93714,-0.02045}, { 1.00725, 0.03714}, 
{ 0.39957, 0.06000}, { 0.73143, 0.05621}, { 0.80571, 0.06891}, { 1.04213, 0.08857}, { 0.87555, 0.10571}, 
{ 1.06437, 0.14000}, { 0.91070, 0.15143}, { 1.08109, 0.22000}, { 0.93295, 0.22571}, { 0.93252, 0.26571}, 
{ 1.07177, 0.32286}, { 0.90857, 0.34064}, { 1.04616, 0.38571}, { 0.86857, 0.38686}, { 0.79429, 0.42252}, 
{ 0.39957, 0.43143}, { 1.01296, 0.43143}, { 0.69714, 0.43563}, { 0.97143, 0.46686}, { 0.88197, 0.51143}, 
{ 0.40571, 0.56437}, { 0.72000, 0.56705}, { 0.39848, 0.57429}, { 0.96956, 0.58571}, { 0.80571, 0.58930}, 
{ 0.84686, 0.62000}, { 0.99641, 0.62571}, { 0.86943, 0.65429}, { 1.02437, 0.70571}, { 0.88420, 0.71143}, 
{ 1.02665, 0.76857}, { 0.87429, 0.79232}, { 1.01673, 0.82000}, { 0.84000, 0.84984}, { 0.77714, 0.88538}, 
{ 0.98607, 0.88857}, { 0.39957, 0.89429}, { 0.71429, 0.89580}, { 0.93143, 0.95296}, { 0.85714, 0.99756}, 
{ 0.80000, 1.01470}, { 0.25714, 1.02615}, { 0.70857, 1.02680},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_66 [] = {
{ 1, 6, 0}, { 2, 7, 1}, { 0,20,46}, { 7, 2, 9}, { 1, 7, 6}, {20,27,46}, { 9, 4,11},
{ 4, 9, 3}, { 2, 3, 9}, {11,10,13}, { 8,11, 4}, {10,11, 8}, {12,13,10}, {14,17,16},
{14,15,17}, {16,21,18}, {14,13,12}, {15,14,12}, {23,18,21}, { 5, 0, 6}, {19,26,22},
{18,24,19}, {16,17,21}, {24,18,23}, {26,19,29}, {19,24,29}, {25,22,26}, {22,25,20},
{30,29,24}, {32,28,31}, {28,32,30}, {32,31,34}, { 0, 5,20}, {34,35,36}, {33,34,31},
{28,30,24}, {36,40,38}, {38,44,39}, {35,37,36}, {34,33,35}, {25,27,20}, {27,41,46},
{40,36,37}, {43,38,40}, {39,45,42}, {42,47,41}, {38,43,44}, {45,39,44}, {47,46,41},
{47,42,45},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_67 [] = {
{ 0.69143,-0.08966}, { 0.80000,-0.08705}, { 0.60000,-0.07823}, { 0.50857,-0.05070}, { 0.93143,-0.05216}, 
{ 0.45714,-0.02486}, { 1.00000,-0.01473}, { 0.39597, 0.02000}, { 0.69714, 0.03563}, { 0.74857, 0.03563}, 
{ 0.62286, 0.04899}, { 0.82286, 0.04899}, { 1.08000, 0.05597}, { 0.57143, 0.06784}, { 0.88000, 0.07229}, 
{ 0.32571, 0.10064}, { 0.93143, 0.10759}, { 0.49143, 0.11901}, { 1.13800, 0.14000}, { 0.45600, 0.15714}, 
{ 0.28930, 0.16286}, { 0.99641, 0.18571}, { 0.41502, 0.22571}, { 1.18605, 0.27714}, { 0.24319, 0.28857}, 
{ 1.04571, 0.31105}, { 0.38244, 0.32857}, { 0.22748, 0.36286}, { 0.36723, 0.44286}, { 0.21866, 0.52857}, 
{ 0.36991, 0.55714}, { 0.22705, 0.60857}, { 1.02857, 0.69469}, { 0.40657, 0.71143}, { 1.16694, 0.72857}, 
{ 0.26286, 0.74089}, { 0.44187, 0.78000}, { 1.13927, 0.80857}, { 0.97143, 0.80914}, { 0.48000, 0.82725}, 
{ 0.31750, 0.84286}, { 0.93714, 0.85011}, { 0.53143, 0.86784}, { 0.89143, 0.88331}, { 1.07582, 0.90571}, 
{ 0.64000, 0.91252}, { 0.64571, 0.91335}, { 0.65714, 0.91563}, { 0.38286, 0.91868}, { 0.78857, 0.91823}, 
{ 1.00571, 0.96902}, { 0.50286, 0.99756}, { 0.93143, 1.01070}, { 0.58286, 1.02680}, { 0.70286, 1.04705}, 
{ 0.80000, 1.04437},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_67 [] = {
{ 1, 9, 0}, { 0, 8, 2}, {14, 6,16}, { 4,14,11}, {24,20,22}, { 7,17,15}, { 2,10, 3},
{ 8,10, 2}, { 9, 1,11}, { 0, 9, 8}, { 4,11, 1}, { 3,13, 5}, {12,16, 6}, {10,13, 3},
{ 5,13, 7}, { 7,13,17}, {22,20,15}, {16,12,21}, {14, 4, 6}, {19,15,17}, {23,25,18},
{22,15,19}, {25,21,18}, {18,21,12}, {27,28,29}, {27,24,26}, {26,24,22}, {28,27,26},
{29,30,31}, {30,29,28}, {33,35,31}, {35,33,40}, {33,31,30}, {34,37,32}, {48,42,51},
{36,40,33}, {40,36,48}, {38,44,41}, {44,38,37}, {32,37,38}, {48,39,42}, {36,39,48},
{54,53,47}, {45,51,42}, {49,43,52}, {50,41,44}, {47,45,46}, {41,50,43}, {45,53,51},
{49,54,47}, {53,45,47}, {49,55,54}, {55,49,52}, {52,43,50},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_68 [] = {
{ 0.26286,-0.07186}, { 0.70286,-0.07252}, { 0.80000,-0.06109}, { 0.89714,-0.03355}, { 0.99555, 0.02571}, 
{ 0.40528, 0.06000}, { 0.72571, 0.05891}, { 1.03582, 0.06571}, { 0.79547, 0.07143}, { 0.88000, 0.10893}, 
{ 1.08150, 0.12857}, { 0.92115, 0.14571}, { 0.96657, 0.21429}, { 1.13966, 0.26571}, { 0.99470, 0.28857}, 
{ 1.16420, 0.39714}, { 1.01823, 0.43714}, { 1.16723, 0.52857}, { 1.01823, 0.53429}, { 1.15277, 0.64286}, 
{ 1.00000, 0.65848}, { 0.97714, 0.72375}, { 1.11216, 0.77429}, { 0.94286, 0.78057}, { 0.87429, 0.84902}, 
{ 1.06607, 0.85429}, { 0.81714, 0.87865}, { 0.40528, 0.89429}, { 0.69143, 0.89807}, { 0.97714, 0.94616}, 
{ 0.90857, 0.98657}, { 0.81143, 1.01580}, { 0.26286, 1.02615}, { 0.70286, 1.02680},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_68 [] = {
{ 2, 6, 1}, { 5, 0, 1}, { 8, 3, 9}, { 3, 8, 2}, { 0,27,32}, { 6, 2, 8}, { 5, 1, 6},
{ 4, 7,11}, { 4, 9, 3}, { 9, 4,11}, {11,10,12}, {11, 7,10}, {13,14,12}, {14,15,16},
{13,12,10}, {16,17,18}, {14,13,15}, {18,19,20}, {17,16,15}, {18,17,19}, {22,21,20},
{21,22,23}, {29,24,23}, {22,20,19}, {26,24,30}, { 0, 5,27}, {25,23,22}, {29,23,25},
{30,24,29}, {26,31,28}, {31,26,30}, {33,32,27}, {28,33,27}, {33,28,31},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_69 [] = {
{ 0.26857,-0.07186}, { 1.08000,-0.06878}, { 1.08000, 0.05164}, { 0.41100, 0.06000}, { 0.41100, 0.42571}, 
{ 1.01143, 0.43100}, { 1.01563, 0.55143}, { 0.41714, 0.55866}, { 1.01143, 0.55757}, { 0.40991, 0.56857}, 
{ 0.41100, 0.89429}, { 1.05143, 0.89957}, { 1.05563, 1.02000}, { 0.26857, 1.02615}, { 1.05143, 1.02615},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_69 [] = {
{ 0, 4,13}, { 1, 3, 0}, { 1, 2, 3}, { 0, 3, 4}, { 7, 5, 8}, { 5, 7, 4}, { 6, 8, 5},
{ 4, 9,13}, { 7, 9, 4}, { 9,10,13}, {11,14,10}, {14,13,10}, {12,14,11},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_70 [] = {
{ 0.26857,-0.07186}, { 0.40571,-0.07186}, { 0.40991, 0.42000}, { 0.41714, 0.42723}, { 0.92615, 0.43143}, 
{ 0.92615, 0.55143}, { 0.41714, 0.55563}, { 0.40991, 0.56286}, { 0.41100, 0.89429}, { 1.00571, 0.90265}, 
{ 1.00571, 1.02307}, { 0.26857, 1.02615},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_70 [] = {
{ 0, 2,11}, { 2, 7,11}, { 2, 0, 1}, { 6, 4, 5}, { 4, 6, 3}, { 3, 6, 2}, { 7, 2, 6},
{ 7, 8,11}, {11, 8,10}, { 8, 9,10},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_71 [] = {
{ 0.82286,-0.08966}, { 0.65714,-0.07866}, { 0.93143,-0.07335}, { 0.56571,-0.05387}, { 1.05143,-0.03355}, 
{ 0.48000,-0.01514}, { 1.12000, 0.00073}, { 0.74286, 0.03866}, { 0.83429, 0.04177}, { 0.38857, 0.05044}, 
{ 0.65143, 0.05470}, { 0.92571, 0.06319}, { 1.23260, 0.07714}, { 0.34857, 0.09302}, { 0.54286, 0.10150}, 
{ 1.03429, 0.11229}, { 0.50286, 0.13044}, { 1.09252, 0.15714}, { 0.44421, 0.19714}, { 0.27429, 0.21629}, 
{ 0.24252, 0.31143}, { 0.39320, 0.31143}, { 0.77714, 0.36243}, { 1.09143, 0.35773}, { 0.22748, 0.39714}, 
{ 0.37605, 0.40286}, { 0.77295, 0.48286}, { 0.77714, 0.48900}, { 1.23429, 0.48900}, { 0.22437, 0.51143}, 
{ 0.37295, 0.51714}, { 0.23320, 0.59143}, { 0.39748, 0.65429}, { 1.09143, 0.68617}, { 1.08571, 0.69099}, 
{ 0.42073, 0.71714}, { 1.21977, 0.72286}, { 0.27387, 0.73429}, { 1.06286, 0.75301}, { 0.30645, 0.80286}, 
{ 0.47616, 0.80286}, { 1.02286, 0.82127}, { 1.18498, 0.82571}, { 0.54286, 0.86150}, { 0.34857, 0.86629}, 
{ 0.94286, 0.88371}, { 1.14857, 0.88793}, { 0.61143, 0.89580}, { 0.86286, 0.91184}, { 0.40168, 0.92286}, 
{ 0.70857, 0.91866}, { 0.80000, 0.92134}, { 1.09714, 0.94384}, { 0.45714, 0.96436}, { 0.53714, 1.00498}, 
{ 1.00000, 1.00371}, { 0.93714, 1.02613}, { 0.62857, 1.03252}, { 0.73714, 1.04705}, { 0.84571, 1.04395},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_71 [] = {
{ 0, 7, 1}, {14, 5, 3}, { 5,14, 9}, { 2, 8, 0}, { 1,10, 3}, { 0, 8, 7}, { 8, 2,11},
{18,13, 9}, {17, 6,12}, {10, 1, 7}, { 4,11, 2}, {13,18,19}, {23,17,12}, {15, 6,17},
{ 4, 6,15}, {16, 9,14}, {11, 4,15}, {14, 3,10}, {19,21,20}, {18, 9,16}, {30,31,29},
{23,27,22}, {25,24,20}, {22,27,26}, {21,19,18}, {25,20,21}, {23,28,27}, {28,23,12},
{29,24,25}, {30,29,25}, {31,32,37}, {38,33,36}, {37,32,39}, {32,31,30}, {35,39,32},
{34,33,38}, {39,40,44}, {38,46,41}, {38,42,46}, {40,39,35}, {44,40,49}, {53,43,54},
{43,49,40}, {42,38,36}, {43,47,54}, {52,41,46}, {41,52,45}, {43,53,49}, {54,47,57},
{50,57,47}, {45,56,48}, {55,45,52}, {48,59,51}, {57,50,58}, {50,51,58}, {56,45,55},
{58,51,59}, {59,48,56},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_72 [] = {
{ 0.26857,-0.07186}, { 0.40571,-0.07186}, { 0.98857,-0.07295}, { 0.98286,-0.06878}, { 1.12571,-0.06878}, 
{ 0.40991, 0.43714}, { 0.41714, 0.44437}, { 0.97714, 0.44329}, { 0.41714, 0.57277}, { 0.97714, 0.57385}, 
{ 0.40991, 0.58000}, { 0.98550, 1.02571}, { 1.12571, 1.02307}, { 0.26857, 1.02615}, { 0.40571, 1.02615}, 
{ 1.12000, 1.02723},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_72 [] = {
{ 4, 9, 7}, { 0, 5,13}, { 5,10,13}, { 5, 0, 1}, { 8, 7, 9}, { 9, 4,11}, {10, 5, 8},
{ 6, 8, 5}, { 4, 3, 2}, { 7, 8, 6}, {14,13,10}, {12,15,11}, { 3, 4, 7}, { 4,12,11},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_73 [] = {
{ 0.42592,-0.07143}, { 0.28571,-0.06878}, { 0.28836, 1.02571}, { 0.42857, 1.02307},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_73 [] = {
{ 1, 3, 2}, { 3, 1, 0}, 
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_74 [] = {
{ 0.45143,-0.09009}, { 0.50857,-0.09009}, { 0.37714,-0.07756}, { 0.58404,-0.07714}, { 0.33143,-0.06086}, 
{ 0.64000,-0.05641}, { 0.26489,-0.01429}, { 0.71429,-0.00117}, { 0.46286, 0.03866}, { 0.53714, 0.04706}, 
{ 0.74902, 0.04857}, { 0.41714, 0.04899}, { 0.57772, 0.06571}, { 0.21143, 0.06772}, { 0.37016, 0.07714}, 
{ 0.34498, 0.11143}, { 0.77252, 0.11143}, { 0.62371, 0.11714}, { 0.18705, 0.16286}, { 0.32462, 0.17429}, 
{ 0.64420, 0.22571}, { 0.79009, 0.23143}, { 0.18546, 0.23714}, { 0.31472, 0.25429}, { 0.64836, 1.02571}, 
{ 0.78857, 1.02307}, { 0.78286, 1.02723},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_74 [] = {
{10,12, 7}, { 4, 2,11}, { 0, 1, 8}, { 3, 8, 1}, {11, 2, 8}, { 0, 8, 2}, { 8, 3, 9},
{ 9, 3,12}, { 4,14, 6}, { 7,12, 5}, { 3, 5,12}, { 6,15,13}, {12,10,17}, {14, 4,11},
{13,19,18}, { 6,14,15}, {22,19,23}, {17,16,20}, {13,15,19}, {16,17,10}, {22,18,19},
{21,20,16}, {20,21,24}, {25,26,24}, {21,25,24},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_75 [] = {
{ 0.25714,-0.07186}, { 0.39429,-0.07186}, { 1.15502,-0.07143}, { 0.97143,-0.07140}, { 0.89527, 0.28857}, 
{ 0.89143, 0.29371}, { 0.89098, 0.29429}, { 0.39848, 0.30000}, { 0.57714, 0.47913}, { 0.40000, 0.49126}, 
{ 0.68956, 0.56857}, { 0.68571, 0.57371}, { 0.68527, 0.57429}, { 1.13216, 1.02571}, { 0.25714, 1.02615}, 
{ 0.39429, 1.02615}, { 0.94857, 1.02680},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_75 [] = {
{ 0, 9,14}, { 0, 7, 9}, { 3,10, 8}, { 3, 6,10}, { 9, 8,16}, { 4, 5, 6}, { 7, 0, 1},
{ 3, 4, 6}, {16, 8,12}, {10,11,12}, { 4, 3, 2}, { 8,10,12}, { 9, 7, 8}, {13,16,12},
{15,14, 9},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_76 [] = {
{ 0.25714,-0.07186}, { 0.93714,-0.07186}, { 0.94134, 0.04857}, { 0.39957, 0.06000}, { 0.93714, 0.05472}, 
{ 0.25714, 1.02615}, { 0.39429, 1.02615},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_76 [] = {
{ 3, 0, 1}, { 0, 3, 5}, { 2, 4, 1}, { 3, 1, 4}, { 6, 5, 3},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_77 [] = {
{ 0.39164,-0.07143}, { 0.71429,-0.07186}, { 1.17143,-0.07295}, { 0.25714,-0.06878}, { 0.84000,-0.06947}, 
{ 1.16571,-0.06878}, { 1.30286,-0.06878}, { 0.78286, 0.09751}, { 0.78857, 0.09751}, { 1.16000, 0.83018}, 
{ 0.40000, 0.84467}, { 0.52151, 0.88286}, { 0.52000, 0.88739}, { 0.51748, 0.89429}, { 0.47580, 1.02000}, 
{ 0.25979, 1.02571}, { 1.11429, 1.02285}, { 1.30286, 1.02307}, { 0.46857, 1.02680},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_77 [] = {
{ 3,10,15}, { 5, 6, 9}, { 6, 5, 2}, { 1,11,10}, { 4, 8, 1}, { 1, 7,11}, { 9,16, 8},
{ 1, 8, 7}, { 9, 8, 4}, {10,18,15}, {13,11,12}, {10, 3, 0}, {10,13,18}, {16, 9,17},
{10,11,13}, {13,14,18}, { 6,17, 9},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_78 [] = {
{ 0.26286,-0.07186}, { 0.39429,-0.07186}, { 0.98286,-0.07295}, { 1.12571,-0.06878}, { 0.98286, 0.17231}, 
{ 0.72045, 0.31143}, { 0.71678, 0.31714}, { 0.72000, 0.31207}, { 0.40000, 0.78092}, { 0.99122, 1.02571}, 
{ 1.12571, 1.02307}, { 0.26286, 1.02615}, { 0.40571, 1.02644}, { 1.12000, 1.02723},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_78 [] = {
{ 0, 8,11}, { 8, 0, 1}, { 4, 3, 9}, { 3, 4, 2}, { 4, 5, 2}, { 6, 7, 5}, {12, 6, 4},
{ 4, 6, 5}, { 6,12, 8}, {10,13, 9}, { 8,12,11}, { 3,10, 9},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_79 [] = {
{ 0.70286,-0.08966}, { 0.77714,-0.08966}, { 0.61143,-0.07605}, { 0.89714,-0.06823}, { 0.97143,-0.04073}, 
{ 0.49143,-0.03229}, { 1.05650, 0.00857}, { 0.42286, 0.01107}, { 0.70857, 0.03605}, { 0.77143, 0.03605}, 
{ 0.63429, 0.04899}, { 0.84571, 0.04899}, { 1.12725, 0.07143}, { 0.35044, 0.07714}, { 0.92716, 0.08286}, 
{ 0.54857, 0.08535}, { 0.49143, 0.12704}, { 1.17465, 0.13429}, { 1.01296, 0.15143}, { 0.28571, 0.17016}, 
{ 0.43955, 0.18571}, { 1.21184, 0.20286}, { 0.40784, 0.23714}, { 1.08086, 0.26000}, { 1.24613, 0.30000}, 
{ 0.23109, 0.31143}, { 1.10665, 0.34571}, { 0.36764, 0.36857}, { 0.21295, 0.43143}, { 1.11848, 0.43714}, 
{ 1.26705, 0.43714}, { 0.36193, 0.51143}, { 1.11848, 0.51714}, { 0.21563, 0.54571}, { 0.36991, 0.59143}, 
{ 1.25522, 0.61429}, { 1.09966, 0.63714}, { 0.23236, 0.64857}, { 1.23681, 0.68857}, { 1.07070, 0.71714}, 
{ 0.41143, 0.73016}, { 0.26645, 0.75143}, { 1.20486, 0.76857}, { 0.45561, 0.79714}, { 1.02286, 0.79270}, 
{ 0.98857, 0.82956}, { 0.31429, 0.83650}, { 1.16045, 0.84286}, { 0.53143, 0.86150}, { 0.92000, 0.87800}, 
{ 0.35582, 0.88857}, { 0.63429, 0.90764}, { 0.85143, 0.90613}, { 1.10286, 0.90956}, { 0.71429, 0.92134}, 
{ 0.79429, 0.91866}, { 0.43493, 0.95714}, { 1.04000, 0.95964}, { 0.52000, 1.00498}, { 0.96000, 1.00327}, 
{ 0.89714, 1.02613}, { 0.63429, 1.03866}, { 0.77714, 1.04705},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_79 [] = {
{ 0, 8, 2}, { 1, 9, 0}, { 8,10, 2}, { 2,10, 5}, { 9, 1,11}, { 5,16, 7}, {11, 3,14},
{ 3,11, 1}, { 3, 4,14}, { 6,14, 4}, { 7,16,13}, {10,15, 5}, { 0, 9, 8}, {16, 5,15},
{14, 6,18}, {13,20,19}, {12,18, 6}, {18,17,23}, {17,21,23}, {20,22,19}, {18,12,17},
{23,21,26}, {25,19,22}, {13,16,20}, {25,27,28}, {27,25,22}, {21,24,26}, {30,29,26},
{32,35,36}, {30,26,24}, {33,34,37}, {32,29,30}, {28,31,33}, {31,28,27}, {34,33,31},
{36,38,39}, {35,32,30}, {41,37,34}, {38,42,39}, {41,40,46}, {35,38,36}, {39,47,44},
{40,43,46}, {53,45,44}, {46,43,50}, {45,57,49}, {40,41,34}, {56,50,43}, {49,59,52},
{48,56,43}, {57,45,53}, {53,44,47}, {56,48,58}, {39,42,47}, {58,51,61}, {59,49,57},
{51,58,48}, {55,52,60}, {62,54,55}, {59,60,52}, {61,54,62}, {54,61,51}, {62,55,60},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_80 [] = {
{ 0.26286,-0.07186}, { 0.40000,-0.07186}, { 0.40420, 0.36857}, { 0.41143, 0.37580}, { 0.73714, 0.37621}, 
{ 0.88571, 0.40034}, { 0.98343, 0.44857}, { 0.41143, 0.50420}, { 0.72571, 0.50420}, { 0.40420, 0.51143}, 
{ 1.04045, 0.51143}, { 0.82947, 0.52286}, { 0.88571, 0.55296}, { 0.91678, 0.58571}, { 1.08252, 0.59714}, 
{ 0.93966, 0.63143}, { 1.09866, 0.68286}, { 0.94966, 0.72857}, { 0.93355, 0.79143}, { 1.08530, 0.80857}, 
{ 0.90857, 0.83270}, { 0.86857, 0.86893}, { 1.05927, 0.87143}, { 0.40528, 0.89429}, { 0.82286, 0.88899}, 
{ 0.74857, 0.89807}, { 1.02439, 0.92286}, { 0.96000, 0.97641}, { 0.89143, 1.00538}, { 0.26286, 1.02615}, 
{ 0.74286, 1.02680},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_80 [] = {
{ 0, 9,29}, { 0, 2, 9}, { 2, 7, 9}, { 7, 3, 8}, {12,11, 5}, { 5,11, 4}, { 4, 8, 3},
{ 3, 7, 2}, { 2, 0, 1}, {11, 8, 4}, {13,12, 6}, {10,13, 6}, { 6,12, 5}, {14,15,10},
{15,14,17}, {13,10,15}, {16,17,14}, {17,19,18}, {19,17,16}, {18,19,20}, {20,27,21},
{22,20,19}, { 9,23,29}, {30,25,24}, {25,30,23}, {27,20,26}, {20,22,26}, {28,24,21},
{28,21,27}, {30,29,23}, {30,24,28},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_81 [] = {
{ 1.23429,-0.15444}, { 1.13714,-0.11188}, { 0.76571,-0.09009}, { 0.64571,-0.08437}, { 0.84000,-0.08034}, 
{ 0.58286,-0.07034}, { 1.27640,-0.06000}, { 0.93143,-0.05470}, { 0.46857,-0.02322}, { 1.00000,-0.02293}, 
{ 0.38857, 0.03330}, { 0.76000, 0.03563}, { 0.68000, 0.03866}, { 0.83547, 0.04857}, { 1.09814, 0.04857}, 
{ 0.61714, 0.05177}, { 0.87591, 0.06571}, { 0.55429, 0.07800}, { 0.80000, 0.10784}, { 0.49143, 0.12132}, 
{ 0.30857, 0.12350}, { 0.74115, 0.12857}, { 0.98286, 0.13189}, { 1.17355, 0.14571}, { 0.42857, 0.19207}, 
{ 0.86857, 0.19927}, { 0.26286, 0.20486}, { 1.05355, 0.22000}, { 0.77714, 0.23134}, { 0.39277, 0.26000}, 
{ 1.23177, 0.27714}, { 0.23387, 0.28286}, { 1.08823, 0.30571}, { 0.36420, 0.36286}, { 0.20991, 0.40286}, 
{ 0.35580, 0.43714}, { 1.25866, 0.43714}, { 1.11009, 0.44286}, { 0.20723, 0.51714}, { 1.25252, 0.58000}, 
{ 0.36420, 0.59714}, { 1.09823, 0.60857}, { 0.23470, 0.67714}, { 0.38857, 0.68947}, { 1.21184, 0.73429}, 
{ 1.05143, 0.73841}, { 0.42902, 0.76857}, { 0.28821, 0.80286}, { 1.00571, 0.80413}, { 1.17188, 0.81429}, 
{ 0.96000, 0.84670}, { 0.51429, 0.85473}, { 0.34473, 0.88286}, { 1.12000, 0.88413}, { 0.57714, 0.89070}, 
{ 0.88571, 0.89070}, { 0.64571, 0.91252}, { 0.76571, 0.92093}, { 0.42857, 0.95759}, { 1.03429, 0.95864}, 
{ 0.50286, 0.99927}, { 0.96571, 0.99800}, { 0.60000, 1.03252}, { 0.86857, 1.03184}, { 0.69714, 1.04705}, 
{ 0.77143, 1.04665},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_81 [] = {
{ 0, 6, 1}, {13, 7,16}, {14, 9, 1}, { 9,16, 7}, { 3,15, 5}, {16, 9,14}, {11, 4,13},
{11, 2, 4}, { 7,13, 4}, {12, 3,11}, { 2,11, 3}, {15, 3,12}, { 5,17, 8}, { 8,19,10},
{10,19,20}, {14, 1, 6}, { 5,15,17}, {20,29,26}, {19, 8,17}, {21,18,28}, {22,16,14},
{16,25,18}, {22,14,27}, {24,20,19}, {16,22,25}, {26,29,31}, {18,25,28}, {14,23,27},
{27,30,32}, {30,27,23}, {31,33,34}, {20,24,29}, {37,32,30}, {33,31,29}, {34,33,38},
{36,37,30}, {35,38,33}, {37,39,41}, {38,40,42}, {37,36,39}, {41,44,45}, {40,38,35},
{42,43,47}, {44,41,39}, {46,47,43}, {43,42,40}, {47,46,52}, {45,49,48}, {59,50,48},
{52,51,58}, {53,48,49}, {61,50,59}, {50,61,55}, {58,51,60}, {51,52,46}, {49,45,44},
{59,48,53}, {57,64,56}, {60,54,62}, {55,63,57}, {51,54,60}, {54,56,62}, {62,56,64},
{63,55,61}, {63,65,57}, {57,65,64},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_82 [] = {
{ 0.26857,-0.07186}, { 0.40571,-0.07186}, { 1.05143,-0.07215}, { 1.22359,-0.07143}, { 1.22535,-0.06571}, 
{ 1.17465, 0.01429}, { 1.17143, 0.01936}, { 1.17098, 0.02000}, { 0.84571, 0.24343}, { 1.00571, 0.27650}, 
{ 0.76571, 0.34698}, { 0.91832, 0.37429}, { 0.73143, 0.37678}, { 0.40991, 0.40857}, { 0.68000, 0.40437}, 
{ 0.41714, 0.41580}, { 0.62286, 0.41538}, { 0.84226, 0.42571}, { 0.92571, 0.44706}, { 0.99429, 0.47502}, 
{ 1.07582, 0.54000}, { 0.41714, 0.54420}, { 0.40991, 0.55143}, { 0.80000, 0.54764}, { 0.88000, 0.56538}, 
{ 1.11641, 0.60286}, { 0.94286, 0.60439}, { 0.96784, 0.63714}, { 1.13823, 0.67714}, { 0.98966, 0.69429}, 
{ 0.99277, 0.74571}, { 1.14134, 0.75143}, { 0.97143, 0.81493}, { 1.12823, 0.82000}, { 0.93143, 0.86115}, 
{ 1.10498, 0.87714}, { 0.89143, 0.88498}, { 0.40991, 0.90000}, { 0.41714, 0.90723}, { 0.78857, 0.90723}, 
{ 1.07011, 0.92857}, { 1.01714, 0.97579}, { 0.97143, 0.99865}, { 0.87429, 1.02109}, { 0.26857, 1.02615}, 
{ 0.80571, 1.02723},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_82 [] = {
{ 2, 9, 8}, { 3, 5, 2}, { 0,37,44}, { 5, 7, 2}, { 5, 6, 7}, { 3, 4, 5}, { 2, 7, 9},
{18,23,17}, {11, 8, 9}, { 8,11,10}, { 0,22,37}, {11,17,10}, {21,16,23}, {21,15,16},
{23,10,17}, {19,24,18}, {23,18,24}, {23,12,10}, {15,21,13}, { 0,21,22}, {16,14,23},
{23,14,12}, {20,26,19}, {26,20,27}, {24,19,26}, {27,25,29}, {28,30,29}, {31,30,28},
{25,27,20}, {30,33,32}, {28,29,25}, {33,30,31}, {32,40,34}, {35,32,33}, { 0, 1,13},
{ 0,13,21}, {41,34,40}, {43,36,42}, {38,39,45}, {32,35,40}, {42,34,41}, {34,42,36},
{36,43,39}, {44,38,45}, {43,45,39}, {37,38,44},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_83 [] = {
{ 0.71429,-0.08966}, { 0.53714,-0.07866}, { 0.82286,-0.07101}, { 0.46286,-0.05959}, { 0.38857,-0.02616}, 
{ 0.94286,-0.01678}, { 0.33714, 0.01044}, { 0.64000, 0.03866}, { 0.73143, 0.04177}, { 1.00571, 0.03883}, 
{ 0.56000, 0.05177}, { 0.28527, 0.06571}, { 0.50857, 0.06930}, { 0.83587, 0.07143}, { 1.04086, 0.08857}, 
{ 0.88127, 0.10000}, { 0.43429, 0.11330}, { 0.24486, 0.13429}, { 0.92613, 0.15714}, { 1.07177, 0.16286}, 
{ 0.38771, 0.16857}, { 0.94134, 0.21429}, { 0.36319, 0.22571}, { 0.21563, 0.23714}, { 1.08109, 0.26571}, 
{ 0.21403, 0.27714}, { 0.93294, 0.27714}, { 0.34857, 0.28916}, { 0.91011, 0.31714}, { 1.06816, 0.32857}, 
{ 0.84000, 0.36943}, { 1.04486, 0.38000}, { 0.76571, 0.39673}, { 0.98286, 0.45241}, { 0.53143, 0.45748}, 
{ 0.42857, 0.49343}, { 0.92571, 0.49070}, { 0.37143, 0.52535}, { 0.82857, 0.53109}, { 0.31044, 0.58000}, 
{ 0.53143, 0.60899}, { 0.43429, 0.65616}, { 0.26244, 0.67143}, { 0.39891, 0.71143}, { 0.90857, 0.71084}, 
{ 0.25295, 0.72286}, { 1.04615, 0.72286}, { 0.39320, 0.76857}, { 0.40359, 0.80857}, { 1.03109, 0.81429}, 
{ 0.26327, 0.82000}, { 0.87429, 0.81493}, { 0.45143, 0.86956}, { 0.82286, 0.87258}, { 0.28930, 0.88286}, 
{ 0.98812, 0.90000}, { 0.50857, 0.90041}, { 0.76571, 0.90151}, { 0.57714, 0.91563}, { 0.67429, 0.91866}, 
{ 0.95443, 0.94000}, { 0.35429, 0.96099}, { 0.89143, 0.98784}, { 0.40000, 0.99188}, { 0.83429, 1.01470}, 
{ 0.50286, 1.03184}, { 0.74857, 1.03823}, { 0.57143, 1.04437}, { 0.67429, 1.04705},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_83 [] = {
{ 2, 8, 0}, { 0, 7, 1}, { 6, 4,16}, { 6,16,11}, { 0, 8, 7}, { 7,10, 1}, { 8, 2,13},
{ 5,15,13}, { 1,10, 3}, {10,12, 3}, { 9,15, 5}, { 4, 3,12}, {15,14,18}, { 5,13, 2},
{14,15, 9}, {16, 4,12}, {21,24,26}, {18,19,21}, {11,20,17}, {20,11,16}, {17,22,23},
{19,18,14}, {22,17,20}, {25,23,27}, {23,22,27}, {24,21,19}, {26,31,28}, {28,33,30},
{24,29,26}, {30,38,32}, {26,29,31}, {34,32,38}, {33,28,31}, {34,40,35}, {33,36,30},
{39,43,42}, {38,30,36}, {41,37,35}, {40,34,38}, {37,41,39}, {41,35,40}, {50,48,54},
{39,41,43}, {44,46,49}, {45,42,43}, {45,47,50}, {48,50,47}, {60,51,55}, {47,45,43},
{51,60,53}, {54,48,61}, {44,49,51}, {55,51,49}, {48,52,61}, {56,63,52}, {57,66,59},
{61,52,63}, {63,56,65}, {62,53,60}, {53,64,57}, {53,62,64}, {59,66,58}, {65,58,67},
{58,65,56}, {66,57,64}, {67,58,68}, {68,58,66},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_84 [] = {
{ 0.54286,-0.07186}, { 0.68000,-0.07186}, { 0.53757, 0.89429}, { 0.68528, 0.89429}, { 0.17714, 0.90265}, 
{ 1.04571, 0.90265}, { 0.17979, 1.02571}, { 1.04571, 1.02307},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_84 [] = {
{ 0, 3, 2}, { 3, 0, 1}, { 6, 4, 2}, { 6, 3, 7}, { 6, 2, 3}, { 3, 5, 7},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_85 [] = {
{ 0.65714,-0.09009}, { 0.77143,-0.08705}, { 0.53143,-0.07034}, { 0.85714,-0.07101}, { 0.47429,-0.05070}, 
{ 0.94286,-0.03629}, { 0.38286, 0.00704}, { 1.02286, 0.02445}, { 0.65714, 0.04437}, { 0.78857, 0.05320}, 
{ 0.33669, 0.06000}, { 0.58286, 0.05748}, { 0.84000, 0.06823}, { 0.52000, 0.08535}, { 1.07070, 0.08857}, 
{ 0.89714, 0.10154}, { 0.46857, 0.13025}, { 1.09966, 0.15714}, { 0.29143, 0.15866}, { 0.94899, 0.17429}, 
{ 0.43177, 0.19714}, { 0.27320, 0.24286}, { 0.97252, 0.26000}, { 1.12680, 0.33429}, { 0.26437, 0.34000}, 
{ 0.40991, 0.34000}, { 0.98134, 0.34571}, { 0.98550, 1.02571}, { 1.12571, 1.02307}, { 0.26857, 1.02615}, 
{ 0.40571, 1.02615}, { 1.12000, 1.02723},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_85 [] = {
{ 3, 9, 1}, {10,20,18}, { 8, 0, 1}, { 0,11, 2}, { 7,15, 5}, { 0, 8,11}, { 8, 1, 9},
{ 9, 3,12}, {13, 4, 2}, { 5,12, 3}, {15, 7,19}, {16,10, 6}, {12, 5,15}, { 4,13, 6},
{13, 2,11}, {21,18,20}, {13,16, 6}, {19,17,22}, {17,19,14}, { 7,14,19}, {10,16,20},
{25,24,21}, {23,26,22}, {23,22,17}, {25,21,20}, {24,25,29}, {30,29,25}, {28,31,27},
{26,23,27}, {23,28,27},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_86 [] = {
{ 0.57714,-0.07025}, { 0.72571,-0.06947}, { 0.64571, 0.06079}, { 0.65143, 0.06062}, { 0.15429, 1.02560}, 
{ 0.30286, 1.02531}, { 1.00571, 1.02531}, { 1.14857, 1.02560},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_86 [] = {
{ 0, 2, 4}, { 3, 2, 0}, { 3, 7, 6}, { 1, 3, 0}, { 3, 1, 7}, { 2, 5, 4},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_87 [] = {
{ 0.45143,-0.07186}, { 0.60000,-0.07017}, { 1.13143,-0.06912}, { 1.27429,-0.06912}, { 0.52571, 0.09707}, 
{ 1.20000, 0.09787}, { 1.13673, 0.38000}, { 0.86857, 0.88103}, { 0.16571, 1.02562}, { 0.78286, 1.02446}, 
{ 1.42857, 1.02446}, { 1.56806, 1.02571}, { 0.30857, 1.02615}, { 0.95429, 1.02615},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_87 [] = {
{ 2, 6, 7}, { 6, 2, 5}, { 1, 4, 0}, { 7, 9, 4}, {11,10, 5}, { 3, 5, 2}, { 8, 0, 4},
{13, 7, 6}, { 9, 7,13}, { 7, 4, 1}, {11, 5, 3}, {12, 8, 4},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_88 [] = {
{ 0.15194,-0.07143}, { 1.14117,-0.07143}, { 0.32000,-0.07106}, { 0.97143,-0.07140}, { 0.65143, 0.37795}, 
{ 0.74607, 0.49429}, { 0.56517, 0.50000}, { 0.74286, 0.49909}, { 0.74219, 0.50000}, { 0.65714, 0.61727}, 
{ 0.20016, 1.02571}, { 0.96000, 1.02568}, { 1.11260, 1.02571}, { 0.36571, 1.02644},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_88 [] = {
{ 0, 2, 6}, { 3, 5, 4}, { 5, 6, 4}, { 5, 8, 6}, { 5, 3, 1}, { 5, 7, 8}, { 4, 6, 2},
{ 9, 6, 8}, {12,11, 8}, { 6,13,10}, {13, 6, 9}, {11, 9, 8},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_89 [] = {
{ 0.71164,-0.07143}, { 0.57143,-0.06878}, { 0.56891, 0.39143}, { 0.71787, 0.39714}, { 0.65143, 0.51441}, 
{ 0.43179, 0.85429}, { 0.42857, 0.85936}, { 0.42812, 0.86000}, { 0.15284, 1.02571}, { 0.32000, 1.02535}, 
{ 0.98286, 1.02464}, { 1.14521, 1.02571},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_89 [] = {
{ 3, 2, 1}, { 3, 1, 0}, { 4, 2, 3}, { 2, 9, 8}, {11,10, 4}, { 5, 2, 4}, { 5, 6, 7},
{ 2, 7, 9}, { 2, 5, 7}, {11, 4, 3},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_90 [] = {
{ 0.17714,-0.07186}, { 1.04000,-0.06878}, { 1.04000, 0.05164}, { 0.17395, 0.06000}, { 0.34602, 0.06000}, 
{ 0.84777, 0.89429}, { 0.24000, 0.89957}, { 1.02395, 0.90000}, { 0.23580, 1.02000}, { 1.02286, 1.02307}, 
{ 0.24000, 1.02615},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_90 [] = {
{ 0, 4, 3}, { 1, 4, 0}, { 1, 2, 4}, { 3, 4, 5}, { 5, 7, 9}, { 4, 7, 5}, { 5,10, 6},
{10, 5, 9}, { 6,10, 8},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_91 [] = {
{ 0.24528,-0.37429}, { 0.54025,-0.37429}, { 0.54025,-0.27143}, { 0.38227,-0.26571}, { 0.38286, 0.91454}, 
{ 0.54134, 0.92286}, { 0.24836, 1.02571}, { 0.53714, 1.02615},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_91 [] = {
{ 0, 4, 6}, { 3, 1, 2}, { 1, 3, 0}, { 0, 3, 4}, { 5, 7, 4}, { 6, 4, 7},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_92 [] = {
{ 0.46286,-0.09182}, { 0.56000,-0.09256}, { 0.56469,-0.08857}, { 0.14713, 1.04286}, { 0.24571, 1.04358},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_92 [] = {
{ 0, 4, 3}, { 0, 2, 4}, { 0, 1, 2},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_93 [] = {
{ 0.17100,-0.37429}, { 0.46597,-0.37429}, { 0.17100,-0.27143}, { 0.32571,-0.26723}, { 0.33295,-0.26000}, 
{ 0.33143, 0.91201}, { 0.17143, 0.91979}, { 0.16991, 1.02000}, { 0.46286, 1.02615},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_93 [] = {
{ 2, 0, 3}, { 1, 3, 0}, { 1, 4, 3}, { 5, 4, 1}, { 7, 6, 8}, { 5, 8, 6}, { 8, 5, 1},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_94 [] = {
{ 0.18389, 0.44857}, { 0.18857, 0.44458}, { 0.32000, 0.44686}, { 0.68571, 0.44746}, { 0.81143, 0.44445}, 
{ 0.81700, 0.44857}, { 0.49714, 0.88224}, { 0.50286, 0.88224}, { 0.44571, 1.04090}, { 0.55429, 1.04168}, 
{ 0.45143, 1.04437},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_94 [] = {
{ 0, 2, 6}, { 0, 6, 8}, { 7, 3, 5}, { 4, 5, 3}, { 2, 0, 1}, {10, 7, 9}, {10, 8, 6},
{10, 6, 7}, { 9, 7, 5},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_95 [] = {
{ 0.11957,-0.37429}, { 1.01186,-0.37429}, { 0.11957,-0.28857}, { 1.01186,-0.28857},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_95 [] = {
{ 2, 1, 3}, { 2, 0, 1},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_96 [] = {
{ 0.38857, 0.82420}, { 0.48000, 0.82420}, { 0.48403, 0.82571}, { 0.37714, 0.82989}, { 0.38286, 0.82575}, 
{ 0.48657, 0.83143}, { 0.21296, 1.02571}, { 0.38771, 1.02571}, { 0.21412, 1.03143}, { 0.38286, 1.03106}, 
{ 0.37714, 1.03295},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_96 [] = {
{ 5, 1, 2}, { 0, 3, 4}, { 3,10, 6}, { 0, 1, 5}, { 7, 3, 0}, { 8, 6,10}, { 7, 0, 5},
{ 3, 7,10}, {10, 7, 9},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_97 [] = {
{ 0.44000,-0.09009}, { 0.50286,-0.08966}, { 0.36571,-0.07756}, { 0.57143,-0.07907}, { 0.92716,-0.07143}, 
{ 0.79429,-0.07106}, { 0.92930,-0.06571}, { 0.62857,-0.06151}, { 0.30857,-0.05514}, { 0.27429,-0.03258}, 
{ 0.68000,-0.03629}, { 0.90748,-0.00857}, { 0.48000, 0.01580}, { 0.53143, 0.01621}, { 0.42768, 0.02571}, 
{ 0.76571, 0.02129}, { 0.22073, 0.03143}, { 0.61804, 0.03714}, { 0.89866, 0.03714}, { 0.37130, 0.06000}, 
{ 0.20613, 0.06571}, { 0.68000, 0.07330}, { 0.34538, 0.10000}, { 0.71429, 0.10809}, { 0.19580, 0.11714}, 
{ 0.89295, 0.13429}, { 0.33907, 0.15714}, { 0.74538, 0.16857}, { 0.20319, 0.19714}, { 0.36000, 0.20914}, 
{ 0.75580, 0.22000}, { 0.40000, 0.24371}, { 0.22812, 0.25429}, { 0.44571, 0.26041}, { 0.66286, 0.29891}, 
{ 0.28000, 0.31258}, { 0.75848, 0.31714}, { 0.75429, 0.32399}, { 0.33714, 0.34657}, { 0.38857, 0.36538}, 
{ 0.68571, 0.41320}, { 0.75772, 0.43714}, { 0.35289, 0.48286}, { 0.22093, 0.50000}, { 0.22857, 0.49470}, 
{ 0.89252, 0.50571}, { 0.75580, 0.51143}, { 0.22857, 0.53547}, { 0.37800, 0.54571}, { 0.74286, 0.55301}, 
{ 0.88680, 0.56286}, { 0.71429, 0.58893}, { 0.41714, 0.59330}, { 0.42228, 0.59714}, { 0.25800, 0.60286}, 
{ 0.42286, 0.59759}, { 0.65143, 0.61959}, { 0.48000, 0.62193}, { 0.86498, 0.62571}, { 0.53143, 0.62950}, 
{ 0.59429, 0.62950}, { 0.28187, 0.63714}, { 0.84571, 0.65486}, { 0.33714, 0.68436}, { 0.80571, 0.69007}, 
{ 0.37915, 0.70571}, { 0.72571, 0.72538}, { 0.45714, 0.72966}, { 0.54286, 0.74152}, { 0.62286, 0.74152},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_97 [] = {
{ 3,13, 1}, { 5, 4,15}, { 4,11,15}, {19, 8, 2}, {13, 3, 7}, {13, 0, 1}, {14, 0,12},
{20,22,24}, { 0,14, 2}, {12, 0,13}, {13, 7,17}, {11, 4, 6}, {19, 2,14}, {17,10,21},
{ 7,10,17}, {11,18,15}, {16,22,20}, { 8,19, 9}, {15,23,21}, {15,21,10}, {23,25,27},
{ 9,19,16}, {19,22,16}, {23,15,25}, {24,26,28}, {27,25,30}, {25,15,18}, {30,25,36},
{32,28,26}, {26,24,22}, {29,32,26}, {39,38,31}, {38,35,29}, {32,29,35}, {31,38,29},
{39,34,40}, {33,39,31}, {39,33,34}, {36,41,37}, {40,37,41}, {37,40,34}, {41,36,25},
{41,45,46}, {43,44,47}, {47,48,54}, {48,47,44}, {50,49,46}, {41,25,45}, {50,46,45},
{42,48,44}, {49,64,51}, {52,53,55}, {52,65,63}, {65,52,55}, {52,61,48}, {52,63,61},
{58,49,50}, {49,58,62}, {69,60,56}, {49,62,64}, {54,48,61}, {57,67,65}, {57,65,55},
{51,66,56}, {69,59,60}, {66,51,64}, {68,67,57}, {59,69,57}, {69,68,57}, {69,56,66},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_98 [] = {
{ 0.61143,-0.09009}, { 0.50286,-0.07823}, { 0.36000,-0.07186}, { 0.24000,-0.06878}, { 0.72000,-0.06213}, 
{ 0.45714,-0.05914}, { 0.77143,-0.03188}, { 0.36571, 0.01806}, { 0.59429, 0.02193}, { 0.83543, 0.02571}, 
{ 0.52000, 0.02823}, { 0.66857, 0.04645}, { 0.46857, 0.05179}, { 0.42704, 0.08857}, { 0.72956, 0.10000}, 
{ 0.88784, 0.10571}, { 0.39216, 0.14000}, { 0.75641, 0.14000}, { 0.91470, 0.18000}, { 0.37462, 0.19143}, 
{ 0.78665, 0.23714}, { 0.36152, 0.28857}, { 0.93252, 0.29429}, { 0.79236, 0.36857}, { 0.93252, 0.37429}, 
{ 0.36420, 0.38000}, { 0.77294, 0.47714}, { 0.39216, 0.50000}, { 0.90899, 0.50000}, { 0.42473, 0.55143}, 
{ 0.73143, 0.55546}, { 0.88657, 0.55714}, { 0.45883, 0.58571}, { 0.67429, 0.60498}, { 0.50857, 0.61641}, 
{ 0.63429, 0.62252}, { 0.56571, 0.62991}, { 0.37714, 0.64118}, { 0.83429, 0.63841}, { 0.37315, 0.64857}, 
{ 0.80571, 0.66686}, { 0.74286, 0.70784}, { 0.46857, 0.71355}, { 0.68571, 0.72899}, { 0.56571, 0.74109}, 
{ 0.61714, 0.74152}, { 0.24265, 1.02571}, { 0.37143, 1.02307}, { 0.36571, 1.02723},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_98 [] = {
{ 3,25,46}, { 5, 1,10}, { 5,12, 7}, { 8, 0, 4}, {11, 6,14}, {11, 4, 6}, { 0, 8, 1},
{ 2, 7, 3}, { 8, 4,11}, {10, 1, 8}, {21, 3,19}, {12,13, 7}, {12, 5,10}, {14, 9,17},
{ 9,14, 6}, {17,15,20}, {16, 7,13}, {15,18,20}, {15,17, 9}, { 3, 7,19}, {22,20,18},
{20,22,23}, {28,26,23}, {22,24,23}, {25, 3,21}, {30,43,33}, {39,46,25}, {28,23,24},
{27,39,25}, {26,31,30}, { 7,16,19}, {31,26,28}, {37,32,42}, {39,27,37}, {40,30,38},
{29,37,27}, {38,30,31}, {35,33,43}, {32,34,42}, {35,45,36}, {37,29,32}, {42,34,36},
{45,35,43}, {43,30,41}, {41,30,40}, {36,45,44}, {42,36,44}, {47,48,46}, {39,47,46},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_99 [] = {
{ 0.53143,-0.08966}, { 0.59429,-0.08966}, { 0.45714,-0.07673}, { 0.68000,-0.07294}, { 0.72571,-0.05343}, 
{ 0.37714,-0.04331}, { 0.33714,-0.01543}, { 0.78857,-0.01011}, { 0.58286, 0.02152}, { 0.29143, 0.03016}, 
{ 0.49625, 0.03143}, { 0.62857, 0.03034}, { 0.83107, 0.03714}, { 0.45714, 0.04943}, { 0.69270, 0.06571}, 
{ 0.26241, 0.07143}, { 0.85714, 0.07873}, { 0.40457, 0.09429}, { 0.72722, 0.10571}, { 0.37629, 0.14000}, 
{ 0.74437, 0.14000}, { 0.22899, 0.14571}, { 0.37184, 0.15143}, { 0.36930, 0.15714}, { 0.88571, 0.15295}, 
{ 0.89406, 0.19714}, { 0.76571, 0.21540}, { 0.21034, 0.22571}, { 0.34705, 0.25429}, { 0.20420, 0.36286}, 
{ 0.34478, 0.36857}, { 0.21673, 0.45429}, { 0.36252, 0.47143}, { 0.75429, 0.47269}, { 0.88058, 0.48857}, 
{ 0.88319, 0.49429}, { 0.38371, 0.52286}, { 0.23849, 0.52857}, { 0.72000, 0.55200}, { 0.86437, 0.55714}, 
{ 0.43025, 0.58000}, { 0.69714, 0.58127}, { 0.28527, 0.61429}, { 0.47429, 0.60943}, { 0.48571, 0.61387}, 
{ 0.83473, 0.61429}, { 0.49143, 0.61641}, { 0.63429, 0.62041}, { 0.54857, 0.62950}, { 0.58857, 0.62991}, 
{ 0.81296, 0.64286}, { 0.32168, 0.65429}, { 0.35429, 0.67964}, { 0.76571, 0.68535}, { 0.44571, 0.72327}, 
{ 0.67429, 0.72816}, { 0.53714, 0.74109}, { 0.60000, 0.74109},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_99 [] = {
{ 2,13, 5}, { 0, 8, 2}, {11, 4,14}, { 1, 8, 0}, { 3,11, 1}, {15,23,21}, { 2,10,13},
{11, 8, 1}, {11, 3, 4}, { 7,14, 4}, {10, 2, 8}, {14, 7,18}, {17, 6,13}, { 6, 5,13},
{17,15, 9}, {18,12,20}, { 7,12,18}, {17, 9, 6}, {16,20,12}, {24,20,16}, {19,15,17},
{15,19,23}, {23,19,22}, {27,28,29}, {26,20,24}, {26,24,25}, {21,28,27}, {28,21,23},
{29,30,31}, {28,30,29}, {31,32,37}, {39,38,33}, {34,39,33}, {32,31,30}, {37,32,36},
{55,49,47}, {37,36,42}, {51,42,36}, {34,35,39}, {45,41,38}, {52,40,43}, {46,43,44},
{50,41,45}, {56,49,57}, {40,51,36}, {51,40,52}, {45,38,39}, {52,43,54}, {47,41,53},
{54,46,48}, {56,48,49}, {53,41,50}, {54,48,56}, {54,43,46}, {57,49,55}, {55,47,53},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_100 [] = {
{ 0.51429,-0.09009}, { 0.56571,-0.08966}, { 0.62857,-0.07673}, { 0.76571,-0.07186}, { 0.88571,-0.06878}, 
{ 0.41143,-0.06486}, { 0.67429,-0.05641}, { 0.36000,-0.03669}, { 0.30286, 0.01025}, { 0.76000, 0.01806}, 
{ 0.53714, 0.02152}, { 0.49714, 0.02891}, { 0.60571, 0.02891}, { 0.68127, 0.07143}, { 0.41714, 0.07561}, 
{ 0.23787, 0.10571}, { 0.71579, 0.11143}, { 0.38241, 0.11714}, { 0.74135, 0.16286}, { 0.21395, 0.16857}, 
{ 0.74286, 0.16739}, { 0.74538, 0.17429}, { 0.34605, 0.20286}, { 0.76420, 0.27714}, { 0.19277, 0.28857}, 
{ 0.33295, 0.28857}, { 0.19277, 0.36286}, { 0.76152, 0.38571}, { 0.33563, 0.39714}, { 0.73355, 0.50000}, 
{ 0.22135, 0.51143}, { 0.36784, 0.51714}, { 0.69714, 0.55841}, { 0.42286, 0.58686}, { 0.26857, 0.60793}, 
{ 0.63429, 0.60943}, { 0.48571, 0.62151}, { 0.56571, 0.62950}, { 0.74857, 0.64048}, { 0.75269, 0.64857}, 
{ 0.30857, 0.65582}, { 0.65714, 0.71355}, { 0.40571, 0.71756}, { 0.50286, 0.74109}, { 0.55429, 0.74152}, 
{ 0.75693, 1.02571}, { 0.88571, 1.02307}, { 0.88000, 1.02723},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_100 [] = {
{ 0,11, 5}, {12, 6,13}, { 1, 2,12}, { 7,14, 8}, {10, 0, 1}, {14, 7, 5}, {10, 1,12},
{ 6,12, 2}, { 0,10,11}, { 8,17,15}, { 9,16,13}, {14, 5,11}, { 4, 9, 3}, { 6, 9,13},
{ 9, 4,18}, {16, 9,18}, {15,22,19}, {17, 8,14}, {22,15,17}, {20,18,21}, {21,18, 4},
{19,25,24}, {21, 4,23}, {25,19,22}, {26,24,25}, {26,28,30}, {39,27, 4}, {26,25,28},
{39,38,29}, {29,38,32}, {27,39,29}, {30,31,34}, {32,38,35}, {31,30,28}, {40,34,31},
{36,42,33}, {23, 4,27}, {35,41,37}, {33,40,31}, {40,33,42}, {41,35,38}, {42,36,43},
{37,43,36}, {44,37,41}, {37,44,43}, {46,47,45}, {39, 4,45}, { 4,46,45},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_101 [] = {
{ 0.54857,-0.09009}, { 0.61143,-0.09009}, { 0.45714,-0.07462}, { 0.71429,-0.07101}, { 0.40571,-0.05641}, 
{ 0.77714,-0.04331}, { 0.33714,-0.01543}, { 0.82857,-0.00670}, { 0.29714, 0.02154}, { 0.56000, 0.02152}, 
{ 0.60571, 0.02193}, { 0.49714, 0.03563}, { 0.68159, 0.04286}, { 0.88150, 0.05429}, { 0.45714, 0.05514}, 
{ 0.26286, 0.06636}, { 0.72000, 0.06759}, { 0.40457, 0.10000}, { 0.91216, 0.11143}, { 0.77229, 0.13429}, 
{ 0.37057, 0.15143}, { 0.22034, 0.15714}, { 0.36613, 0.16286}, { 0.92834, 0.16286}, { 0.36359, 0.16857}, 
{ 0.91429, 0.16966}, { 0.79429, 0.18111}, { 0.35177, 0.20286}, { 0.20462, 0.22571}, { 0.33866, 0.28286}, 
{ 0.34286, 0.28900}, { 0.93454, 0.29429}, { 0.19848, 0.35714}, { 0.93295, 0.39714}, { 0.34857, 0.40134}, 
{ 0.78857, 0.40134}, { 0.34134, 0.40857}, { 0.79580, 0.40857}, { 0.20462, 0.41429}, { 0.35429, 0.47261}, 
{ 0.22327, 0.49429}, { 0.91429, 0.48975}, { 0.77143, 0.50661}, { 0.38857, 0.54057}, { 0.74857, 0.54629}, 
{ 0.40725, 0.56286}, { 0.25714, 0.57001}, { 0.71429, 0.58154}, { 0.87070, 0.58571}, { 0.45143, 0.59759}, 
{ 0.68000, 0.60498}, { 0.29296, 0.62000}, { 0.49143, 0.61681}, { 0.63429, 0.62252}, { 0.54857, 0.62950}, 
{ 0.59429, 0.62991}, { 0.33311, 0.66000}, { 0.81143, 0.65543}, { 0.77143, 0.68607}, { 0.41143, 0.70930}, 
{ 0.72000, 0.71355}, { 0.45714, 0.72605}, { 0.66857, 0.73050}, { 0.54286, 0.74152}, { 0.60000, 0.74152},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_101 [] = {
{ 0, 9,11}, {10, 1, 3}, {10, 3,12}, { 5,12, 3}, {17, 8, 6}, {10, 0, 1}, { 0,11, 2},
{ 4,14, 6}, { 0,10, 9}, { 7,16, 5}, { 5,16,12}, {14, 2,11}, {16, 7,19}, {14, 4, 2},
{15, 8,17}, {26,18,25}, {17, 6,14}, {15,27,21}, { 7,13,19}, {23,25,18}, {20,15,17},
{26,19,18}, {18,19,13}, {24,20,22}, {15,20,24}, {15,24,27}, {21,27,28}, {28,29,32},
{33,37,35}, {29,28,27}, {32,29,38}, {35,34,30}, {40,39,46}, {33,35,30}, {31,33,30},
{36,38,29}, {36,29,34}, {37,41,42}, {40,38,36}, {30,34,29}, {39,40,36}, {41,37,33},
{46,43,51}, {51,49,56}, {42,48,44}, {48,42,41}, {44,48,47}, {49,51,45}, {43,46,39},
{56,49,59}, {50,62,53}, {57,47,48}, {64,55,53}, {45,51,43}, {55,63,54}, {58,47,57},
{62,50,60}, {59,52,61}, {59,49,52}, {47,60,50}, {61,54,63}, {60,47,58}, {61,52,54},
{64,53,62}, {55,64,63},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_102 [] = {
{ 0.28000,-0.07186}, { 0.40571,-0.07186}, { 0.27472, 0.61429}, { 0.41100, 0.61429}, { 0.16571, 0.61957}, 
{ 0.56000, 0.61957}, { 0.56420, 0.71714}, { 0.16571, 0.72329}, { 0.27472, 0.72857}, { 0.41100, 0.72857}, 
{ 0.56000, 0.72329}, { 0.41034, 0.83143}, { 0.27580, 0.86000}, { 0.43429, 0.89555}, { 0.28613, 0.91714}, 
{ 0.46286, 0.91294}, { 0.50286, 0.92134}, { 0.60000, 0.91830}, { 0.31107, 0.96857}, { 0.34286, 1.00099}, 
{ 0.38857, 1.02784}, { 0.61714, 1.03086}, { 0.46286, 1.04395}, { 0.52571, 1.04437},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_102 [] = {
{ 0, 3, 2}, { 3, 0, 1}, { 4, 8, 7}, { 9, 3, 5}, { 2, 3, 8}, { 5, 6,10}, { 4, 2, 8},
{ 9, 8, 3}, { 8,11,12}, {11, 8, 9}, {12,11,14}, { 9, 5,10}, {13,19,18}, {13,18,14},
{13,14,11}, {23,15,16}, {15,23,22}, {21,23,17}, {15,20,13}, {19,13,20}, {20,15,22},
{23,16,17},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_103 [] = {
{ 0.46857,-0.39295}, { 0.56571,-0.39563}, { 0.66286,-0.37959}, { 0.35429,-0.36200}, { 0.74286,-0.34616}, 
{ 0.28571,-0.31868}, { 0.80368,-0.30000}, { 0.50857,-0.28437}, { 0.62286,-0.27395}, { 0.44571,-0.27101}, 
{ 0.23387,-0.24286}, { 0.84657,-0.24286}, { 0.69200,-0.23714}, { 0.38171,-0.23143}, { 0.72150,-0.20286}, 
{ 0.87177,-0.18000}, { 0.34916,-0.15714}, { 0.74899,-0.14000}, { 0.22286,-0.13957}, { 0.50857,-0.07295}, 
{ 0.56000,-0.07295}, { 0.43429,-0.05959}, { 0.65143,-0.05070}, { 0.37143,-0.03355}, { 0.69714,-0.02527}, 
{ 0.89252,-0.00857}, { 0.74857, 0.01873}, { 0.75042, 0.02000}, { 0.75756, 0.02000}, { 0.75429, 0.02333}, 
{ 0.29143, 0.03381}, { 0.53143, 0.03866}, { 0.57143, 0.03907}, { 0.47429, 0.05216}, { 0.64000, 0.05787}, 
{ 0.41714, 0.08704}, { 0.68000, 0.08439}, { 0.23216, 0.12857}, { 0.38036, 0.12857}, { 0.72784, 0.14000}, 
{ 0.35277, 0.18571}, { 0.20530, 0.20857}, { 0.75538, 0.20857}, { 0.19320, 0.28286}, { 0.33295, 0.29429}, 
{ 0.76991, 0.35714}, { 0.19277, 0.37429}, { 0.33563, 0.40857}, { 0.75109, 0.47143}, { 0.35109, 0.47714}, 
{ 0.21143, 0.47832}, { 0.72784, 0.52286}, { 0.23787, 0.55143}, { 0.39044, 0.55143}, { 0.69868, 0.56286}, 
{ 0.66286, 0.59393}, { 0.27107, 0.60857}, { 0.45143, 0.60498}, { 0.48571, 0.62041}, { 0.56571, 0.62991}, 
{ 0.57714, 0.62764}, { 0.58286, 0.62723}, { 0.76571, 0.63477}, { 0.32000, 0.66384}, { 0.68571, 0.70213}, 
{ 0.39429, 0.71229}, { 0.77408, 0.72286}, { 0.88878, 0.72286}, { 0.62857, 0.72816}, { 0.46857, 0.73580}, 
{ 0.56000, 0.74152},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_103 [] = {
{ 1, 7, 0}, { 8, 4,12}, { 2, 8, 1}, { 0, 9, 3}, { 7, 1, 8}, { 5,13,10}, { 9, 0, 7},
{13, 5, 3}, { 8, 2, 4}, { 6,14,12}, { 6,12, 4}, {11,15,17}, {11,14, 6}, {13, 3, 9},
{14,11,17}, {10,16,18}, {16,10,13}, {17,25,28}, {23,21,33}, {22,32,20}, {32,19,20},
{35,23,33}, {19,31,21}, {23,35,30}, {31,19,32}, {32,22,34}, {26,29,36}, {17,15,25},
{33,21,31}, {26,36,24}, {24,34,22}, {26,27,29}, {36,34,24}, {36,29,39}, {30,38,37},
{39,28,25}, {39,29,28}, {37,40,41}, {38,40,37}, {30,35,38}, {39,25,42}, {44,46,43},
{44,43,41}, {44,41,40}, {42,25,45}, {67,51,48}, {46,47,50}, {67,48,45}, {47,46,44},
{50,49,52}, {49,50,47}, {67,62,51}, {62,54,51}, {56,52,49}, {54,62,55}, {55,64,61},
{60,61,59}, {53,56,49}, {56,53,63}, {63,57,65}, {65,58,69}, {65,57,58}, {70,59,61},
{59,69,58}, {64,55,62}, {67,45,25}, {67,66,62}, {63,53,57}, {68,70,61}, {59,70,69},
{64,68,61},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_104 [] = {
{ 0.24571,-0.07186}, { 0.37143,-0.07186}, { 0.76000,-0.07186}, { 0.88571,-0.07186}, { 0.37605, 0.40286}, 
{ 0.37756, 0.40857}, { 0.75538, 0.46000}, { 0.88950, 0.47714}, { 0.38899, 0.48286}, { 0.74538, 0.51714}, 
{ 0.88152, 0.54571}, { 0.42439, 0.55143}, { 0.72000, 0.56914}, { 0.47429, 0.59355}, { 0.68000, 0.60331}, 
{ 0.85996, 0.61429}, { 0.53143, 0.61748}, { 0.61143, 0.62379}, { 0.37714, 0.63983}, { 0.81714, 0.67296}, 
{ 0.45714, 0.70045}, { 0.77714, 0.70213}, { 0.50857, 0.72437}, { 0.68571, 0.73538}, { 0.58857, 0.74152}, 
{ 0.24571, 1.02615}, { 0.37143, 1.02615},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_104 [] = {
{ 0, 4,25}, { 4,18,25}, { 6, 2, 3}, { 9, 6, 7}, { 7, 6, 3}, {18, 8,11}, {18,11,13},
{ 9,15,12}, {12,19,14}, {10, 9, 7}, {18,13,20}, { 8, 4, 5}, {15, 9,10}, { 4, 0, 1},
{18, 4, 8}, {17,24,16}, {19,21,14}, {14,23,17}, {20,16,22}, {16,20,13}, {19,12,15},
{17,23,24}, {23,14,21}, {24,22,16}, {18,26,25},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_105 [] = {
{ 0.25143,-0.07186}, { 0.37714,-0.07186}, { 0.25143, 0.72329}, { 0.37714, 0.72329}, { 0.25143, 0.87403}, 
{ 0.37714, 0.87403}, { 0.25143, 1.02615}, { 0.37714, 1.02615},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_105 [] = {
{ 3, 2, 0}, { 3, 0, 1}, { 4, 5, 6}, { 7, 6, 5},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_106 [] = {
{ 0.14857,-0.39563}, { 0.22286,-0.39252}, { 0.07383,-0.38000}, { 0.26857,-0.37914}, { 0.31429,-0.34989}, 
{ 0.34036,-0.31714}, { 0.18857,-0.27462}, { 0.10286,-0.26950}, { 0.36109,-0.26571}, { 0.22331,-0.24857}, 
{ 0.37563,-0.16857}, { 0.24152,-0.16286}, { 0.24571, 0.72329}, { 0.37143, 0.72329}, { 0.24571, 0.87403}, 
{ 0.37143, 0.87403}, { 0.24571, 1.02615}, { 0.37143, 1.02615},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_106 [] = {
{ 1, 6, 0}, { 3, 6, 1}, { 4, 6, 3}, { 9,10,11}, { 7, 0, 6}, { 7, 2, 0}, { 9, 5, 8},
{ 5, 9, 4}, { 6, 4, 9}, { 9, 8,10}, {11,10,12}, {13,12,10}, {14,15,16}, {17,16,15},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_107 [] = {
{ 0.37450,-0.07143}, { 0.89788,-0.07143}, { 0.24571,-0.06878}, { 0.73714,-0.07035}, { 0.38004, 0.24286}, 
{ 0.68421, 0.25429}, { 0.68045, 0.26000}, { 0.68000, 0.26064}, { 0.46857, 0.32924}, { 0.38286, 0.40888}, 
{ 0.57152, 0.42571}, { 0.69714, 0.72283}, { 0.86359, 0.72286}, { 0.24836, 1.02571}, { 0.37714, 1.02307},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_107 [] = {
{ 2, 9,13}, { 4, 2, 0}, { 5, 8, 3}, { 5, 3, 1}, { 5, 6, 7}, { 9,14,13}, {11, 9,10},
{ 5, 7, 8}, { 7,10, 8}, { 8, 9, 4}, {12,11,10}, { 9, 8,10}, { 2, 4, 9},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_108 [] = {
{ 0.36878,-0.07143}, { 0.24000,-0.06878}, { 0.24265, 1.02571}, { 0.37143, 1.02307},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_108 [] = {
{ 1, 3, 2}, { 3, 1, 0},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_109 [] = {
{ 0.24571,-0.07186}, { 0.37143,-0.07186}, { 0.72000,-0.07295}, { 1.18857,-0.07186}, { 1.31429,-0.07186}, 
{ 0.71429,-0.06878}, { 0.84571,-0.06878}, { 0.37866, 0.37429}, { 0.84723, 0.40286}, { 0.85335, 0.46000}, 
{ 0.39109, 0.48286}, { 0.71277, 0.48286}, { 1.18437, 0.48286}, { 1.31807, 0.52286}, { 0.87787, 0.53429}, 
{ 0.41143, 0.53493}, { 1.17395, 0.54000}, { 0.43582, 0.56857}, { 0.68784, 0.56857}, { 1.14857, 0.58403}, 
{ 0.93143, 0.59188}, { 0.66286, 0.59829}, { 0.82857, 0.60801}, { 0.51009, 0.61429}, { 0.36571, 0.61924}, 
{ 0.63429, 0.61470}, { 1.09714, 0.61580}, { 1.29355, 0.62000}, { 0.56000, 0.62420}, { 1.00571, 0.62152}, 
{ 1.06286, 0.62379}, { 0.41311, 0.67143}, { 0.78857, 0.66975}, { 1.25561, 0.67714}, { 0.90857, 0.68902}, 
{ 0.74286, 0.70784}, { 1.20571, 0.71355}, { 0.35735, 0.72286}, { 0.24571, 0.72329}, { 0.50286, 0.72498}, 
{ 0.99429, 0.73109}, { 1.16000, 0.73109}, { 0.67429, 0.73470}, { 0.57714, 0.74109}, { 1.05143, 0.74152},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_109 [] = {
{ 6, 5, 2}, { 0, 7,38}, { 8,11, 5}, { 7, 0, 1}, { 8, 5, 6}, {12, 3, 4}, {12,13,16},
{ 9,11, 8}, {15,17,24}, {11,22,18}, {22,20,34}, {11, 9,22}, {14,22, 9}, {13,12, 4},
{24,17,31}, { 7,10,38}, {10,15,24}, {16,27,19}, {32,21,18}, {24,37,38}, {20,22,14},
{10,24,38}, {27,16,13}, {31,23,39}, {26,41,30}, {30,40,29}, {32,18,22}, {41,19,36},
{34,29,40}, {19,41,26}, {36,19,33}, {23,31,17}, {35,21,32}, {29,34,20}, {39,28,43},
{33,19,27}, {43,28,42}, {25,42,28}, {28,39,23}, {42,25,21}, {42,21,35}, {44,30,41},
{30,44,40},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_110 [] = {
{ 0.24571,-0.07186}, { 0.37143,-0.07186}, { 0.75429,-0.07186}, { 0.88571,-0.07186}, { 0.24152,-0.06571}, 
{ 0.37563,-0.06571}, { 0.75009,-0.06571}, { 0.88991,-0.06571}, { 0.37605, 0.40286}, { 0.37866, 0.41429}, 
{ 0.38134, 0.44857}, { 0.74665, 0.48286}, { 0.88950, 0.48286}, { 0.39849, 0.51143}, { 0.73229, 0.54000}, 
{ 0.88420, 0.54000}, { 0.43011, 0.56286}, { 0.46286, 0.58893}, { 0.69714, 0.58725}, { 0.87008, 0.59143}, 
{ 0.51580, 0.61429}, { 0.65143, 0.61343}, { 0.36571, 0.62031}, { 0.56571, 0.62420}, { 0.60571, 0.62379}, 
{ 0.61714, 0.62152}, { 0.62286, 0.62109}, { 0.83955, 0.64857}, { 0.40725, 0.66571}, { 0.79429, 0.69179}, 
{ 0.45714, 0.70213}, { 0.24152, 0.71714}, { 0.75429, 0.71355}, { 0.35735, 0.72286}, { 0.24571, 0.72329}, 
{ 0.52571, 0.73050}, { 0.68571, 0.73538}, { 0.58857, 0.74152},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_110 [] = {
{ 1, 4, 0}, { 3, 6, 2}, { 1, 5, 4}, { 3, 7, 6}, { 6,12,11}, {11,15,14}, { 6, 7,12},
{22,16,28}, {10, 8, 9}, {13,22,10}, {10,22, 8}, { 8, 4, 5}, {15,11,12}, { 8,22, 4},
{14,15,19}, {14,19,18}, {25,26,24}, {16,22,13}, {16,17,28}, {30,28,17}, {27,18,19},
{32,23,24}, {29,18,27}, {30,20,35}, {18,32,21}, {31, 4,22}, {20,30,17}, {32,26,21},
{32,24,26}, {32,18,29}, {34,31,33}, {33,31,22}, {35,23,37}, {23,35,20}, {36,23,32},
{37,23,36},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_111 [] = {
{ 0.53143,-0.08966}, { 0.59429,-0.09009}, { 0.69143,-0.07101}, { 0.41143,-0.06213}, { 0.76571,-0.03759}, 
{ 0.34857,-0.02821}, { 0.81714,-0.00099}, { 0.29143, 0.02154}, { 0.54286, 0.02193}, { 0.60571, 0.02420}, 
{ 0.50857, 0.02823}, { 0.64571, 0.03563}, { 0.86331, 0.04857}, { 0.45143, 0.05216}, { 0.25714, 0.06636}, 
{ 0.70857, 0.07330}, { 0.89229, 0.09429}, { 0.40000, 0.09597}, { 0.22771, 0.12286}, { 0.38036, 0.12286}, 
{ 0.37714, 0.12793}, { 0.37669, 0.12857}, { 0.75473, 0.12857}, { 0.76657, 0.15143}, { 0.77101, 0.16286}, 
{ 0.77355, 0.16857}, { 0.92319, 0.18000}, { 0.20764, 0.18571}, { 0.34816, 0.19714}, { 0.78605, 0.20857}, 
{ 0.33563, 0.26000}, { 0.19320, 0.28286}, { 0.93823, 0.28857}, { 0.79848, 0.29429}, { 0.33295, 0.36286}, 
{ 0.93866, 0.37429}, { 0.19580, 0.39714}, { 0.79538, 0.39714}, { 0.35277, 0.47143}, { 0.92319, 0.47143}, 
{ 0.21184, 0.48286}, { 0.77143, 0.48947}, { 0.23216, 0.54000}, { 0.38742, 0.54000}, { 0.89927, 0.54000}, 
{ 0.74286, 0.54057}, { 0.71429, 0.57275}, { 0.42286, 0.57813}, { 0.87678, 0.58000}, { 0.27429, 0.60984}, 
{ 0.48571, 0.61580}, { 0.64571, 0.61580}, { 0.54286, 0.62950}, { 0.58857, 0.62950}, { 0.60000, 0.62723}, 
{ 0.60571, 0.62680}, { 0.83225, 0.63714}, { 0.31025, 0.64857}, { 0.34857, 0.67864}, { 0.75429, 0.69641}, 
{ 0.40000, 0.70784}, { 0.45143, 0.72605}, { 0.68571, 0.72538}, { 0.53714, 0.74152}, { 0.60000, 0.74109},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_111 [] = {
{11, 4,15}, { 8, 0, 1}, {17, 7, 5}, {11, 2, 4}, { 2, 9, 1}, { 8, 1, 9}, { 0, 8,10},
{ 0,10, 3}, { 2,11, 9}, { 3,13, 5}, {10,13, 3}, { 6,12,22}, { 6,15, 4}, {15, 6,22},
{18,28,27}, {17, 5,13}, {14,19,18}, {16,23,22}, {19, 7,17}, { 7,19,14}, {18,19,21},
{24,23,25}, {25,23,16}, {19,20,21}, {16,22,12}, {26,29,25}, {27,30,31}, {26,25,16},
{28,18,21}, {29,26,33}, {30,27,28}, {31,34,36}, {33,32,35}, {26,32,33}, {34,31,30},
{33,35,37}, {40,36,34}, {37,39,41}, {40,38,42}, {39,37,35}, {47,57,43}, {38,40,34},
{43,49,42}, {46,45,56}, {39,44,41}, {41,48,45}, {43,57,49}, {41,44,48}, {43,42,38},
{57,47,58}, {54,55,53}, {56,45,48}, {50,60,47}, {64,63,53}, {64,55,62}, {53,63,52},
{59,62,51}, {61,60,50}, {64,53,55}, {51,62,55}, {52,61,50}, {59,46,56}, {61,52,63},
{46,59,51}, {58,47,60},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_112 [] = {
{ 0.24571,-0.37740}, { 0.37454,-0.37429}, { 0.56000,-0.08966}, { 0.66857,-0.07966}, { 0.47429,-0.06657}, 
{ 0.75429,-0.04331}, { 0.37584,-0.00286}, { 0.80571,-0.00704}, { 0.38286, 0.00159}, { 0.59429, 0.02152}, 
{ 0.52000, 0.02891}, { 0.63429, 0.02992}, { 0.85964, 0.05429}, { 0.45143, 0.06725}, { 0.70857, 0.07330}, 
{ 0.39787, 0.13429}, { 0.39514, 0.14000}, { 0.39216, 0.14571}, { 0.76213, 0.14571}, { 0.90538, 0.14571}, 
{ 0.37462, 0.19714}, { 0.78327, 0.20857}, { 0.92680, 0.22571}, { 0.36379, 0.27143}, { 0.36152, 0.28286}, 
{ 0.79580, 0.29429}, { 0.93563, 0.30000}, { 0.36379, 0.36857}, { 0.79580, 0.36857}, { 0.92680, 0.43714}, 
{ 0.78286, 0.45547}, { 0.38286, 0.47232}, { 0.75429, 0.52921}, { 0.41714, 0.54057}, { 0.88571, 0.56444}, 
{ 0.44571, 0.57582}, { 0.69143, 0.59964}, { 0.51429, 0.62213}, { 0.65143, 0.62213}, { 0.36571, 0.63051}, 
{ 0.56571, 0.63563}, { 0.82704, 0.64857}, { 0.45714, 0.70784}, { 0.74857, 0.70657}, { 0.24571, 0.72329}, 
{ 0.36000, 0.72329}, { 0.51429, 0.73177}, { 0.69143, 0.72899}, { 0.62286, 0.74152},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_112 [] = {
{ 0, 1, 6}, { 0,24,44}, { 3, 9, 2}, { 2,10, 4}, { 3,11, 9}, { 4,13, 8}, {10, 2, 9},
{11, 5,14}, {11, 3, 5}, { 7,14, 5}, { 4,10,13}, {14,12,18}, {14, 7,12}, { 0,20,24},
{15, 8,13}, { 8,15, 6}, {19,18,12}, {18,19,21}, {21,22,25}, {24,27,44}, {17,15,16},
{22,21,19}, {28,25,26}, {22,26,25}, { 6,15,17}, {29,30,28}, {23,24,20}, {20, 6,17},
{29,28,26}, {30,34,32}, {27,31,44}, { 0, 6,20}, {31,39,44}, {32,41,36}, {41,32,34},
{31,33,39}, {42,37,46}, {39,35,42}, {34,30,29}, {39,33,35}, {38,47,40}, {35,37,42},
{47,38,43}, {40,46,37}, {43,36,41}, {39,45,44}, {46,40,48}, {48,40,47}, {38,36,43},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_113 [] = {
{ 0.76000,-0.37740}, { 0.88571,-0.37740}, { 0.56571,-0.09009}, { 0.45143,-0.07673}, { 0.65143,-0.06784}, 
{ 0.36000,-0.03188}, { 0.70857,-0.03465}, { 0.75580,-0.00286}, { 0.74857, 0.00454}, { 0.29714, 0.02418}, 
{ 0.54286, 0.02152}, { 0.57714, 0.02193}, { 0.58857, 0.02420}, { 0.59429, 0.02462}, { 0.47429, 0.03927}, 
{ 0.64571, 0.04371}, { 0.43302, 0.06571}, { 0.70670, 0.09429}, { 0.23914, 0.11143}, { 0.38607, 0.11714}, 
{ 0.38286, 0.12221}, { 0.38241, 0.12286}, { 0.75008, 0.17429}, { 0.21101, 0.19143}, { 0.34748, 0.20857}, 
{ 0.76723, 0.25429}, { 0.19848, 0.26000}, { 0.76723, 0.27143}, { 0.33605, 0.28286}, { 0.76991, 0.28857}, 
{ 0.19580, 0.37429}, { 0.33866, 0.40286}, { 0.75429, 0.45277}, { 0.21101, 0.47143}, { 0.35429, 0.47832}, 
{ 0.73143, 0.51301}, { 0.39846, 0.56286}, { 0.69296, 0.56857}, { 0.25669, 0.58571}, { 0.45143, 0.60902}, 
{ 0.61714, 0.62213}, { 0.49143, 0.62723}, { 0.76571, 0.62602}, { 0.29330, 0.63714}, { 0.56571, 0.63522}, 
{ 0.72403, 0.67143}, { 0.36571, 0.69641}, { 0.66286, 0.71355}, { 0.77408, 0.72286}, { 0.88571, 0.72329}, 
{ 0.44571, 0.72966}, { 0.56000, 0.74152},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_113 [] = {
{29,27,25}, {49,42,32}, {22, 7,25}, { 3,13,11}, { 2,13, 3}, { 4,13, 2}, { 6,15, 4},
{11,13,12}, { 3,14, 5}, {13, 4,15}, {10, 3,11}, {15, 6, 8}, {14, 3,10}, {15, 8,17},
{24,23,18}, { 5,16, 9}, {17, 8,22}, {14,16, 5}, { 9,19,18}, {19,20,21}, {18,19,21},
{42,35,32}, { 7,22, 8}, {16,19, 9}, {49,48,42}, { 7, 0, 1}, {24,18,21}, {23,24,26},
{26,28,30}, {28,26,24}, {30,31,33}, {34,33,31}, {31,30,28}, {33,34,38}, {49,29,25},
{36,43,38}, {49,25, 7}, {35,42,37}, {37,45,40}, {45,37,42}, {29,49,32}, {45,47,40},
{39,43,36}, {46,39,50}, {40,47,44}, {43,39,46}, {36,38,34}, {41,44,51}, {41,50,39},
{49, 7, 1}, {50,41,51}, {51,44,47},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_114 [] = {
{ 0.24571,-0.07186}, { 0.37143,-0.07186}, { 0.24152,-0.06571}, { 0.37563,-0.06571}, { 0.37563, 0.38000}, 
{ 0.39748, 0.50000}, { 0.41964, 0.54571}, { 0.44740, 0.57429}, { 0.61714, 0.57787}, { 0.62286, 0.57880}, 
{ 0.48000, 0.59294}, { 0.57714, 0.59395}, { 0.51429, 0.60134}, { 0.36571, 0.61385}, { 0.41868, 0.68857}, 
{ 0.66769, 0.69429}, { 0.66542, 0.70000}, { 0.24152, 0.71714}, { 0.35735, 0.72286}, { 0.24571, 0.72329}, 
{ 0.46286, 0.72436}, { 0.60000, 0.73109}, { 0.51429, 0.74109}, { 0.55429, 0.74109},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_114 [] = {
{ 1, 2, 0}, { 1, 3, 2}, { 4, 2, 3}, { 5, 6,13}, { 5,13,17}, {21,11,15}, { 2, 4,17},
{ 4, 5,17}, { 6, 7,13}, {18,17,13}, { 7,10,14}, {13, 7,14}, {14,12,20}, {11,21,12},
{ 9,15,11}, {12,14,10}, {19,17,18}, {20,12,22}, { 8, 9,11}, {21,15,16}, {22,12,23},
{23,12,21},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_115 [] = {
{ 0.56000,-0.09009}, { 0.46286,-0.08705}, { 0.65143,-0.07395}, { 0.37143,-0.06723}, { 0.70444,-0.05429}, 
{ 0.33143,-0.04943}, { 0.76057,-0.02000}, { 0.28571,-0.01813}, { 0.79582, 0.01429}, { 0.50286, 0.02152}, 
{ 0.55429, 0.02152}, { 0.56571, 0.02379}, { 0.57714, 0.02420}, { 0.24571, 0.02636}, { 0.64000, 0.04200}, 
{ 0.41714, 0.04371}, { 0.22200, 0.06571}, { 0.38286, 0.06725}, { 0.68384, 0.07714}, { 0.83580, 0.08286}, 
{ 0.69927, 0.10000}, { 0.34200, 0.12286}, { 0.84950, 0.14000}, { 0.71009, 0.15714}, { 0.19109, 0.16286}, 
{ 0.19370, 0.16857}, { 0.32000, 0.18615}, { 0.69864, 0.19143}, { 0.84723, 0.20286}, { 0.65714, 0.22784}, 
{ 0.83641, 0.24286}, { 0.80956, 0.28857}, { 0.34286, 0.32371}, { 0.75429, 0.33641}, { 0.30286, 0.34421}, 
{ 0.69143, 0.36327}, { 0.25714, 0.38445}, { 0.22645, 0.43714}, { 0.41143, 0.44538}, { 0.37587, 0.46571}, 
{ 0.35885, 0.48286}, { 0.21295, 0.49429}, { 0.69143, 0.50460}, { 0.34478, 0.51714}, { 0.81977, 0.52286}, 
{ 0.67514, 0.55143}, { 0.35216, 0.56286}, { 0.22034, 0.56857}, { 0.64000, 0.59465}, { 0.38286, 0.59829}, 
{ 0.79429, 0.61016}, { 0.24000, 0.61573}, { 0.42857, 0.62041}, { 0.58286, 0.62252}, { 0.48571, 0.62991}, 
{ 0.74689, 0.67143}, { 0.28571, 0.67258}, { 0.70286, 0.70045}, { 0.33714, 0.70613}, { 0.38857, 0.72538}, 
{ 0.61714, 0.73050}, { 0.47429, 0.74109}, { 0.54286, 0.74109},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_115 [] = {
{ 2,12, 0}, {10, 1,12}, {12, 2,14}, {14, 4, 6}, { 7,17,13}, { 0,12, 1}, { 4,14, 2},
{11,10,12}, {15, 3, 1}, { 3,15, 5}, { 9, 1,10}, {14, 6,18}, {15, 1, 9}, {17, 5,15},
{ 6, 8,18}, { 5,17, 7}, {21,16,13}, {16,21,24}, {18, 8,20}, {23,28,27}, {21,13,17},
{19,22,23}, {26,25,21}, {21,25,24}, {20,19,23}, {19,20, 8}, {28,23,22}, {27,33,29},
{28,30,27}, {31,27,30}, {27,31,33}, {29,38,32}, {35,29,33}, {29,35,38}, {34,38,36},
{32,38,34}, {36,40,37}, {39,36,38}, {41,43,47}, {43,41,37}, {36,39,40}, {50,45,42},
{43,37,40}, {47,46,51}, {46,47,43}, {53,60,54}, {45,57,48}, {52,58,49}, {45,55,57},
{51,49,56}, {49,51,46}, {50,42,44}, {48,57,53}, {56,49,58}, {55,45,50}, {52,59,58},
{59,52,61}, {52,54,61}, {60,53,57}, {61,54,62}, {62,54,60},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_116 [] = {
{ 0.42286,-0.08395}, { 0.48000,-0.08437}, { 0.55197,-0.07143}, { 0.33714,-0.05914}, { 0.29901,-0.02571}, 
{ 0.28041, 0.00857}, { 0.44571, 0.04816}, { 0.44453, 0.04857}, { 0.53714, 0.04344}, { 0.44000, 0.05008}, 
{ 0.41057, 0.07714}, { 0.26748, 0.10000}, { 0.40152, 0.11714}, { 0.26597, 0.61429}, { 0.40260, 0.61429}, 
{ 0.17143, 0.61957}, { 0.53450, 0.62000}, { 0.53866, 0.71714}, { 0.53450, 0.72286}, { 0.17143, 0.72329}, 
{ 0.26597, 0.72857}, { 0.40260, 0.72857}, { 0.26748, 0.91714}, { 0.40000, 0.99545},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_116 [] = {
{10, 5, 4}, { 6, 7, 9}, {10, 4, 3}, {10, 3, 9}, { 8, 6, 1}, { 6, 9, 1}, { 5,10,11},
{ 8, 1, 2}, { 0, 9, 3}, {11,12,13}, { 0, 1, 9}, {10,12,11}, {17,18,16}, {14,13,12},
{21,14,16}, {18,21,16}, {22,20,23}, {20,13,14}, {15,20,19}, {15,13,20}, {20,14,21},
{23,20,21},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_117 [] = {
{ 0.48571,-0.09009}, { 0.53714,-0.09009}, { 0.41714,-0.07673}, { 0.77143,-0.07295}, { 0.88000,-0.07186}, 
{ 0.63518,-0.06571}, { 0.76571,-0.06878}, { 0.88420,-0.06571}, { 0.34857,-0.04771}, { 0.70857,-0.01846}, 
{ 0.29901,-0.00857}, { 0.27429, 0.02730}, { 0.52000, 0.02723}, { 0.56000, 0.02764}, { 0.47339, 0.03714}, 
{ 0.76000, 0.03684}, { 0.61714, 0.04135}, { 0.43943, 0.05429}, { 0.65143, 0.05787}, { 0.41330, 0.07714}, 
{ 0.25143, 0.08437}, { 0.69143, 0.08704}, { 0.39343, 0.10571}, { 0.38899, 0.11714}, { 0.71473, 0.11714}, 
{ 0.38645, 0.12286}, { 0.73294, 0.15714}, { 0.23848, 0.17429}, { 0.37563, 0.17429}, { 0.75009, 0.26000}, 
{ 0.23848, 0.71714}, { 0.37295, 0.71714}, { 0.75009, 0.71714}, { 0.88420, 0.71714}, { 0.24265, 0.72286}, 
{ 0.36878, 0.72286}, { 0.75429, 0.72329}, { 0.88000, 0.72329},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_117 [] = {
{ 6, 3,15}, { 3, 7,15}, { 3, 4, 7}, { 8,17,10}, { 2,14,17}, { 2,17, 8}, { 5,13, 1},
{19,11,10}, { 9,16, 5}, {12, 1,13}, { 0,12, 2}, {12, 0, 1}, { 9,18,16}, {13, 5,16},
{14, 2,12}, {11,22,20}, {21,18, 9}, {15,21, 9}, {21,15,24}, {20,28,27}, {11,19,22},
{24, 7,26}, {19,10,17}, {24,15, 7}, {25,22,23}, {20,22,25}, {20,25,28}, {26, 7,29},
{31,30,27}, {33,29, 7}, {34,31,35}, {34,30,31}, {31,27,28}, {36,33,37}, {32,29,33},
{36,32,33},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_118 [] = {
{ 0.45714,-0.06947}, { 0.58857,-0.07103}, { 0.52000, 0.09808}, { 0.52571, 0.09808}, { 0.47580, 0.23714}, 
{ 0.16151, 0.71714}, { 0.88420, 0.71714}, { 0.16427, 0.72286}, { 0.30286, 0.71951}, { 0.74857, 0.72090}, 
{ 0.88145, 0.72286}, { 0.29714, 0.72395},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_118 [] = {
{ 4, 0, 2}, { 0, 4, 5}, { 3, 2, 0}, { 1, 3, 0}, { 3, 6, 9}, { 8,11, 5}, { 9, 6,10},
{ 7, 5,11}, { 8, 5, 4}, { 3, 1, 6},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_119 [] = {
{ 0.39429,-0.07215}, { 0.52571,-0.07215}, { 0.97714,-0.07252}, { 0.84571,-0.06947}, { 0.45714, 0.10650}, 
{ 0.46286, 0.10650}, { 0.92000, 0.12073}, { 0.69143, 0.52785}, { 0.15122, 0.72286}, { 0.28571, 0.72090}, 
{ 0.62857, 0.72243}, { 0.76193, 0.72286}, { 1.23164, 0.72286}, { 1.10857, 0.72329},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_119 [] = {
{ 2, 6, 3}, { 0, 4, 8}, { 3, 6, 7}, { 5, 0, 1}, {12,13, 6}, { 5, 4, 0}, { 7,10, 5},
{11,10, 7}, { 7, 5, 1}, {11, 7, 6}, { 4, 9, 8}, {12, 6, 2},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_120 [] = {
{ 0.15697,-0.07143}, { 0.88073,-0.07143}, { 0.15473,-0.06571}, { 0.31429,-0.07035}, { 0.72571,-0.07140}, 
{ 0.88250,-0.06571}, { 0.52000, 0.22529}, { 0.52571, 0.22529}, { 0.60332, 0.33429}, { 0.43534, 0.34000}, 
{ 0.51429, 0.45005}, { 0.17188, 0.71714}, { 0.86812, 0.71714}, { 0.17412, 0.72286}, { 0.86588, 0.72286}, 
{ 0.32571, 0.72395}, { 0.71429, 0.72395},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_120 [] = {
{ 1, 5, 4}, { 2, 6, 9}, { 8, 6, 7}, { 3, 2, 0}, { 4, 8, 7}, { 6, 2, 3}, { 4, 5, 8},
{ 8,10, 6}, {10, 9, 6}, {15,11, 9}, {16,10, 8}, {15, 9,10}, {12,16, 8}, {13,11,15},
{16,12,14},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_121 [] = {
{ 0.34286,-0.39563}, { 0.24000,-0.38043}, { 0.41714,-0.37641}, { 0.45714,-0.34956}, { 0.50436,-0.29429}, 
{ 0.32000,-0.26680}, { 0.22286,-0.25766}, { 0.36652,-0.25429}, { 0.54371,-0.22000}, { 0.41293,-0.21429}, 
{ 0.46848,-0.07714}, { 0.53714, 0.09292}, { 0.16998, 0.72286}, { 0.30857, 0.71999}, { 0.76000, 0.72246}, 
{ 0.88806, 0.72286},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_121 [] = {
{ 2, 7, 0}, { 0, 5, 1}, { 5, 0, 7}, { 6, 1, 5}, { 3, 7, 2}, { 7, 3, 9}, { 3, 4, 9},
{ 9, 8,10}, { 9, 4, 8}, {10,11,12}, {11,15,14}, {11, 8,15}, {11,10, 8}, {11,13,12},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_122 [] = {
{ 0.17714,-0.07295}, { 0.86857,-0.07186}, { 0.17143,-0.06878}, { 0.87277,-0.06571}, { 0.17146, 0.03714}, 
{ 0.34212, 0.03714}, { 0.87277, 0.03714}, { 0.34132, 0.04286}, { 0.44000, 0.04327}, { 0.86857, 0.04329}, 
{ 0.20571, 0.61689}, { 0.67062, 0.62000}, { 0.84991, 0.64286}, { 0.20152, 0.71714}, { 0.84991, 0.71714}, 
{ 0.20571, 0.72329}, { 0.84571, 0.72329},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_122 [] = {
{ 2, 0, 4}, { 0, 1, 9}, { 0, 5, 4}, { 1, 3, 9}, { 5, 0, 8}, { 5, 7, 4}, { 0, 9, 8},
{ 3, 6, 9}, {12,14,11}, {11,14,16}, {11,16,10}, {12,11, 7}, {11, 4, 7}, {10,15,13},
{15,10,16},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_123 [] = {
{ 0.61143,-0.39454}, { 0.46857,-0.38420}, { 0.40000,-0.34154}, { 0.61143,-0.27975}, { 0.35748,-0.27143}, 
{ 0.52000,-0.26992}, { 0.47787,-0.23143}, { 0.46748,-0.19143}, { 0.34134,-0.18000}, { 0.46395, 0.04286}, 
{ 0.33563, 0.05429}, { 0.45184, 0.14571}, { 0.32109, 0.16286}, { 0.29143, 0.21832}, { 0.42286, 0.22716}, 
{ 0.25143, 0.24943}, { 0.18857, 0.26528}, { 0.39429, 0.26698}, { 0.31413, 0.32286}, { 0.18857, 0.38615}, 
{ 0.25143, 0.40073}, { 0.41188, 0.40286}, { 0.29143, 0.42775}, { 0.43514, 0.44286}, { 0.32823, 0.49429}, 
{ 0.45866, 0.52286}, { 0.34134, 0.60286}, { 0.46705, 0.80857}, { 0.34478, 0.84857}, { 0.47748, 0.87143}, 
{ 0.35748, 0.91143}, { 0.50286, 0.90821}, { 0.50793, 0.91143}, { 0.50857, 0.91188}, { 0.61143, 0.92814}, 
{ 0.40571, 0.99511}, { 0.46857, 1.03294}, { 0.53143, 1.04437}, { 0.61143, 1.04329},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_123 [] = {
{ 0, 3, 5}, { 6, 2, 5}, { 2, 6, 4}, { 0, 5, 1}, { 2, 1, 5}, { 4, 7, 8}, { 7, 4, 6},
{ 8, 9,10}, {10,11,12}, { 9, 8, 7}, {11,10, 9}, {12,17,13}, {12,14,17}, {14,12,11},
{18,15,13}, {16,15,20}, {18,13,17}, {16,20,19}, {15,18,20}, {21,22,18}, {22,21,24},
{22,20,18}, {24,25,26}, {23,24,21}, {25,24,23}, {26,27,28}, {27,26,25}, {28,29,30},
{29,28,27}, {30,29,35}, {31,32,33}, {36,31,33}, {31,36,29}, {36,33,37}, {34,38,37},
{35,29,36}, {34,37,33},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_124 [] = {
{ 0.28571,-0.39454}, { 0.38857,-0.39563}, { 0.28571, 1.04329}, { 0.38857, 1.04437},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_124 [] = {
{ 3, 2, 0}, { 3, 0, 1},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_125 [] = {
{ 0.17714,-0.39454}, { 0.31429,-0.38613}, { 0.39429,-0.33832}, { 0.17714,-0.27975}, { 0.27429,-0.26784}, 
{ 0.43681,-0.26000}, { 0.31070,-0.23714}, { 0.44950,-0.19714}, { 0.32723,-0.15714}, { 0.45295, 0.04857}, 
{ 0.33295, 0.11714}, { 0.46857, 0.16404}, { 0.35387, 0.19714}, { 0.51429, 0.23258}, { 0.56000, 0.25681}, 
{ 0.39429, 0.26403}, { 0.60630, 0.26571}, { 0.47702, 0.32857}, { 0.41714, 0.36742}, { 0.60571, 0.38615}, 
{ 0.54857, 0.39927}, { 0.50171, 0.43143}, { 0.36086, 0.43714}, { 0.46748, 0.50000}, { 0.32991, 0.56857}, 
{ 0.45252, 0.78571}, { 0.32723, 0.80286}, { 0.31748, 0.87143}, { 0.29143, 0.90893}, { 0.43470, 0.91714}, 
{ 0.17714, 0.92814}, { 0.41629, 0.95714}, { 0.36571, 1.01107}, { 0.32000, 1.03294}, { 0.17714, 1.04329},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_125 [] = {
{ 4, 3, 0}, { 2, 4, 1}, { 6, 7, 8}, { 1, 4, 0}, { 2, 6, 4}, { 5, 6, 2}, { 6, 5, 7},
{ 8, 9,10}, { 9, 8, 7}, {10,11,12}, {15,13,17}, {11,10, 9}, {12,11,15}, {13,14,17},
{13,15,11}, {20,17,14}, {20,14,16}, {19,20,16}, {21,17,20}, {17,21,18}, {22,23,24},
{22,18,21}, {23,22,21}, {25,26,24}, {25,24,23}, {29,27,26}, {29,26,25}, {27,31,28},
{31,27,29}, {32,28,31}, {28,33,30}, {33,34,30}, {33,28,32},
};

static const VTK_VECTOR_TEXT_POINT VTK_VECTOR_TEXT_POINTS_126 [] = {
{ 0.73714, 0.34462}, { 0.20759, 0.35143}, { 0.21143, 0.34662}, { 0.81143, 0.34723}, { 0.66857, 0.35756}, 
{ 0.86857, 0.36135}, { 0.25143, 0.38115}, { 0.90857, 0.38086}, { 0.52000, 0.41580}, { 0.32571, 0.42723}, 
{ 0.97140, 0.43143}, { 0.37143, 0.43866}, { 0.42286, 0.44093}, { 0.79429, 0.49009}, { 0.21028, 0.50000}, 
{ 0.72571, 0.49681}, { 0.86286, 0.50930}, { 0.25714, 0.54115}, { 0.92571, 0.54759}, { 0.32571, 0.57470}, 
{ 0.50286, 0.57621}, { 0.96571, 0.58154}, { 0.97143, 0.58073}, { 0.38857, 0.58680}, { 0.44000, 0.58723},
};
static const VTK_VECTOR_TEXT_TRIANGLE VTK_VECTOR_TEXT_TRIANGLES_126 [] = {
{ 1,17,14}, { 8, 4,15}, {13, 5, 7}, { 6, 1, 2}, { 5,13, 3}, { 1, 6,17}, { 3,13, 0},
{16,10,18}, {15, 4, 0}, {13, 7,16}, {15, 0,13}, { 8,20,12}, {12,20,11}, { 9,17, 6},
{10,16, 7}, {17, 9,19}, {22,21,18}, {11,20,24}, {11,19, 9}, {20, 8,15}, {11,24,23},
{22,18,10}, {11,23,19},
};

static const VTK_VECTOR_TEXT_GLYPH Letters[] = {
{ 0.438482,  VTK_VECTOR_TEXT_POINTS_33,  11,  VTK_VECTOR_TEXT_TRIANGLES_33,    7 },
{ 0.615625,  VTK_VECTOR_TEXT_POINTS_34,  21,  VTK_VECTOR_TEXT_TRIANGLES_34,   17 },
{ 0.974539,  VTK_VECTOR_TEXT_POINTS_35,  43,  VTK_VECTOR_TEXT_TRIANGLES_35,   43 },
{ 0.921518,  VTK_VECTOR_TEXT_POINTS_36,  73,  VTK_VECTOR_TEXT_TRIANGLES_36,   75 },
{ 1.409911,  VTK_VECTOR_TEXT_POINTS_37,  81,  VTK_VECTOR_TEXT_TRIANGLES_37,   79 },
{ 1.126291,  VTK_VECTOR_TEXT_POINTS_38,  76,  VTK_VECTOR_TEXT_TRIANGLES_38,   78 },
{ 0.364197,  VTK_VECTOR_TEXT_POINTS_39,  10,  VTK_VECTOR_TEXT_TRIANGLES_39,    8 },
{ 0.595731,  VTK_VECTOR_TEXT_POINTS_40,  19,  VTK_VECTOR_TEXT_TRIANGLES_40,   17 },
{ 0.598482,  VTK_VECTOR_TEXT_POINTS_41,  19,  VTK_VECTOR_TEXT_TRIANGLES_41,   17 },
{ 0.685300,  VTK_VECTOR_TEXT_POINTS_42,  34,  VTK_VECTOR_TEXT_TRIANGLES_42,   32 },
{ 0.952768,  VTK_VECTOR_TEXT_POINTS_43,  20,  VTK_VECTOR_TEXT_TRIANGLES_43,   18 },
{ 0.432768,  VTK_VECTOR_TEXT_POINTS_44,  23,  VTK_VECTOR_TEXT_TRIANGLES_44,   21 },
{ 0.606146,  VTK_VECTOR_TEXT_POINTS_45,   8,  VTK_VECTOR_TEXT_TRIANGLES_45,    6 },
{ 0.432768,  VTK_VECTOR_TEXT_POINTS_46,  13,  VTK_VECTOR_TEXT_TRIANGLES_46,   11 },
{ 0.562348,  VTK_VECTOR_TEXT_POINTS_47,   5,  VTK_VECTOR_TEXT_TRIANGLES_47,    3 },
{ 0.926804,  VTK_VECTOR_TEXT_POINTS_48,  53,  VTK_VECTOR_TEXT_TRIANGLES_48,   53 },
{ 0.708571,  VTK_VECTOR_TEXT_POINTS_49,  11,  VTK_VECTOR_TEXT_TRIANGLES_49,    9 },
{ 0.914286,  VTK_VECTOR_TEXT_POINTS_50,  43,  VTK_VECTOR_TEXT_TRIANGLES_50,   41 },
{ 0.927232,  VTK_VECTOR_TEXT_POINTS_51,  68,  VTK_VECTOR_TEXT_TRIANGLES_51,   66 },
{ 0.920000,  VTK_VECTOR_TEXT_POINTS_52,  18,  VTK_VECTOR_TEXT_TRIANGLES_52,   18 },
{ 0.932946,  VTK_VECTOR_TEXT_POINTS_53,  54,  VTK_VECTOR_TEXT_TRIANGLES_53,   52 },
{ 0.927232,  VTK_VECTOR_TEXT_POINTS_54,  70,  VTK_VECTOR_TEXT_TRIANGLES_54,   70 },
{ 0.923788,  VTK_VECTOR_TEXT_POINTS_55,  17,  VTK_VECTOR_TEXT_TRIANGLES_55,   15 },
{ 0.926804,  VTK_VECTOR_TEXT_POINTS_56,  83,  VTK_VECTOR_TEXT_TRIANGLES_56,   85 },
{ 0.927232,  VTK_VECTOR_TEXT_POINTS_57,  72,  VTK_VECTOR_TEXT_TRIANGLES_57,   72 },
{ 0.432768,  VTK_VECTOR_TEXT_POINTS_58,  14,  VTK_VECTOR_TEXT_TRIANGLES_58,   10 },
{ 0.432768,  VTK_VECTOR_TEXT_POINTS_59,  18,  VTK_VECTOR_TEXT_TRIANGLES_59,   14 },
{ 0.952690,  VTK_VECTOR_TEXT_POINTS_60,  11,  VTK_VECTOR_TEXT_TRIANGLES_60,    9 },
{ 0.952768,  VTK_VECTOR_TEXT_POINTS_61,  12,  VTK_VECTOR_TEXT_TRIANGLES_61,    8 },
{ 0.952360,  VTK_VECTOR_TEXT_POINTS_62,  11,  VTK_VECTOR_TEXT_TRIANGLES_62,    9 },
{ 0.918074,  VTK_VECTOR_TEXT_POINTS_63,  45,  VTK_VECTOR_TEXT_TRIANGLES_63,   41 },
{ 1.632597,  VTK_VECTOR_TEXT_POINTS_64, 114,  VTK_VECTOR_TEXT_TRIANGLES_64,  114 },
{ 1.155731,  VTK_VECTOR_TEXT_POINTS_65,  13,  VTK_VECTOR_TEXT_TRIANGLES_65,   13 },
{ 1.081090,  VTK_VECTOR_TEXT_POINTS_66,  48,  VTK_VECTOR_TEXT_TRIANGLES_66,   50 },
{ 1.186046,  VTK_VECTOR_TEXT_POINTS_67,  56,  VTK_VECTOR_TEXT_TRIANGLES_67,   54 },
{ 1.167232,  VTK_VECTOR_TEXT_POINTS_68,  34,  VTK_VECTOR_TEXT_TRIANGLES_68,   34 },
{ 1.080000,  VTK_VECTOR_TEXT_POINTS_69,  15,  VTK_VECTOR_TEXT_TRIANGLES_69,   13 },
{ 1.005714,  VTK_VECTOR_TEXT_POINTS_70,  12,  VTK_VECTOR_TEXT_TRIANGLES_70,   10 },
{ 1.234286,  VTK_VECTOR_TEXT_POINTS_71,  60,  VTK_VECTOR_TEXT_TRIANGLES_71,   58 },
{ 1.125714,  VTK_VECTOR_TEXT_POINTS_72,  16,  VTK_VECTOR_TEXT_TRIANGLES_72,   14 },
{ 0.428571,  VTK_VECTOR_TEXT_POINTS_73,   4,  VTK_VECTOR_TEXT_TRIANGLES_73,    2 },
{ 0.790089,  VTK_VECTOR_TEXT_POINTS_74,  27,  VTK_VECTOR_TEXT_TRIANGLES_74,   25 },
{ 1.155019,  VTK_VECTOR_TEXT_POINTS_75,  17,  VTK_VECTOR_TEXT_TRIANGLES_75,   15 },
{ 0.941339,  VTK_VECTOR_TEXT_POINTS_76,   7,  VTK_VECTOR_TEXT_TRIANGLES_76,    5 },
{ 1.302857,  VTK_VECTOR_TEXT_POINTS_77,  19,  VTK_VECTOR_TEXT_TRIANGLES_77,   17 },
{ 1.125714,  VTK_VECTOR_TEXT_POINTS_78,  14,  VTK_VECTOR_TEXT_TRIANGLES_78,   12 },
{ 1.267054,  VTK_VECTOR_TEXT_POINTS_79,  63,  VTK_VECTOR_TEXT_TRIANGLES_79,   63 },
{ 1.098661,  VTK_VECTOR_TEXT_POINTS_80,  31,  VTK_VECTOR_TEXT_TRIANGLES_80,   31 },
{ 1.276398,  VTK_VECTOR_TEXT_POINTS_81,  66,  VTK_VECTOR_TEXT_TRIANGLES_81,   66 },
{ 1.225355,  VTK_VECTOR_TEXT_POINTS_82,  46,  VTK_VECTOR_TEXT_TRIANGLES_82,   46 },
{ 1.081090,  VTK_VECTOR_TEXT_POINTS_83,  69,  VTK_VECTOR_TEXT_TRIANGLES_83,   67 },
{ 1.045714,  VTK_VECTOR_TEXT_POINTS_84,   8,  VTK_VECTOR_TEXT_TRIANGLES_84,    6 },
{ 1.126804,  VTK_VECTOR_TEXT_POINTS_85,  32,  VTK_VECTOR_TEXT_TRIANGLES_85,   30 },
{ 1.148571,  VTK_VECTOR_TEXT_POINTS_86,   8,  VTK_VECTOR_TEXT_TRIANGLES_86,    6 },
{ 1.568063,  VTK_VECTOR_TEXT_POINTS_87,  14,  VTK_VECTOR_TEXT_TRIANGLES_87,   12 },
{ 1.141168,  VTK_VECTOR_TEXT_POINTS_88,  14,  VTK_VECTOR_TEXT_TRIANGLES_88,   12 },
{ 1.145205,  VTK_VECTOR_TEXT_POINTS_89,  12,  VTK_VECTOR_TEXT_TRIANGLES_89,   10 },
{ 1.040000,  VTK_VECTOR_TEXT_POINTS_90,  11,  VTK_VECTOR_TEXT_TRIANGLES_90,    9 },
{ 0.541339,  VTK_VECTOR_TEXT_POINTS_91,   8,  VTK_VECTOR_TEXT_TRIANGLES_91,    6 },
{ 0.564685,  VTK_VECTOR_TEXT_POINTS_92,   5,  VTK_VECTOR_TEXT_TRIANGLES_92,    3 },
{ 0.465968,  VTK_VECTOR_TEXT_POINTS_93,   9,  VTK_VECTOR_TEXT_TRIANGLES_93,    7 },
{ 0.817005,  VTK_VECTOR_TEXT_POINTS_94,  11,  VTK_VECTOR_TEXT_TRIANGLES_94,    9 },
{ 1.011860,  VTK_VECTOR_TEXT_POINTS_95,   4,  VTK_VECTOR_TEXT_TRIANGLES_95,    2 },
{ 0.486571,  VTK_VECTOR_TEXT_POINTS_96,  11,  VTK_VECTOR_TEXT_TRIANGLES_96,    9 },
{ 0.929303,  VTK_VECTOR_TEXT_POINTS_97,  70,  VTK_VECTOR_TEXT_TRIANGLES_97,   70 },
{ 0.932518,  VTK_VECTOR_TEXT_POINTS_98,  49,  VTK_VECTOR_TEXT_TRIANGLES_98,   49 },
{ 0.894057,  VTK_VECTOR_TEXT_POINTS_99,  58,  VTK_VECTOR_TEXT_TRIANGLES_99,   56 },
{ 0.885714, VTK_VECTOR_TEXT_POINTS_100,  48, VTK_VECTOR_TEXT_TRIANGLES_100,   48 },
{ 0.934539, VTK_VECTOR_TEXT_POINTS_101,  65, VTK_VECTOR_TEXT_TRIANGLES_101,   65 },
{ 0.617143, VTK_VECTOR_TEXT_POINTS_102,  24, VTK_VECTOR_TEXT_TRIANGLES_102,   22 },
{ 0.892518, VTK_VECTOR_TEXT_POINTS_103,  71, VTK_VECTOR_TEXT_TRIANGLES_103,   71 },
{ 0.889502, VTK_VECTOR_TEXT_POINTS_104,  27, VTK_VECTOR_TEXT_TRIANGLES_104,   25 },
{ 0.377143, VTK_VECTOR_TEXT_POINTS_105,   8, VTK_VECTOR_TEXT_TRIANGLES_105,    4 },
{ 0.375625, VTK_VECTOR_TEXT_POINTS_106,  18, VTK_VECTOR_TEXT_TRIANGLES_106,   14 },
{ 0.897876, VTK_VECTOR_TEXT_POINTS_107,  15, VTK_VECTOR_TEXT_TRIANGLES_107,   13 },
{ 0.371429, VTK_VECTOR_TEXT_POINTS_108,   4, VTK_VECTOR_TEXT_TRIANGLES_108,    2 },
{ 1.318074, VTK_VECTOR_TEXT_POINTS_109,  45, VTK_VECTOR_TEXT_TRIANGLES_109,   43 },
{ 0.889911, VTK_VECTOR_TEXT_POINTS_110,  38, VTK_VECTOR_TEXT_TRIANGLES_110,   36 },
{ 0.938661, VTK_VECTOR_TEXT_POINTS_111,  65, VTK_VECTOR_TEXT_TRIANGLES_111,   65 },
{ 0.935625, VTK_VECTOR_TEXT_POINTS_112,  49, VTK_VECTOR_TEXT_TRIANGLES_112,   49 },
{ 0.885714, VTK_VECTOR_TEXT_POINTS_113,  52, VTK_VECTOR_TEXT_TRIANGLES_113,   52 },
{ 0.667686, VTK_VECTOR_TEXT_POINTS_114,  24, VTK_VECTOR_TEXT_TRIANGLES_114,   22 },
{ 0.849502, VTK_VECTOR_TEXT_POINTS_115,  63, VTK_VECTOR_TEXT_TRIANGLES_115,   61 },
{ 0.551972, VTK_VECTOR_TEXT_POINTS_116,  24, VTK_VECTOR_TEXT_TRIANGLES_116,   22 },
{ 0.884197, VTK_VECTOR_TEXT_POINTS_117,  38, VTK_VECTOR_TEXT_TRIANGLES_117,   36 },
{ 0.884203, VTK_VECTOR_TEXT_POINTS_118,  12, VTK_VECTOR_TEXT_TRIANGLES_118,   10 },
{ 1.231638, VTK_VECTOR_TEXT_POINTS_119,  14, VTK_VECTOR_TEXT_TRIANGLES_119,   12 },
{ 0.882498, VTK_VECTOR_TEXT_POINTS_120,  17, VTK_VECTOR_TEXT_TRIANGLES_120,   15 },
{ 0.888063, VTK_VECTOR_TEXT_POINTS_121,  16, VTK_VECTOR_TEXT_TRIANGLES_121,   14 },
{ 0.872768, VTK_VECTOR_TEXT_POINTS_122,  17, VTK_VECTOR_TEXT_TRIANGLES_122,   15 },
{ 0.611429, VTK_VECTOR_TEXT_POINTS_123,  39, VTK_VECTOR_TEXT_TRIANGLES_123,   37 },
{ 0.388571, VTK_VECTOR_TEXT_POINTS_124,   4, VTK_VECTOR_TEXT_TRIANGLES_124,    2 },
{ 0.606299, VTK_VECTOR_TEXT_POINTS_125,  35, VTK_VECTOR_TEXT_TRIANGLES_125,   33 },
{ 0.971429, VTK_VECTOR_TEXT_POINTS_126,  25, VTK_VECTOR_TEXT_TRIANGLES_126,   23 },
};

// Construct object with no string set and backing enabled.
vtkVectorText::vtkVectorText()
{
  this->Text = NULL;

  this->SetNumberOfInputPorts(0);
}

int vtkVectorText::RequestData(
  vtkInformation *vtkNotUsed(request),
  vtkInformationVector **vtkNotUsed(inputVector),
  vtkInformationVector *outputVector)
{
  // get the info object
  vtkInformation *outInfo = outputVector->GetInformationObject(0);

  // get the ouptut
  vtkPolyData *output = vtkPolyData::SafeDownCast(
    outInfo->Get(vtkDataObject::DATA_OBJECT()));

  vtkPoints *newPoints;
  vtkCellArray *newPolys;
  int ptOffset = 0;
  int aPoint, i;
  int pos = 0;
  float xpos = 0;
  float ypos = 0;
  int ptCount, triCount;
  VTK_VECTOR_TEXT_GLYPH aLetter;
  float width;
  float ftmp[3];
  
  if (this->Text == NULL)
    {
    vtkErrorMacro (<< "Text is not set!");
    return 0;
    }

  // Set things up; allocate memory
  newPoints = vtkPoints::New();
  newPolys = vtkCellArray::New();
  ftmp[2] = 0.0;

  // Create Text
  while (this->Text[pos])
    {
    switch (this->Text[pos])
      {
      case 32: 
        xpos += 0.4;
        break;
        
      case 10:
        ypos -= 1.4;
        xpos = 0;
        break;
        
      default:
        // if we have a valid character
        if ((this->Text[pos] > 32)&&(this->Text[pos] < 127))
          {
          // add the result to our output
          aLetter = Letters[static_cast<int>(this->Text[pos])-33];
          ptCount = aLetter.ptCount;
          width = aLetter.width;
          for (i = 0; i < ptCount; i++)
            {
            ftmp[0] = aLetter.points[i].x;
            ftmp[1] = aLetter.points[i].y;
            ftmp[0] += xpos;
            ftmp[1] += ypos;
            newPoints->InsertNextPoint(ftmp);
            }
          triCount = aLetter.triCount;
          for (i = 0; i < triCount; i++)
            {
            newPolys->InsertNextCell(3);
            aPoint = aLetter.triangles[i].p1; 
            newPolys->InsertCellPoint(aPoint + ptOffset);
            aPoint = aLetter.triangles[i].p2; 
            newPolys->InsertCellPoint(aPoint + ptOffset);
            aPoint = aLetter.triangles[i].p3; 
            newPolys->InsertCellPoint(aPoint + ptOffset);
            }
          ptOffset += ptCount;
          xpos += width;
          }
        break;
      }
    pos++;
    }
  
  //
  // Update ourselves and release memory
  //
  output->SetPoints(newPoints);
  newPoints->Delete();
  
  output->SetPolys(newPolys);
  newPolys->Delete();

  return 1;
}
  
void vtkVectorText::PrintSelf(ostream& os, vtkIndent indent)
{
  this->Superclass::PrintSelf(os,indent);

  os << indent << "Text: " << (this->Text ? this->Text : "(none)") << "\n";
}

vtkVectorText::~vtkVectorText()
{
  if (this->Text)
    {
    delete [] this->Text;
    }
}
