'\"
'\" Generated from file '../../runtime/tcllib-1.12/modules/transfer/copyops.man' by tcllib/doctools with format 'nroff'
'\" Copyright (c) 2006-2009 Andreas Kupries <andreas_kupries@users.sourceforge.net>
'\"
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .AP type name in/out ?indent?
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS ?type? ?name?
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .CS
'\"	Begin code excerpt.
'\"
'\" .CE
'\"	End code excerpt.
'\"
'\" .VS ?version? ?br?
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.  The first argument is ignored and used for recording
'\"	the version when the .VS was added, so that the sidebars can be
'\"	found and removed when they reach a certain age.  If another argument
'\"	is present, then a line break is forced before starting the sidebar.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" .SO
'\"	Start of list of standard options for a Tk widget.  The
'\"	options follow on successive lines, in four columns separated
'\"	by tabs.
'\"
'\" .SE
'\"	End of list of standard options for a Tk widget.
'\"
'\" .OP cmdName dbName dbClass
'\"	Start of description of a specific option.  cmdName gives the
'\"	option's name as specified in the class command, dbName gives
'\"	the option's name in the option database, and dbClass gives
'\"	the option's class in the option database.
'\"
'\" .UL arg1 arg2
'\"	Print arg1 underlined, then print arg2 normally.
'\"
'\" RCS: @(#) $Id: man.macros,v 1.1 2009/01/30 04:56:47 andreas_kupries Exp $
'\"
'\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'\"	# SO - start of list of standard options
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
.ft B
..
'\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
'\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
'\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
'\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.de UL
\\$1\l'|0\(ul'\\$2
..
.TH "transfer::copy" n 0.2 transfer "Data transfer facilities"
.BS
.SH NAME
transfer::copy \- Data transfer foundation
.SH SYNOPSIS
package require \fBTcl  8.4\fR
.sp
package require \fBtransfer::copy  ?0.2?\fR
.sp
\fBtransfer::copy::do\fR \fBchan\fR|\fBstring\fR \fIdata\fR \fIoutchannel\fR ?\fIoptions\fR...?
.sp
\fBtransfer::copy::chan\fR \fIchannel\fR \fIoutchannel\fR ?\fIoptions\fR...?
.sp
\fBtransfer::copy::string\fR \fIstring\fR \fIoutchannel\fR ?\fIoptions\fR...?
.sp
\fBtransfer::copy::doChan\fR \fIchannel\fR \fIoutchannel\fR \fIoptvar\fR
.sp
\fBtransfer::copy::doString\fR \fIstring\fR \fIoutchannel\fR \fIoptvar\fR
.sp
\fBtransfer::copy::options\fR \fIoutchannel\fR \fIoptionlist\fR \fIoptvar\fR
.sp
.BE
.SH DESCRIPTION
.PP
This package provides a number of commands for the asynchronous of
information contained in either a string or channel. The main point of
this package is that the commands here provide a nicer callback API
than the builtin command \fBfcopy\fR, making the use of these
facilities simpler than the builtin.
.SH API
.TP
\fBtransfer::copy::do\fR \fBchan\fR|\fBstring\fR \fIdata\fR \fIoutchannel\fR ?\fIoptions\fR...?
This command transfers the information in \fIdata\fR to the
\fIoutchannel\fR, according to the \fIoptions\fR. The type of the
information in \fIdata\fR is determined by the first argument.
.sp
The options available to this command are the same as are available to
the command \fBtransfer::copy::options\fR, and explained there.
.RS
.TP
\fBchan\fR
The argument \fIdata\fR contains the handle of a channel and the
actual infomration to transfer is read from that channel.
.TP
\fBstring\fR
The argument \fIdata\fR contains a string and this is the information
to be transfered.
.RE
.TP
\fBtransfer::copy::chan\fR \fIchannel\fR \fIoutchannel\fR ?\fIoptions\fR...?
This command is a shorter and more direct form for the command
\fBtransfer::copy::do chan\fR.
.TP
\fBtransfer::copy::string\fR \fIstring\fR \fIoutchannel\fR ?\fIoptions\fR...?
This command is a shorter and more direct form for the command
\fBtransfer::copy::do string\fR.
.TP
\fBtransfer::copy::doChan\fR \fIchannel\fR \fIoutchannel\fR \fIoptvar\fR
This command is an alternate form of \fBtransfer::copy::chan\fR which
reads its options out of the array variable named by \fIoptvar\fR
instead of from a variable length argument list.
.TP
\fBtransfer::copy::doString\fR \fIstring\fR \fIoutchannel\fR \fIoptvar\fR
This command is an alternate form of \fBtransfer::copy::string\fR which
reads its options out of the array variable named by \fIoptvar\fR
instead of from a variable length argument list.
.TP
\fBtransfer::copy::options\fR \fIoutchannel\fR \fIoptionlist\fR \fIoptvar\fR
This command is the option processor used by all the commands above
which read their options from a variable length argument list. It
first reads default settings from the channel handle \fIoutchannel\fR,
then processes the list of options in \fIoptionlist\fR, at last stores
the results in the array variable named by \fIoptvar\fR. The contents
of that variable are in a format which is directly understood by all
the commands above which read their options out of an array variable.
.sp
The recognized options are:
.RS
.TP
\fB-blocksize\fR \fIint\fR
This option specifies the size of the chunks to transfer in one
operation. It is optional and defaults to the value of
\fB-buffersize\fR as configured for the output channel.
.sp
If specified its value has to be an integer number greater than zero.
.TP
\fB-command\fR \fIcommandprefix\fR
This option specifies the completion callback of the operation. This
option has to be specified. An error will be thrown if it is not, or
if the empty list was specified as argument to it.
.sp
Its value has to be a command prefix, i.e. a list whose first word is
the command to execute, followed by words containing fixed
arguments. When the callback is invoked one or two additional
arguments are appended to the prefix. The first argument is the number
of bytes which were transfered. The optional second argument is an
error message and added if and only if an error occured during the the
transfer.
.TP
\fB-progress\fR \fIcommandprefix\fR
This option specifies the progress callback of the operation. It is
optional and defaults to the empty list. This last possibility signals
that no feedback was asked for and disabled it.
.sp
Its value has to be a command prefix, see above, \fB-command\fR for
a more detailed explanation. When the callback is invoked a single
additional arguments is appended to the prefix. This argument is the
number of bytes which were transfered so far.
.TP
\fB-size\fR \fIint\fR
This option specifies the number of bytes to read from the input data
and transfer. It is optional and defaults to "Transfer everything".
Its value has to be an integer number and any value less than zero has
the same meaning, i.e. to transfer all available data. Any other value
is the amount of bytes to transfer.
.sp
All transfer commands will throw error an when their user tries to
transfer more data than is available in the input. This happens
immediately, before the transfer is actually started, should the input
be a string. Otherwise the, i.e. for a channel as input, the error is
thrown the moment the underflow condition is actually detected.
.TP
\fB-encoding\fR \fIencodingname\fR
.TP
\fB-eofchar\fR \fIeofspec\fR
.TP
\fB-translation\fR \fItransspec\fR
These options are the same as are recognized by the builtin command
\fBfconfigure\fR and provide the settings for the output channel which
are to be active during the transfer, and only then. I.e. the settings
of the output channel before the transfer are saved, and restored at
the end of a transfer, regardless of its success or failure. None of
these options are required, and they default to the settings of the
output channel if not specified.
.RE
.PP
.SH "BUGS, IDEAS, FEEDBACK"
This document, and the package it describes, will undoubtedly contain
bugs and other problems.
Please report such in the category \fItransfer\fR of the
\fITcllib SF Trackers\fR [http://sourceforge.net/tracker/?group_id=12883].
Please also report any ideas for enhancements you may have for either
package and/or documentation.
.SH KEYWORDS
channel, copy, transfer
.SH CATEGORY
Transfer module
.SH COPYRIGHT
.nf
Copyright (c) 2006-2009 Andreas Kupries <andreas_kupries@users.sourceforge.net>

.fi