#
# Copyright (c) 2004-2011 Purdue University All rights reserved.
# 
# Developed by: HUBzero Technology Group, Purdue University
#               http://hubzero.org
# 
# HUBzero is free software: you can redistribute it and/or modify it under the terms of the
# GNU Lesser General Public License as published by the Free Software Foundation, either
# version 3 of the License, or (at your option) any later version.
# 
# HUBzero is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
# without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
# See the GNU Lesser General Public License for more details.  You should have received a
# copy of the GNU Lesser General Public License along with HUBzero.
# If not, see <http://www.gnu.org/licenses/>.
# 
# GNU LESSER GENERAL PUBLIC LICENSE
# Version 3, 29 June 2007
# Copyright (C) 2007 Free Software Foundation, Inc. <http://fsf.org/>
#
import sys
import os
import time

LOGMESSAGEFILE = sys.stdout
LOGJOBID       = 0

def getLogMessageFileNo():
   global LOGMESSAGEFILE

   logMessageFileNo = None
   if LOGMESSAGEFILE:
      logMessageFileNo = LOGMESSAGEFILE.fileno()

   return(logMessageFileNo)


def openLog(logName):
   global LOGMESSAGEFILE

   try:
      LOGMESSAGEFILE = open(logName,'a')
   except:
      LOGMESSAGEFILE = sys.stdout


def logSetMessageFile(fpMessageFile):
   global LOGMESSAGEFILE

   if LOGMESSAGEFILE:
      if LOGMESSAGEFILE.fileno() != sys.stdout.fileno() and \
         LOGMESSAGEFILE.fileno() != sys.stderr.fileno():
         LOGMESSAGEFILE.close()
   LOGMESSAGEFILE = None

   if fpMessageFile:
      LOGMESSAGEFILE = fpMessageFile


def log(message):
   global LOGMESSAGEFILE

   if LOGMESSAGEFILE and message != "":
      LOGMESSAGEFILE.write("[%s] %s\n" % (time.ctime(),message))
      LOGMESSAGEFILE.flush()


def logPID(message):
   global LOGMESSAGEFILE

   if LOGMESSAGEFILE and message != "":
      LOGMESSAGEFILE.write("[%s] (%d) %s\n" % (time.ctime(),os.getpid(),message))
      LOGMESSAGEFILE.flush()


def logSetJobId(jobId):
   global LOGJOBID

   LOGJOBID = jobId


def logJobId(message):
   global LOGMESSAGEFILE
   global LOGJOBID

   if LOGMESSAGEFILE and message != "":
      LOGMESSAGEFILE.write("[%s] %d: %s\n" % (time.ctime(),LOGJOBID,message))
      LOGMESSAGEFILE.flush()


def logID(message):
   global LOGJOBID

   if message != "":
      if LOGJOBID > 0:
         logJobId(message)
      else:
         logPID(message)


